import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
 *
 * @experimental
 */
export declare class SsmGuiconnect extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to terminate a GUI Connect session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     *
     * @experimental
     */
    toCancelConnection(): this;
    /**
     * (experimental) Grants permission to get the metadata for a GUI Connect session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     *
     * @experimental
     */
    toGetConnection(): this;
    /**
     * (experimental) Grants permission to start a GUI Connect session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     *
     * @experimental
     */
    toStartConnection(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
