from base64 import b64encode
import calendar
from datetime import datetime
import hmac
from hashlib import sha512


class HMAC(object):
    def __init__(self, secret, url, method, body='', nonce=None):
        self.secret = secret
        self.url = url
        self.method = method
        self.body = body if body else ''
        self._nonce = nonce
        self._signature = None

    @property
    def nonce(self):
        if not self._nonce:
            utctime = datetime.utcnow()
            self._nonce = int(calendar.timegm(utctime.timetuple()) * 10 ** 3
                              + utctime.microsecond * 10 ** -3)
        return self._nonce

    @property
    def signature(self):
        if not self._signature:
            message = "{}\n{}\n{}\n{}".format(self.nonce, self.method, self.url, self.body)
            digest = hmac.new(self.secret, msg=message, digestmod=sha512)
            self._signature = b64encode(digest.digest()).replace('\n', '')
        return self._signature
