[![Build Status](https://travis-ci.com/pulumi/pulumi-tls.svg?token=eHg7Zp5zdDDJfTjY8ejq&branch=master)](https://travis-ci.com/pulumi/pulumi-tls)

# TLS Resource Provider

The TLS resource provider for Pulumi lets you create TLS keys and certificates in your cloud programs.  To use
this package, please [install the Pulumi CLI first](https://pulumi.io/).

## Installing

This package is available in many languages in the standard packaging formats.

### Node.js (Java/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

    $ npm install @pulumi/tls

or `yarn`:

    $ yarn add @pulumi/tls

### Python

To use from Python, install using `pip`:

    $ pip install pulumi_tls

### Go

To use from Go, use `go get` to grab the latest version of the library

    $ go get github.com/pulumi/pulumi-tls/sdk/v2/go/...

### .NET

To use from .NET, install using `dotnet add package`:

    $ dotnet add package Pulumi.Tls

## Concepts

The `@pulumi/tls` package provides a strongly-typed means to build cloud applications that create
and interact closely with TLS resources.

## Reference


For further information, please visit [the TLS provider docs](https://www.pulumi.com/docs/intro/cloud-providers/tls) or for detailed reference documentation, please visit [the API docs](https://www.pulumi.com/docs/reference/pkg/tls).
