# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificates=None, id=None, url=None, verify_chain=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        __self__.certificates = certificates
        """
        The certificates protecting the site, with the root of the chain first.
        * `certificates.#.not_after` - The time until which the certificate is invalid, as an
        [RFC3339](https://tools.ietf.org/html/rfc3339) timestamp.
        * `certificates.#.not_before` - The time after which the certificate is valid, as an
        [RFC3339](https://tools.ietf.org/html/rfc3339) timestamp.
        * `certificates.#.is_ca` - `true` if this certificate is a ca certificate.
        * `certificates.#.issuer` - Who verified and signed the certificate, roughly following
        [RFC2253](https://tools.ietf.org/html/rfc2253).
        * `certificates.#.public_key_algorithm` - The algorithm used to create the certificate.
        * `certificates.#.serial_number` - Number that uniquely identifies the certificate with the CA's system. The `format`
        function can be used to convert this base 10 number into other bases, such as hex.
        * `certificates.#.sha1_fingerprint` - The SHA1 fingerprint of the public key of the certificate.
        * `certificates.#.signature_algorithm` - The algorithm used to sign the certificate.
        * `certificates.#.subject` - The entity the certificate belongs to, roughly following
        [RFC2253](https://tools.ietf.org/html/rfc2253).
        * `certificates.#.version` - The version the certificate is in.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        __self__.url = url
        if verify_chain and not isinstance(verify_chain, bool):
            raise TypeError("Expected argument 'verify_chain' to be a bool")
        __self__.verify_chain = verify_chain
class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificates=self.certificates,
            id=self.id,
            url=self.url,
            verify_chain=self.verify_chain)

def get_certificate(url=None,verify_chain=None,opts=None):
    """
    Use this data source to get information, such as SHA1 fingerprint or serial number, about the TLS certificates that
    protect an HTTPS website. Note that the certificate chain isn't verified.


    :param str url: The URL of the website to get the certificates from.
    :param bool verify_chain: Whether to verify the certificate chain while parsing it or not
    """
    __args__ = dict()


    __args__['url'] = url
    __args__['verifyChain'] = verify_chain
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('tls:index/getCertificate:getCertificate', __args__, opts=opts).value

    return AwaitableGetCertificateResult(
        certificates=__ret__.get('certificates'),
        id=__ret__.get('id'),
        url=__ret__.get('url'),
        verify_chain=__ret__.get('verifyChain'))
