# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetPublicKeyResult:
    """
    A collection of values returned by getPublicKey.
    """
    def __init__(__self__, algorithm=None, id=None, private_key_pem=None, public_key_fingerprint_md5=None, public_key_openssh=None, public_key_pem=None):
        if algorithm and not isinstance(algorithm, str):
            raise TypeError("Expected argument 'algorithm' to be a str")
        __self__.algorithm = algorithm
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if private_key_pem and not isinstance(private_key_pem, str):
            raise TypeError("Expected argument 'private_key_pem' to be a str")
        __self__.private_key_pem = private_key_pem
        """
        The private key data in PEM format.
        """
        if public_key_fingerprint_md5 and not isinstance(public_key_fingerprint_md5, str):
            raise TypeError("Expected argument 'public_key_fingerprint_md5' to be a str")
        __self__.public_key_fingerprint_md5 = public_key_fingerprint_md5
        """
        The md5 hash of the public key data in
        OpenSSH MD5 hash format, e.g. `aa:bb:cc:...`. Only available if the
        selected private key format is compatible, as per the rules for
        `public_key_openssh`.
        """
        if public_key_openssh and not isinstance(public_key_openssh, str):
            raise TypeError("Expected argument 'public_key_openssh' to be a str")
        __self__.public_key_openssh = public_key_openssh
        """
        The public key data in OpenSSH `authorized_keys`
        format, if the selected private key format is compatible. All RSA keys
        are supported, and ECDSA keys with curves "P256", "P384" and "P521"
        are supported. This attribute is empty if an incompatible ECDSA curve
        is selected.
        """
        if public_key_pem and not isinstance(public_key_pem, str):
            raise TypeError("Expected argument 'public_key_pem' to be a str")
        __self__.public_key_pem = public_key_pem
        """
        The public key data in PEM format.
        """
class AwaitableGetPublicKeyResult(GetPublicKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicKeyResult(
            algorithm=self.algorithm,
            id=self.id,
            private_key_pem=self.private_key_pem,
            public_key_fingerprint_md5=self.public_key_fingerprint_md5,
            public_key_openssh=self.public_key_openssh,
            public_key_pem=self.public_key_pem)

def get_public_key(private_key_pem=None,opts=None):
    """
    Use this data source to get the public key from a PEM-encoded private key for use in other
    resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_tls as tls

    example = tls.get_public_key(private_key_pem=(lambda path: open(path).read())("~/.ssh/id_rsa"))
    ```


    :param str private_key_pem: The private key to use. Currently-supported key types are "RSA" or "ECDSA".
    """
    __args__ = dict()


    __args__['privateKeyPem'] = private_key_pem
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('tls:index/getPublicKey:getPublicKey', __args__, opts=opts).value

    return AwaitableGetPublicKeyResult(
        algorithm=__ret__.get('algorithm'),
        id=__ret__.get('id'),
        private_key_pem=__ret__.get('privateKeyPem'),
        public_key_fingerprint_md5=__ret__.get('publicKeyFingerprintMd5'),
        public_key_openssh=__ret__.get('publicKeyOpenssh'),
        public_key_pem=__ret__.get('publicKeyPem'))
