"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An Origin that represents a group.
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 */
class OriginGroup {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_OriginGroupProps(props);
    }
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.OriginGroup", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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