# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class SecretBackendRole(pulumi.CustomResource):
    backend: pulumi.Output[str]
    """
    The unique name of the Vault mount to configure.
    """
    creation_statements: pulumi.Output[list]
    """
    The database statements to execute when
    creating a user.
    """
    db_name: pulumi.Output[str]
    """
    The unique name of the database connection to use for
    the role.
    """
    default_ttl: pulumi.Output[float]
    """
    The default number of seconds for leases for this
    role.
    """
    max_ttl: pulumi.Output[float]
    """
    The maximum number of seconds for leases for this
    role.
    """
    name: pulumi.Output[str]
    """
    A unique name to give the role.
    """
    renew_statements: pulumi.Output[list]
    """
    The database statements to execute when
    renewing a user.
    """
    revocation_statements: pulumi.Output[list]
    """
    The database statements to execute when
    revoking a user.
    """
    rollback_statements: pulumi.Output[list]
    """
    The database statements to execute when
    rolling back creation due to an error.
    """
    def __init__(__self__, resource_name, opts=None, backend=None, creation_statements=None, db_name=None, default_ttl=None, max_ttl=None, name=None, renew_statements=None, revocation_statements=None, rollback_statements=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a SecretBackendRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[list] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[float] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[float] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[str] name: A unique name to give the role.
        :param pulumi.Input[list] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[list] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[list] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            if creation_statements is None:
                raise TypeError("Missing required property 'creation_statements'")
            __props__['creation_statements'] = creation_statements
            if db_name is None:
                raise TypeError("Missing required property 'db_name'")
            __props__['db_name'] = db_name
            __props__['default_ttl'] = default_ttl
            __props__['max_ttl'] = max_ttl
            __props__['name'] = name
            __props__['renew_statements'] = renew_statements
            __props__['revocation_statements'] = revocation_statements
            __props__['rollback_statements'] = rollback_statements
        super(SecretBackendRole, __self__).__init__(
            'vault:database/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, backend=None, creation_statements=None, db_name=None, default_ttl=None, max_ttl=None, name=None, renew_statements=None, revocation_statements=None, rollback_statements=None):
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[list] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[float] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[float] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[str] name: A unique name to give the role.
        :param pulumi.Input[list] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[list] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[list] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["creation_statements"] = creation_statements
        __props__["db_name"] = db_name
        __props__["default_ttl"] = default_ttl
        __props__["max_ttl"] = max_ttl
        __props__["name"] = name
        __props__["renew_statements"] = renew_statements
        __props__["revocation_statements"] = revocation_statements
        __props__["rollback_statements"] = rollback_statements
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
