# coding: utf-8

# flake8: noqa
"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from symbl_rest.models.action import Action
from symbl_rest.models.action_item_list_response import ActionItemListResponse
from symbl_rest.models.async_audio_url_parameters import AsyncAudioUrlParameters
from symbl_rest.models.async_confidence_threshold import AsyncConfidenceThreshold
from symbl_rest.models.async_detect_phrases import AsyncDetectPhrases
from symbl_rest.models.async_entities_payload import AsyncEntitiesPayload
from symbl_rest.models.async_meeting_name import AsyncMeetingName
from symbl_rest.models.async_messages_field import AsyncMessagesField
from symbl_rest.models.async_messages_field_inner import AsyncMessagesFieldInner
from symbl_rest.models.async_response import AsyncResponse
from symbl_rest.models.async_text_parameters import AsyncTextParameters
from symbl_rest.models.async_video_url_parameters import AsyncVideoUrlParameters
from symbl_rest.models.audio_config import AudioConfig
from symbl_rest.models.avatar import Avatar
from symbl_rest.models.conversation import Conversation
from symbl_rest.models.conversation_action_item import ConversationActionItem
from symbl_rest.models.conversation_follow_up import ConversationFollowUp
from symbl_rest.models.conversation_insight_item import ConversationInsightItem
from symbl_rest.models.conversation_intent import ConversationIntent
from symbl_rest.models.conversation_message import ConversationMessage
from symbl_rest.models.conversation_question import ConversationQuestion
from symbl_rest.models.conversation_topic import ConversationTopic
from symbl_rest.models.custom_entities import CustomEntities
from symbl_rest.models.duration_payload import DurationPayload
from symbl_rest.models.endpoint import Endpoint
from symbl_rest.models.endpoint_connect_request import EndpointConnectRequest
from symbl_rest.models.endpoint_connect_response import EndpointConnectResponse
from symbl_rest.models.endpoint_request_data import EndpointRequestData
from symbl_rest.models.error import Error
from symbl_rest.models.external_event import ExternalEvent
from symbl_rest.models.follow_up_list_response import FollowUpListResponse
from symbl_rest.models.from_payload import FromPayload
from symbl_rest.models.generic_error import GenericError
from symbl_rest.models.grant import Grant
from symbl_rest.models.insights_list_response import InsightsListResponse
from symbl_rest.models.intent import Intent
from symbl_rest.models.intent_list_response import IntentListResponse
from symbl_rest.models.job_response import JobResponse
from symbl_rest.models.language import Language
from symbl_rest.models.location_trunc import LocationTrunc
from symbl_rest.models.member_list_response import MemberListResponse
from symbl_rest.models.members_info import MembersInfo
from symbl_rest.models.message_list_response import MessageListResponse
from symbl_rest.models.metric import Metric
from symbl_rest.models.metric_entry import MetricEntry
from symbl_rest.models.metric_entry_create import MetricEntryCreate
from symbl_rest.models.metric_entry_response import MetricEntryResponse
from symbl_rest.models.metric_label import MetricLabel
from symbl_rest.models.metric_response import MetricResponse
from symbl_rest.models.model_from import ModelFrom
from symbl_rest.models.parent_ref import ParentRef
from symbl_rest.models.phrase import Phrase
from symbl_rest.models.question_list_response import QuestionListResponse
from symbl_rest.models.refresh_token_request import RefreshTokenRequest
from symbl_rest.models.revoke_token_request import RevokeTokenRequest
from symbl_rest.models.sentiment import Sentiment
from symbl_rest.models.sentiment_polarity import SentimentPolarity
from symbl_rest.models.session_trunc import SessionTrunc
from symbl_rest.models.session_user import SessionUser
from symbl_rest.models.summary_info import SummaryInfo
from symbl_rest.models.tag import Tag
from symbl_rest.models.text_payload import TextPayload
from symbl_rest.models.time_zone import TimeZone
from symbl_rest.models.token import Token
from symbl_rest.models.topic_list_response import TopicListResponse
from symbl_rest.models.unauthorized_error import UnauthorizedError
from symbl_rest.models.user_trunc import UserTrunc
from symbl_rest.models.word import Word
