# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EndpointConnectResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'connection_id': 'str',
        'event_url': 'str',
        'result_web_socket_url': 'str',
        'conversation_id': 'str',
        'summary_info': 'list[SummaryInfo]'
    }

    attribute_map = {
        'connection_id': 'connectionId',
        'event_url': 'eventUrl',
        'result_web_socket_url': 'resultWebSocketUrl',
        'conversation_id': 'conversationId',
        'summary_info': 'summaryInfo'
    }

    def __init__(self, connection_id=None, event_url=None, result_web_socket_url=None, conversation_id=None, summary_info=None):  # noqa: E501
        """EndpointConnectResponse - a model defined in Swagger"""  # noqa: E501
        self._connection_id = None
        self._event_url = None
        self._result_web_socket_url = None
        self._conversation_id = None
        self._summary_info = None
        self.discriminator = None
        self.connection_id = connection_id
        if event_url is not None:
            self.event_url = event_url
        if result_web_socket_url is not None:
            self.result_web_socket_url = result_web_socket_url
        if conversation_id is not None:
            self.conversation_id = conversation_id
        if summary_info is not None:
            self.summary_info = summary_info

    @property
    def connection_id(self):
        """Gets the connection_id of this EndpointConnectResponse.  # noqa: E501

        Unique Id for the connection  # noqa: E501

        :return: The connection_id of this EndpointConnectResponse.  # noqa: E501
        :rtype: str
        """
        return self._connection_id

    @connection_id.setter
    def connection_id(self, connection_id):
        """Sets the connection_id of this EndpointConnectResponse.

        Unique Id for the connection  # noqa: E501

        :param connection_id: The connection_id of this EndpointConnectResponse.  # noqa: E501
        :type: str
        """
        if connection_id is None:
            raise ValueError("Invalid value for `connection_id`, must not be `None`")  # noqa: E501

        self._connection_id = connection_id

    @property
    def event_url(self):
        """Gets the event_url of this EndpointConnectResponse.  # noqa: E501

        WebHook URL to be used to publish any events externally (started_speaking, stopped_speaking etc.)  # noqa: E501

        :return: The event_url of this EndpointConnectResponse.  # noqa: E501
        :rtype: str
        """
        return self._event_url

    @event_url.setter
    def event_url(self, event_url):
        """Sets the event_url of this EndpointConnectResponse.

        WebHook URL to be used to publish any events externally (started_speaking, stopped_speaking etc.)  # noqa: E501

        :param event_url: The event_url of this EndpointConnectResponse.  # noqa: E501
        :type: str
        """

        self._event_url = event_url

    @property
    def result_web_socket_url(self):
        """Gets the result_web_socket_url of this EndpointConnectResponse.  # noqa: E501

        WebSocket URL on which the results will be published  # noqa: E501

        :return: The result_web_socket_url of this EndpointConnectResponse.  # noqa: E501
        :rtype: str
        """
        return self._result_web_socket_url

    @result_web_socket_url.setter
    def result_web_socket_url(self, result_web_socket_url):
        """Sets the result_web_socket_url of this EndpointConnectResponse.

        WebSocket URL on which the results will be published  # noqa: E501

        :param result_web_socket_url: The result_web_socket_url of this EndpointConnectResponse.  # noqa: E501
        :type: str
        """

        self._result_web_socket_url = result_web_socket_url

    @property
    def conversation_id(self):
        """Gets the conversation_id of this EndpointConnectResponse.  # noqa: E501

        Unique ID for the conversation  # noqa: E501

        :return: The conversation_id of this EndpointConnectResponse.  # noqa: E501
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """Sets the conversation_id of this EndpointConnectResponse.

        Unique ID for the conversation  # noqa: E501

        :param conversation_id: The conversation_id of this EndpointConnectResponse.  # noqa: E501
        :type: str
        """

        self._conversation_id = conversation_id

    @property
    def summary_info(self):
        """Gets the summary_info of this EndpointConnectResponse.  # noqa: E501

        The information objects containing details on post meeting Summary UI  # noqa: E501

        :return: The summary_info of this EndpointConnectResponse.  # noqa: E501
        :rtype: list[SummaryInfo]
        """
        return self._summary_info

    @summary_info.setter
    def summary_info(self, summary_info):
        """Sets the summary_info of this EndpointConnectResponse.

        The information objects containing details on post meeting Summary UI  # noqa: E501

        :param summary_info: The summary_info of this EndpointConnectResponse.  # noqa: E501
        :type: list[SummaryInfo]
        """

        self._summary_info = summary_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EndpointConnectResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EndpointConnectResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
