/*
 Highcharts JS v8.0.4 (2020-03-10)

 Annotations module

 (c) 2009-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/modules/annotations",["highcharts"],function(m){e(m);e.Highcharts=m;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function m(d,c,e,k){d.hasOwnProperty(c)||(d[c]=k.apply(null,e))}e=e?e._modules:{};m(e,"annotations/eventEmitterMixin.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,c){var e=c.addEvent,k=c.inArray,
b=c.objectEach,t=c.pick,q=c.removeEvent,v=d.fireEvent;return{addEvents:function(){var a=this;e(a.graphic.element,"mousedown",function(h){a.onMouseDown(h)});b(a.options.events,function(h,b){var f=function(g){"click"===b&&a.cancelClick||h.call(a,a.chart.pointer.normalize(g),a.target)};if(-1===k(b,a.nonDOMEvents||[]))a.graphic.on(b,f);else e(a,b,f)});a.options.draggable&&(e(a,"drag",a.onDrag),a.graphic.renderer.styledMode||a.graphic.css({cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[a.options.draggable]}));
a.isUpdating||v(a,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(a){var h=this,b=h.chart.pointer;a.preventDefault&&a.preventDefault();if(2!==a.button){a=b.normalize(a);var f=a.chartX;var g=a.chartY;h.cancelClick=!1;h.chart.hasDraggedAnnotation=!0;h.removeDrag=e(d.doc,"mousemove",function(a){h.hasDragged=!0;a=b.normalize(a);a.prevChartX=f;a.prevChartY=g;v(h,"drag",a);f=a.chartX;
g=a.chartY});h.removeMouseUp=e(d.doc,"mouseup",function(g){h.cancelClick=h.hasDragged;h.hasDragged=!1;h.chart.hasDraggedAnnotation=!1;v(t(h.target,h),"afterUpdate");h.onMouseUp(g)})}},onMouseUp:function(a){var h=this.chart;a=this.target||this;var b=h.options.annotations;h=h.annotations.indexOf(a);this.removeDocEvents();b[h]=a.options},onDrag:function(a){if(this.chart.isInsidePlot(a.chartX-this.chart.plotLeft,a.chartY-this.chart.plotTop)){var h=this.mouseMoveToTranslation(a);"x"===this.options.draggable&&
(h.y=0);"y"===this.options.draggable&&(h.x=0);this.points.length?this.translate(h.x,h.y):(this.shapes.forEach(function(a){a.translate(h.x,h.y)}),this.labels.forEach(function(a){a.translate(h.x,h.y)}));this.redraw(!1)}},mouseMoveToRadians:function(a,h,b){var f=a.prevChartY-b,g=a.prevChartX-h;b=a.chartY-b;a=a.chartX-h;this.chart.inverted&&(h=g,g=f,f=h,h=a,a=b,b=h);return Math.atan2(b,a)-Math.atan2(f,g)},mouseMoveToTranslation:function(a){var h=a.chartX-a.prevChartX;a=a.chartY-a.prevChartY;if(this.chart.inverted){var b=
a;a=h;h=b}return{x:h,y:a}},mouseMoveToScale:function(a,h,b){h=(a.chartX-h||1)/(a.prevChartX-h||1);a=(a.chartY-b||1)/(a.prevChartY-b||1);this.chart.inverted&&(b=a,a=h,h=b);return{x:h,y:a}},destroy:function(){this.removeDocEvents();q(this);this.hcEvents=null}}});m(e,"annotations/ControlPoint.js",[e["parts/Utilities.js"],e["annotations/eventEmitterMixin.js"]],function(d,c){var e=d.extend,k=d.merge,b=d.pick;d=function(c,d,e,a){this.chart=c;this.target=d;this.options=e;this.index=b(e.index,a)};e(d.prototype,
c);d.prototype.nonDOMEvents=["drag"];d.prototype.setVisibility=function(b){this.graphic.attr("visibility",b?"visible":"hidden");this.options.visible=b};d.prototype.render=function(){var b=this.chart,c=this.options;this.graphic=b.renderer.symbol(c.symbol,0,0,c.width,c.height).add(b.controlPointsGroup).css(c.style);this.setVisibility(c.visible);this.addEvents()};d.prototype.redraw=function(b){this.graphic[b?"animate":"attr"](this.options.positioner.call(this,this.target))};d.prototype.destroy=function(){c.destroy.call(this);
this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};d.prototype.update=function(b){var c=this.chart,d=this.target,a=this.index;b=k(!0,this.options,b);this.destroy();this.constructor(c,d,b,a);this.render(c.controlPointsGroup);this.redraw()};return d});m(e,"annotations/MockPoint.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,c){var e=c.defined;c=c.extend;var k=function(b,c,e){this.series={visible:!0,chart:b,getPlotBox:d.Series.prototype.getPlotBox};
this.target=c||null;this.options=e;this.applyOptions(this.getOptions())};k.fromPoint=function(b){return new k(b.series.chart,null,{x:b.x,y:b.y,xAxis:b.series.xAxis,yAxis:b.series.yAxis})};k.pointToPixels=function(b,c){var d=b.series,e=d.chart,a=b.plotX,h=b.plotY;e.inverted&&(b.mock?(a=b.plotY,h=b.plotX):(a=e.plotWidth-b.plotY,h=e.plotHeight-b.plotX));d&&!c&&(b=d.getPlotBox(),a+=b.translateX,h+=b.translateY);return{x:a,y:h}};k.pointToOptions=function(b){return{x:b.x,y:b.y,xAxis:b.series.xAxis,yAxis:b.series.yAxis}};
c(k.prototype,{mock:!0,hasDynamicOptions:function(){return"function"===typeof this.options},getOptions:function(){return this.hasDynamicOptions()?this.options(this.target):this.options},applyOptions:function(b){this.command=b.command;this.setAxis(b,"x");this.setAxis(b,"y");this.refresh()},setAxis:function(b,c){c+="Axis";b=b[c];var q=this.series.chart;this.series[c]=b instanceof d.Axis?b:e(b)?q[c][b]||q.get(b):null},toAnchor:function(){var b=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&
(b[0]=this.plotY,b[1]=this.plotX);return b},getLabelConfig:function(){return{x:this.x,y:this.y,point:this}},isInsidePane:function(){var b=this.plotX,c=this.plotY,d=this.series.xAxis,k=this.series.yAxis,a=!0;d&&(a=e(b)&&0<=b&&b<=d.len);k&&(a=a&&e(c)&&0<=c&&c<=k.len);return a},refresh:function(){var b=this.series,c=b.xAxis;b=b.yAxis;var d=this.getOptions();c?(this.x=d.x,this.plotX=c.toPixels(d.x,!0)):(this.x=null,this.plotX=d.x);b?(this.y=d.y,this.plotY=b.toPixels(d.y,!0)):(this.y=null,this.plotY=d.y);
this.isInside=this.isInsidePane()},translate:function(b,c,d,e){this.hasDynamicOptions()||(this.plotX+=d,this.plotY+=e,this.refreshOptions())},scale:function(b,c,d,e){if(!this.hasDynamicOptions()){var a=this.plotY*e;this.plotX=(1-d)*b+this.plotX*d;this.plotY=(1-e)*c+a;this.refreshOptions()}},rotate:function(b,c,d){if(!this.hasDynamicOptions()){var e=Math.cos(d);d=Math.sin(d);var a=this.plotX,h=this.plotY;a-=b;h-=c;this.plotX=a*e-h*d+b;this.plotY=a*d+h*e+c;this.refreshOptions()}},refreshOptions:function(){var b=
this.series,c=b.xAxis;b=b.yAxis;this.x=this.options.x=c?this.options.x=c.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=b?b.toValue(this.plotY,!0):this.plotY}});return k});m(e,"annotations/controllable/controllableMixin.js",[e["parts/Utilities.js"],e["annotations/ControlPoint.js"],e["annotations/MockPoint.js"],e["parts/Tooltip.js"]],function(d,c,e,k){var b=d.isObject,t=d.isString,q=d.merge,B=d.splat;return{init:function(a,b,c){this.annotation=a;this.chart=a.chart;this.options=b;this.points=
[];this.controlPoints=[];this.index=c;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var a=this.options;return a.points||a.point&&B(a.point)},attrsFromOptions:function(a){var b=this.constructor.attrsMap,c={},f,g=this.chart.styledMode;for(f in a){var l=b[f];!l||g&&-1!==["fill","stroke","stroke-width"].indexOf(l)||(c[l]=a[f])}return c},anchor:function(a){var b=a.series.getPlotBox();a=a.mock?a.toAnchor():k.prototype.getAnchor.call({chart:a.series.chart},
a);a={x:a[0]+(this.options.x||0),y:a[1]+(this.options.y||0),height:a[2]||0,width:a[3]||0};return{relativePosition:a,absolutePosition:q(a,{x:a.x+b.translateX,y:a.y+b.translateY})}},point:function(a,c){if(a&&a.series)return a;c&&null!==c.series||(b(a)?c=new e(this.chart,this,a):t(a)?c=this.chart.get(a)||null:"function"===typeof a&&(c=a.call(c,this),c=c.series?c:new e(this.chart,this,a)));return c},linkPoints:function(){var a=this.getPointsOptions(),b=this.points,c=a&&a.length||0,f;for(f=0;f<c;f++){var g=
this.point(a[f],b[f]);if(!g){b.length=0;return}g.mock&&g.refresh();b[f]=g}return b},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(b,d){b=q(this.options.controlPointOptions,b);b.index||(b.index=d);a[d]=b;this.controlPoints.push(new c(this.chart,this,b))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(a){this.controlPoints.forEach(function(a){a.render()})},redraw:function(a){this.controlPoints.forEach(function(b){b.redraw(a)})},transform:function(a,
b,c,f,g){if(this.chart.inverted){var l=b;b=c;c=l}this.points.forEach(function(l,d){this.transformPoint(a,b,c,f,g,d)},this)},transformPoint:function(a,b,c,f,g,l){var d=this.points[l];d.mock||(d=this.points[l]=e.fromPoint(d));d[a](b,c,f,g)},translate:function(a,b){this.transform("translate",null,null,a,b)},translatePoint:function(a,b,c){this.transformPoint("translate",null,null,a,b,c)},translateShape:function(a,b){var c=this.annotation.chart,f=this.annotation.userOptions,g=c.annotations.indexOf(this.annotation);
c=c.options.annotations[g];this.translatePoint(a,b,0);c[this.collection][this.index].point=this.options.point;f[this.collection][this.index].point=this.options.point},rotate:function(a,b,c){this.transform("rotate",a,b,c)},scale:function(a,b,c,f){this.transform("scale",a,b,c,f)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(b){b.setVisibility(a)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());
this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var b=this.annotation;a=q(!0,this.options,a);var c=this.graphic.parentGroup;this.destroy();this.constructor(b,a);this.render(c);this.redraw()}}});m(e,"annotations/controllable/markerMixin.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,c){var e=c.addEvent,k=c.defined,b=c.merge,t=c.objectEach,q=c.uniqueKey,v={arrow:{tagName:"marker",
render:!1,id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 0 L 10 5 L 0 10 Z",strokeWidth:0}]},"reverse-arrow":{tagName:"marker",render:!1,id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 5 L 10 0 L 10 10 Z",strokeWidth:0}]}};d.SVGRenderer.prototype.addMarker=function(a,c){var d={id:a},f={stroke:c.color||"none",fill:c.color||"rgba(0, 0, 0, 0.75)"};d.children=c.children.map(function(a){return b(f,a)});c=this.definition(b(!0,
{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"},c,d));c.id=a;return c};c=function(a){return function(b){this.attr(a,"url(#"+b+")")}};c={markerEndSetter:c("marker-end"),markerStartSetter:c("marker-start"),setItemMarkers:function(a){var c=a.options,d=a.chart,f=d.options.defs,g=c.fill,l=k(g)&&"none"!==g?g:c.stroke;["markerStart","markerEnd"].forEach(function(g){var p=c[g],e;if(p){for(e in f){var h=f[e];if(p===h.id&&"marker"===h.tagName){var n=h;break}}n&&(p=a[g]=d.renderer.addMarker((c.id||
q())+"-"+n.id,b(n,{color:l})),a.attr(g,p.attr("id")))}})}};e(d.Chart,"afterGetContainer",function(){this.options.defs=b(v,this.options.defs||{});t(this.options.defs,function(a){"marker"===a.tagName&&!1!==a.render&&this.renderer.addMarker(a.id,a)},this)});return c});m(e,"annotations/controllable/ControllablePath.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/controllable/markerMixin.js"]],function(d,c,e,k){var b=c.extend;c=c.merge;
var t="rgba(192,192,192,"+(d.svg?.0001:.002)+")";d=function(b,c,a){this.init(b,c,a);this.collection="shapes"};d.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};c(!0,d.prototype,e,{type:"path",setMarkers:k.setItemMarkers,toD:function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;var c=this.points,a=c.length,d=a,e=c[0],f=d&&this.anchor(e).absolutePosition,g=0,l=2;for(b=f&&["M",f.x,f.y];++g<a&&d;)e=c[g],d=e.command||"L",
f=this.anchor(e).absolutePosition,"Z"===d?b[++l]=d:(d!==c[g-1].command&&(b[++l]=d),b[++l]=f.x,b[++l]=f.y),d=e.series.visible;return d?this.chart.renderer.crispLine(b,this.graphic.strokeWidth()):null},shouldBeDrawn:function(){return e.shouldBeDrawn.call(this)||!!this.options.d},render:function(c){var d=this.options,a=this.attrsFromOptions(d);this.graphic=this.annotation.chart.renderer.path(["M",0,0]).attr(a).add(c);d.className&&this.graphic.addClass(d.className);this.tracker=this.annotation.chart.renderer.path(["M",
0,0]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(c);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:t,fill:t,"stroke-width":this.graphic.strokeWidth()+2*d.snap});e.render.call(this);b(this.graphic,{markerStartSetter:k.markerStartSetter,markerEndSetter:k.markerEndSetter});this.setMarkers(this)},redraw:function(b){var c=this.toD(),a=b?"animate":"attr";c?(this.graphic[a]({d:c}),this.tracker[a]({d:c})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));
this.graphic.placed=this.tracker.placed=!!c;e.redraw.call(this,b)}});return d});m(e,"annotations/controllable/ControllableRect.js",[e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/controllable/ControllablePath.js"]],function(d,c,e){d=d.merge;var k=function(b,c,d){this.init(b,c,d);this.collection="shapes"};k.attrsMap=d(e.attrsMap,{width:"width",height:"height"});d(!0,k.prototype,c,{type:"rect",translate:c.translateShape,render:function(b){var d=this.attrsFromOptions(this.options);
this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(d).add(b);c.render.call(this)},redraw:function(b){var d=this.anchor(this.points[0]).absolutePosition;if(d)this.graphic[b?"animate":"attr"]({x:d.x,y:d.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!d;c.redraw.call(this,b)}});return k});m(e,"annotations/controllable/ControllableCircle.js",[e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/controllable/ControllablePath.js"]],
function(d,c,e){d=d.merge;var k=function(b,c,d){this.init(b,c,d);this.collection="shapes"};k.attrsMap=d(e.attrsMap,{r:"r"});d(!0,k.prototype,c,{type:"circle",translate:c.translateShape,render:function(b){var d=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(d).add(b);c.render.call(this)},redraw:function(b){var d=this.anchor(this.points[0]).absolutePosition;if(d)this.graphic[b?"animate":"attr"]({x:d.x,y:d.y,r:this.options.r});else this.graphic.attr({x:0,
y:-9E9});this.graphic.placed=!!d;c.redraw.call(this,b)},setRadius:function(b){this.options.r=b}});return k});m(e,"annotations/controllable/ControllableLabel.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/MockPoint.js"],e["parts/Tooltip.js"]],function(d,c,e,k,b){var t=c.extend,q=c.format,B=c.isNumber,a=c.merge,h=c.pick,m=function(a,g,b){this.init(a,g,b);this.collection="labels"};m.shapesWithoutBackground=["connector"];m.alignedPosition=
function(a,b){var c=a.align,g=a.verticalAlign,f=(b.x||0)+(a.x||0),d=(b.y||0)+(a.y||0),e,n;"right"===c?e=1:"center"===c&&(e=2);e&&(f+=(b.width-(a.width||0))/e);"bottom"===g?n=1:"middle"===g&&(n=2);n&&(d+=(b.height-(a.height||0))/n);return{x:Math.round(f),y:Math.round(d)}};m.justifiedOptions=function(a,b,c,d){var g=c.align,f=c.verticalAlign,e=b.box?0:b.padding||0,n=b.getBBox();b={align:g,verticalAlign:f,x:c.x,y:c.y,width:b.width,height:b.height};c=d.x-a.plotLeft;var l=d.y-a.plotTop;d=c+e;0>d&&("right"===
g?b.align="left":b.x=-d);d=c+n.width-e;d>a.plotWidth&&("left"===g?b.align="right":b.x=a.plotWidth-d);d=l+e;0>d&&("bottom"===f?b.verticalAlign="top":b.y=-d);d=l+n.height-e;d>a.plotHeight&&("top"===f?b.verticalAlign="bottom":b.y=a.plotHeight-d);return b};m.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};a(!0,m.prototype,e,{translatePoint:function(b,a){e.translatePoint.call(this,b,a,0)},translate:function(b,a){var c=
this.annotation.chart,d=this.annotation.userOptions,g=c.annotations.indexOf(this.annotation);g=c.options.annotations[g];c.inverted&&(c=b,b=a,a=c);this.options.x+=b;this.options.y+=a;g[this.collection][this.index].x=this.options.x;g[this.collection][this.index].y=this.options.y;d[this.collection][this.index].x=this.options.x;d[this.collection][this.index].y=this.options.y},render:function(b){var a=this.options,c=this.attrsFromOptions(a),d=a.style;this.graphic=this.annotation.chart.renderer.label("",
0,-9999,a.shape,null,null,a.useHTML,null,"annotation-label").attr(c).add(b);this.annotation.chart.styledMode||("contrast"===d.color&&(d.color=this.annotation.chart.renderer.getContrast(-1<m.shapesWithoutBackground.indexOf(a.shape)?"#FFFFFF":a.backgroundColor)),this.graphic.css(a.style).shadow(a.shadow));a.className&&this.graphic.addClass(a.className);this.graphic.labelrank=a.labelrank;e.render.call(this)},redraw:function(a){var b=this.options,c=this.text||b.format||b.text,d=this.graphic,f=this.points[0];
d.attr({text:c?q(c,f.getLabelConfig(),this.annotation.chart):b.formatter.call(f,this)});b=this.anchor(f);(c=this.position(b))?(d.alignAttr=c,c.anchorX=b.absolutePosition.x,c.anchorY=b.absolutePosition.y,d[a?"animate":"attr"](c)):d.attr({x:0,y:-9999});d.placed=!!c;e.redraw.call(this,a)},anchor:function(){var b=e.anchor.apply(this,arguments),a=this.options.x||0,c=this.options.y||0;b.absolutePosition.x-=a;b.absolutePosition.y-=c;b.relativePosition.x-=a;b.relativePosition.y-=c;return b},position:function(a){var c=
this.graphic,d=this.annotation.chart,f=this.points[0],e=this.options,u=a.absolutePosition,r=a.relativePosition;if(a=f.series.visible&&k.prototype.isInsidePane.call(f)){if(e.distance)var n=b.prototype.getPosition.call({chart:d,distance:h(e.distance,16)},c.width,c.height,{plotX:r.x,plotY:r.y,negative:f.negative,ttBelow:f.ttBelow,h:r.height||r.width});else e.positioner?n=e.positioner.call(this):(f={x:u.x,y:u.y,width:0,height:0},n=m.alignedPosition(t(e,{width:c.width,height:c.height}),f),"justify"===
this.options.overflow&&(n=m.alignedPosition(m.justifiedOptions(d,c,e,n),f)));e.crop&&(e=n.x-d.plotLeft,f=n.y-d.plotTop,a=d.isInsidePlot(e,f)&&d.isInsidePlot(e+c.width,f+c.height))}return a?n:null}});d.SVGRenderer.prototype.symbols.connector=function(b,a,c,d,e){var f=e&&e.anchorX;e=e&&e.anchorY;var g=c/2;if(B(f)&&B(e)){var n=["M",f,e];var A=a-e;0>A&&(A=-d-A);A<c&&(g=f<b+c/2?A:c-A);e>a+d?n.push("L",b+g,a+d):e<a?n.push("L",b+g,a):f<b?n.push("L",b,a+d/2):f>b+c&&n.push("L",b+c,a+d/2)}return n||[]};return m});
m(e,"annotations/controllable/ControllableImage.js",[e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/controllable/ControllableLabel.js"]],function(d,c,e){d=d.merge;var k=function(b,c,d){this.init(b,c,d);this.collection="shapes"};k.attrsMap={width:"width",height:"height",zIndex:"zIndex"};d(!0,k.prototype,c,{type:"image",translate:c.translateShape,render:function(b){var d=this.attrsFromOptions(this.options),e=this.options;this.graphic=this.annotation.chart.renderer.image(e.src,
0,-9E9,e.width,e.height).attr(d).add(b);this.graphic.width=e.width;this.graphic.height=e.height;c.render.call(this)},redraw:function(b){var d=this.anchor(this.points[0]);if(d=e.prototype.position.call(this,d))this.graphic[b?"animate":"attr"]({x:d.x,y:d.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!d;c.redraw.call(this,b)}});return k});m(e,"annotations/annotations.btx.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["annotations/controllable/controllableMixin.js"],e["annotations/controllable/ControllableRect.js"],
e["annotations/controllable/ControllableCircle.js"],e["annotations/controllable/ControllablePath.js"],e["annotations/controllable/ControllableImage.js"],e["annotations/controllable/ControllableLabel.js"],e["annotations/eventEmitterMixin.js"],e["annotations/MockPoint.js"],e["annotations/ControlPoint.js"]],function(d,c,e,k,b,m,q,v,a,h,C){var f=c.addEvent,g=c.defined,l=c.destroyObjectProperties,p=c.erase,z=c.extend,u=c.find,r=c.merge,n=c.pick,A=c.splat;c=c.wrap;var w=d.fireEvent,D=d.reduce,x=d.Chart.prototype,
y=d.Annotation=function(b,a){this.chart=b;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=r(this.defaultOptions,a);this.userOptions=a;a=this.getLabelsAndShapesOptions(this.options,a);this.options.labels=a.labels;this.options.shapes=a.shapes;this.init(b,this.options)};r(!0,y.prototype,e,a,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",
borderColor:"black",borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return g(this.y)?this.y:"Annotation label"},overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:"black","stroke-width":2,fill:"white"},
visible:!1,events:{}},events:{},zIndex:6},init:function(){this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.addClipPaths();this.setLabelCollector()},getLabelsAndShapesOptions:function(a,b){var c={};["labels","shapes"].forEach(function(d){a[d]&&(c[d]=A(b[d]).map(function(b,c){return r(a[d][c],b)}))});return c},addShapes:function(){(this.options.shapes||[]).forEach(function(a,b){a=this.initShape(a,b);r(!0,this.options.shapes[b],a.options)},this)},addLabels:function(){(this.options.labels||
[]).forEach(function(a,b){a=this.initLabel(a,b);r(!0,this.options.labels[b],a.options)},this)},addClipPaths:function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},setClipAxes:function(){var a=this.chart.xAxis,b=this.chart.yAxis,c=D((this.options.labels||[]).concat(this.options.shapes||[]),function(c,d){return[a[d&&d.point&&d.point.xAxis]||c[0],b[d&&d.point&&d.point.yAxis]||c[1]]},[]);this.clipXAxis=c[0];this.clipYAxis=c[1]},getClipBox:function(){return{x:this.clipXAxis.left,
y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},setLabelCollector:function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,b){b.options.allowOverlap||a.push(b.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)},setOptions:function(a){this.options=r(this.defaultOptions,a)},redraw:function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,
a);this.redrawItems(this.labels,a);e.redraw.call(this,a)},redrawItems:function(a,b){for(var c=a.length;c--;)this.redrawItem(a[c],b)},render:function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.clipRect&&this.graphic.clip(this.clipRect);
this.addEvents();e.render.call(this)},setVisibility:function(a){var b=this.options;a=n(a,!b.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);b.visible=a},setControlPointsVisibility:function(a){var b=function(b){b.setControlPointsVisibility(a)};e.setControlPointsVisibility.call(this,a);this.shapes.forEach(b);this.labels.forEach(b)},destroy:function(){var b=this.chart,c=function(a){a.destroy()};this.labels.forEach(c);this.shapes.forEach(c);this.clipYAxis=
this.clipXAxis=null;p(b.labelCollectors,this.labelCollector);a.destroy.call(this);e.destroy.call(this);l(this,b)},remove:function(){return this.chart.removeAnnotation(this)},update:function(a){var b=this.chart,c=this.getLabelsAndShapesOptions(this.userOptions,a),d=b.annotations.indexOf(this);a=r(!0,this.userOptions,a);a.labels=c.labels;a.shapes=c.shapes;this.destroy();this.constructor(b,a);b.options.annotations[d]=a;this.isUpdating=!0;this.redraw();this.isUpdating=!1;w(this,"afterUpdate")},initShape:function(a,
b){a=r(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new y.shapesMap[a.type](this,a,b);b.itemType="shape";this.shapes.push(b);return b},initLabel:function(a,b){a=r(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new v(this,a,b);b.itemType="label";this.labels.push(b);return b},redrawItem:function(a,b){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(n(b,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):
this.destroyItem(a)},adjustVisibility:function(a){var b=!1,c=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(b=!0)});b?"hidden"===c.visibility&&c.show():c.hide()},destroyItem:function(a){p(this[a.itemType+"s"],a);a.destroy()},renderItem:function(a){a.render("label"===a.itemType?this.labelsGroup:this.shapesGroup)}});y.shapesMap={rect:k,circle:b,path:m,image:q};y.types={};y.MockPoint=h;y.ControlPoint=C;d.extendAnnotation=function(a,b,c,d){b=b||y;r(!0,a.prototype,b.prototype,
c);a.prototype.defaultOptions=r(a.prototype.defaultOptions,d||{})};z(x,{initAnnotation:function(a){a=new (y.types[a.type]||y)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,b){a=this.initAnnotation(a);this.options.annotations.push(a.options);n(b,!0)&&a.redraw();return a},removeAnnotation:function(a){var b=this.annotations,c="annotations"===a.coll?a:u(b,function(b){return b.options.id===a});c&&(w(c,"remove"),p(this.options.annotations,c.options),p(b,c),c.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);
this.annotations.forEach(function(a){a.redraw()})}});x.collectionsWithUpdate.push("annotations");x.collectionsWithInit.annotations=[x.addAnnotation];x.callbacks.push(function(a){a.annotations=[];a.options.annotations||(a.options.annotations=[]);a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,c){b=a.initAnnotation(b);a.options.annotations[c]=b.options});a.drawAnnotations();
f(a,"redraw",a.drawAnnotations);f(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()})});c(d.Pointer.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||a.apply(this,Array.prototype.slice.call(arguments,1))})});m(e,"mixins/navigation.js",[],function(){return{initUpdate:function(d){d.navigation||(d.navigation={updates:[],update:function(c,d){this.updates.forEach(function(e){e.update.call(e.context,c,d)})}})},addUpdate:function(d,c){c.navigation||
this.initUpdate(c);c.navigation.updates.push({update:d,context:c})}}});m(e,"annotations/navigationBindings.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/navigation.js"]],function(d,c,e){function k(b){var c=b.prototype.defaultOptions.events&&b.prototype.defaultOptions.events.click;l(!0,b.prototype.defaultOptions.events,{click:function(b){var d=this,e=d.chart.navigationBindings,f=e.activeAnnotation;c&&c.click.call(d,b);f!==d?(e.deselectAnnotation(),e.activeAnnotation=d,d.setControlPointsVisibility(!0),
a(e,"showPopup",{annotation:d,formType:"annotation-toolbar",options:e.annotationToFields(d),onSubmit:function(a){var b={};"remove"===a.actionType?(e.activeAnnotation=!1,e.chart.removeAnnotation(d)):(e.fieldsToOptions(a.fields,b),e.deselectAnnotation(),a=b.typeOptions,"measure"===d.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),d.update(b))}})):(e.deselectAnnotation(),a(e,"closePopup"));b.activeAnnotation=!0}})}var b=c.addEvent,m=
c.attr,q=c.extend,B=c.format,a=c.fireEvent,h=c.isArray,C=c.isFunction,f=c.isNumber,g=c.isObject,l=c.merge,p=c.objectEach,z=c.pick,u=d.doc,r=d.win;d.NavigationBindings=function(a,b){this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=u.getElementsByClassName(this.options.bindingsClassName)};d.NavigationBindings.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth",
"stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line",
"height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[]};d.NavigationBindings.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};q(d.NavigationBindings.prototype,{initEvents:function(){var a=this,c=a.chart,d=a.container,e=a.options;a.boundClassNames={};p(e.bindings,function(b){a.boundClassNames[b.className]=b});[].forEach.call(d,function(c){a.eventsToUnbind.push(b(c,"click",function(b){var c=a.getButtonEvents(d,b);c&&a.bindingsButtonClick(c.button,
c.events,b)}))});p(e.events||{},function(c,d){C(c)&&a.eventsToUnbind.push(b(a,d,c))});a.eventsToUnbind.push(b(c.container,"click",function(b){!c.cancelClick&&c.isInsidePlot(b.chartX-c.plotLeft,b.chartY-c.plotTop)&&a.bindingsChartClick(this,b)}));a.eventsToUnbind.push(b(c.container,"mousemove",function(b){a.bindingsContainerMouseMove(this,b)}))},initUpdate:function(){var a=this;e.addUpdate(function(b){a.update(b)},this.chart)},bindingsButtonClick:function(b,c,d){var e=this.chart;this.selectedButtonElement&&
(a(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&e.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=c;this.selectedButtonElement=b;a(this,"selectButton",{button:b});c.init&&c.init.call(this,b,d);(c.start||c.steps)&&e.renderer.boxWrapper.addClass("highcharts-draw-mode")},bindingsChartClick:function(b,c){b=this.chart;var d=this.selectedButton;b=b.renderer.boxWrapper;
var e;if(e=this.activeAnnotation&&!c.activeAnnotation&&c.target.parentNode){a:{e=c.target;var f=r.Element.prototype,g=f.matches||f.msMatchesSelector||f.webkitMatchesSelector,n=null;if(f.closest)n=f.closest.call(e,".highcharts-popup");else{do{if(g.call(e,".highcharts-popup"))break a;e=e.parentElement||e.parentNode}while(null!==e&&1===e.nodeType)}e=n}e=!e}e&&(a(this,"closePopup"),this.deselectAnnotation());d&&d.start&&(this.nextEvent?(this.nextEvent(c,this.currentUserDetails),this.steps&&(this.stepIndex++,
d.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=d.steps[this.stepIndex]:(a(this,"deselectButton",{button:this.selectedButtonElement}),b.removeClass("highcharts-draw-mode"),d.end&&d.end.call(this,c,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=d.start.call(this,c),d.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=d.steps[this.stepIndex]):(a(this,"deselectButton",{button:this.selectedButtonElement}),
b.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,d.end&&d.end.call(this,c,this.currentUserDetails))))},bindingsContainerMouseMove:function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)},fieldsToOptions:function(a,b){p(a,function(a,c){var d=parseFloat(a),e=c.split("."),g=b,n=e.length-1;!f(d)||a.match(/px/g)||c.match(/format/g)||(a=d);""!==a&&"undefined"!==a&&e.forEach(function(b,c){var d=z(e[c+1],"");n===c?g[b]=a:(g[b]||(g[b]=d.match(/\d/g)?[]:
{}),g=g[b])})});return b},deselectAnnotation:function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},annotationToFields:function(a){function b(c,d,e,l){if(e&&-1===k.indexOf(d)&&(0<=(e.indexOf&&e.indexOf(d))||e[d]||!0===e))if(h(c))l[d]=[],c.forEach(function(a,c){g(a)?(l[d][c]={},p(a,function(a,e){b(a,e,f[d],l[d][c])})):b(a,0,f[d],l[d])});else if(g(c)){var w={};h(l)?(l.push(w),w[d]={},w=w[d]):l[d]=w;p(c,function(a,c){b(a,c,0===d?e:f[d],w)})}else"format"===
d?l[d]=[B(c,a.labels[0].points[0]).toString(),"text"]:h(l)?l.push([c,n(c)]):l[d]=[c,n(c)]}var c=a.options,e=d.NavigationBindings.annotationsEditable,f=e.nestedOptions,n=this.utils.getFieldType,l=z(c.type,c.shapes&&c.shapes[0]&&c.shapes[0].type,c.labels&&c.labels[0]&&c.labels[0].itemType,"label"),k=d.NavigationBindings.annotationsNonEditable[c.langKey]||[],u={langKey:c.langKey,type:l};p(c,function(a,d){"typeOptions"===d?(u[d]={},p(c[d],function(a,c){b(a,c,f,u[d],!0)})):b(a,d,e[l],u)});return u},getClickedClassNames:function(a,
b){var c=b.target;b=[];for(var d;c&&((d=m(c,"class"))&&(b=b.concat(d.split(" ").map(function(a){return[a,c]}))),c=c.parentNode,c!==a););return b},getButtonEvents:function(a,b){var c=this,d;this.getClickedClassNames(a,b).forEach(function(a){c.boundClassNames[a[0]]&&!d&&(d={events:c.boundClassNames[a[0]],button:a[1]})});return d},update:function(a){this.options=l(!0,this.options,a);this.removeEvents();this.initEvents()},removeEvents:function(){this.eventsToUnbind.forEach(function(a){a()})},destroy:function(){this.removeEvents()},
utils:{updateRectSize:function(a,b){var c=b.chart,d=b.options.typeOptions,e=c.pointer.getCoordinates(a);a=e.xAxis[0].value-d.point.x;d=d.point.y-e.yAxis[0].value;b.update({typeOptions:{background:{width:c.inverted?d:a,height:c.inverted?a:d}}})},getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]}}});d.Chart.prototype.initNavigationBindings=function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new d.NavigationBindings(this,
a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};b(d.Chart,"load",function(){this.initNavigationBindings()});b(d.Chart,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});b(d.NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});b(d.Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});d.Annotation&&(k(d.Annotation),p(d.Annotation.types,function(a){k(a)}));
d.setOptions({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",
fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(l({langKey:"circle",shapes:[{type:"circle",point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},r:5,controlPoints:[{positioner:function(a){var b=d.Annotation.MockPoint.pointToPixels(a.points[0]);
a=a.options.r;return{x:b.x+a*Math.cos(Math.PI/4)-this.graphic.width/2,y:b.y+a*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(a,b){var c=b.annotation;a=this.mouseMoveToTranslation(a);b.setRadius(Math.max(b.options.r+a.y/Math.sin(Math.PI/4),5));c.options.shapes[0]=c.userOptions.shapes[0]=b.options;b.redraw(!1)}}}]}]},b.annotationsOptions,b.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].point,d=this.chart.xAxis[0].toPixels(c.x);c=this.chart.yAxis[0].toPixels(c.y);
var e=this.chart.inverted;b.update({shapes:[{r:Math.max(Math.sqrt(Math.pow(e?c-a.chartX:d-a.chartX,2)+Math.pow(e?d-a.chartY:c-a.chartY,2)),5)}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a),c=this.chart.options.navigation,e=b.xAxis[0].value;b=b.yAxis[0].value;return this.chart.addAnnotation(l({langKey:"rectangle",shapes:[{type:"path",points:[{xAxis:0,yAxis:0,x:e,y:b},{xAxis:0,yAxis:0,x:e,y:b},{xAxis:0,yAxis:0,x:e,
y:b},{xAxis:0,yAxis:0,x:e,y:b}]}],controlPoints:[{positioner:function(a){a=d.Annotation.MockPoint.pointToPixels(a.shapes[0].points[2]);return{x:a.x-4,y:a.y-4}},events:{drag:function(b){var c=this.chart.pointer.getCoordinates(a),d=c.xAxis[0].value;c=c.yAxis[0].value;var e=b.options.shapes[0].points;e[1].x=d;e[2].x=d;e[2].y=c;e[3].y=c;b.options.shapes[0].points=e;b.redraw(!1)}}}]},c.annotationsOptions,c.bindings.rectangleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].points,
d=this.chart.pointer.getCoordinates(a);a=d.xAxis[0].value;d=d.yAxis[0].value;c[1].x=a;c[2].x=a;c[2].y=d;c[3].y=d;b.update({shapes:[{points:c}]})}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(l({langKey:"label",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},overflow:"none",crop:!0,controlPoints:[{symbol:"triangle-down",
positioner:function(a){if(!a.graphic.placed)return{x:0,y:-9E7};a=d.Annotation.MockPoint.pointToPixels(a.points[0]);return{x:a.x-this.graphic.width/2,y:a.y-this.graphic.height/2}},events:{drag:function(a,b){a=this.mouseMoveToTranslation(a);b.translatePoint(a.x,a.y);b.annotation.labels[0].options=b.options;b.redraw(!1)}}},{symbol:"square",positioner:function(a){return a.graphic.placed?{x:a.graphic.alignAttr.x-this.graphic.width/2,y:a.graphic.alignAttr.y-this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(a,
b){a=this.mouseMoveToTranslation(a);b.translate(a.x,a.y);b.annotation.labels[0].options=b.options;b.redraw(!1)}}}]}]},b.annotationsOptions,b.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{}}})});m(e,"annotations/popup.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,c){var e=c.addEvent,k=c.createElement,b=c.defined,m=c.isArray,q=c.isObject,v=c.isString,a=c.objectEach,h=c.pick;c=c.wrap;var C=/\d/g;c(d.Pointer.prototype,"onContainerMouseDown",function(a,
b){var c=b.target&&b.target.className;v(c)&&0<=c.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,1))});d.Popup=function(a,b){this.init(a,b)};d.Popup.prototype={init:function(a,b){this.container=k("div",{className:"highcharts-popup"},null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var a=this;var b=k("div",{className:"highcharts-popup-close"},null,this.container);b.style["background-image"]="url("+this.iconsURL+"close.svg)";
["click","touchstart"].forEach(function(c){e(b,c,function(){a.closePopup()})})},addColsContainer:function(a){var b=k("div",{className:"highcharts-popup-lhs-col"},null,a);a=k("div",{className:"highcharts-popup-rhs-col"},null,a);k("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,b,c,d){var e=a.split(".");e=e[e.length-1];var f=this.lang;b="highcharts-"+b+"-"+e;b.match(C)||k("label",{innerHTML:f[e]||e,htmlFor:b},null,c);k("input",{name:b,value:d[0],
type:d[1],className:"highcharts-popup-field"},null,c).setAttribute("highcharts-data-name",a)},addButton:function(a,b,c,d,h){var f=this,g=this.closePopup,l=this.getFields;var p=k("button",{innerHTML:b},null,a);["click","touchstart"].forEach(function(a){e(p,a,function(){g.call(f);return d(l(h,c))})});return p},getFields:function(a,b){var c=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];
var e,f;var g={actionType:b,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(c,function(a){f=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?g.seriesId=a.value:f?g.fields[f]=a.value:g.type=a.value});a&&(g.fields["params.volumeSeriesID"]=a.getAttribute("value"));return g},showPopup:function(){var a=this.container,b=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),
a.removeAttribute("style"));a.appendChild(b);a.style.display="block"},closePopup:function(){this.popup.container.style.display="none"},showForm:function(a,b,c,d){this.popup=b.navigationBindings.popup;this.showPopup();"indicators"===a&&this.indicators.addForm.call(this,b,c,d);"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,b,c,d);"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d);"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0)},getLangpack:function(){return d.getOptions().lang.navigation.popup},
annotations:{addToolbar:function(a,b,c){var d=this,e=this.lang,f=this.popup.container,g=this.showForm;-1===f.className.indexOf("highcharts-annotation-toolbar")&&(f.className+=" highcharts-annotation-toolbar");f.style.top=a.plotTop+10+"px";k("span",{innerHTML:h(e[b.langKey]||b.langKey,b.shapes&&b.shapes[0].type)},null,f);var l=this.addButton(f,e.removeButton||"remove","remove",c,f);l.className+=" highcharts-annotation-remove-button";l.style["background-image"]="url("+this.iconsURL+"destroy.svg)";l=
this.addButton(f,e.editButton||"edit","edit",function(){g.call(d,"annotation-edit",a,b,c)},f);l.className+=" highcharts-annotation-edit-button";l.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,c,d){var e=this.popup.container,f=this.lang;k("h2",{innerHTML:f[b.langKey]||b.langKey,className:"highcharts-popup-main-title"},null,e);var g=k("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,e);var l=k("div",{className:"highcharts-popup-bottom-row"},
null,e);this.annotations.addFormFields.call(this,g,a,"",b,[],!0);this.addButton(l,d?f.addButton||"add":f.saveButton||"save",d?"add":"save",c,e)},addFormFields:function(b,c,d,e,h,u){var f=this,g=this.annotations.addFormFields,l=this.addInput,p=this.lang,z,x;a(e,function(a,e){z=""!==d?d+"."+e:e;q(a)&&(!m(a)||m(a)&&q(a[0])?(x=p[e]||e,x.match(C)||h.push([!0,x,b]),g.call(f,b,c,z,a,h,!1)):h.push([f,z,"annotation",b,a]))});u&&(h=h.sort(function(a){return a[1].match(/format/g)?-1:1}),h.forEach(function(a){!0===
a[0]?k("span",{className:"highcharts-annotation-title",innerHTML:a[1]},null,a[2]):l.apply(a[0],a.splice(1))}))}},indicators:{addForm:function(a,b,c){var d=this.indicators,e=this.lang;this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(b[0]);d.addIndicatorList.call(this,a,b[0],"add");var f=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.addButton||"add","add",c,f);this.addColsContainer(b[1]);d.addIndicatorList.call(this,
a,b[1],"edit");f=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",c,f);this.addButton(f,e.removeButton||"remove","remove",c,f)},addIndicatorList:function(b,c,d){var f=this,g=c.querySelectorAll(".highcharts-popup-lhs-col")[0];c=c.querySelectorAll(".highcharts-popup-rhs-col")[0];var l="edit"===d,h=l?b.series:b.options.plotOptions,n=this.indicators.addFormFields,m;var q=k("ul",{className:"highcharts-indicator-list"},null,g);var t=c.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];
a(h,function(a,c){var d=a.options;if(a.params||d&&d.params){var g=f.indicators.getNameType(a,c),p=g.type;m=k("li",{className:"highcharts-indicator-list",innerHTML:g.name},null,q);["click","touchstart"].forEach(function(c){e(m,c,function(){n.call(f,b,l?a:h[p],g.type,t);l&&a.options&&k("input",{type:"hidden",name:"highcharts-id-"+p,value:a.options.id},null,t).setAttribute("highcharts-data-series-id",a.options.id)})})}});0<q.childNodes.length&&q.childNodes[0].click()},getNameType:function(a,b){var c=
a.options,e=d.seriesTypes;e=e[b]&&e[b].prototype.nameBase||b.toUpperCase();c&&c.type&&(b=a.options.type,e=a.name);return{name:e,type:b}},listAllSeries:function(a,c,d,e,h){a="highcharts-"+c+"-type-"+a;var f;k("label",{innerHTML:this.lang[c]||c,htmlFor:a},null,e);var g=k("select",{name:a,className:"highcharts-popup-field"},null,e);g.setAttribute("id","highcharts-select-"+c);d.series.forEach(function(a){f=a.options;!f.params&&f.id&&"highcharts-navigator-series"!==f.id&&k("option",{innerHTML:f.name||
f.id,value:f.id},null,g)});b(h)&&(g.value=h)},addFormFields:function(a,b,c,d){var e=b.params||b.options.params,f=this.indicators.getNameType;d.innerHTML="";k("h3",{className:"highcharts-indicator-title",innerHTML:f(b,c).name},null,d);k("input",{type:"hidden",name:"highcharts-type-"+c,value:c},null,d);this.indicators.listAllSeries.call(this,c,"series",a,d,b.linkedParent&&e.volumeSeriesID);e.volumeSeriesID&&this.indicators.listAllSeries.call(this,c,"volume",a,d,b.linkedParent&&b.linkedParent.options.id);
this.indicators.addParamInputs.call(this,a,"params",e,c,d)},addParamInputs:function(b,c,d,e,h){var f=this,g=this.indicators.addParamInputs,l=this.addInput,k;a(d,function(a,d){k=c+"."+d;q(a)?g.call(f,b,k,a,e,h):"params.volumeSeriesID"!==k&&l.call(f,k,e,h,[a,"text"])})},getAmount:function(){var b=0;a(this.series,function(a){var c=a.options;(a.params||c&&c.params)&&b++});return b}},tabs:{init:function(a){var b=this.tabs;a=this.indicators.getAmount.call(a);var c=b.addMenuItem.call(this,"add");b.addMenuItem.call(this,
"edit",a);b.addContentItem.call(this,"add");b.addContentItem.call(this,"edit");b.switchTabs.call(this,a);b.selectTab.call(this,c,0)},addMenuItem:function(a,b){var c=this.popup.container,d="highcharts-tab-item",e=this.lang;0===b&&(d+=" highcharts-tab-disabled");b=k("span",{innerHTML:e[a+"Button"]||a,className:d},null,c);b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return k("div",{className:"highcharts-tab-item-content"},null,this.popup.container)},switchTabs:function(a){var b=
this,c;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(d,f){c=d.getAttribute("highcharts-data-tab-type");"edit"===c&&0===a||["click","touchstart"].forEach(function(a){e(d,a,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,this,f)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,
b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),a[c].classList.remove("highcharts-tab-item-show")}}};e(d.NavigationBindings,"showPopup",function(a){this.popup||(this.popup=new d.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/8.0.4/gfx/stock-icons/"));
this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});e(d.NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()})});m(e,"masters/modules/annotations.btx.js",[],function(){})});
//# sourceMappingURL=annotations.js.map