/*
 Highstock JS v8.0.4 (2020-03-10)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(p){"object"===typeof module&&module.exports?(p["default"]=p,module.exports=p):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(G){p(G);p.Highcharts=G;return p}):p("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(p){function G(r,m,E,n){r.hasOwnProperty(m)||(r[m]=n.apply(null,E))}p=p?p._modules:{};G(p,"parts/Scrollbar.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){var E=m.addEvent,n=m.correctFloat,B=m.defined,
J=m.destroyObjectProperties,p=m.fireEvent,w=m.merge,C=m.pick,H=m.removeEvent;m=r.Axis;var e=r.defaultOptions,l=r.hasTouch,t,q={height:r.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",
trackBorderWidth:1};e.scrollbar=w(!0,q,e.scrollbar);r.swapXY=t=function(b,g){var v=b.length;if(g)for(g=0;g<v;g+=3){var z=b[g+1];b[g+1]=b[g+2];b[g+2]=z}return b};var d=function(){function b(g,v,b){this._events=[];this.from=this.chartY=this.chartX=0;this.scrollbar=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=
{};this.y=this.x=0;this.chart=b;this.options=v;this.renderer=b.renderer;this.init(g,v,b)}b.prototype.addEvents=function(){var g=this.options.inverted?[1,0]:[0,1],v=this.scrollbarButtons,b=this.scrollbarGroup.element,a=this.track.element,f=this.mouseDownHandler.bind(this),k=this.mouseMoveHandler.bind(this),d=this.mouseUpHandler.bind(this);g=[[v[g[0]].element,"click",this.buttonToMinClick.bind(this)],[v[g[1]].element,"click",this.buttonToMaxClick.bind(this)],[a,"click",this.trackClick.bind(this)],[b,
"mousedown",f],[b.ownerDocument,"mousemove",k],[b.ownerDocument,"mouseup",d]];l&&g.push([b,"touchstart",f],[b.ownerDocument,"touchmove",k],[b.ownerDocument,"touchend",d]);g.forEach(function(a){E.apply(null,a)});this._events=g};b.prototype.buttonToMaxClick=function(g){var b=(this.to-this.from)*C(this.options.step,.2);this.updatePosition(this.from+b,this.to+b);p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:g})};b.prototype.buttonToMinClick=function(g){var b=n(this.to-this.from)*
C(this.options.step,.2);this.updatePosition(n(this.from-b),n(this.to-b));p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:g})};b.prototype.cursorToScrollbarPosition=function(g){var b=this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(g.chartX-this.x-this.xOffset)/(this.barWidth-b),chartY:(g.chartY-this.y-this.yOffset)/(this.barWidth-b)}};b.prototype.destroy=function(){var g=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar",
"scrollbarGroup","group"].forEach(function(g){this[g]&&this[g].destroy&&(this[g]=this[g].destroy())},this);g&&this===g.scrollbar&&(g.scrollbar=null,J(g.scrollbarButtons))};b.prototype.drawScrollbarButton=function(g){var b=this.renderer,d=this.scrollbarButtons,a=this.options,f=this.size;var k=b.g().add(this.group);d.push(k);k=b.rect().addClass("highcharts-scrollbar-button").add(k);this.chart.styledMode||k.attr({stroke:a.buttonBorderColor,"stroke-width":a.buttonBorderWidth,fill:a.buttonBackgroundColor});
k.attr(k.crisp({x:-.5,y:-.5,width:f+1,height:f+1,r:a.buttonBorderRadius},k.strokeWidth()));k=b.path(t(["M",f/2+(g?-1:1),f/2-3,"L",f/2+(g?-1:1),f/2+3,"L",f/2+(g?2:-2),f/2],a.vertical)).addClass("highcharts-scrollbar-arrow").add(d[g]);this.chart.styledMode||k.attr({fill:a.buttonArrowColor})};b.prototype.init=function(g,b,d){this.scrollbarButtons=[];this.renderer=g;this.userOptions=b;this.options=w(q,b);this.chart=d;this.size=C(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};
b.prototype.mouseDownHandler=function(b){b=this.chart.pointer.normalize(b);b=this.cursorToScrollbarPosition(b);this.chartX=b.chartX;this.chartY=b.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};b.prototype.mouseMoveHandler=function(b){var g=this.chart.pointer.normalize(b),d=this.options.vertical?"chartY":"chartX",a=this.initPositions||[];!this.grabbedCenter||b.touches&&0===b.touches[0][d]||(g=this.cursorToScrollbarPosition(g)[d],d=this[d],d=g-d,this.hasDragged=!0,this.updatePosition(a[0]+
d,a[1]+d),this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:b.type,DOMEvent:b}))};b.prototype.mouseUpHandler=function(b){this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:b.type,DOMEvent:b});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};b.prototype.position=function(b,d,e,a){var f=this.options.vertical,k=0,g=this.rendered?"animate":"attr";this.x=b;this.y=d+this.trackBorderWidth;this.width=e;this.xOffset=
this.height=a;this.yOffset=k;f?(this.width=this.yOffset=e=k=this.size,this.xOffset=d=0,this.barWidth=a-2*e,this.x=b+=this.options.margin):(this.height=this.xOffset=a=d=this.size,this.barWidth=e-2*a,this.y+=this.options.margin);this.group[g]({translateX:b,translateY:this.y});this.track[g]({width:e,height:a});this.scrollbarButtons[1][g]({translateX:f?0:e-d,translateY:f?a-k:0})};b.prototype.removeEvents=function(){this._events.forEach(function(b){H.apply(null,b)});this._events.length=0};b.prototype.render=
function(){var b=this.renderer,d=this.options,e=this.size,a=this.chart.styledMode,f;this.group=f=b.g("scrollbar").attr({zIndex:d.zIndex,translateY:-99999}).add();this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:d.trackBorderRadius||0,height:e,width:e}).add(f);a||this.track.attr({fill:d.trackBackgroundColor,stroke:d.trackBorderColor,"stroke-width":d.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=
b.g().add(f);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:e,width:e,r:d.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(t(["M",-3,e/4,"L",-3,2*e/3,"M",0,e/4,"L",0,2*e/3,"M",3,e/4,"L",3,2*e/3],d.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);a||(this.scrollbar.attr({fill:d.barBackgroundColor,stroke:d.barBorderColor,"stroke-width":d.barBorderWidth}),this.scrollbarRifles.attr({stroke:d.rifleColor,"stroke-width":1}));
this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};b.prototype.setRange=function(b,d){var g=this.options,a=g.vertical,f=g.minWidth,k=this.barWidth,e,v=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(B(k)){b=Math.max(b,0);var l=Math.ceil(k*b);this.calculatedWidth=e=n(k*Math.min(d,1)-l);e<
f&&(l=(k-f+e)*b,e=f);f=Math.floor(l+this.xOffset+this.yOffset);k=e/2-.5;this.from=b;this.to=d;a?(this.scrollbarGroup[v]({translateY:f}),this.scrollbar[v]({height:e}),this.scrollbarRifles[v]({translateY:k}),this.scrollbarTop=f,this.scrollbarLeft=0):(this.scrollbarGroup[v]({translateX:f}),this.scrollbar[v]({width:e}),this.scrollbarRifles[v]({translateX:k}),this.scrollbarLeft=f,this.scrollbarTop=0);12>=e?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===g.showFull&&(0>=b&&1<=d?this.group.hide():
this.group.show());this.rendered=!0}};b.prototype.trackClick=function(b){var d=this.chart.pointer.normalize(b),g=this.to-this.from,a=this.y+this.scrollbarTop,f=this.x+this.scrollbarLeft;this.options.vertical&&d.chartY>a||!this.options.vertical&&d.chartX>f?this.updatePosition(this.from+g,this.to+g):this.updatePosition(this.from-g,this.to-g);p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:b})};b.prototype.update=function(b){this.destroy();this.init(this.chart.renderer,w(!0,
this.options,b),this.chart)};b.prototype.updatePosition=function(b,d){1<d&&(b=n(1-n(d-b)),d=1);0>b&&(d=n(d-b),b=0);this.from=b;this.to=d};return b}();r.Scrollbar||(E(m,"afterInit",function(){var b=this;b.options&&b.options.scrollbar&&b.options.scrollbar.enabled&&(b.options.scrollbar.vertical=!b.horiz,b.options.startOnTick=b.options.endOnTick=!1,b.scrollbar=new d(b.chart.renderer,b.options.scrollbar,b.chart),E(b.scrollbar,"changed",function(d){var g=Math.min(C(b.options.min,b.min),b.min,b.dataMin),
e=Math.max(C(b.options.max,b.max),b.max,b.dataMax)-g;if(b.horiz&&!b.reversed||!b.horiz&&b.reversed){var a=g+e*this.to;g+=e*this.from}else a=g+e*(1-this.from),g+=e*(1-this.to);C(this.options.liveRedraw,r.svg&&!r.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===d.DOMType||!B(d.DOMType)?b.setExtremes(g,a,!0,"mousemove"!==d.DOMType,d):this.setRange(this.from,this.to)}))}),E(m,"afterRender",function(){var b=Math.min(C(this.options.min,this.min),this.min,C(this.dataMin,this.min)),d=Math.max(C(this.options.max,
this.max),this.max,C(this.dataMax,this.max)),e=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),a=this.chart.scrollbarsOffsets,f=this.options.margin||0;e&&(this.horiz?(this.opposite||(a[1]+=l),e.position(this.left,this.top+this.height+2+a[1]-(this.opposite?f:0),this.width,this.height),this.opposite||(a[1]+=f),l=1):(this.opposite&&(a[0]+=l),e.position(this.left+this.width+2+a[0]-(this.opposite?0:f),this.top,this.width,this.height),this.opposite&&(a[0]+=f),l=0),a[l]+=e.size+e.options.margin,
isNaN(b)||isNaN(d)||!B(this.min)||!B(this.max)||this.min===this.max?e.setRange(0,1):(a=(this.min-b)/(d-b),b=(this.max-b)/(d-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?e.setRange(a,b):e.setRange(1-b,1-a)))}),E(m,"afterGetOffset",function(){var b=this.horiz?2:1,d=this.scrollbar;d&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=d.size+d.options.margin)}),r.Scrollbar=d);return r.Scrollbar});G(p,"parts/Navigator.js",[p["parts/Globals.js"],p["parts/Color.js"],p["parts/Scrollbar.js"],
p["parts/Utilities.js"]],function(r,m,E,n){m=m.parse;var B=n.addEvent,p=n.clamp,I=n.correctFloat,w=n.defined,C=n.destroyObjectProperties,H=n.erase,e=n.extend,l=n.find,t=n.isArray,q=n.isNumber,d=n.merge,b=n.pick,g=n.removeEvent,v=n.splat,z=r.Axis;n=r.Chart;var a=r.defaultOptions,f=r.hasTouch,k=r.isTouchDevice,A=r.Series,D=function(c){for(var h=[],x=1;x<arguments.length;x++)h[x-1]=arguments[x];h=[].filter.call(h,q);if(h.length)return Math[c].apply(0,h)};var F="undefined"===typeof r.seriesTypes.areaspline?
"line":"areaspline";e(a,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:m("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:F,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,
2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},
yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});r.Renderer.prototype.symbols["navigator-handle"]=function(c,h,x,b,a){c=a.width/2;h=Math.round(c/3)+.5;a=a.height;return["M",-c-1,.5,"L",c,.5,"L",c,a+.5,"L",-c-1,a+.5,"L",-c-1,.5,"M",-h,4,"L",-h,a-3,"M",h-1,4,"L",h-1,a-3]};z.prototype.toFixedRange=function(c,h,x,a){var y=this.chart&&this.chart.fixedRange,
d=(this.pointRange||0)/2;c=b(x,this.translate(c,!0,!this.horiz));h=b(a,this.translate(h,!0,!this.horiz));var k=y&&(h-c)/y;w(x)||(c=I(c+d));w(a)||(h=I(h-d));.7<k&&1.3>k&&(a?c=h-y:h=c+y);q(c)&&q(h)||(c=h=void 0);return{min:c,max:h}};var u=function(){function c(h){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=
this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(h)}c.prototype.drawHandle=function(h,x,c,a){var b=this.navigatorOptions.handles.height;this.handles[x][a](c?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(h,10)+.5-b)}:{translateX:Math.round(this.left+parseInt(h,10)),translateY:Math.round(this.top+this.height/2-b/2-1)})};c.prototype.drawOutline=function(h,x,c,a){var b=this.navigatorOptions.maskInside,y=this.outline.strokeWidth(),
d=y/2;y=y%2/2;var k=this.outlineHeight,f=this.scrollbarHeight,g=this.size,e=this.left-f,u=this.top;c?(e-=d,c=u+x+y,x=u+h+y,h=["M",e+k,u-f-y,"L",e+k,c,"L",e,c,"L",e,x,"L",e+k,x,"L",e+k,u+g+f].concat(b?["M",e+k,c-d,"L",e+k,x+d]:[])):(h+=e+f-y,x+=e+f-y,u+=d,h=["M",e,u,"L",h,u,"L",h,u+k,"L",x,u+k,"L",x,u,"L",e+g+2*f,u].concat(b?["M",h-d,u,"L",x+d,u]:[]));this.outline[a]({d:h})};c.prototype.drawMasks=function(h,x,c,b){var a=this.left,y=this.top,d=this.height;if(c){var k=[a,a,a];var f=[y,y+h,y+x];var e=
[d,d,d];var g=[h,x-h,this.size-x]}else k=[a,a+h,a+x],f=[y,y,y],e=[h,x-h,this.size-x],g=[d,d,d];this.shades.forEach(function(h,c){h[b]({x:k[c],y:f[c],width:e[c],height:g[c]})})};c.prototype.renderElements=function(){var h=this,c=h.navigatorOptions,a=c.maskInside,b=h.chart,d=b.renderer,k,f={cursor:b.inverted?"ns-resize":"ew-resize"};h.navigatorGroup=k=d.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!a,a,!a].forEach(function(x,a){h.shades[a]=d.rect().addClass("highcharts-navigator-mask"+
(1===a?"-inside":"-outside")).add(k);b.styledMode||h.shades[a].attr({fill:x?c.maskFill:"rgba(0,0,0,0)"}).css(1===a&&f)});h.outline=d.path().addClass("highcharts-navigator-outline").add(k);b.styledMode||h.outline.attr({"stroke-width":c.outlineWidth,stroke:c.outlineColor});c.handles.enabled&&[0,1].forEach(function(x){c.handles.inverted=b.inverted;h.handles[x]=d.symbol(c.handles.symbols[x],-c.handles.width/2-1,0,c.handles.width,c.handles.height,c.handles);h.handles[x].attr({zIndex:7-x}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][x]).add(k);if(!b.styledMode){var a=c.handles;h.handles[x].attr({fill:a.backgroundColor,stroke:a.borderColor,"stroke-width":a.lineWidth}).css(f)}})};c.prototype.update=function(h){(this.series||[]).forEach(function(h){h.baseSeries&&delete h.baseSeries.navigatorSeries});this.destroy();d(!0,this.chart.options.navigator,this.options,h);this.init(this.chart)};c.prototype.render=function(h,c,a,d){var x=this.chart,y=this.scrollbarHeight,k,f=this.xAxis,e=f.pointRange||0;var g=f.fake?x.xAxis[0]:
f;var u=this.navigatorEnabled,M,l=this.rendered;var v=x.inverted;var A=x.xAxis[0].minRange,t=x.xAxis[0].options.maxRange;if(!this.hasDragged||w(a)){h=I(h-e/2);c=I(c+e/2);if(!q(h)||!q(c))if(l)a=0,d=b(f.width,g.width);else return;this.left=b(f.left,x.plotLeft+y+(v?x.plotWidth:0));this.size=M=k=b(f.len,(v?x.plotHeight:x.plotWidth)-2*y);x=v?y:k+2*y;a=b(a,f.toPixels(h,!0));d=b(d,f.toPixels(c,!0));q(a)&&Infinity!==Math.abs(a)||(a=0,d=x);h=f.toValue(a,!0);c=f.toValue(d,!0);var D=Math.abs(I(c-h));D<A?this.grabbedLeft?
a=f.toPixels(c-A-e,!0):this.grabbedRight&&(d=f.toPixels(h+A+e,!0)):w(t)&&I(D-e)>t&&(this.grabbedLeft?a=f.toPixels(c-t-e,!0):this.grabbedRight&&(d=f.toPixels(h+t+e,!0)));this.zoomedMax=p(Math.max(a,d),0,M);this.zoomedMin=p(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(a,d),0,M);this.range=this.zoomedMax-this.zoomedMin;M=Math.round(this.zoomedMax);a=Math.round(this.zoomedMin);u&&(this.navigatorGroup.attr({visibility:"visible"}),l=l&&!this.hasDragged?"animate":"attr",this.drawMasks(a,M,v,l),
this.drawOutline(a,M,v,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(a,0,v,l),this.drawHandle(M,1,v,l)));this.scrollbar&&(v?(v=this.top-y,g=this.left-y+(u||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),y=k+2*y):(v=this.top+(u?this.height:-y),g=this.left-y),this.scrollbar.position(g,v,x,y),this.scrollbar.setRange(this.zoomedMin/(k||1),this.zoomedMax/(k||1)));this.rendered=!0}};c.prototype.addMouseEvents=function(){var h=this,c=h.chart,a=c.container,b=[],d,k;h.mouseMoveHandler=d=
function(c){h.onMouseMove(c)};h.mouseUpHandler=k=function(c){h.onMouseUp(c)};b=h.getPartsEvents("mousedown");b.push(B(c.renderTo,"mousemove",d),B(a.ownerDocument,"mouseup",k));f&&(b.push(B(c.renderTo,"touchmove",d),B(a.ownerDocument,"touchend",k)),b.concat(h.getPartsEvents("touchstart")));h.eventsToUnbind=b;h.series&&h.series[0]&&b.push(B(h.series[0].xAxis,"foundExtremes",function(){c.navigator.modifyNavigatorAxisExtremes()}))};c.prototype.getPartsEvents=function(h){var c=this,a=[];["shades","handles"].forEach(function(x){c[x].forEach(function(b,
d){a.push(B(b.element,h,function(h){c[x+"Mousedown"](h,d)}))})});return a};c.prototype.shadesMousedown=function(h,c){h=this.chart.pointer.normalize(h);var a=this.chart,x=this.xAxis,b=this.zoomedMin,d=this.left,k=this.size,f=this.range,e=h.chartX;a.inverted&&(e=h.chartY,d=this.top);if(1===c)this.grabbedCenter=e,this.fixedWidth=f,this.dragOffset=e-b;else{h=e-d-f/2;if(0===c)h=Math.max(0,h);else if(2===c&&h+f>=k)if(h=k-f,this.reversedExtremes){h-=f;var g=this.getUnionExtremes().dataMin}else var u=this.getUnionExtremes().dataMax;
h!==b&&(this.fixedWidth=f,c=x.toFixedRange(h,h+f,g,u),w(c.min)&&a.xAxis[0].setExtremes(Math.min(c.min,c.max),Math.max(c.min,c.max),!0,null,{trigger:"navigator"}))}};c.prototype.handlesMousedown=function(h,c){this.chart.pointer.normalize(h);h=this.chart;var a=h.xAxis[0],x=this.reversedExtremes;0===c?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=x?a.min:a.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=x?a.max:a.min);h.fixedRange=null};c.prototype.onMouseMove=
function(h){var c=this,a=c.chart,d=c.left,f=c.navigatorSize,e=c.range,g=c.dragOffset,u=a.inverted;h.touches&&0===h.touches[0].pageX||(h=a.pointer.normalize(h),a=h.chartX,u&&(d=c.top,a=h.chartY),c.grabbedLeft?(c.hasDragged=!0,c.render(0,0,a-d,c.otherHandlePos)):c.grabbedRight?(c.hasDragged=!0,c.render(0,0,c.otherHandlePos,a-d)):c.grabbedCenter&&(c.hasDragged=!0,a<g?a=g:a>f+g-e&&(a=f+g-e),c.render(0,0,a-g,a-g+e)),c.hasDragged&&c.scrollbar&&b(c.scrollbar.options.liveRedraw,r.svg&&!k&&!this.chart.isBoosting)&&
(h.DOMType=h.type,setTimeout(function(){c.onMouseUp(h)},0)))};c.prototype.onMouseUp=function(h){var c=this.chart,a=this.xAxis,b=this.scrollbar,d=h.DOMEvent||h,f=c.inverted,k=this.rendered&&!this.hasDragged?"animate":"attr",e=Math.round(this.zoomedMax),g=Math.round(this.zoomedMin);if(this.hasDragged&&(!b||!b.hasDragged)||"scrollbar"===h.trigger){b=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var u=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var l=this.fixedExtreme;
this.zoomedMax===this.size&&(l=this.reversedExtremes?b.dataMin:b.dataMax);0===this.zoomedMin&&(u=this.reversedExtremes?b.dataMax:b.dataMin);a=a.toFixedRange(this.zoomedMin,this.zoomedMax,u,l);w(a.min)&&c.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d})}"mousemove"!==h.DOMType&&"touchmove"!==h.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&(this.shades&&this.drawMasks(g,e,f,k),this.outline&&this.drawOutline(g,e,f,k),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(g,0,f,k),this.drawHandle(e,1,f,k)))};c.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(h){h()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};c.prototype.removeBaseSeriesEvents=function(){var h=
this.baseSeries||[];this.navigatorEnabled&&h[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&h.forEach(function(h){g(h,"updatedData",this.updatedDataHandler)},this),h[0].xAxis&&g(h[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};c.prototype.init=function(h){var c=h.options,a=c.navigator,f=a.enabled,k=c.scrollbar,e=k.enabled;c=f?a.height:0;var g=e?k.height:0;this.handles=[];this.shades=[];this.chart=h;this.setBaseSeries();this.height=c;this.scrollbarHeight=g;this.scrollbarEnabled=e;this.navigatorEnabled=
f;this.navigatorOptions=a;this.scrollbarOptions=k;this.outlineHeight=c+g;this.opposite=b(a.opposite,!(f||!h.inverted));var u=this;f=u.baseSeries;k=h.xAxis.length;e=h.yAxis.length;var l=f&&f[0]&&f[0].xAxis||h.xAxis[0]||{options:{}};h.isDirtyBox=!0;u.navigatorEnabled?(u.xAxis=new z(h,d({breaks:l.options.breaks,ordinal:l.options.ordinal},a.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:k,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,
maxPadding:0,zoomEnabled:!1},h.inverted?{offsets:[g,0,-g,0],width:c}:{offsets:[0,-g,0,g],height:c})),u.yAxis=new z(h,d(a.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,zoomEnabled:!1},h.inverted?{width:c}:{height:c})),f||a.series.data?u.updateNavigatorSeries(!1):0===h.series.length&&(u.unbindRedraw=B(h,"beforeRedraw",function(){0<h.series.length&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=h.inverted&&!u.xAxis.reversed||!h.inverted&&u.xAxis.reversed,
u.renderElements(),u.addMouseEvents()):u.xAxis={translate:function(c,a){var b=h.xAxis[0],d=b.getExtremes(),x=b.len-2*g,f=D("min",b.options.min,d.dataMin);b=D("max",b.options.max,d.dataMax)-f;return a?c*b/x+f:x*(c-f)/b},toPixels:function(h){return this.translate(h)},toValue:function(h){return this.translate(h,!0)},toFixedRange:z.prototype.toFixedRange,fake:!0};h.options.scrollbar.enabled&&(h.scrollbar=u.scrollbar=new E(h.renderer,d(h.options.scrollbar,{margin:u.navigatorEnabled?0:10,vertical:h.inverted}),
h),B(u.scrollbar,"changed",function(c){var a=u.size,b=a*this.to;a*=this.from;u.hasDragged=u.scrollbar.hasDragged;u.render(0,0,a,b);(h.options.scrollbar.liveRedraw||"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType)&&setTimeout(function(){u.onMouseUp(c)})}));u.addBaseSeriesEvents();u.addChartEvents()};c.prototype.getUnionExtremes=function(h){var c=this.chart.xAxis[0],a=this.xAxis,d=a.options,f=c.options,k;h&&null===c.dataMin||(k={dataMin:b(d&&d.min,D("min",f.min,c.dataMin,a.dataMin,a.min)),dataMax:b(d&&
d.max,D("max",f.max,c.dataMax,a.dataMax,a.max))});return k};c.prototype.setBaseSeries=function(h,c){var a=this.chart,b=this.baseSeries=[];h=h||a.options&&a.options.navigator.baseSeries||(a.series.length?l(a.series,function(h){return!h.options.isInternal}).index:0);(a.series||[]).forEach(function(c,a){c.options.isInternal||!c.options.showInNavigator&&(a!==h&&c.options.id!==h||!1===c.options.showInNavigator)||b.push(c)});this.xAxis&&!this.xAxis.fake&&this.updateNavigatorSeries(!0,c)};c.prototype.updateNavigatorSeries=
function(c,f){var h=this,x=h.chart,k=h.baseSeries,u,l,A=h.navigatorOptions.series,D,q={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:!1,isInternal:!0,states:{inactive:{opacity:1}}},z=h.series=(h.series||[]).filter(function(c){var a=c.baseSeries;return 0>k.indexOf(a)?(a&&(g(a,"updatedData",h.updatedDataHandler),delete a.navigatorSeries),c.chart&&c.destroy(),!1):!0});k&&k.length&&k.forEach(function(c){var g=
c.navigatorSeries,y=e({color:c.color,visible:c.visible},t(A)?a.navigator.series:A);g&&!1===h.navigatorOptions.adaptToUpdatedData||(q.name="Navigator "+k.length,u=c.options||{},D=u.navigatorOptions||{},l=d(u,q,y,D),l.pointRange=b(y.pointRange,D.pointRange,a.plotOptions[l.type||"line"].pointRange),y=D.data||y.data,h.hasNavigatorData=h.hasNavigatorData||!!y,l.data=y||u.data&&u.data.slice(0),g&&g.options?g.update(l,f):(c.navigatorSeries=x.initSeries(l),c.navigatorSeries.baseSeries=c,z.push(c.navigatorSeries)))});
if(A.data&&(!k||!k.length)||t(A))h.hasNavigatorData=!1,A=v(A),A.forEach(function(c,b){q.name="Navigator "+(z.length+1);l=d(a.navigator.series,{color:x.series[b]&&!x.series[b].options.isInternal&&x.series[b].color||x.options.colors[b]||x.options.colors[0]},q,c);l.data=c.data;l.data&&(h.hasNavigatorData=!0,z.push(x.initSeries(l)))});c&&this.addBaseSeriesEvents()};c.prototype.addBaseSeriesEvents=function(){var c=this,a=c.baseSeries||[];a[0]&&a[0].xAxis&&B(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);
a.forEach(function(h){B(h,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});B(h,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&h.xAxis&&B(h,"updatedData",this.updatedDataHandler);B(h,"remove",function(){this.navigatorSeries&&(H(c.series,this.navigatorSeries),w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},this)};c.prototype.getBaseSeriesMin=
function(c){return this.baseSeries.reduce(function(c,h){return Math.min(c,h.xData?h.xData[0]:c)},c)};c.prototype.modifyNavigatorAxisExtremes=function(){var c=this.xAxis,a;"undefined"!==typeof c.getExtremes&&(!(a=this.getUnionExtremes(!0))||a.dataMin===c.min&&a.dataMax===c.max||(c.min=a.dataMin,c.max=a.dataMax))};c.prototype.modifyBaseAxisExtremes=function(){var c=this.chart.navigator,a=this.getExtremes(),d=a.dataMin,f=a.dataMax;a=a.max-a.min;var k=c.stickToMin,e=c.stickToMax,g=b(this.options.overscroll,
0),u=c.series&&c.series[0],l=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(k){var v=d;var A=v+a}e&&(A=f+g,k||(v=Math.max(A-a,c.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE))));l&&(k||e)&&q(v)&&(this.min=this.userMin=v,this.max=this.userMax=A)}c.stickToMin=c.stickToMax=null};c.prototype.updatedDataHandler=function(){var c=this.chart.navigator,a=this.navigatorSeries,b=c.getBaseSeriesMin(this.xData[0]);c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):
Math.round(c.zoomedMax)>=Math.round(c.size);c.stickToMin=q(this.xAxis.min)&&this.xAxis.min<=b&&(!this.chart.fixedRange||!c.stickToMax);a&&!c.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,!1,null,!1))};c.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(B(this.chart,"redraw",function(){var c=this.navigator,a=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||c.scrollbar&&this.xAxis[0]);a&&c.render(a.min,
a.max)}),B(this.chart,"getMargins",function(){var c=this.navigator,a=c.opposite?"plotTop":"marginBottom";this.inverted&&(a=c.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:0)+c.navigatorOptions.margin}))};c.prototype.destroy=function(){this.removeEvents();this.xAxis&&(H(this.chart.xAxis,this.xAxis),H(this.chart.axes,this.xAxis));this.yAxis&&(H(this.chart.yAxis,this.yAxis),H(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&
c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&this[c].destroy&&this[c].destroy();this[c]=null},this);[this.handles].forEach(function(c){C(c)},this)};return c}();r.Navigator||(r.Navigator=u,B(z,"zoom",function(c){var a=this.chart.options,b=a.chart.zoomType,d=a.chart.pinchType,f=a.navigator;a=a.rangeSelector;this.isXAxis&&(f&&f.enabled||a&&a.enabled)&&("y"===b?c.zoomed=!1:(!k&&
"xy"===b||k&&"xy"===d)&&this.options.range&&(b=this.previousZoom,w(c.newMin)?this.previousZoom=[this.min,this.max]:b&&(c.newMin=b[0],c.newMax=b[1],delete this.previousZoom)));"undefined"!==typeof c.zoomed&&c.preventDefault()}),B(n,"beforeShowResetZoom",function(){var c=this.options,a=c.navigator,b=c.rangeSelector;if((a&&a.enabled||b&&b.enabled)&&(!k&&"x"===c.chart.zoomType||k&&"x"===c.chart.pinchType))return!1}),B(n,"beforeRender",function(){var c=this.options;if(c.navigator.enabled||c.scrollbar.enabled)this.scroller=
this.navigator=new u(this)}),B(n,"afterSetChartSize",function(){var c=this.legend,a=this.navigator;if(a){var d=c&&c.options;var f=a.xAxis;var k=a.yAxis;var e=a.scrollbarHeight;this.inverted?(a.left=a.opposite?this.chartWidth-e-a.height:this.spacing[3]+e,a.top=this.plotTop+e):(a.left=this.plotLeft+e,a.top=a.navigatorOptions.top||this.chartHeight-a.height-e-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(d&&"bottom"===d.verticalAlign&&d.enabled&&!d.floating?
c.legendHeight+b(d.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));f&&k&&(this.inverted?f.options.left=k.options.left=a.left:f.options.top=k.options.top=a.top,f.setAxisSize(),k.setAxisSize())}}),B(n,"update",function(c){var a=c.options.navigator||{},b=c.options.scrollbar||{};this.navigator||this.scroller||!a.enabled&&!b.enabled||(d(!0,this.options.navigator,a),d(!0,this.options.scrollbar,b),delete c.options.navigator,delete c.options.scrollbar)}),B(n,"afterUpdate",function(c){this.navigator||
this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new u(this),b(c.redraw,!0)&&this.redraw(c.animation))}),B(n,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),B(A,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),n.prototype.callbacks.push(function(c){var a=c.navigator;a&&c.xAxis[0]&&(c=c.xAxis[0].getExtremes(),a.render(c.min,c.max))}));
r.Navigator=u;return r.Navigator});G(p,"parts/OrdinalAxis.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){var p=m.addEvent,n=m.css,B=m.defined,J=m.extend,I=m.pick,w=m.timeUnits,C=r.Axis;m=r.Chart;var H=r.noop;p(r.Series,"updatedData",function(){var e=this.xAxis;e&&e.options.ordinal&&delete e.ordinalIndex});C.prototype.getTimeTicks=function(e,l,t,q,d,b,g){var v=0,z,a,f={},k=[],A=-Number.MAX_VALUE,D=this.options.tickPixelInterval,F=this.chart.time,u=[];if(!this.options.ordinal&&!this.options.breaks||
!d||3>d.length||"undefined"===typeof l)return F.getTimeTicks.apply(F,arguments);var c=d.length;for(z=0;z<c;z++){var h=z&&d[z-1]>t;d[z]<l&&(v=z);if(z===c-1||d[z+1]-d[z]>5*b||h){if(d[z]>A){for(a=F.getTimeTicks(e,d[v],d[z],q);a.length&&a[0]<=A;)a.shift();a.length&&(A=a[a.length-1]);u.push(k.length);k=k.concat(a)}v=z+1}if(h)break}a=a.info;if(g&&a.unitRange<=w.hour){z=k.length-1;for(v=1;v<z;v++)if(F.dateFormat("%d",k[v])!==F.dateFormat("%d",k[v-1])){f[k[v]]="day";var x=!0}x&&(f[k[0]]="day");a.higherRanks=
f}a.segmentStarts=u;k.info=a;if(g&&B(D)){v=u=k.length;x=[];var y;for(F=[];v--;)z=this.translate(k[v]),y&&(F[v]=y-z),x[v]=y=z;F.sort();F=F[Math.floor(F.length/2)];F<.6*D&&(F=null);v=k[u-1]>t?u-1:u;for(y=void 0;v--;)z=x[v],u=Math.abs(y-z),y&&u<.8*D&&(null===F||u<.8*F)?(f[k[v]]&&!f[k[v+1]]?(u=v+1,y=z):u=v,k.splice(u,1)):y=z}return k};J(C.prototype,{beforeSetTickPositions:function(){var e=[],l,t=!1,q=this.getExtremes(),d=q.min,b=q.max,g,v=this.isXAxis&&!!this.options.breaks;q=this.options.ordinal;var z=
Number.MAX_VALUE,a=this.chart.options.chart.ignoreHiddenSeries,f;if(q||v){this.series.forEach(function(b,d){l=[];if(!(a&&!1===b.visible||!1===b.takeOrdinalPosition&&!v)&&(e=e.concat(b.processedXData),k=e.length,e.sort(function(a,c){return a-c}),z=Math.min(z,I(b.closestPointRange,z)),k)){for(d=0;d<k-1;)e[d]!==e[d+1]&&l.push(e[d+1]),d++;l[0]!==e[0]&&l.unshift(e[0]);e=l}b.isSeriesBoosting&&(f=!0)});f&&(e.length=0);var k=e.length;if(2<k){var A=e[1]-e[0];for(g=k-1;g--&&!t;)e[g+1]-e[g]!==A&&(t=!0);!this.options.keepOrdinalPadding&&
(e[0]-d>A||b-e[e.length-1]>A)&&(t=!0)}else this.options.overscroll&&(2===k?z=e[1]-e[0]:1===k?(z=this.options.overscroll,e=[e[0],e[0]+z]):z=this.overscrollPointsRange);t?(this.options.overscroll&&(this.overscrollPointsRange=z,e=e.concat(this.getOverscrollPositions())),this.ordinalPositions=e,A=this.ordinal2lin(Math.max(d,e[0]),!0),g=Math.max(this.ordinal2lin(Math.min(b,e[e.length-1]),!0),1),this.ordinalSlope=b=(b-d)/(g-A),this.ordinalOffset=d-A*b):(this.overscrollPointsRange=I(this.closestPointRange,
this.overscrollPointsRange),this.ordinalPositions=this.ordinalSlope=this.ordinalOffset=void 0)}this.isOrdinal=q&&t;this.groupIntervalFactor=null},val2lin:function(e,l){var t=this.ordinalPositions;if(t){var q=t.length,d;for(d=q;d--;)if(t[d]===e){var b=d;break}for(d=q-1;d--;)if(e>t[d]||0===d){e=(e-t[d])/(t[d+1]-t[d]);b=d+e;break}l=l?b:this.ordinalSlope*(b||0)+this.ordinalOffset}else l=e;return l},lin2val:function(e,l){var t=this.ordinalPositions;if(t){var q=this.ordinalSlope,d=this.ordinalOffset,b=
t.length-1;if(l)if(0>e)e=t[0];else if(e>b)e=t[b];else{b=Math.floor(e);var g=e-b}else for(;b--;)if(l=q*b+d,e>=l){q=q*(b+1)+d;g=(e-l)/(q-l);break}return"undefined"!==typeof g&&"undefined"!==typeof t[b]?t[b]+(g?g*(t[b+1]-t[b]):0):e}return e},getExtendedPositions:function(){var e=this,l=e.chart,t=e.series[0].currentDataGrouping,q=e.ordinalIndex,d=t?t.count+t.unitName:"raw",b=e.options.overscroll,g=e.getExtremes(),v;q||(q=e.ordinalIndex={});if(!q[d]){var z={series:[],chart:l,getExtremes:function(){return{min:g.dataMin,
max:g.dataMax+b}},options:{ordinal:!0},val2lin:C.prototype.val2lin,ordinal2lin:C.prototype.ordinal2lin};e.series.forEach(function(a){v={xAxis:z,xData:a.xData.slice(),chart:l,destroyGroupedData:H};v.xData=v.xData.concat(e.getOverscrollPositions());v.options={dataGrouping:t?{enabled:!0,forced:!0,approximation:"open",units:[[t.unitName,[t.count]]]}:{enabled:!1}};a.processData.apply(v);z.series.push(v)});e.beforeSetTickPositions.apply(z);q[d]=z.ordinalPositions}return q[d]},getOverscrollPositions:function(){var e=
this.options.overscroll,l=this.overscrollPointsRange,t=[],q=this.dataMax;if(B(l))for(t.push(q);q<=this.dataMax+e;)q+=l,t.push(q);return t},getGroupIntervalFactor:function(e,l,t){t=t.processedXData;var q=t.length,d=[];var b=this.groupIntervalFactor;if(!b){for(b=0;b<q-1;b++)d[b]=t[b+1]-t[b];d.sort(function(b,d){return b-d});d=d[Math.floor(q/2)];e=Math.max(e,t[0]);l=Math.min(l,t[q-1]);this.groupIntervalFactor=b=q*d/(l-e)}return b},postProcessTickInterval:function(e){var l=this.ordinalSlope;return l?
this.options.breaks?this.closestPointRange||e:e/(l/this.closestPointRange):e}});C.prototype.ordinal2lin=C.prototype.val2lin;p(m,"pan",function(e){var l=this.xAxis[0],t=l.options.overscroll,q=e.originalEvent.chartX,d=this.options.chart&&this.options.chart.panning,b=!1;if(d&&"y"!==d.type&&l.options.ordinal&&l.series.length){var g=this.mouseDownX,v=l.getExtremes(),z=v.dataMax,a=v.min,f=v.max,k=this.hoverPoints,A=l.closestPointRange||l.overscrollPointsRange;g=(g-q)/(l.translationSlope*(l.ordinalSlope||
A));var D={ordinalPositions:l.getExtendedPositions()};A=l.lin2val;var F=l.val2lin;if(!D.ordinalPositions)b=!0;else if(1<Math.abs(g)){k&&k.forEach(function(c){c.setState()});if(0>g){k=D;var u=l.ordinalPositions?l:D}else k=l.ordinalPositions?l:D,u=D;D=u.ordinalPositions;z>D[D.length-1]&&D.push(z);this.fixedRange=f-a;g=l.toFixedRange(null,null,A.apply(k,[F.apply(k,[a,!0])+g,!0]),A.apply(u,[F.apply(u,[f,!0])+g,!0]));g.min>=Math.min(v.dataMin,a)&&g.max<=Math.max(z,f)+t&&l.setExtremes(g.min,g.max,!0,!1,
{trigger:"pan"});this.mouseDownX=q;n(this.container,{cursor:"move"})}}else b=!0;b||d&&/y/.test(d.type)?t&&(l.max=l.dataMax+t):e.preventDefault()});p(C,"foundExtremes",function(){this.isXAxis&&B(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&B(this.userMin)&&(this.min+=this.options.overscroll))});p(C,"afterSetScale",function(){this.horiz&&
!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)})});G(p,"modules/broken-axis.btx.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){var p=m.addEvent,n=m.extend,B=m.find,J=m.fireEvent,I=m.isArray,w=m.pick,C=r.Axis;m=r.Series;var H=function(e,l){return B(l,function(l){return l.from<e&&e<l.to})};n(C.prototype,{isInBreak:function(e,l){var t=e.repeat||Infinity,q=e.from,d=e.to-e.from;l=l>=q?(l-q)%t:t-(q-l)%t;return e.inclusive?
l<=d:l<d&&0!==l},isInAnyBreak:function(e,l){var t=this.options.breaks,q=t&&t.length,d;if(q){for(;q--;)if(this.isInBreak(t[q],e)){var b=!0;d||(d=w(t[q].showPoints,!this.isXAxis))}var g=b&&l?b&&!d:b}return g}});p(C,"afterInit",function(){"function"===typeof this.setBreaks&&this.setBreaks(this.options.breaks,!1)});p(C,"afterSetTickPositions",function(){if(this.isBroken){var e=this.tickPositions,l=this.tickPositions.info,t=[],q;for(q=0;q<e.length;q++)this.isInAnyBreak(e[q])||t.push(e[q]);this.tickPositions=
t;this.tickPositions.info=l}});p(C,"afterSetOptions",function(){this.isBroken&&(this.options.ordinal=!1)});C.prototype.setBreaks=function(e,l){function t(b){var e=b,g;for(g=0;g<d.breakArray.length;g++){var a=d.breakArray[g];if(a.to<=b)e-=a.len;else if(a.from>=b)break;else if(d.isInBreak(a,b)){e-=b-a.from;break}}return e}function q(b){var e;for(e=0;e<d.breakArray.length;e++){var g=d.breakArray[e];if(g.from>=b)break;else g.to<b?b+=g.len:d.isInBreak(g,b)&&(b+=g.len)}return b}var d=this,b=I(e)&&!!e.length;
d.isDirty=d.isBroken!==b;d.isBroken=b;d.options.breaks=d.userOptions.breaks=e;d.forceRedraw=!0;d.series.forEach(function(b){b.isDirty=!0});b||d.val2lin!==t||(delete d.val2lin,delete d.lin2val);b&&(d.userOptions.ordinal=!1,d.val2lin=t,d.lin2val=q,d.setExtremes=function(b,d,e,a,f){if(this.isBroken){for(var k,g=this.options.breaks;k=H(b,g);)b=k.to;for(;k=H(d,g);)d=k.from;d<b&&(d=b)}C.prototype.setExtremes.call(this,b,d,e,a,f)},d.setAxisTranslation=function(b){C.prototype.setAxisTranslation.call(this,
b);this.unitLength=null;if(this.isBroken){b=d.options.breaks;var e=[],g=[],a=0,f,k=d.userMin||d.min,l=d.userMax||d.max,t=w(d.pointRangePadding,0),q;b.forEach(function(c){f=c.repeat||Infinity;d.isInBreak(c,k)&&(k+=c.to%f-k%f);d.isInBreak(c,l)&&(l-=l%f-c.from%f)});b.forEach(function(a){c=a.from;for(f=a.repeat||Infinity;c-f>k;)c-=f;for(;c<k;)c+=f;for(q=c;q<l;q+=f)e.push({value:q,move:"in"}),e.push({value:q+(a.to-a.from),move:"out",size:a.breakSize})});e.sort(function(c,a){return c.value===a.value?("in"===
c.move?0:1)-("in"===a.move?0:1):c.value-a.value});var u=0;var c=k;e.forEach(function(b){u+="in"===b.move?1:-1;1===u&&"in"===b.move&&(c=b.value);0===u&&(g.push({from:c,to:b.value,len:b.value-c-(b.size||0)}),a+=b.value-c-(b.size||0))});d.breakArray=g;d.unitLength=l-k-a+t;J(d,"afterBreaks");d.staticScale?d.transA=d.staticScale:d.unitLength&&(d.transA*=(l-d.min+t)/d.unitLength);t&&(d.minPixelPadding=d.transA*d.minPointOffset);d.min=k;d.max=l}});w(l,!0)&&this.chart.redraw()};p(m,"afterGeneratePoints",
function(){var e=this.options.connectNulls,l=this.points,t=this.xAxis,q=this.yAxis;if(this.isDirty)for(var d=l.length;d--;){var b=l[d],g=!(null===b.y&&!1===e)&&(t&&t.isInAnyBreak(b.x,!0)||q&&q.isInAnyBreak(b.y,!0));b.visible=g?!1:!1!==b.options.visible}});p(m,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,w(this.pointArrayMap,["y"]))});r.Series.prototype.drawBreaks=function(e,l){var t=this,q=t.points,d,b,g,v;e&&l.forEach(function(l){d=e.breakArray||[];b=e.isXAxis?
e.min:w(t.options.threshold,e.min);q.forEach(function(a){v=w(a["stack"+l.toUpperCase()],a[l]);d.forEach(function(d){g=!1;if(b<d.from&&v>d.to||b>d.from&&v<d.from)g="pointBreak";else if(b<d.from&&v>d.from&&v<d.to||b>d.from&&v>d.to&&v<d.from)g="pointInBreak";g&&J(e,g,{point:a,brk:d})})})})};r.Series.prototype.gappedPath=function(){var e=this.currentDataGrouping,l=e&&e.gapSize;e=this.options.gapSize;var t=this.points.slice(),q=t.length-1,d=this.yAxis,b;if(e&&0<q)for("value"!==this.options.gapUnit&&(e*=
this.basePointRange),l&&l>e&&l>=this.basePointRange&&(e=l),b=void 0;q--;)b&&!1!==b.visible||(b=t[q+1]),l=t[q],!1!==b.visible&&!1!==l.visible&&(b.x-l.x>e&&(b=(l.x+b.x)/2,t.splice(q+1,0,{isNull:!0,x:b}),this.options.stacking&&(b=d.stacks[this.stackKey][b]=new r.StackItem(d,d.options.stackLabels,!1,b,this.stack),b.total=0)),b=l);return this.getGraphPath(t)}});G(p,"masters/modules/broken-axis.btx.js",[],function(){});G(p,"parts/DataGrouping.js",[p["parts/Globals.js"],p["parts/Point.js"],p["parts/Tooltip.js"],
p["parts/Utilities.js"]],function(r,m,p,n){"";var B=n.addEvent,J=n.arrayMax,E=n.arrayMin,w=n.correctFloat,C=n.defined,H=n.error,e=n.extend,l=n.format,t=n.isNumber,q=n.merge,d=n.pick,b=r.Axis,g=r.defaultPlotOptions;n=r.Series;var v=r.approximations={sum:function(c){var a=c.length;if(!a&&c.hasNulls)var b=null;else if(a)for(b=0;a--;)b+=c[a];return b},average:function(c){var a=c.length;c=v.sum(c);t(c)&&a&&(c=w(c/a));return c},averages:function(){var c=[];[].forEach.call(arguments,function(a){c.push(v.average(a))});
return"undefined"===typeof c[0]?void 0:c},open:function(c){return c.length?c[0]:c.hasNulls?null:void 0},high:function(c){return c.length?J(c):c.hasNulls?null:void 0},low:function(c){return c.length?E(c):c.hasNulls?null:void 0},close:function(c){return c.length?c[c.length-1]:c.hasNulls?null:void 0},ohlc:function(c,a,b,d){c=v.open(c);a=v.high(a);b=v.low(b);d=v.close(d);if(t(c)||t(a)||t(b)||t(d))return[c,a,b,d]},range:function(c,a){c=v.low(c);a=v.high(a);if(t(c)||t(a))return[c,a];if(null===c&&null===
a)return null}},z=function(c,a,b,d){var h=this,k=h.data,f=h.options&&h.options.data,e=[],u=[],g=[],x=c.length,l=!!a,y=[],A=h.pointArrayMap,D=A&&A.length,z=["x"].concat(A||["y"]),n=0,F=0,w;d="function"===typeof d?d:v[d]?v[d]:v[h.getDGApproximation&&h.getDGApproximation()||"average"];D?A.forEach(function(){y.push([])}):y.push([]);var m=D||1;for(w=0;w<=x&&!(c[w]>=b[0]);w++);for(w;w<=x;w++){for(;"undefined"!==typeof b[n+1]&&c[w]>=b[n+1]||w===x;){var r=b[n];h.dataGroupInfo={start:h.cropStart+F,length:y[0].length};
var p=d.apply(h,y);h.pointClass&&!C(h.dataGroupInfo.options)&&(h.dataGroupInfo.options=q(h.pointClass.prototype.optionsToObject.call({series:h},h.options.data[h.cropStart+F])),z.forEach(function(c){delete h.dataGroupInfo.options[c]}));"undefined"!==typeof p&&(e.push(r),u.push(p),g.push(h.dataGroupInfo));F=w;for(r=0;r<m;r++)y[r].length=0,y[r].hasNulls=!1;n+=1;if(w===x)break}if(w===x)break;if(A)for(r=h.cropStart+w,p=k&&k[r]||h.pointClass.prototype.applyOptions.apply({series:h},[f[r]]),r=0;r<D;r++){var B=
p[A[r]];t(B)?y[r].push(B):null===B&&(y[r].hasNulls=!0)}else r=l?a[w]:null,t(r)?y[0].push(r):null===r&&(y[0].hasNulls=!0)}return{groupedXData:e,groupedYData:u,groupMap:g}},a={approximations:v,groupData:z},f=n.prototype,k=f.processData,A=f.generatePoints,D={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M",
"%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},F={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},u=r.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,
30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];f.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};f.groupData=z;f.processData=function(){var c=this.chart,a=this.options.dataGrouping,b=!1!==this.allowDG&&a&&d(a.enabled,c.options.isStock),e=this.visible||!c.options.chart.ignoreHiddenSeries,g,l=this.currentDataGrouping,A=!1;this.forceCrop=b;this.groupPixelWidth=null;this.hasProcessed=
!0;b&&!this.requireSorting&&(this.requireSorting=A=!0);b=!1===k.apply(this,arguments)||!b;A&&(this.requireSorting=!1);if(!b){this.destroyGroupedData();b=a.groupAll?this.xData:this.processedXData;var t=a.groupAll?this.yData:this.processedYData,v=c.plotSizeX;c=this.xAxis;var q=c.options.ordinal,D=this.groupPixelWidth=c.getGroupPixelWidth&&c.getGroupPixelWidth();if(D){this.isDirty=g=!0;this.points=null;A=c.getExtremes();var w=A.min;A=A.max;q=q&&c.getGroupIntervalFactor(w,A,this)||1;D=D*(A-w)/v*q;v=c.getTimeTicks(c.normalizeTimeTickInterval(D,
a.units||u),Math.min(w,b[0]),Math.max(A,b[b.length-1]),c.options.startOfWeek,b,this.closestPointRange);t=f.groupData.apply(this,[b,t,v,a.approximation]);b=t.groupedXData;q=t.groupedYData;var r=0;if(a.smoothed&&b.length){var n=b.length-1;for(b[n]=Math.min(b[n],A);n--&&0<n;)b[n]+=D/2;b[0]=Math.max(b[0],w)}for(n=1;n<v.length;n++)v.info.segmentStarts&&-1!==v.info.segmentStarts.indexOf(n)||(r=Math.max(v[n]-v[n-1],r));w=v.info;w.gapSize=r;this.closestPointRange=v.info.totalRange;this.groupMap=t.groupMap;
if(C(b[0])&&b[0]<c.min&&e){if(!C(c.options.min)&&c.min<=c.dataMin||c.min===c.dataMin)c.min=Math.min(b[0],c.min);c.dataMin=Math.min(b[0],c.dataMin)}a.groupAll&&(a=this.cropData(b,q,c.min,c.max,1),b=a.xData,q=a.yData);this.processedXData=b;this.processedYData=q}else this.groupMap=null;this.hasGroupedData=g;this.currentDataGrouping=w;this.preventGraphAnimation=(l&&l.totalRange)!==(w&&w.totalRange)}};f.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(c,a){c&&(this.groupedData[a]=
c.destroy?c.destroy():null)},this),this.groupedData.length=0)};f.generatePoints=function(){A.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};B(m,"update",function(){if(this.dataGroup)return H(24,!1,this.series.chart),!1});B(p,"headerFormatter",function(c){var a=this.chart,b=a.time,d=c.labelConfig,k=d.series,f=k.tooltipOptions,u=k.options.dataGrouping,g=f.xDateFormat,A=k.xAxis,v=f[(c.isFooter?"footer":"header")+"Format"];if(A&&"datetime"===A.options.type&&
u&&t(d.key)){var q=k.currentDataGrouping;u=u.dateTimeLabelFormats||D.dateTimeLabelFormats;if(q)if(f=u[q.unitName],1===q.count)g=f[0];else{g=f[1];var w=f[2]}else!g&&u&&(g=this.getXDateFormat(d,f,A));g=b.dateFormat(g,d.key);w&&(g+=b.dateFormat(w,d.key+q.totalRange-1));k.chart.styledMode&&(v=this.styledModeFormat(v));c.text=l(v,{point:e(d.point,{key:g}),series:k},a);c.preventDefault()}});B(n,"destroy",f.destroyGroupedData);B(n,"afterSetOptions",function(c){c=c.options;var a=this.type,b=this.chart.options.plotOptions,
d=g[a].dataGrouping,k=this.useCommonDataGrouping&&D;if(F[a]||k)d||(d=q(D,F[a])),c.dataGrouping=q(k,d,b.series&&b.series.dataGrouping,b[a].dataGrouping,this.userOptions.dataGrouping)});B(b,"afterSetScale",function(){this.series.forEach(function(c){c.hasProcessed=!1})});b.prototype.getGroupPixelWidth=function(){var c=this.series,a=c.length,b,k=0,f=!1,e;for(b=a;b--;)(e=c[b].options.dataGrouping)&&(k=Math.max(k,d(e.groupPixelWidth,D.groupPixelWidth)));for(b=a;b--;)(e=c[b].options.dataGrouping)&&c[b].hasProcessed&&
(a=(c[b].processedXData||c[b].data).length,c[b].groupPixelWidth||a>this.chart.plotSizeX/k||a&&e.forced)&&(f=!0);return f?k:0};b.prototype.setDataGrouping=function(c,a){var h;a=d(a,!0);c||(c={forced:!1,units:null});if(this instanceof b)for(h=this.series.length;h--;)this.series[h].update({dataGrouping:c},!1);else this.chart.options.series.forEach(function(a){a.dataGrouping=c},!1);this.ordinalSlope=null;a&&this.chart.redraw()};r.dataGrouping=a;"";return a});G(p,"parts/OHLCSeries.js",[p["parts/Globals.js"],
p["parts/Point.js"],p["parts/Utilities.js"]],function(r,m,p){p=p.seriesType;var n=r.seriesTypes;p("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(n){return[n.open,n.high,n.low,n.close]},pointValKey:"close",
pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},init:function(){n.column.prototype.init.apply(this,arguments);this.options.stacking=!1},pointAttribs:function(r,m){m=n.column.prototype.pointAttribs.call(this,r,m);var p=this.options;delete m.fill;!r.options.color&&p.upColor&&r.open<r.close&&(m.stroke=p.upColor);return m},translate:function(){var r=this,m=r.yAxis,p=!!r.modifyValue,w=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];n.column.prototype.translate.apply(r);r.points.forEach(function(n){[n.open,
n.high,n.low,n.close,n.low].forEach(function(C,e){null!==C&&(p&&(C=r.modifyValue(C)),n[w[e]]=m.toPixels(C,!0))});n.tooltipPos[1]=n.plotHigh+m.pos-r.chart.plotTop})},drawPoints:function(){var n=this,r=n.chart,m=function(n,r,m){n[2]=Math.max(m+r,n[2]);n[5]=Math.min(m-r,n[5])};n.points.forEach(function(w){var p=w.graphic,B=!p;if("undefined"!==typeof w.plotY){p||(w.graphic=p=r.renderer.path().add(n.group));r.styledMode||p.attr(n.pointAttribs(w,w.selected&&"select"));var e=p.strokeWidth();var l=e%2/2;
var t=Math.round(w.plotX)-l;var q=Math.round(w.shapeArgs.width/2);var d=["M",t,Math.round(w.yBottom),"L",t,Math.round(w.plotHigh)];if(null!==w.open){var b=Math.round(w.plotOpen)+l;d.push("M",t,b,"L",t-q,b);m(d,e/2,b)}null!==w.close&&(b=Math.round(w.plotClose)+l,d.push("M",t,b,"L",t+q,b),m(d,e/2,b));p[B?"attr":"animate"]({d:d}).addClass(w.getClassName(),!0)}})},animate:null},{getClassName:function(){return m.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}});
""});G(p,"parts/CandlestickSeries.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){var p=m.merge;m=m.seriesType;var n=r.defaultPlotOptions,B=r.seriesTypes;m("candlestick","ohlc",p(n.column,{states:{hover:{lineWidth:2}},tooltip:n.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(n,r){var w=B.column.prototype.pointAttribs.call(this,n,r),m=this.options,p=n.open<n.close,e=m.lineColor||this.color;w["stroke-width"]=
m.lineWidth;w.fill=n.options.color||(p?m.upColor||this.color:this.color);w.stroke=n.options.lineColor||(p?m.upLineColor||e:e);r&&(n=m.states[r],w.fill=n.color||w.fill,w.stroke=n.lineColor||w.stroke,w["stroke-width"]=n.lineWidth||w["stroke-width"]);return w},drawPoints:function(){var n=this,r=n.chart,w=n.yAxis.reversed;n.points.forEach(function(m){var p=m.graphic,e=!p;if("undefined"!==typeof m.plotY){p||(m.graphic=p=r.renderer.path().add(n.group));n.chart.styledMode||p.attr(n.pointAttribs(m,m.selected&&
"select")).shadow(n.options.shadow);var l=p.strokeWidth()%2/2;var t=Math.round(m.plotX)-l;var q=m.plotOpen;var d=m.plotClose;var b=Math.min(q,d);q=Math.max(q,d);var g=Math.round(m.shapeArgs.width/2);d=w?q!==m.yBottom:Math.round(b)!==Math.round(m.plotHigh);var v=w?Math.round(b)!==Math.round(m.plotHigh):q!==m.yBottom;b=Math.round(b)+l;q=Math.round(q)+l;l=[];l.push("M",t-g,q,"L",t-g,b,"L",t+g,b,"L",t+g,q,"Z","M",t,b,"L",t,d?Math.round(w?m.yBottom:m.plotHigh):b,"M",t,q,"L",t,v?Math.round(w?m.plotHigh:
m.yBottom):q);p[e?"attr":"animate"]({d:l}).addClass(m.getClassName(),!0)}})}});""});G(p,"mixins/on-series.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){var p=m.defined,n=m.stableSort,B=r.seriesTypes;return{getPlotBox:function(){return r.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){B.column.prototype.translate.apply(this);var r=this,m=r.options,w=r.chart,C=r.points,E=C.length-1,e,l=m.onSeries;l=l&&w.get(l);
m=m.onKey||"y";var t=l&&l.options.step,q=l&&l.points,d=q&&q.length,b=w.inverted,g=r.xAxis,v=r.yAxis,z=0,a;if(l&&l.visible&&d){z=(l.pointXOffset||0)+(l.barW||0)/2;w=l.currentDataGrouping;var f=q[d-1].x+(w?w.totalRange:0);n(C,function(a,b){return a.x-b.x});for(m="plot"+m[0].toUpperCase()+m.substr(1);d--&&C[E];){var k=q[d];w=C[E];w.y=k.y;if(k.x<=w.x&&"undefined"!==typeof k[m]){if(w.x<=f&&(w.plotY=k[m],k.x<w.x&&!t&&(a=q[d+1])&&"undefined"!==typeof a[m])){var A=(w.x-k.x)/(a.x-k.x);w.plotY+=A*(a[m]-k[m]);
w.y+=A*(a.y-k.y)}E--;d++;if(0>E)break}}}C.forEach(function(a,d){a.plotX+=z;if("undefined"===typeof a.plotY||b)0<=a.plotX&&a.plotX<=g.len?b?(a.plotY=g.translate(a.x,0,1,0,1),a.plotX=p(a.y)?v.translate(a.y,0,0,0,1):0):a.plotY=(g.opposite?0:r.yAxis.len)+g.offset:a.shapeArgs={};if((e=C[d-1])&&e.plotX===a.plotX){"undefined"===typeof e.stackIndex&&(e.stackIndex=0);var k=e.stackIndex+1}a.stackIndex=k});this.onSeries=l}}});G(p,"parts/FlagsSeries.js",[p["parts/Globals.js"],p["parts/Utilities.js"],p["mixins/on-series.js"]],
function(r,m,p){function n(d){b[d+"pin"]=function(e,g,a,f,k){var l=k&&k.anchorX;k=k&&k.anchorY;"circle"===d&&f>a&&(e-=Math.round((f-a)/2),a=f);var n=b[d](e,g,a,f);l&&k&&(n.push("M","circle"===d?e+a/2:n[1]+n[4]/2,g>k?g:g+f,"L",l,k),n=n.concat(b.circle(l-1,k-1,2,2)));return n}}var B=m.addEvent,E=m.defined,I=m.isNumber,w=m.merge,C=m.objectEach,H=m.seriesType,e=m.wrap;m=r.noop;var l=r.Renderer,t=r.Series,q=r.TrackerMixin,d=r.VMLRenderer,b=r.SVGRenderer.prototype.symbols;H("flags","column",{pointRange:0,
allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:t.prototype.init,pointAttribs:function(b,d){var e=this.options,a=b&&b.color||this.color,f=e.lineColor,k=b&&b.lineWidth;b=b&&b.fillColor||
e.fillColor;d&&(b=e.states[d].fillColor,f=e.states[d].lineColor,k=e.states[d].lineWidth);return{fill:b||a,stroke:f||a,"stroke-width":k||e.lineWidth||0}},translate:p.translate,getPlotBox:p.getPlotBox,drawPoints:function(){var b=this.points,d=this.chart,l=d.renderer,a=d.inverted,f=this.options,k=f.y,A,n=this.yAxis,m={},u=[];for(A=b.length;A--;){var c=b[A];var h=(a?c.plotY:c.plotX)>this.xAxis.len;var x=c.plotX;var y=c.stackIndex;var t=c.options.shape||f.shape;var q=c.plotY;"undefined"!==typeof q&&(q=
c.plotY+k-("undefined"!==typeof y&&y*f.stackDistance));c.anchorX=y?void 0:c.plotX;var p=y?void 0:c.plotY;var B="flag"!==t;y=c.graphic;"undefined"!==typeof q&&0<=x&&!h?(y||(y=c.graphic=l.label("",null,null,t,null,null,f.useHTML),d.styledMode||y.attr(this.pointAttribs(c)).css(w(f.style,c.style)),y.attr({align:B?"center":"left",width:f.width,height:f.height,"text-align":f.textAlign}).addClass("highcharts-point").add(this.markerGroup),c.graphic.div&&(c.graphic.div.point=c),d.styledMode||y.shadow(f.shadow),
y.isNew=!0),0<x&&(x-=y.strokeWidth()%2),t={y:q,anchorY:p},f.allowOverlapX&&(t.x=x,t.anchorX=c.anchorX),y.attr({text:c.options.title||f.title||"A"})[y.isNew?"attr":"animate"](t),f.allowOverlapX||(m[c.plotX]?m[c.plotX].size=Math.max(m[c.plotX].size,y.width):m[c.plotX]={align:B?.5:0,size:y.width,target:x,anchorX:x}),c.tooltipPos=[x,q+n.pos-d.plotTop]):y&&(c.graphic=y.destroy())}f.allowOverlapX||(C(m,function(a){a.plotX=a.anchorX;u.push(a)}),r.distribute(u,a?n.len:this.xAxis.len,100),b.forEach(function(a){var c=
a.graphic&&m[a.plotX];c&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:c.pos+c.align*c.size,anchorX:a.anchorX}),E(c.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));f.useHTML&&e(this.markerGroup,"on",function(a){return r.SVGElement.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var b=this.points;q.drawTrackerPoint.apply(this);b.forEach(function(d){var e=d.graphic;e&&B(e.element,"mouseover",
function(){0<d.stackIndex&&!d.raised&&(d._y=e.y,e.attr({y:d._y-8}),d.raised=!0);b.forEach(function(a){a!==d&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})})})},animate:function(b){b&&this.setClip()},setClip:function(){t.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:m,invertGroups:m},{isValid:function(){return I(this.y)||"undefined"===typeof this.y}});b.flag=function(d,e,l,a,f){var k=
f&&f.anchorX||d;f=f&&f.anchorY||e;return b.circle(k-1,f-1,2,2).concat(["M",k,f,"L",d,e+a,d,e,d+l,e,d+l,e+a,d,e+a,"Z"])};n("circle");n("square");l===d&&["circlepin","flag","squarepin"].forEach(function(e){d.prototype.symbols[e]=b[e]});""});G(p,"parts/RangeSelector.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(r,m){function p(a){this.init(a)}var n=m.addEvent,B=m.createElement,G=m.css,I=m.defined,w=m.destroyObjectProperties,C=m.discardElement,H=m.extend,e=m.fireEvent,l=m.isNumber,t=m.merge,
q=m.objectEach,d=m.pick,b=m.pInt,g=m.splat,v=r.Axis;m=r.Chart;var z=r.defaultOptions;H(z,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});z.lang=t(z.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});p.prototype={clickButton:function(a,b){var k=this.chart,e=this.buttonOptions[a],f=k.xAxis[0],
m=k.scroller&&k.scroller.getUnionExtremes()||f||{},u=m.dataMin,c=m.dataMax,h=f&&Math.round(Math.min(f.max,d(c,f.max))),x=e.type;m=e._range;var y,t=e.dataGrouping;if(null!==u&&null!==c){k.fixedRange=m;t&&(this.forcedDataGrouping=!0,v.prototype.setDataGrouping.call(f||{chart:this.chart},t,!1),this.frozenStates=e.preserveDataGrouping);if("month"===x||"year"===x)if(f){x={range:e,max:h,chart:k,dataMin:u,dataMax:c};var q=f.minFromRange.call(x);l(x.newMax)&&(h=x.newMax)}else m=e;else if(m)q=Math.max(h-m,
u),h=Math.min(q+m,c);else if("ytd"===x)if(f)"undefined"===typeof c&&(u=Number.MAX_VALUE,c=Number.MIN_VALUE,k.series.forEach(function(a){a=a.xData;u=Math.min(a[0],u);c=Math.max(a[a.length-1],c)}),b=!1),h=this.getYTDExtremes(c,u,k.time.useUTC),q=y=h.min,h=h.max;else{this.deferredYTDClick=a;return}else"all"===x&&f&&(q=u,h=c);q+=e._offsetMin;h+=e._offsetMax;this.setSelected(a);if(f)f.setExtremes(q,h,d(b,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:e});else{var r=g(k.options.xAxis)[0];var p=
r.range;r.range=m;var w=r.min;r.min=y;n(k,"load",function(){r.range=p;r.min=w})}}},setSelected:function(a){this.selected=this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var b=this,d=a.options.rangeSelector,g=d.buttons||[].concat(b.defaultButtons),l=d.selected,m=function(){var a=b.minInput,c=b.maxInput;a&&a.blur&&
e(a,"blur");c&&c.blur&&e(c,"blur")};b.chart=a;b.options=d;b.buttons=[];b.buttonOptions=g;this.unMouseDown=n(a.container,"mousedown",m);this.unResize=n(a,"resize",m);g.forEach(b.computeButtonRange);"undefined"!==typeof l&&g[l]&&this.clickButton(l,!1);n(a,"load",function(){a.xAxis&&a.xAxis[0]&&n(a.xAxis[0],"setExtremes",function(d){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==d.trigger&&"updatedData"!==d.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,!1)})})},updateButtonStates:function(){var a=
this,b=this.chart,d=b.xAxis[0],e=Math.round(d.max-d.min),g=!d.hasVisibleSeries,m=b.scroller&&b.scroller.getUnionExtremes()||d,u=m.dataMin,c=m.dataMax;b=a.getYTDExtremes(c,u,b.time.useUTC);var h=b.min,n=b.max,y=a.selected,t=l(y),q=a.options.allButtonsEnabled,r=a.buttons;a.buttonOptions.forEach(function(b,k){var f=b._range,l=b.type,m=b.count||1,x=r[k],A=0,p=b._offsetMax-b._offsetMin;b=k===y;var v=f>c-u,w=f<d.minRange,D=!1,z=!1;f=f===e;("month"===l||"year"===l)&&e+36E5>=864E5*{month:28,year:365}[l]*
m-p&&e-36E5<=864E5*{month:31,year:366}[l]*m+p?f=!0:"ytd"===l?(f=n-h+p===e,D=!b):"all"===l&&(f=d.max-d.min>=c-u,z=!b&&t&&f);l=!q&&(v||w||z||g);m=b&&f||f&&!t&&!D||b&&a.frozenStates;l?A=3:m&&(t=!0,A=2);x.state!==A&&(x.setState(A),0===A&&y===k&&a.setSelected(null))})},computeButtonRange:function(a){var b=a.type,e=a.count||1,g={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(g[b])a._range=g[b]*e;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*e;a._offsetMin=
d(a.offsetMin,0);a._offsetMax=d(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,b){var d=this.chart.options.rangeSelector,e=this.chart.time,f=this[a+"Input"];I(b)&&(f.previousValue=f.HCTime,f.HCTime=b);f.value=e.dateFormat(d.inputEditDateFormat||"%Y-%m-%d",f.HCTime);this[a+"DateBox"].attr({text:e.dateFormat(d.inputDateFormat||"%b %e, %Y",f.HCTime)})},showInput:function(a){var b=this.inputGroup,d=this[a+"DateBox"];G(this[a+"Input"],{left:b.translateX+d.x+"px",top:b.translateY+
"px",width:d.width-2+"px",height:d.height-2+"px",border:"2px solid silver"})},hideInput:function(a){G(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(a){function d(){var a=x.value,c=(u.inputDateParser||Date.parse)(a),d=g.xAxis[0],f=g.scroller&&g.scroller.xAxis?g.scroller.xAxis:d,k=f.dataMin;f=f.dataMax;c!==x.previousValue&&(x.previousValue=c,l(c)||(c=a.split("-"),c=Date.UTC(b(c[0]),b(c[1])-1,b(c[2]))),l(c)&&(g.time.useUTC||(c+=6E4*(new Date).getTimezoneOffset()),
h?c>e.maxInput.HCTime?c=void 0:c<k&&(c=k):c<e.minInput.HCTime?c=void 0:c>f&&(c=f),"undefined"!==typeof c&&d.setExtremes(h?c:d.min,h?d.max:c,void 0,void 0,{trigger:"rangeSelectorInput"})))}var e=this,g=e.chart,m=g.renderer.style||{},n=g.renderer,u=g.options.rangeSelector,c=e.div,h="min"===a,x,y,q=this.inputGroup;this[a+"Label"]=y=n.label(z.lang[h?"rangeSelectorFrom":"rangeSelectorTo"],this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(q);q.offset+=y.width+5;this[a+"DateBox"]=
n=n.label("",q.offset).addClass("highcharts-range-input").attr({padding:2,width:u.inputBoxWidth||90,height:u.inputBoxHeight||17,"text-align":"center"}).on("click",function(){e.showInput(a);e[a+"Input"].focus()});g.styledMode||n.attr({stroke:u.inputBoxBorderColor||"#cccccc","stroke-width":1});n.add(q);q.offset+=n.width+(h?10:0);this[a+"Input"]=x=B("input",{name:a,className:"highcharts-range-selector",type:"text"},{top:g.plotTop+"px"},c);g.styledMode||(y.css(t(m,u.labelStyle)),n.css(t({color:"#333333"},
m,u.inputStyle)),G(x,H({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:m.fontSize,fontFamily:m.fontFamily,top:"-9999em"},u.inputStyle)));x.onfocus=function(){e.showInput(a)};x.onblur=function(){x===r.doc.activeElement&&d();e.hideInput(a);x.blur()};x.onchange=d;x.onkeypress=function(a){13===a.keyCode&&d()}},getPosition:function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,
inputTop:a+b.inputPosition.y-10}},getYTDExtremes:function(a,b,d){var e=this.chart.time,f=new e.Date(a),k=e.get("FullYear",f);d=d?e.Date.UTC(k,0,1):+new e.Date(k,0,1);b=Math.max(b||0,d);f=f.getTime();return{max:Math.min(a||f,f),min:b}},render:function(a,b){var e=this,f=e.chart,g=f.renderer,l=f.container,u=f.options,c=u.exporting&&!1!==u.exporting.enabled&&u.navigation&&u.navigation.buttonOptions,h=z.lang,m=e.div,n=u.rangeSelector,q=d(u.chart.style&&u.chart.style.zIndex,0)+1;u=n.floating;var t=e.buttons;
m=e.inputGroup;var r=n.buttonTheme,p=n.buttonPosition,v=n.inputPosition,w=n.inputEnabled,C=r&&r.states,E=f.plotLeft,K=e.buttonGroup,H,G=e.options.verticalAlign,I=f.legend,O=I&&I.options,P=p.y,J=v.y,Q=f.hasLoaded,R=Q?"animate":"attr",N=0,L=0;if(!1!==n.enabled){e.rendered||(e.group=H=g.g("range-selector-group").attr({zIndex:7}).add(),e.buttonGroup=K=g.g("range-selector-buttons").add(H),e.zoomText=g.text(h.rangeSelectorZoom,0,15).add(K),f.styledMode||(e.zoomText.css(n.labelStyle),r["stroke-width"]=d(r["stroke-width"],
0)),e.buttonOptions.forEach(function(a,c){t[c]=g.button(a.text,0,0,function(b){var d=a.events&&a.events.click,h;d&&(h=d.call(a,b));!1!==h&&e.clickButton(c);e.isActive=!0},r,C&&C.hover,C&&C.select,C&&C.disabled).attr({"text-align":"center"}).add(K)}),!1!==w&&(e.div=m=B("div",null,{position:"relative",height:0,zIndex:q}),l.parentNode.insertBefore(m,l),e.inputGroup=m=g.g("input-group").add(H),m.offset=0,e.drawInput("min"),e.drawInput("max")));e.zoomText[R]({x:d(E+p.x,E)});var S=d(E+p.x,E)+e.zoomText.getBBox().width+
5;e.buttonOptions.forEach(function(a,c){t[c][R]({x:S});S+=t[c].width+d(n.buttonSpacing,5)});E=f.plotLeft-f.spacing[3];e.updateButtonStates();c&&this.titleCollision(f)&&"top"===G&&"right"===p.align&&p.y+K.getBBox().height-12<(c.y||0)+c.height&&(N=-40);l=p.x-f.spacing[3];"right"===p.align?l+=N-E:"center"===p.align&&(l-=E/2);K.align({y:p.y,width:K.getBBox().width,align:p.align,x:l},!0,f.spacingBox);e.group.placed=Q;e.buttonGroup.placed=Q;!1!==w&&(N=c&&this.titleCollision(f)&&"top"===G&&"right"===v.align&&
v.y-m.getBBox().height-12<(c.y||0)+c.height+f.spacing[0]?-40:0,"left"===v.align?l=E:"right"===v.align&&(l=-Math.max(f.axisOffset[1],-N)),m.align({y:v.y,width:m.getBBox().width,align:v.align,x:v.x+l-2},!0,f.spacingBox),c=m.alignAttr.translateX+m.alignOptions.x-N+m.getBBox().x+2,l=m.alignOptions.width,h=K.alignAttr.translateX+K.getBBox().x,E=K.getBBox().width+20,(v.align===p.align||h+E>c&&c+l>h&&P<J+m.getBBox().height)&&m.attr({translateX:m.alignAttr.translateX+(f.axisOffset[1]>=-N?0:-N),translateY:m.alignAttr.translateY+
K.getBBox().height+10}),e.setInputValue("min",a),e.setInputValue("max",b),e.inputGroup.placed=Q);e.group.align({verticalAlign:G},!0,f.spacingBox);a=e.group.getBBox().height+20;b=e.group.alignAttr.translateY;"bottom"===G&&(I=O&&"bottom"===O.verticalAlign&&O.enabled&&!O.floating?I.legendHeight+d(O.margin,10):0,a=a+I-20,L=b-a-(u?0:n.y)-(f.titleOffset?f.titleOffset[2]:0)-10);if("top"===G)u&&(L=0),f.titleOffset&&f.titleOffset[0]&&(L=f.titleOffset[0]),L+=f.margin[0]-f.spacing[0]||0;else if("middle"===G)if(J===
P)L=0>J?b+void 0:b;else if(J||P)L=0>J||0>P?L-Math.min(J,P):b-a+NaN;e.group.translate(n.x,n.y+Math.floor(L));!1!==w&&(e.minInput.style.marginTop=e.group.translateY+"px",e.maxInput.style.marginTop=e.group.translateY+"px");e.rendered=!0}},getHeight:function(){var a=this.options,b=this.group,d=a.y,e=a.buttonPosition.y,g=a.inputPosition.y;if(a.height)return a.height;a=b?b.getBBox(!0).height+13+d:0;b=Math.min(g,e);if(0>g&&0>e||0<g&&0<e)a+=Math.abs(b);return a},titleCollision:function(a){return!(a.options.title.text||
a.options.subtitle.text)},update:function(a){var b=this.chart;t(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()},destroy:function(){var a=this,b=a.minInput,d=a.maxInput;a.unMouseDown();a.unResize();w(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);q(a,function(b,d){b&&"chart"!==d&&(b.destroy?b.destroy():b.nodeType&&C(this[d]));b!==p.prototype[d]&&(a[d]=null)},this)}};v.prototype.minFromRange=function(){var a=this.range,
b=a.type,e=this.max,g=this.chart.time,m=function(a,c){var d="year"===b?"FullYear":"Month",e=new g.Date(a),h=g.get(d,e);g.set(d,e,h+c);h===g.get(d,e)&&g.set("Date",e,0);return e.getTime()-a};if(l(a)){var n=e-a;var u=a}else n=e+m(e,-a.count),this.chart&&(this.chart.fixedRange=e-n);var c=d(this.dataMin,Number.MIN_VALUE);l(n)||(n=c);n<=c&&(n=c,"undefined"===typeof u&&(u=m(n,a.count)),this.newMax=Math.min(n+u,this.dataMax));l(e)||(n=void 0);return n};r.RangeSelector||(n(m,"afterGetContainer",function(){this.options.rangeSelector.enabled&&
(this.rangeSelector=new p(this))}),n(m,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(l(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),n(m,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,
e=this.extraTopMargin;b&&b.enabled&&!I(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new p(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==d||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)}),n(m,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,
"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),n(m,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),m.prototype.callbacks.push(function(a){function b(){d=a.xAxis[0].getExtremes();l(d.min)&&e.render(d.min,d.max)}var d,e=a.rangeSelector;if(e){var g=n(a.xAxis[0],"afterSetExtremes",function(a){e.render(a.min,a.max)});var m=n(a,"redraw",b);b()}n(a,"destroy",function(){e&&
(m(),g())})}),r.RangeSelector=p)});G(p,"parts/StockChart.js",[p["parts/Globals.js"],p["parts/Point.js"],p["parts/Utilities.js"]],function(r,m,p){var n=p.addEvent,B=p.arrayMax,E=p.arrayMin,G=p.clamp,w=p.defined,C=p.extend,H=p.find,e=p.format,l=p.isNumber,t=p.isString,q=p.merge,d=p.pick,b=p.splat;p=r.Axis;var g=r.Chart,v=r.Renderer,z=r.Series,a=r.SVGRenderer,f=r.VMLRenderer,k=z.prototype,A=k.init,D=k.processData,F=m.prototype.tooltipFormatter;r.StockChart=r.stockChart=function(a,c,e){var h=t(a)||a.nodeName,
f=arguments[h?1:0],u=f,l=f.series,k=r.getOptions(),m,n=f.chart&&f.chart.panning,p=d(f.navigator&&f.navigator.enabled,k.navigator.enabled,!0),v=n&&/y/.test(n.type),w={startOnTick:!1,endOnTick:!1};f.xAxis=b(f.xAxis||{}).map(function(a,b){return q({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},k.xAxis,k.xAxis&&k.xAxis[b],a,{type:"datetime",categories:null},p?w:null)});f.yAxis=b(f.yAxis||{}).map(function(a,b){m=d(a.opposite,!0);return q({labels:{y:-2},
opposite:m,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},k.yAxis,k.yAxis&&k.yAxis[b],a,v?w:null)});f.series=null;f=q({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:p},scrollbar:{enabled:d(k.scrollbar.enabled,!0)},rangeSelector:{enabled:d(k.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:d(k.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},f,{isStock:!0});f.series=u.series=l;return h?new g(a,f,e):new g(f,c)};n(z,"setOptions",function(a){var b;
this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=q(a.plotOptions[this.type],b)))});n(p,"autoLabelAlign",function(a){var b=this.chart,d=this.options;b=b._labelPanes=b._labelPanes||{};var e=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(d=d.top+","+d.height,!b[d]&&e.enabled&&(15===e.x&&(e.x=0),"undefined"===typeof e.align&&(e.align=
"right"),b[d]=this,a.align="right",a.preventDefault()))});n(p,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});n(p,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=e.options[b];return l(a)?[g[b][a]]:t(a)?[g.get(a)]:f.map(function(a){return a[b]})}var e=this,f=this.isLinked&&!this.series?this.linkedParent.series:this.series,g=e.chart,k=g.renderer,u=e.left,
m=e.top,n,p,q,r,v=[],z=[],A=a.translatedValue,B=a.value,C=a.force;if(g.options.isStock&&!1!==a.acrossPanes&&"xAxis"===e.coll||"yAxis"===e.coll){a.preventDefault();z=b(e.coll);var D=e.isXAxis?g.yAxis:g.xAxis;D.forEach(function(a){if(w(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=w(a.options[b])?g[b][a.options[b]]:g[b][0];e===b&&z.push(a)}});var E=z.length?[]:[e.isXAxis?g.yAxis[0]:g.xAxis[0]];z.forEach(function(a){-1!==E.indexOf(a)||H(E,function(b){return b.pos===
a.pos&&b.len===a.len})||E.push(a)});var F=d(A,e.translate(B,null,null,a.old));l(F)&&(e.horiz?E.forEach(function(a){var b;p=a.pos;r=p+a.len;n=q=Math.round(F+e.transB);"pass"!==C&&(n<u||n>u+e.width)&&(C?n=q=G(n,u,u+e.width):b=!0);b||v.push("M",n,p,"L",q,r)}):E.forEach(function(a){var b;n=a.pos;q=n+a.len;p=r=Math.round(m+e.height-F);"pass"!==C&&(p<m||p>m+e.height)&&(C?p=r=G(p,m,m+e.height):b=!0);b||v.push("M",n,p,"L",q,r)}));a.path=0<v.length?k.crispPolyLine(v,a.lineWidth||1):null}});a.prototype.crispPolyLine=
function(a,b){var c;for(c=0;c<a.length;c+=6)a[c+1]===a[c+4]&&(a[c+1]=a[c+4]=Math.round(a[c+1])-b%2/2),a[c+2]===a[c+5]&&(a[c+2]=a[c+5]=Math.round(a[c+2])+b%2/2);return a};v===f&&(f.prototype.crispPolyLine=a.prototype.crispPolyLine);n(p,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});n(p,"afterDrawCrosshair",function(a){var b,f;if(w(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var g=this.chart,k=this.options.crosshair.label,l=this.horiz,
n=this.opposite,m=this.left,u=this.top,p=this.crossLabel,q=k.format,r="",t="inside"===this.options.tickPosition,v=!1!==this.crosshair.snap,z=0,A=a.e||this.cross&&this.cross.e,B=a.point;var D=this.lin2log;if(this.isLog){a=D(this.min);var E=D(this.max)}else a=this.min,E=this.max;D=l?"center":n?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";p||(p=this.crossLabel=g.renderer.label(null,null,null,k.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&
" highcharts-color-"+this.series[0].colorIndex)).attr({align:k.align||D,padding:d(k.padding,8),r:d(k.borderRadius,3),zIndex:2}).add(this.labelGroup),g.styledMode||p.attr({fill:k.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:k.borderColor||"","stroke-width":k.borderWidth||0}).css(C({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},k.style)));l?(D=v?B.plotX+m:A.chartX,u+=n?0:this.height):(D=n?this.width+m:0,u=v?B.plotY+u:A.chartY);q||k.formatter||(this.isDatetimeAxis&&
(r="%b %d, %Y"),q="{value"+(r?":"+r:"")+"}");r=v?B[this.isXAxis?"x":"y"]:this.toValue(l?A.chartX:A.chartY);p.attr({text:q?e(q,{value:r},g):k.formatter.call(this,r),x:D,y:u,visibility:r<a||r>E?"hidden":"visible"});k=p.getBBox();if(l){if(t&&!n||!t&&n)u=p.y-k.height}else u=p.y-k.height/2;l?(b=m-k.x,f=m+this.width-k.x):(b="left"===this.labelAlign?m:0,f="right"===this.labelAlign?m+this.width:g.chartWidth);p.translateX<b&&(z=b-p.translateX);p.translateX+k.width>=f&&(z=-(p.translateX+k.width-f));p.attr({x:D+
z,y:u,anchorX:l?D:this.opposite?0:g.chartWidth,anchorY:l?this.opposite?g.chartHeight:0:u+k.height/2})}});k.init=function(){A.apply(this,arguments);this.setCompare(this.options.compare)};k.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,d){var c=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof c?(b="value"===a?b-c:b/c*100-(100===this.options.compareBase?0:100),d&&(d.change=b),b):0}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=
!0)};k.processData=function(a){var b,d=-1,e=!0===this.options.compareStart?0:1;D.apply(this,arguments);if(this.xAxis&&this.processedYData){var f=this.processedXData;var g=this.processedYData;var k=g.length;this.pointArrayMap&&(d=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<k-e;b++){var m=g[b]&&-1<d?g[b][d]:g[b];if(l(m)&&f[b+e]>=this.xAxis.min&&0!==m){this.compareValue=m;break}}}};n(z,"afterGetExtremes",function(){if(this.modifyValue){var a=[this.modifyValue(this.dataMin),
this.modifyValue(this.dataMax)];this.dataMin=E(a);this.dataMax=B(a)}});p.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),d(b,!0)&&this.chart.redraw())};m.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,d(this.series.tooltipOptions.changeDecimals,2)));return F.apply(this,[a])};n(z,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&
!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var d=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,e=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=d&&(b-=Math.max(e-d,0))}!this.clipBox&&this.animate?(this.clipBox=q(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b):a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len}))}});n(g,"update",
function(a){a=a.options;"scrollbar"in a&&this.navigator&&(q(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)});n(p,"afterSetScale",function(){var a=this,b=a.chart.options.chart&&a.chart.options.chart.panning;if(b&&("y"===b.type||"xy"===b.type)&&!a.isXAxis&&!w(a.panningState)){var d=Number.MAX_VALUE,e=Number.MIN_VALUE;a.series.forEach(function(b){d=Math.min(r.arrayMin(b.yData),d)-(a.min&&a.dataMin?a.dataMin-a.min:0);e=Math.max(r.arrayMax(b.yData),e)+(a.max&&a.dataMax?
a.max-a.dataMax:0)});a.panningState={startMin:d,startMax:e}}})});G(p,"masters/modules/stock.btx.js",[],function(){})});
//# sourceMappingURL=stock.js.map