# -*- coding: utf-8 -*-

"""Pyslvs graph functions."""

__all__ = [
    'link_assortment',
    'contracted_link_assortment',
    'labeled_enumerate',
    'Graph',
    'is_planar',
    'external_loop_layout',
    'conventional_graph',
    'contracted_graph',
    'link_synthesis',
    'contracted_link_synthesis',
]
__author__ = "Yuan Chang"
__copyright__ = "Copyright (C) 2016-2020"
__license__ = "AGPL"
__email__ = "pyslvs@gmail.com"

from .graph import (
    link_assortment,
    contracted_link_assortment,
    labeled_enumerate,
    Graph,
)
from .planar import is_planar
from .layout import external_loop_layout
from .structural import (
    conventional_graph,
    contracted_graph,
    link_synthesis,
    contracted_link_synthesis,
)
