from abc import ABC, abstractmethod
from typing import Tuple

from firexapp.discovery import get_firex_tracking_services_entry_points, PkgVersionInfo
from firexapp.submit.install_configs import FireXInstallConfigs

_services = None


class TrackingService(ABC):

    install_configs: FireXInstallConfigs

    def extra_cli_arguments(self, arg_parser):
        pass

    @abstractmethod
    def start(self, args, install_configs: FireXInstallConfigs, **kwargs) -> {}:
        self.install_configs = install_configs

    def ready_for_tasks(self, **kwargs) -> bool:
        return True

    def ready_release_console(self, **kwargs) -> bool:
        return True

    def get_version(self) -> str:
        return None


def get_service_name(service: TrackingService) -> str:
    return service.__class__.__name__


def get_service_top_module(service: TrackingService) -> str:
    return service.__module__.split('.')[0]


def get_tracking_services() -> Tuple[TrackingService]:
    global _services
    if _services is None:
        entry_pts = get_firex_tracking_services_entry_points()
        entry_objects = [e.load() for e in entry_pts]
        _services = tuple([point() for point in entry_objects])
    return _services


def get_tracking_services_versions() -> [PkgVersionInfo]:
    return [PkgVersionInfo(pkg=get_service_top_module(service), version=service.get_version())
            for service in get_tracking_services()]


def has_flame() -> bool:
    # Unfortunate coupling, but just too many things vary depending on presence of flame. Will eventually bring
    # flame in to firexapp.
    return 'FlameLauncher' in get_tracking_services()