"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.rpc.status_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class PipelineJob(google.protobuf.message.Message):
    """The spec of a pipeline job."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        value: typing.Text
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class RuntimeConfig(google.protobuf.message.Message):
        """The runtime config of a PipelineJob."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___Value: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___Value] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class ParameterValuesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> google.protobuf.struct_pb2.Value: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[google.protobuf.struct_pb2.Value] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        PARAMETERS_FIELD_NUMBER: builtins.int
        GCS_OUTPUT_DIRECTORY_FIELD_NUMBER: builtins.int
        PARAMETER_VALUES_FIELD_NUMBER: builtins.int
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Value]:
            """Deprecated. Use [RuntimeConfig.parameter_values][] instead."""
            pass
        gcs_output_directory: typing.Text
        """A path in a Cloud Storage bucket which will be treated as the root
        output directory of the pipeline. It is used by the system to
        generate the paths of output artifacts.
        This is a GCP-specific optimization.
        """

        @property
        def parameter_values(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, google.protobuf.struct_pb2.Value]:
            """The runtime parameters of the PipelineJob. The parameters will be
            passed into [PipelineJob.pipeline_spec][] to replace the placeholders
            at runtime.
            """
            pass
        def __init__(self,
            *,
            parameters: typing.Optional[typing.Mapping[typing.Text, global___Value]] = ...,
            gcs_output_directory: typing.Text = ...,
            parameter_values: typing.Optional[typing.Mapping[typing.Text, google.protobuf.struct_pb2.Value]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["gcs_output_directory",b"gcs_output_directory","parameter_values",b"parameter_values","parameters",b"parameters"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    PIPELINE_SPEC_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RUNTIME_CONFIG_FIELD_NUMBER: builtins.int
    name: typing.Text
    """Name of the job."""

    display_name: typing.Text
    """User friendly display name"""

    @property
    def pipeline_spec(self) -> google.protobuf.struct_pb2.Struct:
        """Definition of the pipeline that is being executed."""
        pass
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """The labels with user-defined metadata to organize PipelineJob."""
        pass
    @property
    def runtime_config(self) -> global___PipelineJob.RuntimeConfig:
        """Runtime config of the pipeline."""
        pass
    def __init__(self,
        *,
        name: typing.Text = ...,
        display_name: typing.Text = ...,
        pipeline_spec: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        labels: typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        runtime_config: typing.Optional[global___PipelineJob.RuntimeConfig] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline_spec",b"pipeline_spec","runtime_config",b"runtime_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","labels",b"labels","name",b"name","pipeline_spec",b"pipeline_spec","runtime_config",b"runtime_config"]) -> None: ...
global___PipelineJob = PipelineJob

class PipelineSpec(google.protobuf.message.Message):
    """The spec of a pipeline."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class RuntimeParameter(google.protobuf.message.Message):
        """The definition of the runtime parameter."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TYPE_FIELD_NUMBER: builtins.int
        DEFAULT_VALUE_FIELD_NUMBER: builtins.int
        type: global___PrimitiveType.PrimitiveTypeEnum.ValueType
        """Required field. The type of the runtime parameter."""

        @property
        def default_value(self) -> global___Value:
            """Optional field. Default value of the runtime parameter. If not set and
            the runtime parameter value is not provided during runtime, an error will
            be raised.
            """
            pass
        def __init__(self,
            *,
            type: global___PrimitiveType.PrimitiveTypeEnum.ValueType = ...,
            default_value: typing.Optional[global___Value] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["default_value",b"default_value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["default_value",b"default_value","type",b"type"]) -> None: ...

    class ComponentsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ComponentSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ComponentSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    PIPELINE_INFO_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SPEC_FIELD_NUMBER: builtins.int
    SDK_VERSION_FIELD_NUMBER: builtins.int
    SCHEMA_VERSION_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    ROOT_FIELD_NUMBER: builtins.int
    DEFAULT_PIPELINE_ROOT_FIELD_NUMBER: builtins.int
    @property
    def pipeline_info(self) -> global___PipelineInfo:
        """The metadata of the pipeline."""
        pass
    @property
    def deployment_spec(self) -> google.protobuf.struct_pb2.Struct:
        """The deployment config of the pipeline.
        The deployment config can be extended to provide platform specific configs.
        """
        pass
    sdk_version: typing.Text
    """The version of the sdk, which compiles the spec."""

    schema_version: typing.Text
    """The version of the schema."""

    @property
    def components(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ComponentSpec]:
        """The map of name to definition of all components used in this pipeline."""
        pass
    @property
    def root(self) -> global___ComponentSpec:
        """The definition of the main pipeline.  Execution of the pipeline is
        completed upon the completion of this component.
        """
        pass
    default_pipeline_root: typing.Text
    """Optional field. The default root output directory of the pipeline."""

    def __init__(self,
        *,
        pipeline_info: typing.Optional[global___PipelineInfo] = ...,
        deployment_spec: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        sdk_version: typing.Text = ...,
        schema_version: typing.Text = ...,
        components: typing.Optional[typing.Mapping[typing.Text, global___ComponentSpec]] = ...,
        root: typing.Optional[global___ComponentSpec] = ...,
        default_pipeline_root: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_spec",b"deployment_spec","pipeline_info",b"pipeline_info","root",b"root"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components",b"components","default_pipeline_root",b"default_pipeline_root","deployment_spec",b"deployment_spec","pipeline_info",b"pipeline_info","root",b"root","schema_version",b"schema_version","sdk_version",b"sdk_version"]) -> None: ...
global___PipelineSpec = PipelineSpec

class ComponentSpec(google.protobuf.message.Message):
    """Definition of a component."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INPUT_DEFINITIONS_FIELD_NUMBER: builtins.int
    OUTPUT_DEFINITIONS_FIELD_NUMBER: builtins.int
    DAG_FIELD_NUMBER: builtins.int
    EXECUTOR_LABEL_FIELD_NUMBER: builtins.int
    @property
    def input_definitions(self) -> global___ComponentInputsSpec:
        """Definition of the input parameters and artifacts of the component."""
        pass
    @property
    def output_definitions(self) -> global___ComponentOutputsSpec:
        """Definition of the output parameters and artifacts of the component."""
        pass
    @property
    def dag(self) -> global___DagSpec: ...
    executor_label: typing.Text
    def __init__(self,
        *,
        input_definitions: typing.Optional[global___ComponentInputsSpec] = ...,
        output_definitions: typing.Optional[global___ComponentOutputsSpec] = ...,
        dag: typing.Optional[global___DagSpec] = ...,
        executor_label: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dag",b"dag","executor_label",b"executor_label","implementation",b"implementation","input_definitions",b"input_definitions","output_definitions",b"output_definitions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dag",b"dag","executor_label",b"executor_label","implementation",b"implementation","input_definitions",b"input_definitions","output_definitions",b"output_definitions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["implementation",b"implementation"]) -> typing.Optional[typing_extensions.Literal["dag","executor_label"]]: ...
global___ComponentSpec = ComponentSpec

class DagSpec(google.protobuf.message.Message):
    """A DAG contains multiple tasks."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class TasksEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___PipelineTaskSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___PipelineTaskSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    TASKS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def tasks(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___PipelineTaskSpec]:
        """The tasks inside the dag."""
        pass
    @property
    def outputs(self) -> global___DagOutputsSpec:
        """Defines how the outputs of the dag are linked to the sub tasks."""
        pass
    def __init__(self,
        *,
        tasks: typing.Optional[typing.Mapping[typing.Text, global___PipelineTaskSpec]] = ...,
        outputs: typing.Optional[global___DagOutputsSpec] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["outputs",b"outputs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["outputs",b"outputs","tasks",b"tasks"]) -> None: ...
global___DagSpec = DagSpec

class DagOutputsSpec(google.protobuf.message.Message):
    """Definition of the output artifacts and parameters of the DAG component."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ArtifactSelectorSpec(google.protobuf.message.Message):
        """Selects a defined output artifact from a sub task of the DAG."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PRODUCER_SUBTASK_FIELD_NUMBER: builtins.int
        OUTPUT_ARTIFACT_KEY_FIELD_NUMBER: builtins.int
        producer_subtask: typing.Text
        """The name of the sub task which produces the output that matches with
        the `output_artifact_key`.
        """

        output_artifact_key: typing.Text
        """The key of [ComponentOutputsSpec.artifacts][] map of the producer task."""

        def __init__(self,
            *,
            producer_subtask: typing.Text = ...,
            output_artifact_key: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["output_artifact_key",b"output_artifact_key","producer_subtask",b"producer_subtask"]) -> None: ...

    class DagOutputArtifactSpec(google.protobuf.message.Message):
        """Selects a list of output artifacts that will be aggregated to the single
        output artifact channel of the DAG.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        ARTIFACT_SELECTORS_FIELD_NUMBER: builtins.int
        @property
        def artifact_selectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DagOutputsSpec.ArtifactSelectorSpec]:
            """The selected artifacts will be aggregated as output as a single
            output channel of the DAG.
            """
            pass
        def __init__(self,
            *,
            artifact_selectors: typing.Optional[typing.Iterable[global___DagOutputsSpec.ArtifactSelectorSpec]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifact_selectors",b"artifact_selectors"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___DagOutputsSpec.DagOutputArtifactSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___DagOutputsSpec.DagOutputArtifactSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ParameterSelectorSpec(google.protobuf.message.Message):
        """Selects a defined output parameter from a sub task of the DAG."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PRODUCER_SUBTASK_FIELD_NUMBER: builtins.int
        OUTPUT_PARAMETER_KEY_FIELD_NUMBER: builtins.int
        producer_subtask: typing.Text
        """The name of the sub task which produces the output that matches with
        the `output_parameter_key`.
        """

        output_parameter_key: typing.Text
        """The key of [ComponentOutputsSpec.parameters][] map of the producer task."""

        def __init__(self,
            *,
            producer_subtask: typing.Text = ...,
            output_parameter_key: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["output_parameter_key",b"output_parameter_key","producer_subtask",b"producer_subtask"]) -> None: ...

    class ParameterSelectorsSpec(google.protobuf.message.Message):
        """Aggregate output parameters from sub tasks into a list object."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PARAMETER_SELECTORS_FIELD_NUMBER: builtins.int
        @property
        def parameter_selectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DagOutputsSpec.ParameterSelectorSpec]: ...
        def __init__(self,
            *,
            parameter_selectors: typing.Optional[typing.Iterable[global___DagOutputsSpec.ParameterSelectorSpec]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["parameter_selectors",b"parameter_selectors"]) -> None: ...

    class MapParameterSelectorsSpec(google.protobuf.message.Message):
        """Aggregates output parameters from sub tasks into a map object."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class MappedParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___DagOutputsSpec.ParameterSelectorSpec: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___DagOutputsSpec.ParameterSelectorSpec] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        MAPPED_PARAMETERS_FIELD_NUMBER: builtins.int
        @property
        def mapped_parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___DagOutputsSpec.ParameterSelectorSpec]: ...
        def __init__(self,
            *,
            mapped_parameters: typing.Optional[typing.Mapping[typing.Text, global___DagOutputsSpec.ParameterSelectorSpec]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["mapped_parameters",b"mapped_parameters"]) -> None: ...

    class DagOutputParameterSpec(google.protobuf.message.Message):
        """We support four ways to fan-in output parameters from sub tasks to the DAG
        parent task.
        1. Directly expose a single output parameter from a sub task,
        2. (Conditional flow) Expose a list of output from multiple tasks
        (some might be skipped) but allows only one of the output being generated.
        3. Expose a list of outputs from multiple tasks (e.g. iterator flow).
        4. Expose the aggregation of output parameters as a name-value map.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        VALUE_FROM_PARAMETER_FIELD_NUMBER: builtins.int
        VALUE_FROM_ONEOF_FIELD_NUMBER: builtins.int
        @property
        def value_from_parameter(self) -> global___DagOutputsSpec.ParameterSelectorSpec:
            """Returns the sub-task parameter as a DAG parameter.  The selected
            parameter must have the same type as the DAG parameter type.
            """
            pass
        @property
        def value_from_oneof(self) -> global___DagOutputsSpec.ParameterSelectorsSpec:
            """Returns one of the sub-task parameters as a DAG parameter. If there are
            multiple values are available to select, the DAG will fail. All the
            selected parameters must have the same type as the DAG parameter type.
            """
            pass
        def __init__(self,
            *,
            value_from_parameter: typing.Optional[global___DagOutputsSpec.ParameterSelectorSpec] = ...,
            value_from_oneof: typing.Optional[global___DagOutputsSpec.ParameterSelectorsSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["kind",b"kind","value_from_oneof",b"value_from_oneof","value_from_parameter",b"value_from_parameter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["kind",b"kind","value_from_oneof",b"value_from_oneof","value_from_parameter",b"value_from_parameter"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["value_from_parameter","value_from_oneof"]]: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___DagOutputsSpec.DagOutputParameterSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___DagOutputsSpec.DagOutputParameterSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    ARTIFACTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___DagOutputsSpec.DagOutputArtifactSpec]:
        """Name to the output artifact channel of the DAG."""
        pass
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___DagOutputsSpec.DagOutputParameterSpec]:
        """The name to the output parameter."""
        pass
    def __init__(self,
        *,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___DagOutputsSpec.DagOutputArtifactSpec]] = ...,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___DagOutputsSpec.DagOutputParameterSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameters",b"parameters"]) -> None: ...
global___DagOutputsSpec = DagOutputsSpec

class ComponentInputsSpec(google.protobuf.message.Message):
    """Definition specification of the component input parameters and artifacts."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ArtifactSpec(google.protobuf.message.Message):
        """Definition of an artifact input."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        ARTIFACT_TYPE_FIELD_NUMBER: builtins.int
        @property
        def artifact_type(self) -> global___ArtifactTypeSchema: ...
        def __init__(self,
            *,
            artifact_type: typing.Optional[global___ArtifactTypeSchema] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type"]) -> None: ...

    class ParameterSpec(google.protobuf.message.Message):
        """Definition of a parameter input."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TYPE_FIELD_NUMBER: builtins.int
        PARAMETER_TYPE_FIELD_NUMBER: builtins.int
        DEFAULT_VALUE_FIELD_NUMBER: builtins.int
        IS_OPTIONAL_FIELD_NUMBER: builtins.int
        type: global___PrimitiveType.PrimitiveTypeEnum.ValueType
        """Specifies an input parameter's type.
        Deprecated. Use [ParameterSpec.parameter_type][] instead.
        """

        parameter_type: global___ParameterType.ParameterTypeEnum.ValueType
        """Specifies an input parameter's type."""

        @property
        def default_value(self) -> google.protobuf.struct_pb2.Value:
            """Optional field. Default value of the input parameter."""
            pass
        is_optional: builtins.bool
        """Whether this input parameter is optional or not.
        - If required, the parameter should either have a default value, or have
        to be able to resolve to a concrete value at runtime.
        - If it's optional, it can be missing from the
        PipelineTaskInputsSpec.InputParameterSpec (if it's instantiated into a
        task), or can be missing from the runtimeParameter (if it's the root
        component). If the value is missing, the default_value will be used. Or
        if default_value is not provided, the default value of the parameter's
        type will be used.
        """

        def __init__(self,
            *,
            type: global___PrimitiveType.PrimitiveTypeEnum.ValueType = ...,
            parameter_type: global___ParameterType.ParameterTypeEnum.ValueType = ...,
            default_value: typing.Optional[google.protobuf.struct_pb2.Value] = ...,
            is_optional: builtins.bool = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["default_value",b"default_value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["default_value",b"default_value","is_optional",b"is_optional","parameter_type",b"parameter_type","type",b"type"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ComponentInputsSpec.ArtifactSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ComponentInputsSpec.ArtifactSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ComponentInputsSpec.ParameterSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ComponentInputsSpec.ParameterSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    ARTIFACTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ComponentInputsSpec.ArtifactSpec]:
        """Name to artifact input."""
        pass
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ComponentInputsSpec.ParameterSpec]:
        """Name to parameter input."""
        pass
    def __init__(self,
        *,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___ComponentInputsSpec.ArtifactSpec]] = ...,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___ComponentInputsSpec.ParameterSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameters",b"parameters"]) -> None: ...
global___ComponentInputsSpec = ComponentInputsSpec

class ComponentOutputsSpec(google.protobuf.message.Message):
    """Definition specification of the component output parameters and artifacts."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ArtifactSpec(google.protobuf.message.Message):
        """Definition of an artifact output."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class PropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class CustomPropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        ARTIFACT_TYPE_FIELD_NUMBER: builtins.int
        PROPERTIES_FIELD_NUMBER: builtins.int
        CUSTOM_PROPERTIES_FIELD_NUMBER: builtins.int
        METADATA_FIELD_NUMBER: builtins.int
        @property
        def artifact_type(self) -> global___ArtifactTypeSchema: ...
        @property
        def properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """Deprecated. Use [ArtifactSpec.metadata][] instead."""
            pass
        @property
        def custom_properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """Deprecated. Use [ArtifactSpec.metadata][] instead."""
            pass
        @property
        def metadata(self) -> google.protobuf.struct_pb2.Struct:
            """Properties of the Artifact."""
            pass
        def __init__(self,
            *,
            artifact_type: typing.Optional[global___ArtifactTypeSchema] = ...,
            properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            custom_properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            metadata: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type","metadata",b"metadata"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type","custom_properties",b"custom_properties","metadata",b"metadata","properties",b"properties"]) -> None: ...

    class ParameterSpec(google.protobuf.message.Message):
        """Definition of a parameter output."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TYPE_FIELD_NUMBER: builtins.int
        PARAMETER_TYPE_FIELD_NUMBER: builtins.int
        type: global___PrimitiveType.PrimitiveTypeEnum.ValueType
        """Specifies an input parameter's type.
        Deprecated. Use [ParameterSpec.parameter_type][] instead.
        """

        parameter_type: global___ParameterType.ParameterTypeEnum.ValueType
        """Specifies an output parameter's type."""

        def __init__(self,
            *,
            type: global___PrimitiveType.PrimitiveTypeEnum.ValueType = ...,
            parameter_type: global___ParameterType.ParameterTypeEnum.ValueType = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["parameter_type",b"parameter_type","type",b"type"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ComponentOutputsSpec.ArtifactSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ComponentOutputsSpec.ArtifactSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ComponentOutputsSpec.ParameterSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ComponentOutputsSpec.ParameterSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    ARTIFACTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ComponentOutputsSpec.ArtifactSpec]:
        """Name to artifact output."""
        pass
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ComponentOutputsSpec.ParameterSpec]:
        """Name to parameter output."""
        pass
    def __init__(self,
        *,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___ComponentOutputsSpec.ArtifactSpec]] = ...,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___ComponentOutputsSpec.ParameterSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameters",b"parameters"]) -> None: ...
global___ComponentOutputsSpec = ComponentOutputsSpec

class TaskInputsSpec(google.protobuf.message.Message):
    """The spec of task inputs."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class InputArtifactSpec(google.protobuf.message.Message):
        """The specification of a task input artifact."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class TaskOutputArtifactSpec(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            PRODUCER_TASK_FIELD_NUMBER: builtins.int
            OUTPUT_ARTIFACT_KEY_FIELD_NUMBER: builtins.int
            producer_task: typing.Text
            """The name of the upstream task which produces the output that matches
            with the `output_artifact_key`.
            """

            output_artifact_key: typing.Text
            """The key of [TaskOutputsSpec.artifacts][] map of the producer task."""

            def __init__(self,
                *,
                producer_task: typing.Text = ...,
                output_artifact_key: typing.Text = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["output_artifact_key",b"output_artifact_key","producer_task",b"producer_task"]) -> None: ...

        TASK_OUTPUT_ARTIFACT_FIELD_NUMBER: builtins.int
        COMPONENT_INPUT_ARTIFACT_FIELD_NUMBER: builtins.int
        @property
        def task_output_artifact(self) -> global___TaskInputsSpec.InputArtifactSpec.TaskOutputArtifactSpec:
            """Pass the input artifact from another task within the same parent
            component.
            """
            pass
        component_input_artifact: typing.Text
        """Pass the input artifact from parent component input artifact."""

        def __init__(self,
            *,
            task_output_artifact: typing.Optional[global___TaskInputsSpec.InputArtifactSpec.TaskOutputArtifactSpec] = ...,
            component_input_artifact: typing.Text = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["component_input_artifact",b"component_input_artifact","kind",b"kind","task_output_artifact",b"task_output_artifact"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["component_input_artifact",b"component_input_artifact","kind",b"kind","task_output_artifact",b"task_output_artifact"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["task_output_artifact","component_input_artifact"]]: ...

    class InputParameterSpec(google.protobuf.message.Message):
        """Represents an input parameter. The value can be taken from an upstream
        task's output parameter (if specifying `producer_task` and
        `output_parameter_key`, or it can be a runtime value, which can either be
        determined at compile-time, or from a pipeline parameter.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class TaskOutputParameterSpec(google.protobuf.message.Message):
            """Represents an upstream task's output parameter."""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            PRODUCER_TASK_FIELD_NUMBER: builtins.int
            OUTPUT_PARAMETER_KEY_FIELD_NUMBER: builtins.int
            producer_task: typing.Text
            """The name of the upstream task which produces the output parameter that
            matches with the `output_parameter_key`.
            """

            output_parameter_key: typing.Text
            """The key of [TaskOutputsSpec.parameters][] map of the producer task."""

            def __init__(self,
                *,
                producer_task: typing.Text = ...,
                output_parameter_key: typing.Text = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["output_parameter_key",b"output_parameter_key","producer_task",b"producer_task"]) -> None: ...

        class TaskFinalStatus(google.protobuf.message.Message):
            """Represents an upstream task's final status. The field can only be set if
            the schema version is `2.0.0`. The resolved input parameter will be a
            json payload in string type.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            PRODUCER_TASK_FIELD_NUMBER: builtins.int
            producer_task: typing.Text
            """The name of the upsteram task where the final status is coming from."""

            def __init__(self,
                *,
                producer_task: typing.Text = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["producer_task",b"producer_task"]) -> None: ...

        TASK_OUTPUT_PARAMETER_FIELD_NUMBER: builtins.int
        RUNTIME_VALUE_FIELD_NUMBER: builtins.int
        COMPONENT_INPUT_PARAMETER_FIELD_NUMBER: builtins.int
        TASK_FINAL_STATUS_FIELD_NUMBER: builtins.int
        PARAMETER_EXPRESSION_SELECTOR_FIELD_NUMBER: builtins.int
        @property
        def task_output_parameter(self) -> global___TaskInputsSpec.InputParameterSpec.TaskOutputParameterSpec:
            """Output parameter from an upstream task."""
            pass
        @property
        def runtime_value(self) -> global___ValueOrRuntimeParameter:
            """A constant value or runtime parameter."""
            pass
        component_input_parameter: typing.Text
        """Pass the input parameter from parent component input parameter."""

        @property
        def task_final_status(self) -> global___TaskInputsSpec.InputParameterSpec.TaskFinalStatus:
            """The final status of an uptream task."""
            pass
        parameter_expression_selector: typing.Text
        """Selector expression of Common Expression Language (CEL)
        that applies to the parameter found from above kind.

        The expression is applied to the Value type
        [Value][].  For example,
        'size(string_value)' will return the size of the Value.string_value.

        After applying the selection, the parameter will be returned as a
        [Value][].  The type of the Value is either deferred from the input
        definition in the corresponding
        [ComponentSpec.input_definitions.parameters][], or if not found,
        automatically deferred as either string value or double value.

        In addition to the builtin functions in CEL, The value.string_value can
        be treated as a json string and parsed to the [google.protobuf.Value][]
        proto message. Then, the CEL expression provided in this field will be
        used to get the requested field. For examples,
         - if Value.string_value is a json array of "[1.1, 2.2, 3.3]",
         'parseJson(string_value)[i]' will pass the ith parameter from the list
         to the current task, or
         - if the Value.string_value is a json map of "{"a": 1.1, "b": 2.2,
         "c": 3.3}, 'parseJson(string_value)[key]' will pass the map value from
         the struct map to the current task.

        If unset, the value will be passed directly to the current task.
        """

        def __init__(self,
            *,
            task_output_parameter: typing.Optional[global___TaskInputsSpec.InputParameterSpec.TaskOutputParameterSpec] = ...,
            runtime_value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
            component_input_parameter: typing.Text = ...,
            task_final_status: typing.Optional[global___TaskInputsSpec.InputParameterSpec.TaskFinalStatus] = ...,
            parameter_expression_selector: typing.Text = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["component_input_parameter",b"component_input_parameter","kind",b"kind","runtime_value",b"runtime_value","task_final_status",b"task_final_status","task_output_parameter",b"task_output_parameter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["component_input_parameter",b"component_input_parameter","kind",b"kind","parameter_expression_selector",b"parameter_expression_selector","runtime_value",b"runtime_value","task_final_status",b"task_final_status","task_output_parameter",b"task_output_parameter"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["task_output_parameter","runtime_value","component_input_parameter","task_final_status"]]: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___TaskInputsSpec.InputParameterSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___TaskInputsSpec.InputParameterSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___TaskInputsSpec.InputArtifactSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___TaskInputsSpec.InputArtifactSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    PARAMETERS_FIELD_NUMBER: builtins.int
    ARTIFACTS_FIELD_NUMBER: builtins.int
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___TaskInputsSpec.InputParameterSpec]:
        """A map of input parameters which are small values, stored by the system and
        can be queriable.
        """
        pass
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___TaskInputsSpec.InputArtifactSpec]:
        """A map of input artifacts."""
        pass
    def __init__(self,
        *,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___TaskInputsSpec.InputParameterSpec]] = ...,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___TaskInputsSpec.InputArtifactSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameters",b"parameters"]) -> None: ...
global___TaskInputsSpec = TaskInputsSpec

class TaskOutputsSpec(google.protobuf.message.Message):
    """The spec of task outputs."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class OutputArtifactSpec(google.protobuf.message.Message):
        """The specification of a task output artifact."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class PropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class CustomPropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        ARTIFACT_TYPE_FIELD_NUMBER: builtins.int
        PROPERTIES_FIELD_NUMBER: builtins.int
        CUSTOM_PROPERTIES_FIELD_NUMBER: builtins.int
        @property
        def artifact_type(self) -> global___ArtifactTypeSchema:
            """The type of the artifact."""
            pass
        @property
        def properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """The properties of the artifact, which are determined either at
            compile-time, or at pipeline submission time through runtime parameters
            """
            pass
        @property
        def custom_properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """The custom properties of the artifact, which are determined either at
            compile-time, or at pipeline submission time through runtime parameters
            """
            pass
        def __init__(self,
            *,
            artifact_type: typing.Optional[global___ArtifactTypeSchema] = ...,
            properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            custom_properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifact_type",b"artifact_type","custom_properties",b"custom_properties","properties",b"properties"]) -> None: ...

    class OutputParameterSpec(google.protobuf.message.Message):
        """Specification for output parameters produced by the task."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TYPE_FIELD_NUMBER: builtins.int
        type: global___PrimitiveType.PrimitiveTypeEnum.ValueType
        """Required field. The type of the output parameter."""

        def __init__(self,
            *,
            type: global___PrimitiveType.PrimitiveTypeEnum.ValueType = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["type",b"type"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___TaskOutputsSpec.OutputParameterSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___TaskOutputsSpec.OutputParameterSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___TaskOutputsSpec.OutputArtifactSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___TaskOutputsSpec.OutputArtifactSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    PARAMETERS_FIELD_NUMBER: builtins.int
    ARTIFACTS_FIELD_NUMBER: builtins.int
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___TaskOutputsSpec.OutputParameterSpec]:
        """A map of output parameters which are small values, stored by the system and
        can be queriable. The output key is used
        by [TaskInputsSpec.InputParameterSpec][] of the downstream task to specify
        the data dependency. The same key will also be used by
        [ExecutorInput.Inputs][] to reference the output parameter.
        """
        pass
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___TaskOutputsSpec.OutputArtifactSpec]:
        """A map of output artifacts. Keyed by output key. The output key is used
        by [TaskInputsSpec.InputArtifactSpec][] of the downstream task to specify
        the data dependency. The same key will also be used by
        [ExecutorInput.Inputs][] to reference the output artifact.
        """
        pass
    def __init__(self,
        *,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___TaskOutputsSpec.OutputParameterSpec]] = ...,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___TaskOutputsSpec.OutputArtifactSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameters",b"parameters"]) -> None: ...
global___TaskOutputsSpec = TaskOutputsSpec

class PrimitiveType(google.protobuf.message.Message):
    """Represent primitive types. The wrapper is needed to give a namespace of
    enum value so we don't need add `PRIMITIVE_TYPE_` prefix of each enum value.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _PrimitiveTypeEnum:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _PrimitiveTypeEnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PrimitiveType._PrimitiveTypeEnum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIMITIVE_TYPE_UNSPECIFIED: PrimitiveType._PrimitiveTypeEnum.ValueType  # 0
        INT: PrimitiveType._PrimitiveTypeEnum.ValueType  # 1
        DOUBLE: PrimitiveType._PrimitiveTypeEnum.ValueType  # 2
        STRING: PrimitiveType._PrimitiveTypeEnum.ValueType  # 3
    class PrimitiveTypeEnum(_PrimitiveTypeEnum, metaclass=_PrimitiveTypeEnumEnumTypeWrapper):
        """The primitive types.
        Deprecated. Use [ParameterType.ParameterTypeEnum][] instead.
        """
        pass

    PRIMITIVE_TYPE_UNSPECIFIED: PrimitiveType.PrimitiveTypeEnum.ValueType  # 0
    INT: PrimitiveType.PrimitiveTypeEnum.ValueType  # 1
    DOUBLE: PrimitiveType.PrimitiveTypeEnum.ValueType  # 2
    STRING: PrimitiveType.PrimitiveTypeEnum.ValueType  # 3

    def __init__(self,
        ) -> None: ...
global___PrimitiveType = PrimitiveType

class ParameterType(google.protobuf.message.Message):
    """Represent parameter types. The wrapper is needed to give a namespace of
    enum value so we don't need add `PARAMETER_TYPE_` prefix of each enum value.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _ParameterTypeEnum:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ParameterTypeEnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ParameterType._ParameterTypeEnum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PARAMETER_TYPE_ENUM_UNSPECIFIED: ParameterType._ParameterTypeEnum.ValueType  # 0
        """Indicates that the parameter type was not specified."""

        NUMBER_DOUBLE: ParameterType._ParameterTypeEnum.ValueType  # 1
        """Indicates that a parameter is a number that is stored in a field of type
        `double`.
        """

        NUMBER_INTEGER: ParameterType._ParameterTypeEnum.ValueType  # 2
        """Indicates that a parameter is an integer stored in the `number_field`,
        which is of type `double`. NUMBER_INTEGER values must be within the range
        of JavaScript safe integers (-(2^53 - 1) to (2^53 - 1)). If you need to
        support integers outside the range of JavaScript safe integers, use the
        `STRING` parameter type to describe your parameter.
        """

        STRING: ParameterType._ParameterTypeEnum.ValueType  # 3
        """Indicates that a parameter is a string."""

        BOOLEAN: ParameterType._ParameterTypeEnum.ValueType  # 4
        """Indicates that a parameters is a boolean value."""

        LIST: ParameterType._ParameterTypeEnum.ValueType  # 5
        """Indicates that a parameter is a list of values. LIST parameters are
        serialized to JSON when passed as an input or output of a pipeline step.
        """

        STRUCT: ParameterType._ParameterTypeEnum.ValueType  # 6
        """Indicates that a parameter is a struct value; structs represent a data
        structure like a Python dictionary or a JSON object. STRUCT parameters
        are serialized to JSON when passed as an input or output of a pipeline
        step.
        """

    class ParameterTypeEnum(_ParameterTypeEnum, metaclass=_ParameterTypeEnumEnumTypeWrapper):
        """The parameter types."""
        pass

    PARAMETER_TYPE_ENUM_UNSPECIFIED: ParameterType.ParameterTypeEnum.ValueType  # 0
    """Indicates that the parameter type was not specified."""

    NUMBER_DOUBLE: ParameterType.ParameterTypeEnum.ValueType  # 1
    """Indicates that a parameter is a number that is stored in a field of type
    `double`.
    """

    NUMBER_INTEGER: ParameterType.ParameterTypeEnum.ValueType  # 2
    """Indicates that a parameter is an integer stored in the `number_field`,
    which is of type `double`. NUMBER_INTEGER values must be within the range
    of JavaScript safe integers (-(2^53 - 1) to (2^53 - 1)). If you need to
    support integers outside the range of JavaScript safe integers, use the
    `STRING` parameter type to describe your parameter.
    """

    STRING: ParameterType.ParameterTypeEnum.ValueType  # 3
    """Indicates that a parameter is a string."""

    BOOLEAN: ParameterType.ParameterTypeEnum.ValueType  # 4
    """Indicates that a parameters is a boolean value."""

    LIST: ParameterType.ParameterTypeEnum.ValueType  # 5
    """Indicates that a parameter is a list of values. LIST parameters are
    serialized to JSON when passed as an input or output of a pipeline step.
    """

    STRUCT: ParameterType.ParameterTypeEnum.ValueType  # 6
    """Indicates that a parameter is a struct value; structs represent a data
    structure like a Python dictionary or a JSON object. STRUCT parameters
    are serialized to JSON when passed as an input or output of a pipeline
    step.
    """


    def __init__(self,
        ) -> None: ...
global___ParameterType = ParameterType

class PipelineTaskSpec(google.protobuf.message.Message):
    """The spec of a pipeline task."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class CachingOptions(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        ENABLE_CACHE_FIELD_NUMBER: builtins.int
        enable_cache: builtins.bool
        """Whether or not to enable cache for this task. Defaults to false."""

        def __init__(self,
            *,
            enable_cache: builtins.bool = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["enable_cache",b"enable_cache"]) -> None: ...

    class TriggerPolicy(google.protobuf.message.Message):
        """Trigger policy defines how the task gets triggered. If a task is not
        triggered, it will run into SKIPPED state.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class _TriggerStrategy:
            ValueType = typing.NewType('ValueType', builtins.int)
            V: typing_extensions.TypeAlias = ValueType
        class _TriggerStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PipelineTaskSpec.TriggerPolicy._TriggerStrategy.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            TRIGGER_STRATEGY_UNSPECIFIED: PipelineTaskSpec.TriggerPolicy._TriggerStrategy.ValueType  # 0
            """Unspecified.  Behave the same as ALL_UPSTREAM_TASKS_SUCCEEDED."""

            ALL_UPSTREAM_TASKS_SUCCEEDED: PipelineTaskSpec.TriggerPolicy._TriggerStrategy.ValueType  # 1
            """Specifies that all upstream tasks are in succeeded state."""

            ALL_UPSTREAM_TASKS_COMPLETED: PipelineTaskSpec.TriggerPolicy._TriggerStrategy.ValueType  # 2
            """Specifies that all upstream tasks are in any final state."""

        class TriggerStrategy(_TriggerStrategy, metaclass=_TriggerStrategyEnumTypeWrapper):
            """An enum defines the trigger strategy of when the task will be ready to be
            triggered.
            ALL_UPSTREAM_TASKS_SUCCEEDED - all upstream tasks in succeeded state.
            ALL_UPSTREAM_TASKS_COMPLETED - all upstream tasks in any final state.
            (Note that CANCELLED is also a final state but job will not trigger new
            tasks when job is in CANCELLING state, so that the task with the trigger
            policy at ALL_UPSTREAM_TASKS_COMPLETED will not start when job
            cancellation is in progress.)
            """
            pass

        TRIGGER_STRATEGY_UNSPECIFIED: PipelineTaskSpec.TriggerPolicy.TriggerStrategy.ValueType  # 0
        """Unspecified.  Behave the same as ALL_UPSTREAM_TASKS_SUCCEEDED."""

        ALL_UPSTREAM_TASKS_SUCCEEDED: PipelineTaskSpec.TriggerPolicy.TriggerStrategy.ValueType  # 1
        """Specifies that all upstream tasks are in succeeded state."""

        ALL_UPSTREAM_TASKS_COMPLETED: PipelineTaskSpec.TriggerPolicy.TriggerStrategy.ValueType  # 2
        """Specifies that all upstream tasks are in any final state."""


        CONDITION_FIELD_NUMBER: builtins.int
        STRATEGY_FIELD_NUMBER: builtins.int
        condition: typing.Text
        """An expression which will be evaluated into a boolean value. True to
        trigger the task to run. The expression follows the language of
        [CEL Spec][https://github.com/google/cel-spec]. It can access the data
        from [ExecutorInput][] message of the task.
        For example:
        - `inputs.artifacts['model'][0].properties['accuracy']*100 > 90`
        - `inputs.parameters['type'] == 'foo' && inputs.parameters['num'] == 1`
        """

        strategy: global___PipelineTaskSpec.TriggerPolicy.TriggerStrategy.ValueType
        """The trigger strategy of this task.  The `strategy` and `condition` are
        in logic "AND", as a task will only be tested for the `condition` when
        the `strategy` is meet.
        Unset or set to default value of TRIGGER_STATEGY_UNDEFINED behaves the
        same as ALL_UPSTREAM_TASKS_SUCCEEDED.
        """

        def __init__(self,
            *,
            condition: typing.Text = ...,
            strategy: global___PipelineTaskSpec.TriggerPolicy.TriggerStrategy.ValueType = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["condition",b"condition","strategy",b"strategy"]) -> None: ...

    class RetryPolicy(google.protobuf.message.Message):
        """User-configured task-level retry."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        MAX_RETRY_COUNT_FIELD_NUMBER: builtins.int
        BACKOFF_DURATION_FIELD_NUMBER: builtins.int
        BACKOFF_FACTOR_FIELD_NUMBER: builtins.int
        BACKOFF_MAX_DURATION_FIELD_NUMBER: builtins.int
        max_retry_count: builtins.int
        """Number of retries before considering a task as failed. Set to 0 or
        unspecified to disallow retry."
        """

        @property
        def backoff_duration(self) -> google.protobuf.duration_pb2.Duration:
            """The time interval between retries. Defaults to zero (an immediate retry)."""
            pass
        backoff_factor: builtins.float
        """The exponential backoff factor applied to backoff_duration. If
        unspecified, will default to 2.
        """

        @property
        def backoff_max_duration(self) -> google.protobuf.duration_pb2.Duration:
            """The maximum duration during which the task will be retried according to
            the backoff strategy. Max allowed is 1 hour - higher value will be capped
            to this limit. If unspecified, will set to 1 hour.
            """
            pass
        def __init__(self,
            *,
            max_retry_count: builtins.int = ...,
            backoff_duration: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
            backoff_factor: builtins.float = ...,
            backoff_max_duration: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["backoff_duration",b"backoff_duration","backoff_max_duration",b"backoff_max_duration"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["backoff_duration",b"backoff_duration","backoff_factor",b"backoff_factor","backoff_max_duration",b"backoff_max_duration","max_retry_count",b"max_retry_count"]) -> None: ...

    class IteratorPolicy(google.protobuf.message.Message):
        """Iterator related settings."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PARALLELISM_LIMIT_FIELD_NUMBER: builtins.int
        parallelism_limit: builtins.int
        """The limit for the number of concurrent sub-tasks spawned by an iterator
        task. The value should be a non-negative integer. A value of 0 represents
        unconstrained parallelism.
        """

        def __init__(self,
            *,
            parallelism_limit: builtins.int = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["parallelism_limit",b"parallelism_limit"]) -> None: ...

    TASK_INFO_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    DEPENDENT_TASKS_FIELD_NUMBER: builtins.int
    CACHING_OPTIONS_FIELD_NUMBER: builtins.int
    COMPONENT_REF_FIELD_NUMBER: builtins.int
    TRIGGER_POLICY_FIELD_NUMBER: builtins.int
    ARTIFACT_ITERATOR_FIELD_NUMBER: builtins.int
    PARAMETER_ITERATOR_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    ITERATOR_POLICY_FIELD_NUMBER: builtins.int
    @property
    def task_info(self) -> global___PipelineTaskInfo:
        """Basic info of a pipeline task."""
        pass
    @property
    def inputs(self) -> global___TaskInputsSpec:
        """Specification for task inputs which contains parameters and artifacts."""
        pass
    @property
    def dependent_tasks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """A list of names of upstream tasks that do not provide input
        artifacts for this task, but nonetheless whose completion this task depends
        on.
        """
        pass
    @property
    def caching_options(self) -> global___PipelineTaskSpec.CachingOptions: ...
    @property
    def component_ref(self) -> global___ComponentRef:
        """Reference to a component.  Use this field to define either a DAG or an
        executor.
        """
        pass
    @property
    def trigger_policy(self) -> global___PipelineTaskSpec.TriggerPolicy:
        """Trigger policy of the task."""
        pass
    @property
    def artifact_iterator(self) -> global___ArtifactIteratorSpec:
        """Iterator to iterate over an artifact input."""
        pass
    @property
    def parameter_iterator(self) -> global___ParameterIteratorSpec:
        """Iterator to iterate over a parameter input."""
        pass
    @property
    def retry_policy(self) -> global___PipelineTaskSpec.RetryPolicy:
        """User-configured task-level retry.
        Applicable only to component tasks.
        """
        pass
    @property
    def iterator_policy(self) -> global___PipelineTaskSpec.IteratorPolicy:
        """Iterator related settings."""
        pass
    def __init__(self,
        *,
        task_info: typing.Optional[global___PipelineTaskInfo] = ...,
        inputs: typing.Optional[global___TaskInputsSpec] = ...,
        dependent_tasks: typing.Optional[typing.Iterable[typing.Text]] = ...,
        caching_options: typing.Optional[global___PipelineTaskSpec.CachingOptions] = ...,
        component_ref: typing.Optional[global___ComponentRef] = ...,
        trigger_policy: typing.Optional[global___PipelineTaskSpec.TriggerPolicy] = ...,
        artifact_iterator: typing.Optional[global___ArtifactIteratorSpec] = ...,
        parameter_iterator: typing.Optional[global___ParameterIteratorSpec] = ...,
        retry_policy: typing.Optional[global___PipelineTaskSpec.RetryPolicy] = ...,
        iterator_policy: typing.Optional[global___PipelineTaskSpec.IteratorPolicy] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["artifact_iterator",b"artifact_iterator","caching_options",b"caching_options","component_ref",b"component_ref","inputs",b"inputs","iterator",b"iterator","iterator_policy",b"iterator_policy","parameter_iterator",b"parameter_iterator","retry_policy",b"retry_policy","task_info",b"task_info","trigger_policy",b"trigger_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_iterator",b"artifact_iterator","caching_options",b"caching_options","component_ref",b"component_ref","dependent_tasks",b"dependent_tasks","inputs",b"inputs","iterator",b"iterator","iterator_policy",b"iterator_policy","parameter_iterator",b"parameter_iterator","retry_policy",b"retry_policy","task_info",b"task_info","trigger_policy",b"trigger_policy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["iterator",b"iterator"]) -> typing.Optional[typing_extensions.Literal["artifact_iterator","parameter_iterator"]]: ...
global___PipelineTaskSpec = PipelineTaskSpec

class ArtifactIteratorSpec(google.protobuf.message.Message):
    """The spec of an artifact iterator. It supports fan-out a workflow from a list
    of artifacts.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ItemsSpec(google.protobuf.message.Message):
        """Specifies the name of the artifact channel which contains the collection of
        items to iterate. The iterator will create a sub-task for each item of
        the collection and pass the item as a new input artifact channel as
        specified by [item_input][].
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        INPUT_ARTIFACT_FIELD_NUMBER: builtins.int
        input_artifact: typing.Text
        """The name of the input artifact."""

        def __init__(self,
            *,
            input_artifact: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["input_artifact",b"input_artifact"]) -> None: ...

    ITEMS_FIELD_NUMBER: builtins.int
    ITEM_INPUT_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> global___ArtifactIteratorSpec.ItemsSpec:
        """The items to iterate."""
        pass
    item_input: typing.Text
    """The name of the input artifact channel which has the artifact item from the
    [items][] collection.
    """

    def __init__(self,
        *,
        items: typing.Optional[global___ArtifactIteratorSpec.ItemsSpec] = ...,
        item_input: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["items",b"items"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["item_input",b"item_input","items",b"items"]) -> None: ...
global___ArtifactIteratorSpec = ArtifactIteratorSpec

class ParameterIteratorSpec(google.protobuf.message.Message):
    """The spec of a parameter iterator. It supports fan-out a workflow from a
    string parameter which contains a JSON array.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ItemsSpec(google.protobuf.message.Message):
        """Specifies the spec to decribe the parameter items to iterate."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        RAW_FIELD_NUMBER: builtins.int
        INPUT_PARAMETER_FIELD_NUMBER: builtins.int
        raw: typing.Text
        """The raw JSON array."""

        input_parameter: typing.Text
        """The name of the input parameter whose value has the items collection.
        The parameter must be in STRING type and its content can be parsed
        as a JSON array.
        """

        def __init__(self,
            *,
            raw: typing.Text = ...,
            input_parameter: typing.Text = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["input_parameter",b"input_parameter","kind",b"kind","raw",b"raw"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["input_parameter",b"input_parameter","kind",b"kind","raw",b"raw"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["raw","input_parameter"]]: ...

    ITEMS_FIELD_NUMBER: builtins.int
    ITEM_INPUT_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> global___ParameterIteratorSpec.ItemsSpec:
        """The items to iterate."""
        pass
    item_input: typing.Text
    """The name of the input parameter which has the item value from the
    [items][] collection.
    """

    def __init__(self,
        *,
        items: typing.Optional[global___ParameterIteratorSpec.ItemsSpec] = ...,
        item_input: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["items",b"items"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["item_input",b"item_input","items",b"items"]) -> None: ...
global___ParameterIteratorSpec = ParameterIteratorSpec

class ComponentRef(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text
    """The name of a component. Refer to the key of the
    [PipelineSpec.components][] map.
    """

    def __init__(self,
        *,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___ComponentRef = ComponentRef

class PipelineInfo(google.protobuf.message.Message):
    """Basic info of a pipeline."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text
    """Required field. The name of the pipeline.
    The name will be used to create or find pipeline context in MLMD.
    """

    def __init__(self,
        *,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___PipelineInfo = PipelineInfo

class ArtifactTypeSchema(google.protobuf.message.Message):
    """The definition of a artifact type in MLMD."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEMA_TITLE_FIELD_NUMBER: builtins.int
    SCHEMA_URI_FIELD_NUMBER: builtins.int
    INSTANCE_SCHEMA_FIELD_NUMBER: builtins.int
    SCHEMA_VERSION_FIELD_NUMBER: builtins.int
    schema_title: typing.Text
    """The name of the type. The format of the title must be:
    `<namespace>.<title>`.
    Examples:
     - `aiplatform.Model`
     - `acme.CustomModel`
    When this field is set, the type must be pre-registered in the MLMD
    store.
    """

    schema_uri: typing.Text
    """Points to a YAML file stored on Google Cloud Storage describing the
    format.
    Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
    [PipelineArtifactTypeSchema.instance_schema][] instead.
    """

    instance_schema: typing.Text
    """Contains a raw YAML string, describing the format of
    the properties of the type.
    """

    schema_version: typing.Text
    """The schema version of the artifact. If the value is not set, it defaults
    to the the latest version in the system.
    """

    def __init__(self,
        *,
        schema_title: typing.Text = ...,
        schema_uri: typing.Text = ...,
        instance_schema: typing.Text = ...,
        schema_version: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["instance_schema",b"instance_schema","kind",b"kind","schema_title",b"schema_title","schema_uri",b"schema_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_schema",b"instance_schema","kind",b"kind","schema_title",b"schema_title","schema_uri",b"schema_uri","schema_version",b"schema_version"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["kind",b"kind"]) -> typing.Optional[typing_extensions.Literal["schema_title","schema_uri","instance_schema"]]: ...
global___ArtifactTypeSchema = ArtifactTypeSchema

class PipelineTaskInfo(google.protobuf.message.Message):
    """The basic info of a task."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text
    """The display name of the task."""

    def __init__(self,
        *,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___PipelineTaskInfo = PipelineTaskInfo

class ValueOrRuntimeParameter(google.protobuf.message.Message):
    """Definition for a value or reference to a runtime parameter. A
    ValueOrRuntimeParameter instance can be either a field value that is
    determined during compilation time, or a runtime parameter which will be
    determined during runtime.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONSTANT_VALUE_FIELD_NUMBER: builtins.int
    RUNTIME_PARAMETER_FIELD_NUMBER: builtins.int
    CONSTANT_FIELD_NUMBER: builtins.int
    @property
    def constant_value(self) -> global___Value:
        """Constant value which is determined in compile time.
        Deprecated. Use [ValueOrRuntimeParameter.constant][] instead.
        """
        pass
    runtime_parameter: typing.Text
    """The runtime parameter refers to the parent component input parameter."""

    @property
    def constant(self) -> google.protobuf.struct_pb2.Value:
        """Constant value which is determined in compile time."""
        pass
    def __init__(self,
        *,
        constant_value: typing.Optional[global___Value] = ...,
        runtime_parameter: typing.Text = ...,
        constant: typing.Optional[google.protobuf.struct_pb2.Value] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["constant",b"constant","constant_value",b"constant_value","runtime_parameter",b"runtime_parameter","value",b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["constant",b"constant","constant_value",b"constant_value","runtime_parameter",b"runtime_parameter","value",b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value",b"value"]) -> typing.Optional[typing_extensions.Literal["constant_value","runtime_parameter","constant"]]: ...
global___ValueOrRuntimeParameter = ValueOrRuntimeParameter

class PipelineDeploymentConfig(google.protobuf.message.Message):
    """The definition of the deployment config of the pipeline. It contains the
    the platform specific executor configs for KFP OSS.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class PipelineContainerSpec(google.protobuf.message.Message):
        """The specification on a container invocation.
        The string fields of the message support string based placeholder contract
        defined in [ExecutorInput](). The output of the container follows the
        contract of [ExecutorOutput]().
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class Lifecycle(google.protobuf.message.Message):
            """The lifecycle hooks of the container.
            Each hook follows the same I/O contract as the main container entrypoint.
            See [ExecutorInput]() and [ExecutorOutput]() for details.
            (-- TODO(b/165323565): add more documentation on caching and lifecycle
            hooks. --)
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            class Exec(google.protobuf.message.Message):
                """The command and args to execute a program."""
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                COMMAND_FIELD_NUMBER: builtins.int
                ARGS_FIELD_NUMBER: builtins.int
                @property
                def command(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
                    """The command of the exec program."""
                    pass
                @property
                def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
                    """The args of the exec program."""
                    pass
                def __init__(self,
                    *,
                    command: typing.Optional[typing.Iterable[typing.Text]] = ...,
                    args: typing.Optional[typing.Iterable[typing.Text]] = ...,
                    ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal["args",b"args","command",b"command"]) -> None: ...

            PRE_CACHE_CHECK_FIELD_NUMBER: builtins.int
            @property
            def pre_cache_check(self) -> global___PipelineDeploymentConfig.PipelineContainerSpec.Lifecycle.Exec:
                """This hook is invoked before caching check. It can change the properties
                of the execution and output artifacts before they are used to compute
                the cache key. The updated metadata will be passed into the main
                container entrypoint.
                """
                pass
            def __init__(self,
                *,
                pre_cache_check: typing.Optional[global___PipelineDeploymentConfig.PipelineContainerSpec.Lifecycle.Exec] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["pre_cache_check",b"pre_cache_check"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["pre_cache_check",b"pre_cache_check"]) -> None: ...

        class ResourceSpec(google.protobuf.message.Message):
            """The specification on the resource requirements of a container execution.
            This can include specification of vCPU, memory requirements, as well as
            accelerator types and counts.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            class AcceleratorConfig(google.protobuf.message.Message):
                """The specification on the accelerators being attached to this container."""
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                TYPE_FIELD_NUMBER: builtins.int
                COUNT_FIELD_NUMBER: builtins.int
                type: typing.Text
                """The type of accelerators."""

                count: builtins.int
                """The number of accelerators."""

                def __init__(self,
                    *,
                    type: typing.Text = ...,
                    count: builtins.int = ...,
                    ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal["count",b"count","type",b"type"]) -> None: ...

            CPU_LIMIT_FIELD_NUMBER: builtins.int
            MEMORY_LIMIT_FIELD_NUMBER: builtins.int
            ACCELERATOR_FIELD_NUMBER: builtins.int
            cpu_limit: builtins.float
            """The limit of the number of vCPU cores. This container execution needs
            at most cpu_limit vCPU to run.
            """

            memory_limit: builtins.float
            """The memory limit in GB. This container execution needs at most
            memory_limit RAM to run.
            """

            @property
            def accelerator(self) -> global___PipelineDeploymentConfig.PipelineContainerSpec.ResourceSpec.AcceleratorConfig: ...
            def __init__(self,
                *,
                cpu_limit: builtins.float = ...,
                memory_limit: builtins.float = ...,
                accelerator: typing.Optional[global___PipelineDeploymentConfig.PipelineContainerSpec.ResourceSpec.AcceleratorConfig] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["accelerator",b"accelerator"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["accelerator",b"accelerator","cpu_limit",b"cpu_limit","memory_limit",b"memory_limit"]) -> None: ...

        class EnvVar(google.protobuf.message.Message):
            """Environment variables to be passed to the container.
            Represents an environment variable present in a container.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            NAME_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            name: typing.Text
            """Name of the environment variable. Must be a valid C identifier. It can
            be composed of characters such as uppercase, lowercase characters,
            underscore, digits, but the leading character should be either a
            letter or an underscore.
            """

            value: typing.Text
            """Variables that reference a $(VAR_NAME) are expanded using the previous
            defined environment variables in the container and any environment
            variables defined by the platform runtime that executes this pipeline.
            If a variable cannot be resolved, the reference in the input string
            will be unchanged. The $(VAR_NAME) syntax can be escaped with a double
            $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
            regardless of whether the variable exists or not.
            """

            def __init__(self,
                *,
                name: typing.Text = ...,
                value: typing.Text = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["name",b"name","value",b"value"]) -> None: ...

        IMAGE_FIELD_NUMBER: builtins.int
        COMMAND_FIELD_NUMBER: builtins.int
        ARGS_FIELD_NUMBER: builtins.int
        LIFECYCLE_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        ENV_FIELD_NUMBER: builtins.int
        image: typing.Text
        """The image uri of the container."""

        @property
        def command(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
            """The main entrypoint commands of the container to run. If not provided,
            fallback to use the entry point command defined in the container image.
            """
            pass
        @property
        def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
            """The arguments to pass into the main entrypoint of the container."""
            pass
        @property
        def lifecycle(self) -> global___PipelineDeploymentConfig.PipelineContainerSpec.Lifecycle:
            """The lifecycle hooks of the container executor."""
            pass
        @property
        def resources(self) -> global___PipelineDeploymentConfig.PipelineContainerSpec.ResourceSpec: ...
        @property
        def env(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineDeploymentConfig.PipelineContainerSpec.EnvVar]:
            """Environment variables to be passed to the container."""
            pass
        def __init__(self,
            *,
            image: typing.Text = ...,
            command: typing.Optional[typing.Iterable[typing.Text]] = ...,
            args: typing.Optional[typing.Iterable[typing.Text]] = ...,
            lifecycle: typing.Optional[global___PipelineDeploymentConfig.PipelineContainerSpec.Lifecycle] = ...,
            resources: typing.Optional[global___PipelineDeploymentConfig.PipelineContainerSpec.ResourceSpec] = ...,
            env: typing.Optional[typing.Iterable[global___PipelineDeploymentConfig.PipelineContainerSpec.EnvVar]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["lifecycle",b"lifecycle","resources",b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["args",b"args","command",b"command","env",b"env","image",b"image","lifecycle",b"lifecycle","resources",b"resources"]) -> None: ...

    class ImporterSpec(google.protobuf.message.Message):
        """The specification to import or reimport a new artifact to the pipeline."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class PropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class CustomPropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ValueOrRuntimeParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ValueOrRuntimeParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        ARTIFACT_URI_FIELD_NUMBER: builtins.int
        TYPE_SCHEMA_FIELD_NUMBER: builtins.int
        PROPERTIES_FIELD_NUMBER: builtins.int
        CUSTOM_PROPERTIES_FIELD_NUMBER: builtins.int
        METADATA_FIELD_NUMBER: builtins.int
        REIMPORT_FIELD_NUMBER: builtins.int
        @property
        def artifact_uri(self) -> global___ValueOrRuntimeParameter:
            """The URI of the artifact."""
            pass
        @property
        def type_schema(self) -> global___ArtifactTypeSchema:
            """The type of the artifact."""
            pass
        @property
        def properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """The properties of the artifact.
            Deprecated. Use [ImporterSpec.metadata][] instead.
            """
            pass
        @property
        def custom_properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ValueOrRuntimeParameter]:
            """The custom properties of the artifact.
            Deprecated. Use [ImporterSpec.metadata][] instead.
            """
            pass
        @property
        def metadata(self) -> google.protobuf.struct_pb2.Struct:
            """Properties of the Artifact."""
            pass
        reimport: builtins.bool
        """Whether or not import an artifact regardless it has been imported before."""

        def __init__(self,
            *,
            artifact_uri: typing.Optional[global___ValueOrRuntimeParameter] = ...,
            type_schema: typing.Optional[global___ArtifactTypeSchema] = ...,
            properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            custom_properties: typing.Optional[typing.Mapping[typing.Text, global___ValueOrRuntimeParameter]] = ...,
            metadata: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
            reimport: builtins.bool = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["artifact_uri",b"artifact_uri","metadata",b"metadata","type_schema",b"type_schema"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifact_uri",b"artifact_uri","custom_properties",b"custom_properties","metadata",b"metadata","properties",b"properties","reimport",b"reimport","type_schema",b"type_schema"]) -> None: ...

    class ResolverSpec(google.protobuf.message.Message):
        """ResolverSpec resolves artifacts from historical metadata and returns them
        to the pipeline as output artifacts of the resolver task. The downstream
        tasks can consume them as their input artifacts.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class ArtifactQuerySpec(google.protobuf.message.Message):
            """The query to fetch artifacts."""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FILTER_FIELD_NUMBER: builtins.int
            LIMIT_FIELD_NUMBER: builtins.int
            filter: typing.Text
            """The filter of the artifact query. The supported syntax are:
            - `in_context("<context name>")`
            - `artifact_type="<artifact type name>"`
            - `uri="<uri>"`
            - `state=<state>`
            - `name="value"`
            - `AND` to combine two conditions and returns when both are true.
            If no `in_context` filter is set, the query will be scoped to the
            the current pipeline context.
            """

            limit: builtins.int
            """The maximum number of the artifacts to be returned from the
            query. If not defined, the default limit is `1`.
            """

            def __init__(self,
                *,
                filter: typing.Text = ...,
                limit: builtins.int = ...,
                ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["filter",b"filter","limit",b"limit"]) -> None: ...

        class OutputArtifactQueriesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___PipelineDeploymentConfig.ResolverSpec.ArtifactQuerySpec: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___PipelineDeploymentConfig.ResolverSpec.ArtifactQuerySpec] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        OUTPUT_ARTIFACT_QUERIES_FIELD_NUMBER: builtins.int
        @property
        def output_artifact_queries(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___PipelineDeploymentConfig.ResolverSpec.ArtifactQuerySpec]:
            """A list of resolver output definitions. The
            key of the map must be exactly the same as
            the keys in the [PipelineTaskOutputsSpec.artifacts][] map.
            At least one output must be defined.
            """
            pass
        def __init__(self,
            *,
            output_artifact_queries: typing.Optional[typing.Mapping[typing.Text, global___PipelineDeploymentConfig.ResolverSpec.ArtifactQuerySpec]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["output_artifact_queries",b"output_artifact_queries"]) -> None: ...

    class AIPlatformCustomJobSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        CUSTOM_JOB_FIELD_NUMBER: builtins.int
        @property
        def custom_job(self) -> google.protobuf.struct_pb2.Struct:
            """API Specification for invoking a Google Cloud AI Platform CustomJob.
            The fields must match the field names and structures of CustomJob
            defined in
            https://cloud.google.com/ai-platform-unified/docs/reference/rest/v1beta1/projects.locations.customJobs.
            The field types must be either the same, or be a string containing the
            string based placeholder contract defined in [ExecutorInput](). The
            placeholders will be replaced with the actual value during the runtime
            before the job is launched.
            """
            pass
        def __init__(self,
            *,
            custom_job: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["custom_job",b"custom_job"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["custom_job",b"custom_job"]) -> None: ...

    class ExecutorSpec(google.protobuf.message.Message):
        """The specification of the executor."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        CONTAINER_FIELD_NUMBER: builtins.int
        IMPORTER_FIELD_NUMBER: builtins.int
        RESOLVER_FIELD_NUMBER: builtins.int
        CUSTOM_JOB_FIELD_NUMBER: builtins.int
        @property
        def container(self) -> global___PipelineDeploymentConfig.PipelineContainerSpec:
            """Starts a container."""
            pass
        @property
        def importer(self) -> global___PipelineDeploymentConfig.ImporterSpec:
            """Import an artifact."""
            pass
        @property
        def resolver(self) -> global___PipelineDeploymentConfig.ResolverSpec:
            """Resolves an existing artifact."""
            pass
        @property
        def custom_job(self) -> global___PipelineDeploymentConfig.AIPlatformCustomJobSpec:
            """Starts a Google Cloud AI Platform CustomJob."""
            pass
        def __init__(self,
            *,
            container: typing.Optional[global___PipelineDeploymentConfig.PipelineContainerSpec] = ...,
            importer: typing.Optional[global___PipelineDeploymentConfig.ImporterSpec] = ...,
            resolver: typing.Optional[global___PipelineDeploymentConfig.ResolverSpec] = ...,
            custom_job: typing.Optional[global___PipelineDeploymentConfig.AIPlatformCustomJobSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["container",b"container","custom_job",b"custom_job","importer",b"importer","resolver",b"resolver","spec",b"spec"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["container",b"container","custom_job",b"custom_job","importer",b"importer","resolver",b"resolver","spec",b"spec"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["spec",b"spec"]) -> typing.Optional[typing_extensions.Literal["container","importer","resolver","custom_job"]]: ...

    class ExecutorsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___PipelineDeploymentConfig.ExecutorSpec: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___PipelineDeploymentConfig.ExecutorSpec] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    EXECUTORS_FIELD_NUMBER: builtins.int
    @property
    def executors(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___PipelineDeploymentConfig.ExecutorSpec]:
        """Map from executor label to executor spec."""
        pass
    def __init__(self,
        *,
        executors: typing.Optional[typing.Mapping[typing.Text, global___PipelineDeploymentConfig.ExecutorSpec]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["executors",b"executors"]) -> None: ...
global___PipelineDeploymentConfig = PipelineDeploymentConfig

class Value(google.protobuf.message.Message):
    """Value is the value of the field."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INT_VALUE_FIELD_NUMBER: builtins.int
    DOUBLE_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    int_value: builtins.int
    """An integer value"""

    double_value: builtins.float
    """A double value"""

    string_value: typing.Text
    """A string value"""

    def __init__(self,
        *,
        int_value: builtins.int = ...,
        double_value: builtins.float = ...,
        string_value: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["double_value",b"double_value","int_value",b"int_value","string_value",b"string_value","value",b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["double_value",b"double_value","int_value",b"int_value","string_value",b"string_value","value",b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value",b"value"]) -> typing.Optional[typing_extensions.Literal["int_value","double_value","string_value"]]: ...
global___Value = Value

class RuntimeArtifact(google.protobuf.message.Message):
    """The definition of a runtime artifact."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Value: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Value] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class CustomPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Value: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Value] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    URI_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    CUSTOM_PROPERTIES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: typing.Text
    """The name of an artifact."""

    @property
    def type(self) -> global___ArtifactTypeSchema:
        """The type of the artifact."""
        pass
    uri: typing.Text
    """The URI of the artifact."""

    @property
    def properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Value]:
        """The properties of the artifact.
        Deprecated. Use [RuntimeArtifact.metadata][] instead.
        """
        pass
    @property
    def custom_properties(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Value]:
        """The custom properties of the artifact.
        Deprecated. Use [RuntimeArtifact.metadata][] instead.
        """
        pass
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Properties of the Artifact."""
        pass
    def __init__(self,
        *,
        name: typing.Text = ...,
        type: typing.Optional[global___ArtifactTypeSchema] = ...,
        uri: typing.Text = ...,
        properties: typing.Optional[typing.Mapping[typing.Text, global___Value]] = ...,
        custom_properties: typing.Optional[typing.Mapping[typing.Text, global___Value]] = ...,
        metadata: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata",b"metadata","type",b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom_properties",b"custom_properties","metadata",b"metadata","name",b"name","properties",b"properties","type",b"type","uri",b"uri"]) -> None: ...
global___RuntimeArtifact = RuntimeArtifact

class ArtifactList(google.protobuf.message.Message):
    """Message that represents a list of artifacts."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ARTIFACTS_FIELD_NUMBER: builtins.int
    @property
    def artifacts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuntimeArtifact]:
        """A list of artifacts."""
        pass
    def __init__(self,
        *,
        artifacts: typing.Optional[typing.Iterable[global___RuntimeArtifact]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts"]) -> None: ...
global___ArtifactList = ArtifactList

class ExecutorInput(google.protobuf.message.Message):
    """The input of an executor, which includes all the data that
    can be passed into the executor spec by a string based placeholder.

    The string based placeholder uses a JSON path to reference to the data
    in the [ExecutionInput]().

    `{{$}}`: prints the full [ExecutorInput]() as a JSON string.
    `{{$.inputs.artifacts['<name>'].uri}}`: prints the URI of an input
    artifact.
    `{{$.inputs.artifacts['<name>'].properties['<property name>']}}`: prints
    the
      property of an input artifact.
    `{{$.inputs.parameters['<name>']}}`: prints the value of an input
    parameter.
    `{{$.outputs.artifacts['<name>'].uri}}: prints the URI of an output artifact.
    `{{$.outputs.artifacts['<name>'].properties['<property name>']}}`: prints the
      property of an output artifact.
    `{{$.outputs.parameters['<name>'].output_file}}`: prints a file path which
    points to a file and container can write to it to return the value of the
    parameter..
    `{{$.outputs.output_file}}`: prints a file path of the output metadata file
    which is used to send output metadata from executor to orchestrator. The
    contract of the output metadata is [ExecutorOutput](). When both parameter
    output file and executor output metadata files are set by the container, the
    output metadata file will have higher precedence to set output parameters.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class Inputs(google.protobuf.message.Message):
        """The runtime inputs data of the execution."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___Value: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___Value] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class ArtifactsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ArtifactList: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ArtifactList] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class ParameterValuesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> google.protobuf.struct_pb2.Value: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[google.protobuf.struct_pb2.Value] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        PARAMETERS_FIELD_NUMBER: builtins.int
        ARTIFACTS_FIELD_NUMBER: builtins.int
        PARAMETER_VALUES_FIELD_NUMBER: builtins.int
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Value]:
            """Input parameters of the execution.
            Deprecated. Use [ExecutorInput.Inputs.parameter_values][] instead.
            """
            pass
        @property
        def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ArtifactList]:
            """Input artifacts of the execution."""
            pass
        @property
        def parameter_values(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, google.protobuf.struct_pb2.Value]:
            """Input parameters of the execution."""
            pass
        def __init__(self,
            *,
            parameters: typing.Optional[typing.Mapping[typing.Text, global___Value]] = ...,
            artifacts: typing.Optional[typing.Mapping[typing.Text, global___ArtifactList]] = ...,
            parameter_values: typing.Optional[typing.Mapping[typing.Text, google.protobuf.struct_pb2.Value]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameter_values",b"parameter_values","parameters",b"parameters"]) -> None: ...

    class OutputParameter(google.protobuf.message.Message):
        """The runtime output parameter."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        OUTPUT_FILE_FIELD_NUMBER: builtins.int
        output_file: typing.Text
        """The file path which is used by the executor to pass the parameter value
        to the system.
        """

        def __init__(self,
            *,
            output_file: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["output_file",b"output_file"]) -> None: ...

    class Outputs(google.protobuf.message.Message):
        """The runtime outputs data of the execution."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ExecutorInput.OutputParameter: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ExecutorInput.OutputParameter] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        class ArtifactsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: typing.Text
            @property
            def value(self) -> global___ArtifactList: ...
            def __init__(self,
                *,
                key: typing.Text = ...,
                value: typing.Optional[global___ArtifactList] = ...,
                ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

        PARAMETERS_FIELD_NUMBER: builtins.int
        ARTIFACTS_FIELD_NUMBER: builtins.int
        OUTPUT_FILE_FIELD_NUMBER: builtins.int
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ExecutorInput.OutputParameter]:
            """The runtime output parameters."""
            pass
        @property
        def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ArtifactList]:
            """The runtime output artifacts."""
            pass
        output_file: typing.Text
        """The file path of the full output metadata JSON. The schema of the output
        file is [ExecutorOutput][].

        When the full output metadata file is set by the container, the output
        parameter files will be ignored.
        """

        def __init__(self,
            *,
            parameters: typing.Optional[typing.Mapping[typing.Text, global___ExecutorInput.OutputParameter]] = ...,
            artifacts: typing.Optional[typing.Mapping[typing.Text, global___ArtifactList]] = ...,
            output_file: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","output_file",b"output_file","parameters",b"parameters"]) -> None: ...

    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def inputs(self) -> global___ExecutorInput.Inputs:
        """The runtime input artifacts of the task invocation."""
        pass
    @property
    def outputs(self) -> global___ExecutorInput.Outputs:
        """The runtime output artifacts of the task invocation."""
        pass
    def __init__(self,
        *,
        inputs: typing.Optional[global___ExecutorInput.Inputs] = ...,
        outputs: typing.Optional[global___ExecutorInput.Outputs] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs",b"inputs","outputs",b"outputs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs",b"inputs","outputs",b"outputs"]) -> None: ...
global___ExecutorInput = ExecutorInput

class ExecutorOutput(google.protobuf.message.Message):
    """The schema of the output metadata of an execution. It will be used to parse
    the output metadata file.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___Value: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___Value] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ArtifactsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___ArtifactList: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___ArtifactList] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    class ParameterValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[google.protobuf.struct_pb2.Value] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    PARAMETERS_FIELD_NUMBER: builtins.int
    ARTIFACTS_FIELD_NUMBER: builtins.int
    PARAMETER_VALUES_FIELD_NUMBER: builtins.int
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Value]:
        """The values for output parameters.
        Deprecated. Use [ExecutorOutput.parameter_values][] instead.
        """
        pass
    @property
    def artifacts(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___ArtifactList]:
        """The updated metadata for output artifact."""
        pass
    @property
    def parameter_values(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, google.protobuf.struct_pb2.Value]:
        """The values for output parameters."""
        pass
    def __init__(self,
        *,
        parameters: typing.Optional[typing.Mapping[typing.Text, global___Value]] = ...,
        artifacts: typing.Optional[typing.Mapping[typing.Text, global___ArtifactList]] = ...,
        parameter_values: typing.Optional[typing.Mapping[typing.Text, google.protobuf.struct_pb2.Value]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts",b"artifacts","parameter_values",b"parameter_values","parameters",b"parameters"]) -> None: ...
global___ExecutorOutput = ExecutorOutput

class PipelineTaskFinalStatus(google.protobuf.message.Message):
    """The final status of a task. The structure will be passed to input parameter
    of kind `task_final_status`.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    PIPELINE_JOB_UUID_FIELD_NUMBER: builtins.int
    PIPELINE_JOB_NAME_FIELD_NUMBER: builtins.int
    PIPELINE_JOB_RESOURCE_NAME_FIELD_NUMBER: builtins.int
    PIPELINE_TASK_NAME_FIELD_NUMBER: builtins.int
    state: typing.Text
    """The final state of the task.
    The value is the string version of [PipelineStateEnum.PipelineTaskState][]
    """

    @property
    def error(self) -> google.rpc.status_pb2.Status:
        """The error of the task."""
        pass
    pipeline_job_uuid: builtins.int
    """The pipeline job unique id."""

    pipeline_job_name: typing.Text
    """The pipeline job name from the [PipelineJob.name][]."""

    pipeline_job_resource_name: typing.Text
    """The pipeline job resource name, in the format of
    `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
    """

    pipeline_task_name: typing.Text
    """The pipeline task that produces this status."""

    def __init__(self,
        *,
        state: typing.Text = ...,
        error: typing.Optional[google.rpc.status_pb2.Status] = ...,
        pipeline_job_uuid: builtins.int = ...,
        pipeline_job_name: typing.Text = ...,
        pipeline_job_resource_name: typing.Text = ...,
        pipeline_task_name: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error",b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error",b"error","pipeline_job_name",b"pipeline_job_name","pipeline_job_resource_name",b"pipeline_job_resource_name","pipeline_job_uuid",b"pipeline_job_uuid","pipeline_task_name",b"pipeline_task_name","state",b"state"]) -> None: ...
global___PipelineTaskFinalStatus = PipelineTaskFinalStatus

class PipelineStateEnum(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _PipelineTaskState:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _PipelineTaskStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PipelineStateEnum._PipelineTaskState.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TASK_STATE_UNSPECIFIED: PipelineStateEnum._PipelineTaskState.ValueType  # 0
        PENDING: PipelineStateEnum._PipelineTaskState.ValueType  # 1
        RUNNING_DRIVER: PipelineStateEnum._PipelineTaskState.ValueType  # 2
        DRIVER_SUCCEEDED: PipelineStateEnum._PipelineTaskState.ValueType  # 3
        RUNNING_EXECUTOR: PipelineStateEnum._PipelineTaskState.ValueType  # 4
        SUCCEEDED: PipelineStateEnum._PipelineTaskState.ValueType  # 5
        CANCEL_PENDING: PipelineStateEnum._PipelineTaskState.ValueType  # 6
        CANCELLING: PipelineStateEnum._PipelineTaskState.ValueType  # 7
        CANCELLED: PipelineStateEnum._PipelineTaskState.ValueType  # 8
        FAILED: PipelineStateEnum._PipelineTaskState.ValueType  # 9
        SKIPPED: PipelineStateEnum._PipelineTaskState.ValueType  # 10
        """Indicates that the task is skipped to run due to a cache hit."""

        QUEUED: PipelineStateEnum._PipelineTaskState.ValueType  # 11
        """Indicates that the task was just populated to the DB but not ready to
        be scheduled.  Once job handler determined the task being ready to
        be scheduled, the task state will change to PENDING.  The state
        transition is depicted below:
         * QUEUED(not ready to run) --> PENDING(ready to run) --> RUNNING
        """

        NOT_TRIGGERED: PipelineStateEnum._PipelineTaskState.ValueType  # 12
        """Indicates that the task is not triggered based on the
        [PipelineTaskSpec.TriggerPolicy.condition][] config.
        """

        UNSCHEDULABLE: PipelineStateEnum._PipelineTaskState.ValueType  # 13
        """Indicates that the tasks will no longer be schedulable.  Usually a task
        was set to this state because its all upstream tasks are in final state
        but the [PipelineTaskSpec.TriggerPolicy.strategy][] disallows the task to
        be triggered.
        The difference between `NOT_TRIGGERED` is that `UNSCHEDULABLE` must met
        [PipelineTaskSpec.TriggerPolicy.strategy][], but must not met the
        [PipelineTaskSpec.TriggerPolicy.condition][].
        """

    class PipelineTaskState(_PipelineTaskState, metaclass=_PipelineTaskStateEnumTypeWrapper):
        pass

    TASK_STATE_UNSPECIFIED: PipelineStateEnum.PipelineTaskState.ValueType  # 0
    PENDING: PipelineStateEnum.PipelineTaskState.ValueType  # 1
    RUNNING_DRIVER: PipelineStateEnum.PipelineTaskState.ValueType  # 2
    DRIVER_SUCCEEDED: PipelineStateEnum.PipelineTaskState.ValueType  # 3
    RUNNING_EXECUTOR: PipelineStateEnum.PipelineTaskState.ValueType  # 4
    SUCCEEDED: PipelineStateEnum.PipelineTaskState.ValueType  # 5
    CANCEL_PENDING: PipelineStateEnum.PipelineTaskState.ValueType  # 6
    CANCELLING: PipelineStateEnum.PipelineTaskState.ValueType  # 7
    CANCELLED: PipelineStateEnum.PipelineTaskState.ValueType  # 8
    FAILED: PipelineStateEnum.PipelineTaskState.ValueType  # 9
    SKIPPED: PipelineStateEnum.PipelineTaskState.ValueType  # 10
    """Indicates that the task is skipped to run due to a cache hit."""

    QUEUED: PipelineStateEnum.PipelineTaskState.ValueType  # 11
    """Indicates that the task was just populated to the DB but not ready to
    be scheduled.  Once job handler determined the task being ready to
    be scheduled, the task state will change to PENDING.  The state
    transition is depicted below:
     * QUEUED(not ready to run) --> PENDING(ready to run) --> RUNNING
    """

    NOT_TRIGGERED: PipelineStateEnum.PipelineTaskState.ValueType  # 12
    """Indicates that the task is not triggered based on the
    [PipelineTaskSpec.TriggerPolicy.condition][] config.
    """

    UNSCHEDULABLE: PipelineStateEnum.PipelineTaskState.ValueType  # 13
    """Indicates that the tasks will no longer be schedulable.  Usually a task
    was set to this state because its all upstream tasks are in final state
    but the [PipelineTaskSpec.TriggerPolicy.strategy][] disallows the task to
    be triggered.
    The difference between `NOT_TRIGGERED` is that `UNSCHEDULABLE` must met
    [PipelineTaskSpec.TriggerPolicy.strategy][], but must not met the
    [PipelineTaskSpec.TriggerPolicy.condition][].
    """


    def __init__(self,
        ) -> None: ...
global___PipelineStateEnum = PipelineStateEnum
