"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Predicate(google.protobuf.message.Message):
    """Predicate captures individual conditions that must be true for a resource
    being filtered.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Op:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _OpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Predicate._Op.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Predicate._Op.ValueType  # 0
        EQUALS: Predicate._Op.ValueType  # 1
        """Operators on scalar values. Only applies to one of |int_value|,
        |long_value|, |string_value| or |timestamp_value|.
        """

        NOT_EQUALS: Predicate._Op.ValueType  # 2
        GREATER_THAN: Predicate._Op.ValueType  # 3
        GREATER_THAN_EQUALS: Predicate._Op.ValueType  # 5
        LESS_THAN: Predicate._Op.ValueType  # 6
        LESS_THAN_EQUALS: Predicate._Op.ValueType  # 7
        IN: Predicate._Op.ValueType  # 8
        """Checks if the value is a member of a given array, which should be one of
        |int_values|, |long_values| or |string_values|.
        """

        IS_SUBSTRING: Predicate._Op.ValueType  # 9
        """Checks if the value contains |string_value| as a substring match. Only
        applies to |string_value|.
        """

    class Op(_Op, metaclass=_OpEnumTypeWrapper):
        """Op is the operation to apply."""
        pass

    UNKNOWN: Predicate.Op.ValueType  # 0
    EQUALS: Predicate.Op.ValueType  # 1
    """Operators on scalar values. Only applies to one of |int_value|,
    |long_value|, |string_value| or |timestamp_value|.
    """

    NOT_EQUALS: Predicate.Op.ValueType  # 2
    GREATER_THAN: Predicate.Op.ValueType  # 3
    GREATER_THAN_EQUALS: Predicate.Op.ValueType  # 5
    LESS_THAN: Predicate.Op.ValueType  # 6
    LESS_THAN_EQUALS: Predicate.Op.ValueType  # 7
    IN: Predicate.Op.ValueType  # 8
    """Checks if the value is a member of a given array, which should be one of
    |int_values|, |long_values| or |string_values|.
    """

    IS_SUBSTRING: Predicate.Op.ValueType  # 9
    """Checks if the value contains |string_value| as a substring match. Only
    applies to |string_value|.
    """


    OP_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    LONG_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    TIMESTAMP_VALUE_FIELD_NUMBER: builtins.int
    INT_VALUES_FIELD_NUMBER: builtins.int
    LONG_VALUES_FIELD_NUMBER: builtins.int
    STRING_VALUES_FIELD_NUMBER: builtins.int
    op: global___Predicate.Op.ValueType
    key: typing.Text
    int_value: builtins.int
    long_value: builtins.int
    string_value: typing.Text
    @property
    def timestamp_value(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp values will be converted to Unix time (seconds since the epoch)
        prior to being used in a filtering operation.
        """
        pass
    @property
    def int_values(self) -> global___IntValues:
        """Array values below are only meant to be used by the IN operator."""
        pass
    @property
    def long_values(self) -> global___LongValues: ...
    @property
    def string_values(self) -> global___StringValues: ...
    def __init__(self,
        *,
        op: global___Predicate.Op.ValueType = ...,
        key: typing.Text = ...,
        int_value: builtins.int = ...,
        long_value: builtins.int = ...,
        string_value: typing.Text = ...,
        timestamp_value: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        int_values: typing.Optional[global___IntValues] = ...,
        long_values: typing.Optional[global___LongValues] = ...,
        string_values: typing.Optional[global___StringValues] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["int_value",b"int_value","int_values",b"int_values","long_value",b"long_value","long_values",b"long_values","string_value",b"string_value","string_values",b"string_values","timestamp_value",b"timestamp_value","value",b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["int_value",b"int_value","int_values",b"int_values","key",b"key","long_value",b"long_value","long_values",b"long_values","op",b"op","string_value",b"string_value","string_values",b"string_values","timestamp_value",b"timestamp_value","value",b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value",b"value"]) -> typing.Optional[typing_extensions.Literal["int_value","long_value","string_value","timestamp_value","int_values","long_values","string_values"]]: ...
global___Predicate = Predicate

class IntValues(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        values: typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values",b"values"]) -> None: ...
global___IntValues = IntValues

class StringValues(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        values: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values",b"values"]) -> None: ...
global___StringValues = StringValues

class LongValues(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        values: typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values",b"values"]) -> None: ...
global___LongValues = LongValues

class Filter(google.protobuf.message.Message):
    """Filter is used to filter resources returned from a ListXXX request.

    Example filters:
    1) Filter runs with status = 'Running'
    filter {
      predicate {
        key: "status"
        op: EQUALS
        string_value: "Running"
      }
    }

    2) Filter runs that succeeded since Dec 1, 2018
    filter {
      predicate {
        key: "status"
        op: EQUALS
        string_value: "Succeeded"
      }
      predicate {
        key: "created_at"
        op: GREATER_THAN
        timestamp_value {
          seconds: 1543651200
        }
      }
    }

    3) Filter runs with one of labels 'label_1' or 'label_2'

    filter {
      predicate {
        key: "label"
        op: IN
        string_values {
          value: 'label_1'
          value: 'label_2'
        }
      }
    }
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PREDICATES_FIELD_NUMBER: builtins.int
    @property
    def predicates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Predicate]:
        """All predicates are AND-ed when this filter is applied."""
        pass
    def __init__(self,
        *,
        predicates: typing.Optional[typing.Iterable[global___Predicate]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["predicates",b"predicates"]) -> None: ...
global___Filter = Filter
