# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Device(Model):
    """Device.

    :param device_id: The unique identifier of the device.
    :type device_id: str
    :param generation_id: The IoT Hub-generated, case-sensitive string up to
     128 characters long. This value is used to distinguish devices with the
     same deviceId, when they have been deleted and re-created.
    :type generation_id: str
    :param etag: The string representing a weak ETag for the device identity,
     as per RFC7232.
    :type etag: str
    :param connection_state: The state of the device. Possible values include:
     'Disconnected', 'Connected'
    :type connection_state: str or ~protocol.models.enum
    :param status: The status of the device. If the status disabled, a device
     cannot connect to the service. Possible values include: 'enabled',
     'disabled'
    :type status: str or ~protocol.models.enum
    :param status_reason: The 128 character-long string that stores the reason
     for the device identity status. All UTF-8 characters are allowed.
    :type status_reason: str
    :param connection_state_updated_time: The date and time the connection
     state was last updated.
    :type connection_state_updated_time: datetime
    :param status_updated_time: The date and time when the status field was
     last updated.
    :type status_updated_time: datetime
    :param last_activity_time: The date and last time the device last
     connected, received, or sent a message.
    :type last_activity_time: datetime
    :param cloud_to_device_message_count: The number of cloud-to-device
     messages currently queued to be sent to the device.
    :type cloud_to_device_message_count: int
    :param authentication: The authentication mechanism used by the device.
    :type authentication: ~protocol.models.AuthenticationMechanism
    :param capabilities: The set of capabilities of the device. For example,
     if this device is an edge device or not.
    :type capabilities: ~protocol.models.DeviceCapabilities
    :param device_scope: The scope of the device. Auto generated and immutable
     for edge devices and modifiable in leaf devices to create child/parent
     relationship.
    :type device_scope: str
    :param parent_scopes: The scopes of the upper level edge devices if
     applicable. Only available for edge devices.
    :type parent_scopes: list[str]
    """

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "generation_id": {"key": "generationId", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_reason": {"key": "statusReason", "type": "str"},
        "connection_state_updated_time": {"key": "connectionStateUpdatedTime", "type": "iso-8601"},
        "status_updated_time": {"key": "statusUpdatedTime", "type": "iso-8601"},
        "last_activity_time": {"key": "lastActivityTime", "type": "iso-8601"},
        "cloud_to_device_message_count": {"key": "cloudToDeviceMessageCount", "type": "int"},
        "authentication": {"key": "authentication", "type": "AuthenticationMechanism"},
        "capabilities": {"key": "capabilities", "type": "DeviceCapabilities"},
        "device_scope": {"key": "deviceScope", "type": "str"},
        "parent_scopes": {"key": "parentScopes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        device_id: str = None,
        generation_id: str = None,
        etag: str = None,
        connection_state=None,
        status=None,
        status_reason: str = None,
        connection_state_updated_time=None,
        status_updated_time=None,
        last_activity_time=None,
        cloud_to_device_message_count: int = None,
        authentication=None,
        capabilities=None,
        device_scope: str = None,
        parent_scopes=None,
        **kwargs
    ) -> None:
        super(Device, self).__init__(**kwargs)
        self.device_id = device_id
        self.generation_id = generation_id
        self.etag = etag
        self.connection_state = connection_state
        self.status = status
        self.status_reason = status_reason
        self.connection_state_updated_time = connection_state_updated_time
        self.status_updated_time = status_updated_time
        self.last_activity_time = last_activity_time
        self.cloud_to_device_message_count = cloud_to_device_message_count
        self.authentication = authentication
        self.capabilities = capabilities
        self.device_scope = device_scope
        self.parent_scopes = parent_scopes
