# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class QueryOperations(object):
    """QueryOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: The API version to use for the request. Constant value: "2020-09-30".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config
        self.api_version = "2020-09-30"

    def get_twins(
        self,
        query_specification,
        x_ms_continuation=None,
        x_ms_max_item_count=None,
        custom_headers=None,
        raw=False,
        **operation_config
    ):
        """Query an IoT Hub to retrieve information regarding device twins using a
        SQL-like language. See
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        for more information. Pagination is supported. This returns information
        about device twins only.

        :param query_specification: The query string. See
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
         for more information.
        :type query_specification: ~protocol.models.QuerySpecification
        :param x_ms_continuation: The continuation token used to get the next
         page of results.
        :type x_ms_continuation: str
        :param x_ms_max_item_count: The maximum number of items returned per
         page. The service may use a different value if the value specified is
         not acceptable.
        :type x_ms_max_item_count: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~protocol.models.Twin] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_twins.metadata["url"]

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)
        if x_ms_continuation is not None:
            header_parameters["x-ms-continuation"] = self._serialize.header(
                "x_ms_continuation", x_ms_continuation, "str"
            )
        if x_ms_max_item_count is not None:
            header_parameters["x-ms-max-item-count"] = self._serialize.header(
                "x_ms_max_item_count", x_ms_max_item_count, "str"
            )

        # Construct body
        body_content = self._serialize.body(query_specification, "QuerySpecification")

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize("[Twin]", response)
            header_dict = {"x-ms-item-type": "str", "x-ms-continuation": "str"}

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    get_twins.metadata = {"url": "/devices/query"}
