"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedKubernetesCluster = exports.ManagedKubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ManagedKubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosManagedKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ManagedKubernetesCluster`
 */
class ManagedKubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ManagedKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosManagedKubernetesCluster = new cs_generated_1.RosManagedKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess ? props.endpointPublicAccess : false,
            workerPeriod: props.workerPeriod ? props.workerPeriod : 1,
            workerPeriodUnit: props.workerPeriodUnit ? props.workerPeriodUnit : 'Month',
            addons: props.addons,
            workerSystemDiskCategory: props.workerSystemDiskCategory ? props.workerSystemDiskCategory : 'cloud_efficiency',
            workerSystemDiskSize: props.workerSystemDiskSize ? props.workerSystemDiskSize : 120,
            name: props.name,
            taint: props.taint,
            cloudMonitorFlags: props.cloudMonitorFlags ? props.cloudMonitorFlags : false,
            serviceCidr: props.serviceCidr ? props.serviceCidr : '172.19.0.0/20',
            workerAutoRenew: props.workerAutoRenew ? props.workerAutoRenew : true,
            proxyMode: props.proxyMode ? props.proxyMode : 'iptables',
            tags: ros.tagFactory(props.tags),
            disableRollback: props.disableRollback ? props.disableRollback : true,
            workerInstanceTypes: props.workerInstanceTypes,
            loginPassword: props.loginPassword,
            kubernetesVersion: props.kubernetesVersion ? props.kubernetesVersion : '1.14.8-aliyun.1',
            containerCidr: props.containerCidr ? props.containerCidr : '172.16.0.0/16',
            keyPair: props.keyPair,
            workerInstanceChargeType: props.workerInstanceChargeType ? props.workerInstanceChargeType : 'PostPaid',
            vSwitchIds: props.vSwitchIds,
            workerDataDisks: props.workerDataDisks,
            securityGroupId: props.securityGroupId,
            timeoutMins: props.timeoutMins ? props.timeoutMins : 60,
            workerDataDisk: props.workerDataDisk ? props.workerDataDisk : false,
            vpcId: props.vpcId,
            numOfNodes: props.numOfNodes ? props.numOfNodes : 3,
            workerAutoRenewPeriod: props.workerAutoRenewPeriod ? props.workerAutoRenewPeriod : 1,
            snatEntry: props.snatEntry ? props.snatEntry : true,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosManagedKubernetesCluster;
        this.attrClusterId = rosManagedKubernetesCluster.attrClusterId;
        this.attrTaskId = rosManagedKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosManagedKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.ManagedKubernetesCluster = ManagedKubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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