# Copyright 2019 The PyGlove Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Package pyglove.

This package is the facade of the public PyGlove library, which includes modules
for symbolic type definition and manipulation, symbolic typing and constraints,
symbolic value generation and etc. It only have a handful of dependencies such
as enum, six, yaml.
"""

# NOTE(daiyip): We disable bad-import-order to preserve the relation of
# imported symbols
# pylint: disable=g-bad-import-order
# pylint: disable=unused-import
# pylint: disable=reimported
# pylint: disable=g-import-not-at-top

from pyglove.core import *
from pyglove import generators

evolution = generators.evolution
early_stopping = generators.early_stopping

 # Placeholder for Google-internal imports.

# pylint: enable=g-import-not-at-top
# pylint: enable=reimported
# pylint: enable=unused-import
# pylint: enable=g-bad-import-order

__version__ = "0.2.0"
