"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'can create a receipt rule set'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            receiptRuleSetName: 'MyRuleSet',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::SES::ReceiptRuleSet', {
            RuleSetName: 'MyRuleSet'
        }));
        test.done();
    },
    'can create a receipt rule set with drop spam'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            dropSpam: true
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::SES::ReceiptRule', {
            Rule: {
                Actions: [
                    {
                        LambdaAction: {
                            FunctionArn: {
                                'Fn::GetAtt': [
                                    'SingletonLambda224e77f9a32e4b4dac32983477abba164533EA15',
                                    'Arn'
                                ]
                            },
                            InvocationType: 'RequestResponse'
                        }
                    }
                ],
                Enabled: true,
                ScanEnabled: true
            }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Lambda::Function'));
        test.done();
    },
    'import receipt rule set'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const receiptRuleSet = lib_1.ReceiptRuleSet.fromReceiptRuleSetName(stack, 'ImportedRuleSet', 'MyRuleSet');
        receiptRuleSet.addRule('MyRule');
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "ImportedRuleSetMyRule53EE2F7F": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": true
                        },
                        "RuleSetName": "MyRuleSet"
                    }
                }
            },
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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