import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudRunDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#location CloudRunDomainMapping#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#name CloudRunDomainMapping#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#project CloudRunDomainMapping#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#metadata CloudRunDomainMapping#metadata}
     *
     * @stability stable
     */
    readonly metadata: CloudRunDomainMappingMetadata;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#spec CloudRunDomainMapping#spec}
     *
     * @stability stable
     */
    readonly spec: CloudRunDomainMappingSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#timeouts CloudRunDomainMapping#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudRunDomainMappingTimeouts;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatusConditions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatusResourceRecords extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get rrdata(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get conditions(): any;
    /**
     * @stability stable
     */
    get mappedRouteName(): string;
    /**
     * @stability stable
     */
    get observedGeneration(): number;
    /**
     * @stability stable
     */
    get resourceRecords(): any;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#annotations CloudRunDomainMapping#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#labels CloudRunDomainMapping#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#namespace CloudRunDomainMapping#namespace}
     *
     * @stability stable
     */
    readonly namespace: string;
}
export declare function cloudRunDomainMappingMetadataToTerraform(struct?: CloudRunDomainMappingMetadataOutputReference | CloudRunDomainMappingMetadata): any;
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudRunDomainMappingMetadata | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudRunDomainMappingMetadata | undefined);
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingSpec {
    /**
     * The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#certificate_mode CloudRunDomainMapping#certificate_mode}
     *
     * @stability stable
     */
    readonly certificateMode?: string;
    /**
     * If set, the mapping will override any mapping set before this spec was set.
     *
     * It is recommended that the user leaves this empty to receive an error
     * warning about a potential conflict and only set it once the respective UI
     * has given such a warning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#force_override CloudRunDomainMapping#force_override}
     *
     * @stability stable
     */
    readonly forceOverride?: boolean | cdktf.IResolvable;
    /**
     * The name of the Cloud Run Service that this DomainMapping applies to. The route must exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#route_name CloudRunDomainMapping#route_name}
     *
     * @stability stable
     */
    readonly routeName: string;
}
export declare function cloudRunDomainMappingSpecToTerraform(struct?: CloudRunDomainMappingSpecOutputReference | CloudRunDomainMappingSpec): any;
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudRunDomainMappingSpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudRunDomainMappingSpec | undefined);
    private _certificateMode?;
    /**
     * @stability stable
     */
    get certificateMode(): string;
    /**
     * @stability stable
     */
    set certificateMode(value: string);
    /**
     * @stability stable
     */
    resetCertificateMode(): void;
    /**
     * @stability stable
     */
    get certificateModeInput(): string | undefined;
    private _forceOverride?;
    /**
     * @stability stable
     */
    get forceOverride(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceOverride(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceOverride(): void;
    /**
     * @stability stable
     */
    get forceOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _routeName?;
    /**
     * @stability stable
     */
    get routeName(): string;
    /**
     * @stability stable
     */
    set routeName(value: string);
    /**
     * @stability stable
     */
    get routeNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudRunDomainMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#create CloudRunDomainMapping#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#delete CloudRunDomainMapping#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function cloudRunDomainMappingTimeoutsToTerraform(struct?: CloudRunDomainMappingTimeoutsOutputReference | CloudRunDomainMappingTimeouts): any;
/**
 * @stability stable
 */
export declare class CloudRunDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudRunDomainMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudRunDomainMappingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping google_cloud_run_domain_mapping}.
 *
 * @stability stable
 */
export declare class CloudRunDomainMapping extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping google_cloud_run_domain_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudRunDomainMappingConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): CloudRunDomainMappingStatus;
    private _metadata;
    /**
     * @stability stable
     */
    get metadata(): CloudRunDomainMappingMetadataOutputReference;
    /**
     * @stability stable
     */
    putMetadata(value: CloudRunDomainMappingMetadata): void;
    /**
     * @stability stable
     */
    get metadataInput(): CloudRunDomainMappingMetadata | undefined;
    private _spec;
    /**
     * @stability stable
     */
    get spec(): CloudRunDomainMappingSpecOutputReference;
    /**
     * @stability stable
     */
    putSpec(value: CloudRunDomainMappingSpec): void;
    /**
     * @stability stable
     */
    get specInput(): CloudRunDomainMappingSpec | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudRunDomainMappingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudRunDomainMappingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudRunDomainMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
