import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudiotRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Activate or deactivate HTTP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#http_config CloudiotRegistry#http_config}
     *
     * @stability stable
     */
    readonly httpConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The default logging verbosity for activity from devices in this registry.
     *
     * Specifies which events should be written to logs. For
     * example, if the LogLevel is ERROR, only events that terminate in
     * errors will be logged. LogLevel is inclusive; enabling INFO logging
     * will also enable ERROR logging. Default value: "NONE" Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#log_level CloudiotRegistry#log_level}
     *
     * @stability stable
     */
    readonly logLevel?: string;
    /**
     * Activate or deactivate MQTT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#mqtt_config CloudiotRegistry#mqtt_config}
     *
     * @stability stable
     */
    readonly mqttConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A unique name for the resource, required by device registry.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#name CloudiotRegistry#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#project CloudiotRegistry#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region in which the created registry should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#region CloudiotRegistry#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * A PubSub topic to publish device state updates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#state_notification_config CloudiotRegistry#state_notification_config}
     *
     * @stability stable
     */
    readonly stateNotificationConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#credentials CloudiotRegistry#credentials}
     *
     * @stability stable
     */
    readonly credentials?: CloudiotRegistryCredentials[];
    /**
     * event_notification_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#event_notification_configs CloudiotRegistry#event_notification_configs}
     *
     * @stability stable
     */
    readonly eventNotificationConfigs?: CloudiotRegistryEventNotificationConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#timeouts CloudiotRegistry#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudiotRegistryTimeouts;
}
/**
 * @stability stable
 */
export interface CloudiotRegistryCredentials {
    /**
     * A public key certificate format and data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#public_key_certificate CloudiotRegistry#public_key_certificate}
     *
     * @stability stable
     */
    readonly publicKeyCertificate: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function cloudiotRegistryCredentialsToTerraform(struct?: CloudiotRegistryCredentials): any;
/**
 * @stability stable
 */
export interface CloudiotRegistryEventNotificationConfigs {
    /**
     * PubSub topic name to publish device events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#pubsub_topic_name CloudiotRegistry#pubsub_topic_name}
     *
     * @stability stable
     */
    readonly pubsubTopicName: string;
    /**
     * If the subfolder name matches this string exactly, this configuration will be used.
     *
     * The string must not include the
     * leading '/' character. If empty, all strings are matched. Empty
     * value can only be used for the last 'event_notification_configs'
     * item.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#subfolder_matches CloudiotRegistry#subfolder_matches}
     *
     * @stability stable
     */
    readonly subfolderMatches?: string;
}
export declare function cloudiotRegistryEventNotificationConfigsToTerraform(struct?: CloudiotRegistryEventNotificationConfigs): any;
/**
 * @stability stable
 */
export interface CloudiotRegistryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#create CloudiotRegistry#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#delete CloudiotRegistry#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#update CloudiotRegistry#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudiotRegistryTimeoutsToTerraform(struct?: CloudiotRegistryTimeoutsOutputReference | CloudiotRegistryTimeouts): any;
/**
 * @stability stable
 */
export declare class CloudiotRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudiotRegistryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudiotRegistryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry google_cloudiot_registry}.
 *
 * @stability stable
 */
export declare class CloudiotRegistry extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry google_cloudiot_registry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudiotRegistryConfig);
    private _httpConfig?;
    /**
     * @stability stable
     */
    get httpConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpConfig(): void;
    /**
     * @stability stable
     */
    get httpConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logLevel?;
    /**
     * @stability stable
     */
    get logLevel(): string;
    /**
     * @stability stable
     */
    set logLevel(value: string);
    /**
     * @stability stable
     */
    resetLogLevel(): void;
    /**
     * @stability stable
     */
    get logLevelInput(): string | undefined;
    private _mqttConfig?;
    /**
     * @stability stable
     */
    get mqttConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mqttConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMqttConfig(): void;
    /**
     * @stability stable
     */
    get mqttConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _stateNotificationConfig?;
    /**
     * @stability stable
     */
    get stateNotificationConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stateNotificationConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStateNotificationConfig(): void;
    /**
     * @stability stable
     */
    get stateNotificationConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): CloudiotRegistryCredentials[];
    /**
     * @stability stable
     */
    set credentials(value: CloudiotRegistryCredentials[]);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): CloudiotRegistryCredentials[] | undefined;
    private _eventNotificationConfigs?;
    /**
     * @stability stable
     */
    get eventNotificationConfigs(): CloudiotRegistryEventNotificationConfigs[];
    /**
     * @stability stable
     */
    set eventNotificationConfigs(value: CloudiotRegistryEventNotificationConfigs[]);
    /**
     * @stability stable
     */
    resetEventNotificationConfigs(): void;
    /**
     * @stability stable
     */
    get eventNotificationConfigsInput(): CloudiotRegistryEventNotificationConfigs[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudiotRegistryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudiotRegistryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudiotRegistryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
