import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetHttpsProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#description ComputeTargetHttpsProxy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#name ComputeTargetHttpsProxy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#project ComputeTargetHttpsProxy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#proxy_bind ComputeTargetHttpsProxy#proxy_bind}
     *
     * @stability stable
     */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
     * Specifies the QUIC override policy for this resource.
     *
     * This determines
     * whether the load balancer will attempt to negotiate QUIC with clients
     * or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
     * specified, uses the QUIC policy with no user overrides, which is
     * equivalent to DISABLE. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#quic_override ComputeTargetHttpsProxy#quic_override}
     *
     * @stability stable
     */
    readonly quicOverride?: string;
    /**
     * A list of SslCertificate resources that are used to authenticate connections between users and the load balancer.
     *
     * At least one SSL
     * certificate must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#ssl_certificates ComputeTargetHttpsProxy#ssl_certificates}
     *
     * @stability stable
     */
    readonly sslCertificates: string[];
    /**
     * A reference to the SslPolicy resource that will be associated with the TargetHttpsProxy resource.
     *
     * If not set, the TargetHttpsProxy
     * resource will not have any SSL policy configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#ssl_policy ComputeTargetHttpsProxy#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: string;
    /**
     * A reference to the UrlMap resource that defines the mapping from URL to the BackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#url_map ComputeTargetHttpsProxy#url_map}
     *
     * @stability stable
     */
    readonly urlMap: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#timeouts ComputeTargetHttpsProxy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetHttpsProxyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetHttpsProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#create ComputeTargetHttpsProxy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#delete ComputeTargetHttpsProxy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy#update ComputeTargetHttpsProxy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeTargetHttpsProxyTimeoutsToTerraform(struct?: ComputeTargetHttpsProxyTimeoutsOutputReference | ComputeTargetHttpsProxyTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeTargetHttpsProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeTargetHttpsProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeTargetHttpsProxyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy google_compute_target_https_proxy}.
 *
 * @stability stable
 */
export declare class ComputeTargetHttpsProxy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_https_proxy google_compute_target_https_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetHttpsProxyConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _proxyBind?;
    /**
     * @stability stable
     */
    get proxyBind(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set proxyBind(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProxyBind(): void;
    /**
     * @stability stable
     */
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get proxyId(): number;
    private _quicOverride?;
    /**
     * @stability stable
     */
    get quicOverride(): string;
    /**
     * @stability stable
     */
    set quicOverride(value: string);
    /**
     * @stability stable
     */
    resetQuicOverride(): void;
    /**
     * @stability stable
     */
    get quicOverrideInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sslCertificates?;
    /**
     * @stability stable
     */
    get sslCertificates(): string[];
    /**
     * @stability stable
     */
    set sslCertificates(value: string[]);
    /**
     * @stability stable
     */
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    /**
     * @stability stable
     */
    get sslPolicy(): string;
    /**
     * @stability stable
     */
    set sslPolicy(value: string);
    /**
     * @stability stable
     */
    resetSslPolicy(): void;
    /**
     * @stability stable
     */
    get sslPolicyInput(): string | undefined;
    private _urlMap?;
    /**
     * @stability stable
     */
    get urlMap(): string;
    /**
     * @stability stable
     */
    set urlMap(value: string);
    /**
     * @stability stable
     */
    get urlMapInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetHttpsProxyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeTargetHttpsProxyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetHttpsProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
