import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetSslProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A reference to the BackendService resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#backend_service ComputeTargetSslProxy#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#description ComputeTargetSslProxy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#name ComputeTargetSslProxy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#project ComputeTargetSslProxy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#proxy_header ComputeTargetSslProxy#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * A list of SslCertificate resources that are used to authenticate connections between users and the load balancer.
     *
     * At least one
     * SSL certificate must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#ssl_certificates ComputeTargetSslProxy#ssl_certificates}
     *
     * @stability stable
     */
    readonly sslCertificates: string[];
    /**
     * A reference to the SslPolicy resource that will be associated with the TargetSslProxy resource.
     *
     * If not set, the TargetSslProxy
     * resource will not have any SSL policy configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#ssl_policy ComputeTargetSslProxy#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#timeouts ComputeTargetSslProxy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetSslProxyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetSslProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#create ComputeTargetSslProxy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#delete ComputeTargetSslProxy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#update ComputeTargetSslProxy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeTargetSslProxyTimeoutsToTerraform(struct?: ComputeTargetSslProxyTimeoutsOutputReference | ComputeTargetSslProxyTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeTargetSslProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeTargetSslProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeTargetSslProxyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy google_compute_target_ssl_proxy}.
 *
 * @stability stable
 */
export declare class ComputeTargetSslProxy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy google_compute_target_ssl_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetSslProxyConfig);
    private _backendService?;
    /**
     * @stability stable
     */
    get backendService(): string;
    /**
     * @stability stable
     */
    set backendService(value: string);
    /**
     * @stability stable
     */
    get backendServiceInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxyId(): number;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sslCertificates?;
    /**
     * @stability stable
     */
    get sslCertificates(): string[];
    /**
     * @stability stable
     */
    set sslCertificates(value: string[]);
    /**
     * @stability stable
     */
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    /**
     * @stability stable
     */
    get sslPolicy(): string;
    /**
     * @stability stable
     */
    set sslPolicy(value: string);
    /**
     * @stability stable
     */
    resetSslPolicy(): void;
    /**
     * @stability stable
     */
    get sslPolicyInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetSslProxyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeTargetSslProxyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetSslProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
