import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleBillingAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account#billing_account DataGoogleBillingAccount#billing_account}.
     *
     * @stability stable
     */
    readonly billingAccount?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account#display_name DataGoogleBillingAccount#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account#open DataGoogleBillingAccount#open}.
     *
     * @stability stable
     */
    readonly open?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/billing_account google_billing_account}.
 *
 * @stability stable
 */
export declare class DataGoogleBillingAccount extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/billing_account google_billing_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleBillingAccountConfig);
    private _billingAccount?;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    resetBillingAccount(): void;
    /**
     * @stability stable
     */
    get billingAccountInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _open?;
    /**
     * @stability stable
     */
    get open(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set open(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOpen(): void;
    /**
     * @stability stable
     */
    get openInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get projectIds(): string[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
