import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#name DataGoogleComputeGlobalForwardingRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The project this resource belongs in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule#project DataGoogleComputeGlobalForwardingRule#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeGlobalForwardingRuleMetadataFilters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get filterLabels(): any;
    /**
     * @stability stable
     */
    get filterMatchCriteria(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeGlobalForwardingRule extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_global_forwarding_rule google_compute_global_forwarding_rule} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeGlobalForwardingRuleConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get ipProtocol(): string;
    /**
     * @stability stable
     */
    get ipVersion(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    metadataFilters(index: string): DataGoogleComputeGlobalForwardingRuleMetadataFilters;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    get portRange(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
