import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeRegionInstanceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group#name DataGoogleComputeRegionInstanceGroup#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group#project DataGoogleComputeRegionInstanceGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group#region DataGoogleComputeRegionInstanceGroup#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group#self_link DataGoogleComputeRegionInstanceGroup#self_link}.
     *
     * @stability stable
     */
    readonly selfLink?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeRegionInstanceGroupInstancesNamedPorts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get port(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeRegionInstanceGroupInstances extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    get namedPorts(): any;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group google_compute_region_instance_group}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeRegionInstanceGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group google_compute_region_instance_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionInstanceGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    instances(index: string): DataGoogleComputeRegionInstanceGroupInstances;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _selfLink?;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    set selfLink(value: string);
    /**
     * @stability stable
     */
    resetSelfLink(): void;
    /**
     * @stability stable
     */
    get selfLinkInput(): string | undefined;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
