import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleContainerEngineVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions#location DataGoogleContainerEngineVersions#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions#project DataGoogleContainerEngineVersions#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions#version_prefix DataGoogleContainerEngineVersions#version_prefix}.
     *
     * @stability stable
     */
    readonly versionPrefix?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions google_container_engine_versions}.
 *
 * @stability stable
 */
export declare class DataGoogleContainerEngineVersions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions google_container_engine_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerEngineVersionsConfig);
    /**
     * @stability stable
     */
    get defaultClusterVersion(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get latestMasterVersion(): string;
    /**
     * @stability stable
     */
    get latestNodeVersion(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    releaseChannelDefaultVersion(key: string): string;
    /**
     * @stability stable
     */
    get validMasterVersions(): string[];
    /**
     * @stability stable
     */
    get validNodeVersions(): string[];
    private _versionPrefix?;
    /**
     * @stability stable
     */
    get versionPrefix(): string;
    /**
     * @stability stable
     */
    set versionPrefix(value: string);
    /**
     * @stability stable
     */
    resetVersionPrefix(): void;
    /**
     * @stability stable
     */
    get versionPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
