import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleDnsKeysConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#managed_zone DataGoogleDnsKeys#managed_zone}.
     *
     * @stability stable
     */
    readonly managedZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#project DataGoogleDnsKeys#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleDnsKeysKeySigningKeysDigests extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get digest(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleDnsKeysKeySigningKeys extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get digests(): any;
    /**
     * @stability stable
     */
    get dsRecord(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isActive(): any;
    /**
     * @stability stable
     */
    get keyLength(): number;
    /**
     * @stability stable
     */
    get keyTag(): number;
    /**
     * @stability stable
     */
    get publicKey(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleDnsKeysZoneSigningKeysDigests extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get digest(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleDnsKeysZoneSigningKeys extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get digests(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isActive(): any;
    /**
     * @stability stable
     */
    get keyLength(): number;
    /**
     * @stability stable
     */
    get keyTag(): number;
    /**
     * @stability stable
     */
    get publicKey(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys}.
 *
 * @stability stable
 */
export declare class DataGoogleDnsKeys extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleDnsKeysConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    keySigningKeys(index: string): DataGoogleDnsKeysKeySigningKeys;
    private _managedZone?;
    /**
     * @stability stable
     */
    get managedZone(): string;
    /**
     * @stability stable
     */
    set managedZone(value: string);
    /**
     * @stability stable
     */
    get managedZoneInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    zoneSigningKeys(index: string): DataGoogleDnsKeysZoneSigningKeys;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
