import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleSecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#project DataGoogleSecretManagerSecret#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#secret_id DataGoogleSecretManagerSecret#secret_id}
     *
     * @stability stable
     */
    readonly secretId: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicas extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customerManagedEncryption(): any;
    /**
     * @stability stable
     */
    get location(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretReplicationUserManaged extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get replicas(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretReplication extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get automatic(): any;
    /**
     * @stability stable
     */
    get userManaged(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretRotation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get nextRotationTime(): string;
    /**
     * @stability stable
     */
    get rotationPeriod(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecretTopics extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret}.
 *
 * @stability stable
 */
export declare class DataGoogleSecretManagerSecret extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleSecretManagerSecretConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    replication(index: string): DataGoogleSecretManagerSecretReplication;
    /**
     * @stability stable
     */
    rotation(index: string): DataGoogleSecretManagerSecretRotation;
    private _secretId?;
    /**
     * @stability stable
     */
    get secretId(): string;
    /**
     * @stability stable
     */
    set secretId(value: string);
    /**
     * @stability stable
     */
    get secretIdInput(): string | undefined;
    /**
     * @stability stable
     */
    topics(index: string): DataGoogleSecretManagerSecretTopics;
    /**
     * @stability stable
     */
    get ttl(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
