import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#description DataLossPreventionJobTrigger#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#display_name DataLossPreventionJobTrigger#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the trigger, either in the format 'projects/{{project}}' or 'projects/{{project}}/locations/{{location}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#parent DataLossPreventionJobTrigger#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#status DataLossPreventionJobTrigger#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * inspect_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#inspect_job DataLossPreventionJobTrigger#inspect_job}
     *
     * @stability stable
     */
    readonly inspectJob?: DataLossPreventionJobTriggerInspectJob;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timeouts DataLossPreventionJobTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionJobTriggerTimeouts;
    /**
     * triggers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#triggers DataLossPreventionJobTrigger#triggers}
     *
     * @stability stable
     */
    readonly triggers: DataLossPreventionJobTriggerTriggers[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable {
    /**
     * Dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#dataset_id DataLossPreventionJobTrigger#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * Name of the table.
     *
     * If is not set a new one will be generated for you with the following format:
     * 'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_id DataLossPreventionJobTrigger#table_id}
     *
     * @stability stable
     */
    readonly tableId?: string;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    resetTableId(): void;
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig {
    /**
     * Schema used for writing the findings for Inspect jobs.
     *
     * This field is only used for
     * Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
     * object. If appending to an existing table, any columns from the predefined schema
     * that are missing will be added. No columns in the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or an (existing)
     * table with no schema, and no changes will be made to an existing table that has a schema.
     * Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#output_schema DataLossPreventionJobTrigger#output_schema}
     *
     * @stability stable
     */
    readonly outputSchema?: string;
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table DataLossPreventionJobTrigger#table}
     *
     * @stability stable
     */
    readonly table: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined);
    private _outputSchema?;
    /**
     * @stability stable
     */
    get outputSchema(): string;
    /**
     * @stability stable
     */
    set outputSchema(value: string);
    /**
     * @stability stable
     */
    resetOutputSchema(): void;
    /**
     * @stability stable
     */
    get outputSchemaInput(): string | undefined;
    private _table;
    /**
     * @stability stable
     */
    get table(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference;
    /**
     * @stability stable
     */
    putTable(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): void;
    /**
     * @stability stable
     */
    get tableInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindings {
    /**
     * output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#output_config DataLossPreventionJobTrigger#output_config}
     *
     * @stability stable
     */
    readonly outputConfig: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindings): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined);
    private _outputConfig;
    /**
     * @stability stable
     */
    get outputConfig(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference;
    /**
     * @stability stable
     */
    putOutputConfig(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): void;
    /**
     * @stability stable
     */
    get outputConfigInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobActions {
    /**
     * save_findings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#save_findings DataLossPreventionJobTrigger#save_findings}
     *
     * @stability stable
     */
    readonly saveFindings: DataLossPreventionJobTriggerInspectJobActionsSaveFindings;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActions): any;
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#dataset_id DataLossPreventionJobTrigger#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_id DataLossPreventionJobTrigger#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions {
    /**
     * table_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_reference DataLossPreventionJobTrigger#table_reference}
     *
     * @stability stable
     */
    readonly tableReference: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined);
    private _tableReference;
    /**
     * @stability stable
     */
    get tableReference(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference;
    /**
     * @stability stable
     */
    putTableReference(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): void;
    /**
     * @stability stable
     */
    get tableReferenceInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet {
    /**
     * The name of a Cloud Storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bucket_name DataLossPreventionJobTrigger#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * A list of regular expressions matching file paths to exclude.
     *
     * All files in the bucket that match at
     * least one of these regular expressions will be excluded from the scan.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#exclude_regex DataLossPreventionJobTrigger#exclude_regex}
     *
     * @stability stable
     */
    readonly excludeRegex?: string[];
    /**
     * A list of regular expressions matching file paths to include.
     *
     * All files in the bucket
     * that match at least one of these regular expressions will be included in the set of files,
     * except for those that also match an item in excludeRegex. Leaving this field empty will
     * match all files by default (this is equivalent to including .* in the list)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#include_regex DataLossPreventionJobTrigger#include_regex}
     *
     * @stability stable
     */
    readonly includeRegex?: string[];
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    private _excludeRegex?;
    /**
     * @stability stable
     */
    get excludeRegex(): string[];
    /**
     * @stability stable
     */
    set excludeRegex(value: string[]);
    /**
     * @stability stable
     */
    resetExcludeRegex(): void;
    /**
     * @stability stable
     */
    get excludeRegexInput(): string[] | undefined;
    private _includeRegex?;
    /**
     * @stability stable
     */
    get includeRegex(): string[];
    /**
     * @stability stable
     */
    set includeRegex(value: string[]);
    /**
     * @stability stable
     */
    resetIncludeRegex(): void;
    /**
     * @stability stable
     */
    get includeRegexInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet {
    /**
     * The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
     * non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
     * equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#url DataLossPreventionJobTrigger#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * regex_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#regex_file_set DataLossPreventionJobTrigger#regex_file_set}
     *
     * @stability stable
     */
    readonly regexFileSet?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _regexFileSet;
    /**
     * @stability stable
     */
    get regexFileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference;
    /**
     * @stability stable
     */
    putRegexFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): void;
    /**
     * @stability stable
     */
    resetRegexFileSet(): void;
    /**
     * @stability stable
     */
    get regexFileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions {
    /**
     * Max number of bytes to scan from a file.
     *
     * If a scanned file's size is bigger than this value
     * then the rest of the bytes are omitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bytes_limit_per_file DataLossPreventionJobTrigger#bytes_limit_per_file}
     *
     * @stability stable
     */
    readonly bytesLimitPerFile?: number;
    /**
     * Max percentage of bytes to scan from a file.
     *
     * The rest are omitted. The number of bytes scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bytes_limit_per_file_percent DataLossPreventionJobTrigger#bytes_limit_per_file_percent}
     *
     * @stability stable
     */
    readonly bytesLimitPerFilePercent?: number;
    /**
     * List of file type groups to include in the scan.
     *
     * If empty, all files are scanned and available data
     * format processors are applied. In addition, the binary content of the selected files is always scanned as well.
     * Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#file_types DataLossPreventionJobTrigger#file_types}
     *
     * @stability stable
     */
    readonly fileTypes?: string[];
    /**
     * Limits the number of files to scan to this percentage of the input FileSet.
     *
     * Number of files scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#files_limit_percent DataLossPreventionJobTrigger#files_limit_percent}
     *
     * @stability stable
     */
    readonly filesLimitPercent?: number;
    /**
     * How to sample bytes if not all bytes are scanned.
     *
     * Meaningful only when used in conjunction with bytesLimitPerFile.
     * If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#sample_method DataLossPreventionJobTrigger#sample_method}
     *
     * @stability stable
     */
    readonly sampleMethod?: string;
    /**
     * file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#file_set DataLossPreventionJobTrigger#file_set}
     *
     * @stability stable
     */
    readonly fileSet: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined);
    private _bytesLimitPerFile?;
    /**
     * @stability stable
     */
    get bytesLimitPerFile(): number;
    /**
     * @stability stable
     */
    set bytesLimitPerFile(value: number);
    /**
     * @stability stable
     */
    resetBytesLimitPerFile(): void;
    /**
     * @stability stable
     */
    get bytesLimitPerFileInput(): number | undefined;
    private _bytesLimitPerFilePercent?;
    /**
     * @stability stable
     */
    get bytesLimitPerFilePercent(): number;
    /**
     * @stability stable
     */
    set bytesLimitPerFilePercent(value: number);
    /**
     * @stability stable
     */
    resetBytesLimitPerFilePercent(): void;
    /**
     * @stability stable
     */
    get bytesLimitPerFilePercentInput(): number | undefined;
    private _fileTypes?;
    /**
     * @stability stable
     */
    get fileTypes(): string[];
    /**
     * @stability stable
     */
    set fileTypes(value: string[]);
    /**
     * @stability stable
     */
    resetFileTypes(): void;
    /**
     * @stability stable
     */
    get fileTypesInput(): string[] | undefined;
    private _filesLimitPercent?;
    /**
     * @stability stable
     */
    get filesLimitPercent(): number;
    /**
     * @stability stable
     */
    set filesLimitPercent(value: number);
    /**
     * @stability stable
     */
    resetFilesLimitPercent(): void;
    /**
     * @stability stable
     */
    get filesLimitPercentInput(): number | undefined;
    private _sampleMethod?;
    /**
     * @stability stable
     */
    get sampleMethod(): string;
    /**
     * @stability stable
     */
    set sampleMethod(value: string);
    /**
     * @stability stable
     */
    resetSampleMethod(): void;
    /**
     * @stability stable
     */
    get sampleMethodInput(): string | undefined;
    private _fileSet;
    /**
     * @stability stable
     */
    get fileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference;
    /**
     * @stability stable
     */
    putFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): void;
    /**
     * @stability stable
     */
    get fileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind {
    /**
     * The name of the Datastore kind.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#name DataLossPreventionJobTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId {
    /**
     * If not empty, the ID of the namespace to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#namespace_id DataLossPreventionJobTrigger#namespace_id}
     *
     * @stability stable
     */
    readonly namespaceId?: string;
    /**
     * The ID of the project to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined);
    private _namespaceId?;
    /**
     * @stability stable
     */
    get namespaceId(): string;
    /**
     * @stability stable
     */
    set namespaceId(value: string);
    /**
     * @stability stable
     */
    resetNamespaceId(): void;
    /**
     * @stability stable
     */
    get namespaceIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions {
    /**
     * kind block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#kind DataLossPreventionJobTrigger#kind}
     *
     * @stability stable
     */
    readonly kind: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind;
    /**
     * partition_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#partition_id DataLossPreventionJobTrigger#partition_id}
     *
     * @stability stable
     */
    readonly partitionId: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined);
    private _kind;
    /**
     * @stability stable
     */
    get kind(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference;
    /**
     * @stability stable
     */
    putKind(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): void;
    /**
     * @stability stable
     */
    get kindInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    private _partitionId;
    /**
     * @stability stable
     */
    get partitionId(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference;
    /**
     * @stability stable
     */
    putPartitionId(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): void;
    /**
     * @stability stable
     */
    get partitionIdInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField {
    /**
     * Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
     *
     * For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
     * modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
     * field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
     *
     * For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
     * timestamp property does not exist or its value is empty or invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#name DataLossPreventionJobTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig {
    /**
     * When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid scanning files that have not been modified since the last time the JobTrigger executed.
     *
     * This will
     * be based on the time of the execution of the last run of the JobTrigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#enable_auto_population_of_timespan_config DataLossPreventionJobTrigger#enable_auto_population_of_timespan_config}
     *
     * @stability stable
     */
    readonly enableAutoPopulationOfTimespanConfig?: boolean | cdktf.IResolvable;
    /**
     * Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#end_time DataLossPreventionJobTrigger#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Exclude files or rows older than this value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#start_time DataLossPreventionJobTrigger#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * timestamp_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timestamp_field DataLossPreventionJobTrigger#timestamp_field}
     *
     * @stability stable
     */
    readonly timestampField: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined);
    private _enableAutoPopulationOfTimespanConfig?;
    /**
     * @stability stable
     */
    get enableAutoPopulationOfTimespanConfig(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutoPopulationOfTimespanConfig(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutoPopulationOfTimespanConfig(): void;
    /**
     * @stability stable
     */
    get enableAutoPopulationOfTimespanConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _timestampField;
    /**
     * @stability stable
     */
    get timestampField(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference;
    /**
     * @stability stable
     */
    putTimestampField(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): void;
    /**
     * @stability stable
     */
    get timestampFieldInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJobStorageConfig {
    /**
     * big_query_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#big_query_options DataLossPreventionJobTrigger#big_query_options}
     *
     * @stability stable
     */
    readonly bigQueryOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions;
    /**
     * cloud_storage_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#cloud_storage_options DataLossPreventionJobTrigger#cloud_storage_options}
     *
     * @stability stable
     */
    readonly cloudStorageOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions;
    /**
     * datastore_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#datastore_options DataLossPreventionJobTrigger#datastore_options}
     *
     * @stability stable
     */
    readonly datastoreOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions;
    /**
     * timespan_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timespan_config DataLossPreventionJobTrigger#timespan_config}
     *
     * @stability stable
     */
    readonly timespanConfig?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfig): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfig | undefined);
    private _bigQueryOptions;
    /**
     * @stability stable
     */
    get bigQueryOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference;
    /**
     * @stability stable
     */
    putBigQueryOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): void;
    /**
     * @stability stable
     */
    resetBigQueryOptions(): void;
    /**
     * @stability stable
     */
    get bigQueryOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    private _cloudStorageOptions;
    /**
     * @stability stable
     */
    get cloudStorageOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference;
    /**
     * @stability stable
     */
    putCloudStorageOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): void;
    /**
     * @stability stable
     */
    resetCloudStorageOptions(): void;
    /**
     * @stability stable
     */
    get cloudStorageOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    private _datastoreOptions;
    /**
     * @stability stable
     */
    get datastoreOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference;
    /**
     * @stability stable
     */
    putDatastoreOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): void;
    /**
     * @stability stable
     */
    resetDatastoreOptions(): void;
    /**
     * @stability stable
     */
    get datastoreOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    private _timespanConfig;
    /**
     * @stability stable
     */
    get timespanConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference;
    /**
     * @stability stable
     */
    putTimespanConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): void;
    /**
     * @stability stable
     */
    resetTimespanConfig(): void;
    /**
     * @stability stable
     */
    get timespanConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerInspectJob {
    /**
     * The name of the template to run when this job is triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#inspect_template_name DataLossPreventionJobTrigger#inspect_template_name}
     *
     * @stability stable
     */
    readonly inspectTemplateName: string;
    /**
     * actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#actions DataLossPreventionJobTrigger#actions}
     *
     * @stability stable
     */
    readonly actions: DataLossPreventionJobTriggerInspectJobActions[];
    /**
     * storage_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#storage_config DataLossPreventionJobTrigger#storage_config}
     *
     * @stability stable
     */
    readonly storageConfig: DataLossPreventionJobTriggerInspectJobStorageConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobToTerraform(struct?: DataLossPreventionJobTriggerInspectJobOutputReference | DataLossPreventionJobTriggerInspectJob): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerInspectJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerInspectJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerInspectJob | undefined);
    private _inspectTemplateName?;
    /**
     * @stability stable
     */
    get inspectTemplateName(): string;
    /**
     * @stability stable
     */
    set inspectTemplateName(value: string);
    /**
     * @stability stable
     */
    get inspectTemplateNameInput(): string | undefined;
    private _actions?;
    /**
     * @stability stable
     */
    get actions(): DataLossPreventionJobTriggerInspectJobActions[];
    /**
     * @stability stable
     */
    set actions(value: DataLossPreventionJobTriggerInspectJobActions[]);
    /**
     * @stability stable
     */
    get actionsInput(): DataLossPreventionJobTriggerInspectJobActions[] | undefined;
    private _storageConfig;
    /**
     * @stability stable
     */
    get storageConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference;
    /**
     * @stability stable
     */
    putStorageConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfig): void;
    /**
     * @stability stable
     */
    get storageConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#create DataLossPreventionJobTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#delete DataLossPreventionJobTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#update DataLossPreventionJobTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataLossPreventionJobTriggerTimeoutsToTerraform(struct?: DataLossPreventionJobTriggerTimeoutsOutputReference | DataLossPreventionJobTriggerTimeouts): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTriggersSchedule {
    /**
     * With this option a job is started a regular periodic basis. For example: every day (86400 seconds).
     *
     * A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.
     *
     * This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#recurrence_period_duration DataLossPreventionJobTrigger#recurrence_period_duration}
     *
     * @stability stable
     */
    readonly recurrencePeriodDuration?: string;
}
export declare function dataLossPreventionJobTriggerTriggersScheduleToTerraform(struct?: DataLossPreventionJobTriggerTriggersScheduleOutputReference | DataLossPreventionJobTriggerTriggersSchedule): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionJobTriggerTriggersScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionJobTriggerTriggersSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionJobTriggerTriggersSchedule | undefined);
    private _recurrencePeriodDuration?;
    /**
     * @stability stable
     */
    get recurrencePeriodDuration(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodDuration(value: string);
    /**
     * @stability stable
     */
    resetRecurrencePeriodDuration(): void;
    /**
     * @stability stable
     */
    get recurrencePeriodDurationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionJobTriggerTriggers {
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#schedule DataLossPreventionJobTrigger#schedule}
     *
     * @stability stable
     */
    readonly schedule?: DataLossPreventionJobTriggerTriggersSchedule;
}
export declare function dataLossPreventionJobTriggerTriggersToTerraform(struct?: DataLossPreventionJobTriggerTriggers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger}.
 *
 * @stability stable
 */
export declare class DataLossPreventionJobTrigger extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionJobTriggerConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastRunTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _inspectJob;
    /**
     * @stability stable
     */
    get inspectJob(): DataLossPreventionJobTriggerInspectJobOutputReference;
    /**
     * @stability stable
     */
    putInspectJob(value: DataLossPreventionJobTriggerInspectJob): void;
    /**
     * @stability stable
     */
    resetInspectJob(): void;
    /**
     * @stability stable
     */
    get inspectJobInput(): DataLossPreventionJobTriggerInspectJob | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionJobTriggerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataLossPreventionJobTriggerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionJobTriggerTimeouts | undefined;
    private _triggers?;
    /**
     * @stability stable
     */
    get triggers(): DataLossPreventionJobTriggerTriggers[];
    /**
     * @stability stable
     */
    set triggers(value: DataLossPreventionJobTriggerTriggers[]);
    /**
     * @stability stable
     */
    get triggersInput(): DataLossPreventionJobTriggerTriggers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
