import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingFolderSinkConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this sink. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#description LoggingFolderSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The destination of the sink (or, in other words, where logs are written to).
     *
     * Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#destination LoggingFolderSink#destination}
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * If set to True, then this sink is disabled and it does not export any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#disabled LoggingFolderSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when exporting logs. Only log entries that match the filter are exported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#filter LoggingFolderSink#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * The folder to be exported to the sink. Note that either [FOLDER_ID] or "folders/[FOLDER_ID]" is accepted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#folder LoggingFolderSink#folder}
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * Whether or not to include children folders in the sink export.
     *
     * If true, logs associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#include_children LoggingFolderSink#include_children}
     *
     * @stability stable
     */
    readonly includeChildren?: boolean | cdktf.IResolvable;
    /**
     * The name of the logging sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#name LoggingFolderSink#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * bigquery_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#bigquery_options LoggingFolderSink#bigquery_options}
     *
     * @stability stable
     */
    readonly bigqueryOptions?: LoggingFolderSinkBigqueryOptions;
    /**
     * exclusions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#exclusions LoggingFolderSink#exclusions}
     *
     * @stability stable
     */
    readonly exclusions?: LoggingFolderSinkExclusions[];
}
/**
 * @stability stable
 */
export interface LoggingFolderSinkBigqueryOptions {
    /**
     * Whether to use BigQuery's partition tables.
     *
     * By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#use_partitioned_tables LoggingFolderSink#use_partitioned_tables}
     *
     * @stability stable
     */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function loggingFolderSinkBigqueryOptionsToTerraform(struct?: LoggingFolderSinkBigqueryOptionsOutputReference | LoggingFolderSinkBigqueryOptions): any;
/**
 * @stability stable
 */
export declare class LoggingFolderSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingFolderSinkBigqueryOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingFolderSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    /**
     * @stability stable
     */
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LoggingFolderSinkExclusions {
    /**
     * A description of this exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#description LoggingFolderSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If set to True, then this exclusion is disabled and it does not exclude any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#disabled LoggingFolderSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * An advanced logs filter that matches the log entries to be excluded.
     *
     * By using the sample function, you can exclude less than 100% of the matching log entries
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#filter LoggingFolderSink#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * A client-assigned identifier, such as "load-balancer-exclusion".
     *
     * Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#name LoggingFolderSink#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function loggingFolderSinkExclusionsToTerraform(struct?: LoggingFolderSinkExclusions): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink google_logging_folder_sink}.
 *
 * @stability stable
 */
export declare class LoggingFolderSink extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink google_logging_folder_sink} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingFolderSinkConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeChildren?;
    /**
     * @stability stable
     */
    get includeChildren(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeChildren(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeChildren(): void;
    /**
     * @stability stable
     */
    get includeChildrenInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get writerIdentity(): string;
    private _bigqueryOptions;
    /**
     * @stability stable
     */
    get bigqueryOptions(): LoggingFolderSinkBigqueryOptionsOutputReference;
    /**
     * @stability stable
     */
    putBigqueryOptions(value: LoggingFolderSinkBigqueryOptions): void;
    /**
     * @stability stable
     */
    resetBigqueryOptions(): void;
    /**
     * @stability stable
     */
    get bigqueryOptionsInput(): LoggingFolderSinkBigqueryOptions | undefined;
    private _exclusions?;
    /**
     * @stability stable
     */
    get exclusions(): LoggingFolderSinkExclusions[];
    /**
     * @stability stable
     */
    set exclusions(value: LoggingFolderSinkExclusions[]);
    /**
     * @stability stable
     */
    resetExclusions(): void;
    /**
     * @stability stable
     */
    get exclusionsInput(): LoggingFolderSinkExclusions[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
