import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * A user-assigned name for this group, used only for display purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#display_name MonitoringGroup#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The filter used to determine which monitored resources belong to this group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#filter MonitoringGroup#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * If true, the members of this group are considered to be a cluster.
     *
     * The system can perform additional analysis on
     * groups that are clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#is_cluster MonitoringGroup#is_cluster}
     *
     * @stability stable
     */
    readonly isCluster?: boolean | cdktf.IResolvable;
    /**
     * The name of the group's parent, if it has one.
     *
     * The format is
     * "projects/{project_id_or_number}/groups/{group_id}". For
     * groups with no parent, parentName is the empty string, "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#parent_name MonitoringGroup#parent_name}
     *
     * @stability stable
     */
    readonly parentName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#project MonitoringGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#timeouts MonitoringGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringGroupTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#create MonitoringGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#delete MonitoringGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#update MonitoringGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringGroupTimeoutsToTerraform(struct?: MonitoringGroupTimeoutsOutputReference | MonitoringGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitoringGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_group google_monitoring_group}.
 *
 * @stability stable
 */
export declare class MonitoringGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_group google_monitoring_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringGroupConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isCluster?;
    /**
     * @stability stable
     */
    get isCluster(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCluster(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsCluster(): void;
    /**
     * @stability stable
     */
    get isClusterInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parentName?;
    /**
     * @stability stable
     */
    get parentName(): string;
    /**
     * @stability stable
     */
    set parentName(value: string);
    /**
     * @stability stable
     */
    resetParentName(): void;
    /**
     * @stability stable
     */
    get parentNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
