import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user provided Resource ID for this Certificate Authority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#certificate_authority_id PrivatecaCertificateAuthority#certificate_authority_id}
     *
     * @stability stable
     */
    readonly certificateAuthorityId: string;
    /**
     * The name of a Cloud Storage bucket where this CertificateAuthority will publish content, such as the CA certificate and CRLs.
     *
     * This must be a bucket name, without any prefixes
     * (such as 'gs://') or suffixes (such as '.googleapis.com'). For example, to use a bucket named
     * my-bucket, you would simply specify 'my-bucket'. If not specified, a managed bucket will be
     * created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#gcs_bucket PrivatecaCertificateAuthority#gcs_bucket}
     *
     * @stability stable
     */
    readonly gcsBucket?: string;
    /**
     * This field allows the CA to be deleted even if the CA has active certs.
     *
     * Active certs include both unrevoked and unexpired certs.
     * Use with care. Defaults to 'false'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ignore_active_certificates_on_deletion PrivatecaCertificateAuthority#ignore_active_certificates_on_deletion}
     *
     * @stability stable
     */
    readonly ignoreActiveCertificatesOnDeletion?: boolean | cdktf.IResolvable;
    /**
     * Labels with user-defined metadata.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
     * "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#labels PrivatecaCertificateAuthority#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The desired lifetime of the CA certificate.
     *
     * Used to create the "notBeforeTime" and
     * "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
     * fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#lifetime PrivatecaCertificateAuthority#lifetime}
     *
     * @stability stable
     */
    readonly lifetime?: string;
    /**
     * Location of the CertificateAuthority. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#location PrivatecaCertificateAuthority#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name of the CaPool this Certificate Authority belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#pool PrivatecaCertificateAuthority#pool}
     *
     * @stability stable
     */
    readonly pool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#project PrivatecaCertificateAuthority#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Type of this CertificateAuthority.
     *
     * ~> **Note:** For 'SUBORDINATE' Certificate Authorities, they need to
     * be manually activated (via Cloud Console of 'gcloud') before they can
     * issue certificates. Default value: "SELF_SIGNED" Possible values: ["SELF_SIGNED", "SUBORDINATE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#type PrivatecaCertificateAuthority#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#config PrivatecaCertificateAuthority#config}
     *
     * @stability stable
     */
    readonly config: PrivatecaCertificateAuthorityConfigA;
    /**
     * key_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_spec PrivatecaCertificateAuthority#key_spec}
     *
     * @stability stable
     */
    readonly keySpec: PrivatecaCertificateAuthorityKeySpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#timeouts PrivatecaCertificateAuthority#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivatecaCertificateAuthorityTimeouts;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityAccessUrls extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get caCertificateAccessUrl(): string;
    /**
     * @stability stable
     */
    get crlAccessUrl(): string;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubject {
    /**
     * The common name of the distinguished name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#common_name PrivatecaCertificateAuthority#common_name}
     *
     * @stability stable
     */
    readonly commonName: string;
    /**
     * The country code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#country_code PrivatecaCertificateAuthority#country_code}
     *
     * @stability stable
     */
    readonly countryCode?: string;
    /**
     * The locality or city of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#locality PrivatecaCertificateAuthority#locality}
     *
     * @stability stable
     */
    readonly locality?: string;
    /**
     * The organization of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#organization PrivatecaCertificateAuthority#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * The organizational unit of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#organizational_unit PrivatecaCertificateAuthority#organizational_unit}
     *
     * @stability stable
     */
    readonly organizationalUnit?: string;
    /**
     * The postal code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#postal_code PrivatecaCertificateAuthority#postal_code}
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * The province, territory, or regional state of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#province PrivatecaCertificateAuthority#province}
     *
     * @stability stable
     */
    readonly province?: string;
    /**
     * The street address of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#street_address PrivatecaCertificateAuthority#street_address}
     *
     * @stability stable
     */
    readonly streetAddress?: string;
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigSubjectToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfigSubject): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined);
    private _commonName?;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    set commonName(value: string);
    /**
     * @stability stable
     */
    get commonNameInput(): string | undefined;
    private _countryCode?;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    set countryCode(value: string);
    /**
     * @stability stable
     */
    resetCountryCode(): void;
    /**
     * @stability stable
     */
    get countryCodeInput(): string | undefined;
    private _locality?;
    /**
     * @stability stable
     */
    get locality(): string;
    /**
     * @stability stable
     */
    set locality(value: string);
    /**
     * @stability stable
     */
    resetLocality(): void;
    /**
     * @stability stable
     */
    get localityInput(): string | undefined;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    /**
     * @stability stable
     */
    get organizationalUnit(): string;
    /**
     * @stability stable
     */
    set organizationalUnit(value: string);
    /**
     * @stability stable
     */
    resetOrganizationalUnit(): void;
    /**
     * @stability stable
     */
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    set postalCode(value: string);
    /**
     * @stability stable
     */
    resetPostalCode(): void;
    /**
     * @stability stable
     */
    get postalCodeInput(): string | undefined;
    private _province?;
    /**
     * @stability stable
     */
    get province(): string;
    /**
     * @stability stable
     */
    set province(value: string);
    /**
     * @stability stable
     */
    resetProvince(): void;
    /**
     * @stability stable
     */
    get provinceInput(): string | undefined;
    private _streetAddress?;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    set streetAddress(value: string);
    /**
     * @stability stable
     */
    resetStreetAddress(): void;
    /**
     * @stability stable
     */
    get streetAddressInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName {
    /**
     * Contains only valid, fully-qualified host names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#dns_names PrivatecaCertificateAuthority#dns_names}
     *
     * @stability stable
     */
    readonly dnsNames?: string[];
    /**
     * Contains only valid RFC 2822 E-mail addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#email_addresses PrivatecaCertificateAuthority#email_addresses}
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ip_addresses PrivatecaCertificateAuthority#ip_addresses}
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
    /**
     * Contains only valid RFC 3986 URIs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#uris PrivatecaCertificateAuthority#uris}
     *
     * @stability stable
     */
    readonly uris?: string[];
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined);
    private _dnsNames?;
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    set dnsNames(value: string[]);
    /**
     * @stability stable
     */
    resetDnsNames(): void;
    /**
     * @stability stable
     */
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    set ipAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    /**
     * @stability stable
     */
    get uris(): string[];
    /**
     * @stability stable
     */
    set uris(value: string[]);
    /**
     * @stability stable
     */
    resetUris(): void;
    /**
     * @stability stable
     */
    get urisInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigSubjectConfig {
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject PrivatecaCertificateAuthority#subject}
     *
     * @stability stable
     */
    readonly subject: PrivatecaCertificateAuthorityConfigSubjectConfigSubject;
    /**
     * subject_alt_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject_alt_name PrivatecaCertificateAuthority#subject_alt_name}
     *
     * @stability stable
     */
    readonly subjectAltName?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName;
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfig): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfig | undefined);
    private _subject;
    /**
     * @stability stable
     */
    get subject(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference;
    /**
     * @stability stable
     */
    putSubject(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubject): void;
    /**
     * @stability stable
     */
    get subjectInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    private _subjectAltName;
    /**
     * @stability stable
     */
    get subjectAltName(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference;
    /**
     * @stability stable
     */
    putSubjectAltName(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): void;
    /**
     * @stability stable
     */
    resetSubjectAltName(): void;
    /**
     * @stability stable
     */
    get subjectAltNameInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    /**
     * @stability stable
     */
    get objectIdPath(): number[];
    /**
     * @stability stable
     */
    set objectIdPath(value: number[]);
    /**
     * @stability stable
     */
    get objectIdPathInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#critical PrivatecaCertificateAuthority#critical}
     *
     * @stability stable
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#value PrivatecaCertificateAuthority#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id PrivatecaCertificateAuthority#object_id}
     *
     * @stability stable
     */
    readonly objectId: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#is_ca PrivatecaCertificateAuthority#is_ca}
     *
     * @stability stable
     */
    readonly isCa: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#max_issuer_path_length PrivatecaCertificateAuthority#max_issuer_path_length}
     *
     * @stability stable
     */
    readonly maxIssuerPathLength?: number;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigCaOptionsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigCaOptions): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined);
    private _isCa?;
    /**
     * @stability stable
     */
    get isCa(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCa(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    /**
     * @stability stable
     */
    get maxIssuerPathLength(): number;
    /**
     * @stability stable
     */
    set maxIssuerPathLength(value: number);
    /**
     * @stability stable
     */
    resetMaxIssuerPathLength(): void;
    /**
     * @stability stable
     */
    get maxIssuerPathLengthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#cert_sign PrivatecaCertificateAuthority#cert_sign}
     *
     * @stability stable
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#content_commitment PrivatecaCertificateAuthority#content_commitment}
     *
     * @stability stable
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#crl_sign PrivatecaCertificateAuthority#crl_sign}
     *
     * @stability stable
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#data_encipherment PrivatecaCertificateAuthority#data_encipherment}
     *
     * @stability stable
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#decipher_only PrivatecaCertificateAuthority#decipher_only}
     *
     * @stability stable
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#digital_signature PrivatecaCertificateAuthority#digital_signature}
     *
     * @stability stable
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#encipher_only PrivatecaCertificateAuthority#encipher_only}
     *
     * @stability stable
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_agreement PrivatecaCertificateAuthority#key_agreement}
     *
     * @stability stable
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_encipherment PrivatecaCertificateAuthority#key_encipherment}
     *
     * @stability stable
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    /**
     * @stability stable
     */
    get certSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set certSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCertSign(): void;
    /**
     * @stability stable
     */
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    /**
     * @stability stable
     */
    get contentCommitment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set contentCommitment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContentCommitment(): void;
    /**
     * @stability stable
     */
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    /**
     * @stability stable
     */
    get crlSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set crlSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCrlSign(): void;
    /**
     * @stability stable
     */
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    /**
     * @stability stable
     */
    get dataEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataEncipherment(): void;
    /**
     * @stability stable
     */
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    /**
     * @stability stable
     */
    get decipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set decipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDecipherOnly(): void;
    /**
     * @stability stable
     */
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    /**
     * @stability stable
     */
    get digitalSignature(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set digitalSignature(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDigitalSignature(): void;
    /**
     * @stability stable
     */
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    /**
     * @stability stable
     */
    get encipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncipherOnly(): void;
    /**
     * @stability stable
     */
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    /**
     * @stability stable
     */
    get keyAgreement(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyAgreement(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyAgreement(): void;
    /**
     * @stability stable
     */
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    /**
     * @stability stable
     */
    get keyEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyEncipherment(): void;
    /**
     * @stability stable
     */
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#client_auth PrivatecaCertificateAuthority#client_auth}
     *
     * @stability stable
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#code_signing PrivatecaCertificateAuthority#code_signing}
     *
     * @stability stable
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#email_protection PrivatecaCertificateAuthority#email_protection}
     *
     * @stability stable
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ocsp_signing PrivatecaCertificateAuthority#ocsp_signing}
     *
     * @stability stable
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#server_auth PrivatecaCertificateAuthority#server_auth}
     *
     * @stability stable
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#time_stamping PrivatecaCertificateAuthority#time_stamping}
     *
     * @stability stable
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    /**
     * @stability stable
     */
    get clientAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAuth(): void;
    /**
     * @stability stable
     */
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    /**
     * @stability stable
     */
    get codeSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set codeSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCodeSigning(): void;
    /**
     * @stability stable
     */
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    /**
     * @stability stable
     */
    get emailProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailProtection(): void;
    /**
     * @stability stable
     */
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    /**
     * @stability stable
     */
    get ocspSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ocspSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOcspSigning(): void;
    /**
     * @stability stable
     */
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    /**
     * @stability stable
     */
    get serverAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServerAuth(): void;
    /**
     * @stability stable
     */
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    /**
     * @stability stable
     */
    get timeStamping(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set timeStamping(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTimeStamping(): void;
    /**
     * @stability stable
     */
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#base_key_usage PrivatecaCertificateAuthority#base_key_usage}
     *
     * @stability stable
     */
    readonly baseKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#extended_key_usage PrivatecaCertificateAuthority#extended_key_usage}
     *
     * @stability stable
     */
    readonly extendedKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#unknown_extended_key_usages PrivatecaCertificateAuthority#unknown_extended_key_usages}
     *
     * @stability stable
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined);
    private _baseKeyUsage;
    /**
     * @stability stable
     */
    get baseKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putBaseKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): void;
    /**
     * @stability stable
     */
    get baseKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putExtendedKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[];
    /**
     * @stability stable
     */
    set unknownExtendedKeyUsages(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[]);
    /**
     * @stability stable
     */
    resetUnknownExtendedKeyUsages(): void;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigPolicyIdsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds): any;
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigX509Config {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#aia_ocsp_servers PrivatecaCertificateAuthority#aia_ocsp_servers}
     *
     * @stability stable
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#additional_extensions PrivatecaCertificateAuthority#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ca_options PrivatecaCertificateAuthority#ca_options}
     *
     * @stability stable
     */
    readonly caOptions: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_usage PrivatecaCertificateAuthority#key_usage}
     *
     * @stability stable
     */
    readonly keyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#policy_ids PrivatecaCertificateAuthority#policy_ids}
     *
     * @stability stable
     */
    readonly policyIds?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigOutputReference | PrivatecaCertificateAuthorityConfigX509Config): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigX509Config | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509Config | undefined);
    private _aiaOcspServers?;
    /**
     * @stability stable
     */
    get aiaOcspServers(): string[];
    /**
     * @stability stable
     */
    set aiaOcspServers(value: string[]);
    /**
     * @stability stable
     */
    resetAiaOcspServers(): void;
    /**
     * @stability stable
     */
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[];
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[]);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions;
    /**
     * @stability stable
     */
    get caOptions(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference;
    /**
     * @stability stable
     */
    putCaOptions(value: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions): void;
    /**
     * @stability stable
     */
    get caOptionsInput(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    private _keyUsage;
    /**
     * @stability stable
     */
    get keyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): void;
    /**
     * @stability stable
     */
    get keyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    private _policyIds?;
    /**
     * @stability stable
     */
    get policyIds(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[];
    /**
     * @stability stable
     */
    set policyIds(value: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[]);
    /**
     * @stability stable
     */
    resetPolicyIds(): void;
    /**
     * @stability stable
     */
    get policyIdsInput(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityConfigA {
    /**
     * subject_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject_config PrivatecaCertificateAuthority#subject_config}
     *
     * @stability stable
     */
    readonly subjectConfig: PrivatecaCertificateAuthorityConfigSubjectConfig;
    /**
     * x509_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#x509_config PrivatecaCertificateAuthority#x509_config}
     *
     * @stability stable
     */
    readonly x509Config: PrivatecaCertificateAuthorityConfigX509Config;
}
export declare function privatecaCertificateAuthorityConfigAToTerraform(struct?: PrivatecaCertificateAuthorityConfigAOutputReference | PrivatecaCertificateAuthorityConfigA): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityConfigA | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityConfigA | undefined);
    private _subjectConfig;
    /**
     * @stability stable
     */
    get subjectConfig(): PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference;
    /**
     * @stability stable
     */
    putSubjectConfig(value: PrivatecaCertificateAuthorityConfigSubjectConfig): void;
    /**
     * @stability stable
     */
    get subjectConfigInput(): PrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    private _x509Config;
    /**
     * @stability stable
     */
    get x509Config(): PrivatecaCertificateAuthorityConfigX509ConfigOutputReference;
    /**
     * @stability stable
     */
    putX509Config(value: PrivatecaCertificateAuthorityConfigX509Config): void;
    /**
     * @stability stable
     */
    get x509ConfigInput(): PrivatecaCertificateAuthorityConfigX509Config | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityKeySpec {
    /**
     * The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience.
     *
     * All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#algorithm PrivatecaCertificateAuthority#algorithm}
     *
     * @stability stable
     */
    readonly algorithm?: string;
    /**
     * The resource name for an existing Cloud KMS CryptoKeyVersion in the format 'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*\/cryptoKeyVersions/*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#cloud_kms_key_version PrivatecaCertificateAuthority#cloud_kms_key_version}
     *
     * @stability stable
     */
    readonly cloudKmsKeyVersion?: string;
}
export declare function privatecaCertificateAuthorityKeySpecToTerraform(struct?: PrivatecaCertificateAuthorityKeySpecOutputReference | PrivatecaCertificateAuthorityKeySpec): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityKeySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityKeySpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityKeySpec | undefined);
    private _algorithm?;
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    set algorithm(value: string);
    /**
     * @stability stable
     */
    resetAlgorithm(): void;
    /**
     * @stability stable
     */
    get algorithmInput(): string | undefined;
    private _cloudKmsKeyVersion?;
    /**
     * @stability stable
     */
    get cloudKmsKeyVersion(): string;
    /**
     * @stability stable
     */
    set cloudKmsKeyVersion(value: string);
    /**
     * @stability stable
     */
    resetCloudKmsKeyVersion(): void;
    /**
     * @stability stable
     */
    get cloudKmsKeyVersionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateAuthorityTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#create PrivatecaCertificateAuthority#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#delete PrivatecaCertificateAuthority#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function privatecaCertificateAuthorityTimeoutsToTerraform(struct?: PrivatecaCertificateAuthorityTimeoutsOutputReference | PrivatecaCertificateAuthorityTimeouts): any;
/**
 * @stability stable
 */
export declare class PrivatecaCertificateAuthorityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCertificateAuthorityTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCertificateAuthorityTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority google_privateca_certificate_authority}.
 *
 * @stability stable
 */
export declare class PrivatecaCertificateAuthority extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority google_privateca_certificate_authority} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateAuthorityConfig);
    /**
     * @stability stable
     */
    accessUrls(index: string): PrivatecaCertificateAuthorityAccessUrls;
    private _certificateAuthorityId?;
    /**
     * @stability stable
     */
    get certificateAuthorityId(): string;
    /**
     * @stability stable
     */
    set certificateAuthorityId(value: string);
    /**
     * @stability stable
     */
    get certificateAuthorityIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    private _gcsBucket?;
    /**
     * @stability stable
     */
    get gcsBucket(): string;
    /**
     * @stability stable
     */
    set gcsBucket(value: string);
    /**
     * @stability stable
     */
    resetGcsBucket(): void;
    /**
     * @stability stable
     */
    get gcsBucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreActiveCertificatesOnDeletion?;
    /**
     * @stability stable
     */
    get ignoreActiveCertificatesOnDeletion(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreActiveCertificatesOnDeletion(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreActiveCertificatesOnDeletion(): void;
    /**
     * @stability stable
     */
    get ignoreActiveCertificatesOnDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    /**
     * @stability stable
     */
    get lifetime(): string;
    /**
     * @stability stable
     */
    set lifetime(value: string);
    /**
     * @stability stable
     */
    resetLifetime(): void;
    /**
     * @stability stable
     */
    get lifetimeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get pemCaCertificates(): string[];
    private _pool?;
    /**
     * @stability stable
     */
    get pool(): string;
    /**
     * @stability stable
     */
    set pool(value: string);
    /**
     * @stability stable
     */
    get poolInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _config;
    /**
     * @stability stable
     */
    get config(): PrivatecaCertificateAuthorityConfigAOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: PrivatecaCertificateAuthorityConfigA): void;
    /**
     * @stability stable
     */
    get configInput(): PrivatecaCertificateAuthorityConfigA | undefined;
    private _keySpec;
    /**
     * @stability stable
     */
    get keySpec(): PrivatecaCertificateAuthorityKeySpecOutputReference;
    /**
     * @stability stable
     */
    putKeySpec(value: PrivatecaCertificateAuthorityKeySpec): void;
    /**
     * @stability stable
     */
    get keySpecInput(): PrivatecaCertificateAuthorityKeySpec | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivatecaCertificateAuthorityTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivatecaCertificateAuthorityTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivatecaCertificateAuthorityTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
