import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Timestamp in UTC when the Secret is scheduled to expire.
     *
     * This is always provided on output, regardless of what was sent on input.
     * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#expire_time SecretManagerSecret#expire_time}
     *
     * @stability stable
     */
    readonly expireTime?: string;
    /**
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be assigned to a given resource.
     *
     * An object containing a list of "key": value pairs. Example:
     * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#labels SecretManagerSecret#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#project SecretManagerSecret#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#secret_id SecretManagerSecret#secret_id}
     *
     * @stability stable
     */
    readonly secretId: string;
    /**
     * The TTL for the Secret. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#ttl SecretManagerSecret#ttl}
     *
     * @stability stable
     */
    readonly ttl?: string;
    /**
     * replication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#replication SecretManagerSecret#replication}
     *
     * @stability stable
     */
    readonly replication: SecretManagerSecretReplication;
    /**
     * rotation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#rotation SecretManagerSecret#rotation}
     *
     * @stability stable
     */
    readonly rotation?: SecretManagerSecretRotation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#timeouts SecretManagerSecret#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecretManagerSecretTimeouts;
    /**
     * topics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#topics SecretManagerSecret#topics}
     *
     * @stability stable
     */
    readonly topics?: SecretManagerSecretTopics[];
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#kms_key_name SecretManagerSecret#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function secretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference | SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManagedReplicas {
    /**
     * The canonical IDs of the location to replicate data. For example: "us-east1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#location SecretManagerSecret#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * customer_managed_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#customer_managed_encryption SecretManagerSecret#customer_managed_encryption}
     *
     * @stability stable
     */
    readonly customerManagedEncryption?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption;
}
export declare function secretManagerSecretReplicationUserManagedReplicasToTerraform(struct?: SecretManagerSecretReplicationUserManagedReplicas): any;
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManaged {
    /**
     * replicas block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#replicas SecretManagerSecret#replicas}
     *
     * @stability stable
     */
    readonly replicas: SecretManagerSecretReplicationUserManagedReplicas[];
}
export declare function secretManagerSecretReplicationUserManagedToTerraform(struct?: SecretManagerSecretReplicationUserManagedOutputReference | SecretManagerSecretReplicationUserManaged): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretReplicationUserManaged | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretReplicationUserManaged | undefined);
    private _replicas?;
    /**
     * @stability stable
     */
    get replicas(): SecretManagerSecretReplicationUserManagedReplicas[];
    /**
     * @stability stable
     */
    set replicas(value: SecretManagerSecretReplicationUserManagedReplicas[]);
    /**
     * @stability stable
     */
    get replicasInput(): SecretManagerSecretReplicationUserManagedReplicas[] | undefined;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplication {
    /**
     * The Secret will automatically be replicated without any restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#automatic SecretManagerSecret#automatic}
     *
     * @stability stable
     */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
     * user_managed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#user_managed SecretManagerSecret#user_managed}
     *
     * @stability stable
     */
    readonly userManaged?: SecretManagerSecretReplicationUserManaged;
}
export declare function secretManagerSecretReplicationToTerraform(struct?: SecretManagerSecretReplicationOutputReference | SecretManagerSecretReplication): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretReplication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretReplication | undefined);
    private _automatic?;
    /**
     * @stability stable
     */
    get automatic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automatic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomatic(): void;
    /**
     * @stability stable
     */
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    private _userManaged;
    /**
     * @stability stable
     */
    get userManaged(): SecretManagerSecretReplicationUserManagedOutputReference;
    /**
     * @stability stable
     */
    putUserManaged(value: SecretManagerSecretReplicationUserManaged): void;
    /**
     * @stability stable
     */
    resetUserManaged(): void;
    /**
     * @stability stable
     */
    get userManagedInput(): SecretManagerSecretReplicationUserManaged | undefined;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretRotation {
    /**
     * Timestamp in UTC at which the Secret is scheduled to rotate.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#next_rotation_time SecretManagerSecret#next_rotation_time}
     *
     * @stability stable
     */
    readonly nextRotationTime?: string;
    /**
     * The Duration between rotation notifications.
     *
     * Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
     * If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#rotation_period SecretManagerSecret#rotation_period}
     *
     * @stability stable
     */
    readonly rotationPeriod?: string;
}
export declare function secretManagerSecretRotationToTerraform(struct?: SecretManagerSecretRotationOutputReference | SecretManagerSecretRotation): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretRotation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretRotation | undefined);
    private _nextRotationTime?;
    /**
     * @stability stable
     */
    get nextRotationTime(): string;
    /**
     * @stability stable
     */
    set nextRotationTime(value: string);
    /**
     * @stability stable
     */
    resetNextRotationTime(): void;
    /**
     * @stability stable
     */
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    /**
     * @stability stable
     */
    get rotationPeriod(): string;
    /**
     * @stability stable
     */
    set rotationPeriod(value: string);
    /**
     * @stability stable
     */
    resetRotationPeriod(): void;
    /**
     * @stability stable
     */
    get rotationPeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#create SecretManagerSecret#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#delete SecretManagerSecret#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#update SecretManagerSecret#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function secretManagerSecretTimeoutsToTerraform(struct?: SecretManagerSecretTimeoutsOutputReference | SecretManagerSecretTimeouts): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretTopics {
    /**
     * The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*\/topics/*.
     *
     * For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#name SecretManagerSecret#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function secretManagerSecretTopicsToTerraform(struct?: SecretManagerSecretTopics): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret google_secret_manager_secret}.
 *
 * @stability stable
 */
export declare class SecretManagerSecret extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret google_secret_manager_secret} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _expireTime?;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    set expireTime(value: string);
    /**
     * @stability stable
     */
    resetExpireTime(): void;
    /**
     * @stability stable
     */
    get expireTimeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _secretId?;
    /**
     * @stability stable
     */
    get secretId(): string;
    /**
     * @stability stable
     */
    set secretId(value: string);
    /**
     * @stability stable
     */
    get secretIdInput(): string | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): string;
    /**
     * @stability stable
     */
    set ttl(value: string);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): string | undefined;
    private _replication;
    /**
     * @stability stable
     */
    get replication(): SecretManagerSecretReplicationOutputReference;
    /**
     * @stability stable
     */
    putReplication(value: SecretManagerSecretReplication): void;
    /**
     * @stability stable
     */
    get replicationInput(): SecretManagerSecretReplication | undefined;
    private _rotation;
    /**
     * @stability stable
     */
    get rotation(): SecretManagerSecretRotationOutputReference;
    /**
     * @stability stable
     */
    putRotation(value: SecretManagerSecretRotation): void;
    /**
     * @stability stable
     */
    resetRotation(): void;
    /**
     * @stability stable
     */
    get rotationInput(): SecretManagerSecretRotation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecretManagerSecretTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecretManagerSecretTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecretManagerSecretTimeouts | undefined;
    private _topics?;
    /**
     * @stability stable
     */
    get topics(): SecretManagerSecretTopics[];
    /**
     * @stability stable
     */
    set topics(value: SecretManagerSecretTopics[]);
    /**
     * @stability stable
     */
    resetTopics(): void;
    /**
     * @stability stable
     */
    get topicsInput(): SecretManagerSecretTopics[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
