import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceAccountIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#members ServiceAccountIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#role ServiceAccountIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#service_account_id ServiceAccountIamBinding#service_account_id}.
     *
     * @stability stable
     */
    readonly serviceAccountId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#condition ServiceAccountIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: ServiceAccountIamBindingCondition;
}
/**
 * @stability stable
 */
export interface ServiceAccountIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#description ServiceAccountIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#expression ServiceAccountIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#title ServiceAccountIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function serviceAccountIamBindingConditionToTerraform(struct?: ServiceAccountIamBindingConditionOutputReference | ServiceAccountIamBindingCondition): any;
/**
 * @stability stable
 */
export declare class ServiceAccountIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceAccountIamBindingCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceAccountIamBindingCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding google_service_account_iam_binding}.
 *
 * @stability stable
 */
export declare class ServiceAccountIamBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding google_service_account_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceAccountIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _serviceAccountId?;
    /**
     * @stability stable
     */
    get serviceAccountId(): string;
    /**
     * @stability stable
     */
    set serviceAccountId(value: string);
    /**
     * @stability stable
     */
    get serviceAccountIdInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): ServiceAccountIamBindingConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: ServiceAccountIamBindingCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): ServiceAccountIamBindingCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
