"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlobalRestApiProps = exports.DefaultRegionalLambdaRestApiProps = exports.DefaultGlobalLambdaRestApiProps = void 0;
const api = require("@aws-cdk/aws-apigateway");
/**
 * Private function to configure an api.RestApiProps
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultRestApiProps(_endpointType, _logGroup) {
    return {
        endpointConfiguration: {
            types: _endpointType
        },
        cloudWatchRole: false,
        // Configure API Gateway Access logging
        deployOptions: {
            accessLogDestination: new api.LogGroupLogDestination(_logGroup),
            accessLogFormat: api.AccessLogFormat.jsonWithStandardFields(),
            loggingLevel: api.MethodLoggingLevel.INFO,
            dataTraceEnabled: true
        },
        defaultMethodOptions: {
            authorizationType: api.AuthorizationType.IAM
        }
    };
}
/**
 * Provides the default set of properties for Edge/Global Lambda backed RestApi
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultGlobalLambdaRestApiProps(_existingLambdaObj, _logGroup) {
    const defaultGatewayProps = {
        handler: _existingLambdaObj,
        options: DefaultRestApiProps([api.EndpointType.EDGE], _logGroup)
    };
    return defaultGatewayProps;
}
exports.DefaultGlobalLambdaRestApiProps = DefaultGlobalLambdaRestApiProps;
/**
 * Provides the default set of properties for Regional Lambda backed RestApi
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultRegionalLambdaRestApiProps(_existingLambdaObj, _logGroup) {
    const defaultGatewayProps = {
        handler: _existingLambdaObj,
        options: DefaultRestApiProps([api.EndpointType.REGIONAL], _logGroup)
    };
    return defaultGatewayProps;
}
exports.DefaultRegionalLambdaRestApiProps = DefaultRegionalLambdaRestApiProps;
/**
 * Provides the default set of properties for Edge/Global RestApi
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultGlobalRestApiProps(_logGroup) {
    return DefaultRestApiProps([api.EndpointType.EDGE], _logGroup);
}
exports.DefaultGlobalRestApiProps = DefaultGlobalRestApiProps;
//# sourceMappingURL=data:application/json;base64,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