"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
// Imports
const kinesisAnalytics = require("@aws-cdk/aws-kinesisanalytics");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1hbmFseXRpY3MtaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsia2luZXNpcy1hbmFseXRpY3MtaGVscGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUYsVUFBVTtBQUNWLGtFQUFrRTtBQUVsRSx3Q0FBd0M7QUFDeEMseURBQXlEO0FBRXpELG1DQUF3QztBQWlCeEMsU0FBZ0Isd0JBQXdCLENBQUMsS0FBb0IsRUFBRSxLQUFvQztJQUVoRywyQ0FBMkM7SUFDM0MsTUFBTSxhQUFhLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRTtRQUM5RCxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsZ0NBQWdDLENBQUM7S0FDeEUsQ0FBQyxDQUFDO0lBRUgsNkNBQTZDO0lBQzdDLE1BQU0sZUFBZSxHQUFHLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLEVBQUU7UUFDcEUsVUFBVSxFQUFFO1lBQ1osSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUNwQixPQUFPLEVBQUU7b0JBQ0wsaUNBQWlDO29CQUNqQyxlQUFlO2lCQUNsQjtnQkFDRCxTQUFTLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQzthQUM3QyxDQUFDO1NBQ0w7S0FBQyxDQUFDLENBQUM7SUFFSix3QkFBd0I7SUFDeEIsZUFBZSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUU1QywyQ0FBMkM7SUFDM0MsTUFBTSxxQkFBcUIsR0FBRyxxQkFBYSxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUM5RyxxQkFBcUIsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsb0JBQW9CLEdBQUc7UUFDbkQsV0FBVyxFQUFFLEtBQUssQ0FBQyxlQUFlLENBQUMsT0FBTztRQUMxQyxPQUFPLEVBQUUsYUFBYSxDQUFDLE9BQU87S0FDakMsQ0FBQztJQUVGLHFEQUFxRDtJQUNyRCxNQUFNLG1CQUFtQixHQUFHLElBQUksZ0JBQWdCLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDO0lBQ2xILG1CQUFtQixDQUFDLFlBQVksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQWtCLENBQUMsQ0FBQztJQUU5RixvQ0FBb0M7SUFDcEMsT0FBTyxtQkFBbUIsQ0FBQztBQUMvQixDQUFDO0FBbkNBLDREQW1DQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDE5IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuIC8vIEltcG9ydHNcbiBpbXBvcnQgKiBhcyBraW5lc2lzQW5hbHl0aWNzIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzYW5hbHl0aWNzJztcbiBpbXBvcnQgKiBhcyBraW5lc2lzRmlyZWhvc2UgZnJvbSAnQGF3cy1jZGsvYXdzLWtpbmVzaXNmaXJlaG9zZSc7XG4gaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuIGltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJy4va2luZXNpcy1hbmFseXRpY3MtZGVmYXVsdHMnO1xuIGltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbiBpbXBvcnQgeyBvdmVycmlkZVByb3BzIH0gZnJvbSAnLi91dGlscyc7XG5cbiBleHBvcnQgaW50ZXJmYWNlIEJ1aWxkS2luZXNpc0FuYWx5dGljc0FwcFByb3BzIHtcbiAgICAvKipcbiAgICAgKiBBIEtpbmVzaXMgRGF0YSBGaXJlaG9zZSBmb3IgdGhlIEtpbmVzaXMgU3RyZWFtcyBhcHBsaWNhdGlvbiB0byBjb25uZWN0IHRvLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAgICovXG4gICAgcmVhZG9ubHkga2luZXNpc0ZpcmVob3NlOiBraW5lc2lzRmlyZWhvc2UuQ2ZuRGVsaXZlcnlTdHJlYW1cbiAgIC8qKlxuICAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wcyBmb3IgdGhlIEtpbmVzaXMgYW5hbHl0aWNzIGFwcC5cbiAgICAqXG4gICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICAqL1xuICAgcmVhZG9ubHkga2luZXNpc0FuYWx5dGljc1Byb3BzPzoga2luZXNpc0FuYWx5dGljcy5DZm5BcHBsaWNhdGlvblByb3BzIHwgYW55XG4gfVxuXG4gZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkS2luZXNpc0FuYWx5dGljc0FwcChzY29wZTogY2RrLkNvbnN0cnVjdCwgcHJvcHM6IEJ1aWxkS2luZXNpc0FuYWx5dGljc0FwcFByb3BzKToga2luZXNpc0FuYWx5dGljcy5DZm5BcHBsaWNhdGlvbiB7XG5cbiAgICAvLyBTZXR1cCB0aGUgSUFNIHJvbGUgZm9yIEtpbmVzaXMgQW5hbHl0aWNzXG4gICAgY29uc3QgYW5hbHl0aWNzUm9sZSA9IG5ldyBpYW0uUm9sZShzY29wZSwgJ0tpbmVzaXNBbmFseXRpY3NSb2xlJywge1xuICAgICAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgna2luZXNpc2FuYWx5dGljcy5hbWF6b25hd3MuY29tJyksXG4gICAgfSk7XG5cbiAgICAvLyBTZXR1cCB0aGUgSUFNIHBvbGljeSBmb3IgS2luZXNpcyBBbmFseXRpY3NcbiAgICBjb25zdCBhbmFseXRpY3NQb2xpY3kgPSBuZXcgaWFtLlBvbGljeShzY29wZSwgJ0tpbmVzaXNBbmFseXRpY3NQb2xpY3knLCB7XG4gICAgICAgIHN0YXRlbWVudHM6IFtcbiAgICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICAgICAgICdmaXJlaG9zZTpEZXNjcmliZURlbGl2ZXJ5U3RyZWFtJyxcbiAgICAgICAgICAgICAgICAnZmlyZWhvc2U6R2V0KidcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgICByZXNvdXJjZXM6IFtwcm9wcy5raW5lc2lzRmlyZWhvc2UuYXR0ckFybl1cbiAgICAgICAgfSlcbiAgICBdfSk7XG5cbiAgICAvLyBBdHRhY2ggcG9saWN5IHRvIHJvbGVcbiAgICBhbmFseXRpY3NQb2xpY3kuYXR0YWNoVG9Sb2xlKGFuYWx5dGljc1JvbGUpO1xuXG4gICAgLy8gU2V0dXAgdGhlIEtpbmVzaXMgYXBwbGljYXRpb24gcHJvcGVydGllc1xuICAgIGNvbnN0IGtpbmVzaXNBbmFseXRpY3NQcm9wcyA9IG92ZXJyaWRlUHJvcHMoZGVmYXVsdHMuRGVmYXVsdENmbkFwcGxpY2F0aW9uUHJvcHMsIHByb3BzLmtpbmVzaXNBbmFseXRpY3NQcm9wcyk7XG4gICAga2luZXNpc0FuYWx5dGljc1Byb3BzLmlucHV0c1swXS5raW5lc2lzRmlyZWhvc2VJbnB1dCA9IHtcbiAgICAgICAgcmVzb3VyY2VBcm46IHByb3BzLmtpbmVzaXNGaXJlaG9zZS5hdHRyQXJuLFxuICAgICAgICByb2xlQXJuOiBhbmFseXRpY3NSb2xlLnJvbGVBcm5cbiAgICB9O1xuXG4gICAgLy8gU2V0dXAgdGhlIEtpbmVzaXMgYXBwbGljYXRpb24gYW5kIGFkZCBkZXBlbmRlbmNpZXNcbiAgICBjb25zdCBraW5lc2lzQW5hbHl0aWNzQXBwID0gbmV3IGtpbmVzaXNBbmFseXRpY3MuQ2ZuQXBwbGljYXRpb24oc2NvcGUsICdLaW5lc2lzQW5hbHl0aWNzJywga2luZXNpc0FuYWx5dGljc1Byb3BzKTtcbiAgICBraW5lc2lzQW5hbHl0aWNzQXBwLmFkZERlcGVuZHNPbihhbmFseXRpY3NQb2xpY3kubm9kZS5maW5kQ2hpbGQoJ1Jlc291cmNlJykgYXMgaWFtLkNmblBvbGljeSk7XG5cbiAgICAvLyBDcmVhdGUgdGhlIGFwcGxpY2F0aW9uIGFuZCByZXR1cm5cbiAgICByZXR1cm4ga2luZXNpc0FuYWx5dGljc0FwcDtcbn0iXX0=