"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDeliveryStreamProps = void 0;
function DefaultCfnDeliveryStreamProps(_bucketArn, _roleArn, _logGroupName, _logStreamName) {
    return {
        extendedS3DestinationConfiguration: {
            bucketArn: _bucketArn,
            bufferingHints: {
                intervalInSeconds: 300,
                sizeInMBs: 5
            },
            compressionFormat: 'GZIP',
            roleArn: _roleArn,
            cloudWatchLoggingOptions: {
                enabled: true,
                logGroupName: _logGroupName,
                logStreamName: _logStreamName
            }
        }
    };
}
exports.DefaultCfnDeliveryStreamProps = DefaultCfnDeliveryStreamProps;
//# sourceMappingURL=data:application/json;base64,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