"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEncryptionKey = void 0;
// Imports
const kms = require("@aws-cdk/aws-kms");
const kms_defaults_1 = require("./kms-defaults");
const utils_1 = require("./utils");
function buildEncryptionKey(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the key properties
    let encryptionKeyProps;
    if (props.encryptionKeyProps) {
        // If property overrides have been provided, incorporate them and deploy
        encryptionKeyProps = utils_1.overrideProps(kms_defaults_1.DefaultEncryptionProps, props.encryptionKeyProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        encryptionKeyProps = kms_defaults_1.DefaultEncryptionProps;
    }
    // Create the encryption key and return
    return new kms.Key(scope, 'EncryptionKey', encryptionKeyProps);
}
exports.buildEncryptionKey = buildEncryptionKey;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zLWhlbHBlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImttcy1oZWxwZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOzs7QUFFSCxVQUFVO0FBQ1Ysd0NBQXdDO0FBQ3hDLGlEQUF3RDtBQUV4RCxtQ0FBd0M7QUFXeEMsU0FBZ0Isa0JBQWtCLENBQUMsS0FBb0IsRUFBRSxLQUErQjtJQUNwRixtQ0FBbUM7SUFDbkMsS0FBSyxHQUFHLENBQUMsS0FBSyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztJQUMzQywyQkFBMkI7SUFDM0IsSUFBSSxrQkFBa0IsQ0FBQztJQUN2QixJQUFJLEtBQUssQ0FBQyxrQkFBa0IsRUFBRTtRQUMxQix3RUFBd0U7UUFDeEUsa0JBQWtCLEdBQUcscUJBQWEsQ0FBQyxxQ0FBc0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsQ0FBQztLQUN4RjtTQUFNO1FBQ0gsbUVBQW1FO1FBQ25FLGtCQUFrQixHQUFHLHFDQUFzQixDQUFDO0tBQy9DO0lBQ0QsdUNBQXVDO0lBQ3ZDLE9BQU8sSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxlQUFlLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztBQUNuRSxDQUFDO0FBZEQsZ0RBY0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAxOSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbi8vIEltcG9ydHNcbmltcG9ydCAqIGFzIGttcyBmcm9tICdAYXdzLWNkay9hd3Mta21zJztcbmltcG9ydCB7IERlZmF1bHRFbmNyeXB0aW9uUHJvcHMgfSBmcm9tICcuL2ttcy1kZWZhdWx0cyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBvdmVycmlkZVByb3BzIH0gZnJvbSAnLi91dGlscyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQnVpbGRFbmNyeXB0aW9uS2V5UHJvcHMge1xuICAgIC8qKlxuICAgICAqIE9wdGlvbmFsIHVzZXItcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBlbmNyeXB0aW9uIGtleS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmNyeXB0aW9uS2V5UHJvcHM/OiBrbXMuS2V5UHJvcHMgfCBhbnlcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGJ1aWxkRW5jcnlwdGlvbktleShzY29wZTogY2RrLkNvbnN0cnVjdCwgcHJvcHM/OiBCdWlsZEVuY3J5cHRpb25LZXlQcm9wcyk6IGttcy5LZXkge1xuICAgIC8vIElmIHByb3BzIGlzIHVuZGVmaW5lZCwgZGVmaW5lIGl0XG4gICAgcHJvcHMgPSAocHJvcHMgPT09IHVuZGVmaW5lZCkgPyB7fSA6IHByb3BzO1xuICAgIC8vIFNldHVwIHRoZSBrZXkgcHJvcGVydGllc1xuICAgIGxldCBlbmNyeXB0aW9uS2V5UHJvcHM7XG4gICAgaWYgKHByb3BzLmVuY3J5cHRpb25LZXlQcm9wcykge1xuICAgICAgICAvLyBJZiBwcm9wZXJ0eSBvdmVycmlkZXMgaGF2ZSBiZWVuIHByb3ZpZGVkLCBpbmNvcnBvcmF0ZSB0aGVtIGFuZCBkZXBsb3lcbiAgICAgICAgZW5jcnlwdGlvbktleVByb3BzID0gb3ZlcnJpZGVQcm9wcyhEZWZhdWx0RW5jcnlwdGlvblByb3BzLCBwcm9wcy5lbmNyeXB0aW9uS2V5UHJvcHMpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIC8vIElmIG5vIHByb3BlcnR5IG92ZXJyaWRlcywgZGVwbG95IHVzaW5nIHRoZSBkZWZhdWx0IGNvbmZpZ3VyYXRpb25cbiAgICAgICAgZW5jcnlwdGlvbktleVByb3BzID0gRGVmYXVsdEVuY3J5cHRpb25Qcm9wcztcbiAgICB9XG4gICAgLy8gQ3JlYXRlIHRoZSBlbmNyeXB0aW9uIGtleSBhbmQgcmV0dXJuXG4gICAgcmV0dXJuIG5ldyBrbXMuS2V5KHNjb3BlLCAnRW5jcnlwdGlvbktleScsIGVuY3J5cHRpb25LZXlQcm9wcyk7XG59Il19