"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSourceProps = exports.DynamoEventSourceProps = exports.DefaultKinesisEventSourceProps = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const s3 = require("@aws-cdk/aws-s3");
function DefaultKinesisEventSourceProps(_eventSourceArn) {
    const defaultEventSourceProps = {
        eventSourceArn: _eventSourceArn
    };
    return defaultEventSourceProps;
}
exports.DefaultKinesisEventSourceProps = DefaultKinesisEventSourceProps;
function DynamoEventSourceProps(_dynamoEventSourceProps) {
    const defaultDynamoEventSourceProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON
    };
    if (_dynamoEventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
//# sourceMappingURL=data:application/json;base64,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