"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildTopic = void 0;
// Imports
const sns = require("@aws-cdk/aws-sns");
const sns_defaults_1 = require("./sns-defaults");
const kms_helper_1 = require("./kms-helper");
const utils_1 = require("./utils");
function buildTopic(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the topic properties
    let snsTopicProps;
    if (props.hasOwnProperty('topicProps')) {
        // If property overrides have been provided, incorporate them and deploy
        snsTopicProps = utils_1.overrideProps(sns_defaults_1.DefaultSnsTopicProps, props.topicProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        snsTopicProps = sns_defaults_1.DefaultSnsTopicProps;
    }
    // Set encryption properties
    if (!props.enableEncryption || props.enableEncryption === true) {
        if (props.encryptionKey) {
            snsTopicProps.masterKey = props.encryptionKey;
        }
        else {
            snsTopicProps.masterKey = kms_helper_1.buildEncryptionKey(scope);
        }
    }
    // Create the stream and return
    return new sns.Topic(scope, 'SnsTopic', snsTopicProps);
}
exports.buildTopic = buildTopic;
//# sourceMappingURL=data:application/json;base64,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