"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDeadLetterQueue = exports.deployQueue = exports.buildQueue = void 0;
// Imports
const sqs = require("@aws-cdk/aws-sqs");
const defaults = require("./sqs-defaults");
const utils_1 = require("./utils");
function buildQueue(scope, id, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Conditional queue creation
    // If an existingQueueObj is not specified
    if (!props.existingQueueObj) {
        // Deploy the queue
        return deployQueue(scope, id, props.queueProps, props.deadLetterQueue);
        // If an existingQueueObj is specified, return that object as the queue to be used
    }
    else {
        return props.existingQueueObj;
    }
}
exports.buildQueue = buildQueue;
function deployQueue(scope, id, queuePropsParam, deadLetterQueueParam) {
    // Setup the queue
    let queueProps;
    if (queuePropsParam) {
        // If property overrides have been provided, incorporate them and deploy
        queueProps = utils_1.overrideProps(defaults.DefaultQueueProps(), queuePropsParam);
    }
    else {
        // If no property overrides, deploy using the default configuration
        queueProps = defaults.DefaultQueueProps();
    }
    // Determine whether a DLQ property should be added
    if (deadLetterQueueParam) {
        queueProps.deadLetterQueue = deadLetterQueueParam;
    }
    // Return the queue
    return new sqs.Queue(scope, id, queueProps);
}
exports.deployQueue = deployQueue;
function buildDeadLetterQueue(props) {
    const mrc = (props.maxReceiveCount) ? props.maxReceiveCount : defaults.defaultMaxReceiveCount;
    // Setup the queue interface
    const dlq = {
        maxReceiveCount: mrc,
        queue: props.deadLetterQueue
    };
    // Return the dead letter queue
    return dlq;
}
exports.buildDeadLetterQueue = buildDeadLetterQueue;
//# sourceMappingURL=data:application/json;base64,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