"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const kinesisanalytics = require("@aws-cdk/aws-kinesisanalytics");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('snapshot test kinesisanalytics default params', () => {
    const stack = new core_1.Stack();
    new kinesisanalytics.CfnApplication(stack, 'KinesisAnalytics', defaults.DefaultCfnApplicationProps);
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test kinesisanalytics override inputProperty', () => {
    const stack = new core_1.Stack();
    const inputProperty = {
        inputSchema: {
            recordColumns: [{ name: 'x', sqlType: 'y' }],
            recordFormat: { recordFormatType: 'csv' }
        },
        namePrefix: 'zzz'
    };
    const defaultProps = defaults.DefaultCfnApplicationProps;
    const inProps = {
        inputs: [inputProperty]
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new kinesisanalytics.CfnApplication(stack, 'KinesisAnalytics', outProps);
    expect(stack).toHaveResource("AWS::KinesisAnalytics::Application", {
        Inputs: [
            {
                InputSchema: {
                    RecordColumns: [
                        {
                            Name: "x",
                            SqlType: "y"
                        }
                    ],
                    RecordFormat: {
                        RecordFormatType: "csv"
                    }
                },
                NamePrefix: "zzz"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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