"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const defaults = require("../index");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
require("@aws-cdk/assert/jest");
test('test DynamoEventSourceProps', () => {
    const props = defaults.DynamoEventSourceProps();
    expect(props).toEqual({
        startingPosition: "TRIM_HORIZON"
    });
});
test('test DynamoEventSourceProps override', () => {
    const myProps = {
        startingPosition: lambda.StartingPosition.LATEST,
        batchSize: 1
    };
    const props = defaults.DynamoEventSourceProps(myProps);
    expect(props).toEqual({
        batchSize: 1,
        startingPosition: "LATEST"
    });
});
test('test KinesisEventSourceProps', () => {
    const streamArn = 'xyz';
    const props = defaults.DefaultKinesisEventSourceProps(streamArn);
    expect(props).toEqual({
        eventSourceArn: "xyz"
    });
});
test('test S3EventSourceProps w/ default props', () => {
    const props = defaults.S3EventSourceProps();
    expect(props).toEqual({
        events: ["s3:ObjectCreated:*"]
    });
});
test('test S3EventSourceProps w/ user props', () => {
    const s3EventSourceProps = {
        events: [
            s3.EventType.OBJECT_CREATED_POST
        ]
    };
    const props = defaults.S3EventSourceProps(s3EventSourceProps);
    expect(props).toEqual({
        events: ["s3:ObjectCreated:Post"]
    });
});
//# sourceMappingURL=data:application/json;base64,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