import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApigeeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#description ApigeeInstance#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Customer Managed Encryption Key (CMEK) used for disk and volume encryption.
     *
     * Required for Apigee paid subscriptions only.
     * Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#disk_encryption_key_name ApigeeInstance#disk_encryption_key_name}
     *
     * @stability stable
     */
    readonly diskEncryptionKeyName?: string;
    /**
     * Display name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#display_name ApigeeInstance#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Compute Engine location where the instance resides.
     *
     * For trial organization
     * subscriptions, the location must be a Compute Engine zone. For paid organization
     * subscriptions, it should correspond to a Compute Engine region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#location ApigeeInstance#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Resource ID of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#name ApigeeInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The Apigee Organization associated with the Apigee instance, in the format 'organizations/{{org_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#org_id ApigeeInstance#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * The size of the CIDR block range that will be reserved by the instance. Possible values: ["SLASH_16", "SLASH_20", "SLASH_22"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#peering_cidr_range ApigeeInstance#peering_cidr_range}
     *
     * @stability stable
     */
    readonly peeringCidrRange?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#timeouts ApigeeInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApigeeInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface ApigeeInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#create ApigeeInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html#delete ApigeeInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ApigeeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html google_apigee_instance}.
 *
 * @stability stable
 */
export declare class ApigeeInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_instance.html google_apigee_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApigeeInstanceConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _diskEncryptionKeyName?;
    /**
     * @stability stable
     */
    get diskEncryptionKeyName(): string | undefined;
    /**
     * @stability stable
     */
    set diskEncryptionKeyName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskEncryptionKeyName(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyNameInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _peeringCidrRange?;
    /**
     * @stability stable
     */
    get peeringCidrRange(): string | undefined;
    /**
     * @stability stable
     */
    set peeringCidrRange(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeeringCidrRange(): void;
    /**
     * @stability stable
     */
    get peeringCidrRangeInput(): string | undefined;
    /**
     * @stability stable
     */
    get port(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ApigeeInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApigeeInstanceTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApigeeInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
