import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#description ComputeDisk#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The image from which to initialize this disk.
     *
     * This can be
     * one of: the image's 'self_link', 'projects/{project}/global/images/{image}',
     * 'projects/{project}/global/images/family/{family}', 'global/images/{image}',
     * 'global/images/family/{family}', 'family/{family}', '{project}/{family}',
     * '{project}/{image}', '{family}', or '{image}'. If referred by family, the
     * images names must include the family name. If they don't, use the
     * [google_compute_image data source](/docs/providers/google/d/compute_image.html).
     * For instance, the image 'centos-6-v20180104' includes its family name 'centos-6'.
     * These images can be referred by family name here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#image ComputeDisk#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Labels to apply to this disk.  A list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#labels ComputeDisk#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#name ComputeDisk#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Physical block size of the persistent disk, in bytes.
     *
     * If not present
     * in a request, a default value is used. Currently supported sizes
     * are 4096 and 16384, other sizes may be added in the future.
     * If an unsupported value is requested, the error message will list
     * the supported values for the caller's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#physical_block_size_bytes ComputeDisk#physical_block_size_bytes}
     *
     * @stability stable
     */
    readonly physicalBlockSizeBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#project ComputeDisk#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Indicates how many IOPS must be provisioned for the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#provisioned_iops ComputeDisk#provisioned_iops}
     *
     * @stability stable
     */
    readonly provisionedIops?: number;
    /**
     * Size of the persistent disk, specified in GB.
     *
     * You can specify this
     * field when creating a persistent disk using the 'image' or
     * 'snapshot' parameter, or specify it alone to create an empty
     * persistent disk.
     *
     * If you specify this field along with 'image' or 'snapshot',
     * the value must not be less than the size of the image
     * or the size of the snapshot.
     *
     * ~>**NOTE** If you change the size, Terraform updates the disk size
     * if upsizing is detected but recreates the disk if downsizing is requested.
     * You can add 'lifecycle.prevent_destroy' in the config to prevent destroying
     * and recreating.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#size ComputeDisk#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * The source snapshot used to create this disk.
     *
     * You can provide this as
     * a partial or full URL to the resource. If the snapshot is in another
     * project than this disk, you must supply a full URL. For example, the
     * following are valid values:
     *
     * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
     * 'projects/project/global/snapshots/snapshot'
     * 'global/snapshots/snapshot'
     * 'snapshot'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#snapshot ComputeDisk#snapshot}
     *
     * @stability stable
     */
    readonly snapshot?: string;
    /**
     * URL of the disk type resource describing which disk type to use to create the disk.
     *
     * Provide this when creating the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#type ComputeDisk#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * A reference to the zone where the disk resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#zone ComputeDisk#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#disk_encryption_key ComputeDisk#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: ComputeDiskDiskEncryptionKey;
    /**
     * source_image_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#source_image_encryption_key ComputeDisk#source_image_encryption_key}
     *
     * @stability stable
     */
    readonly sourceImageEncryptionKey?: ComputeDiskSourceImageEncryptionKey;
    /**
     * source_snapshot_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#source_snapshot_encryption_key ComputeDisk#source_snapshot_encryption_key}
     *
     * @stability stable
     */
    readonly sourceSnapshotEncryptionKey?: ComputeDiskSourceSnapshotEncryptionKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#timeouts ComputeDisk#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeDiskTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeDiskDiskEncryptionKey {
    /**
     * The self link of the encryption key used to encrypt the disk.
     *
     * Also called KmsKeyName
     * in the cloud console. Your project's Compute Engine System service account
     * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
     * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
     * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_self_link ComputeDisk#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_service_account ComputeDisk#kms_key_service_account}
     *
     * @stability stable
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#raw_key ComputeDisk#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
/**
 * @stability stable
 */
export declare class ComputeDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyServiceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyServiceAccount(): void;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string | undefined;
    /**
     * @stability stable
     */
    set rawKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeDiskSourceImageEncryptionKey {
    /**
     * The self link of the encryption key used to encrypt the disk.
     *
     * Also called KmsKeyName
     * in the cloud console. Your project's Compute Engine System service account
     * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
     * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
     * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_self_link ComputeDisk#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_service_account ComputeDisk#kms_key_service_account}
     *
     * @stability stable
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#raw_key ComputeDisk#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
/**
 * @stability stable
 */
export declare class ComputeDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyServiceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyServiceAccount(): void;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string | undefined;
    /**
     * @stability stable
     */
    set rawKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeDiskSourceSnapshotEncryptionKey {
    /**
     * The self link of the encryption key used to encrypt the disk.
     *
     * Also called KmsKeyName
     * in the cloud console. Your project's Compute Engine System service account
     * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
     * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
     * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_self_link ComputeDisk#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#kms_key_service_account ComputeDisk#kms_key_service_account}
     *
     * @stability stable
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#raw_key ComputeDisk#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
/**
 * @stability stable
 */
export declare class ComputeDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyServiceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyServiceAccount(): void;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string | undefined;
    /**
     * @stability stable
     */
    set rawKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#create ComputeDisk#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#delete ComputeDisk#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html#update ComputeDisk#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html google_compute_disk}.
 *
 * @stability stable
 */
export declare class ComputeDisk extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_disk.html google_compute_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeDiskConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _image?;
    /**
     * @stability stable
     */
    get image(): string | undefined;
    /**
     * @stability stable
     */
    set image(value: string | undefined);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get lastAttachTimestamp(): string;
    /**
     * @stability stable
     */
    get lastDetachTimestamp(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    /**
     * @stability stable
     */
    get physicalBlockSizeBytes(): number | undefined;
    /**
     * @stability stable
     */
    set physicalBlockSizeBytes(value: number | undefined);
    /**
     * @stability stable
     */
    resetPhysicalBlockSizeBytes(): void;
    /**
     * @stability stable
     */
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _provisionedIops?;
    /**
     * @stability stable
     */
    get provisionedIops(): number | undefined;
    /**
     * @stability stable
     */
    set provisionedIops(value: number | undefined);
    /**
     * @stability stable
     */
    resetProvisionedIops(): void;
    /**
     * @stability stable
     */
    get provisionedIopsInput(): number | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number | undefined;
    /**
     * @stability stable
     */
    set size(value: number | undefined);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _snapshot?;
    /**
     * @stability stable
     */
    get snapshot(): string | undefined;
    /**
     * @stability stable
     */
    set snapshot(value: string | undefined);
    /**
     * @stability stable
     */
    resetSnapshot(): void;
    /**
     * @stability stable
     */
    get snapshotInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    get sourceSnapshotId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get users(): string[];
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string | undefined;
    /**
     * @stability stable
     */
    set zone(value: string | undefined);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _diskEncryptionKey?;
    private __diskEncryptionKeyOutput;
    /**
     * @stability stable
     */
    get diskEncryptionKey(): ComputeDiskDiskEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putDiskEncryptionKey(value: ComputeDiskDiskEncryptionKey | undefined): void;
    /**
     * @stability stable
     */
    resetDiskEncryptionKey(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyInput(): ComputeDiskDiskEncryptionKey | undefined;
    private _sourceImageEncryptionKey?;
    private __sourceImageEncryptionKeyOutput;
    /**
     * @stability stable
     */
    get sourceImageEncryptionKey(): ComputeDiskSourceImageEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putSourceImageEncryptionKey(value: ComputeDiskSourceImageEncryptionKey | undefined): void;
    /**
     * @stability stable
     */
    resetSourceImageEncryptionKey(): void;
    /**
     * @stability stable
     */
    get sourceImageEncryptionKeyInput(): ComputeDiskSourceImageEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey?;
    private __sourceSnapshotEncryptionKeyOutput;
    /**
     * @stability stable
     */
    get sourceSnapshotEncryptionKey(): ComputeDiskSourceSnapshotEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putSourceSnapshotEncryptionKey(value: ComputeDiskSourceSnapshotEncryptionKey | undefined): void;
    /**
     * @stability stable
     */
    resetSourceSnapshotEncryptionKey(): void;
    /**
     * @stability stable
     */
    get sourceSnapshotEncryptionKeyInput(): ComputeDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeDiskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeDiskTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
