# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'ClientAddons',
    'ClientAddonsSamlp',
    'ClientAddonsSamlpLogout',
    'ClientJwtConfiguration',
    'ClientMobile',
    'ClientMobileAndroid',
    'ClientMobileIos',
    'ConnectionOptions',
    'ConnectionOptionsPasswordComplexityOptions',
    'ConnectionOptionsPasswordDictionary',
    'ConnectionOptionsPasswordHistory',
    'ConnectionOptionsPasswordNoPersonalInfo',
    'ConnectionOptionsTotp',
    'CustomDomainVerification',
    'EmailCredentials',
    'GlobalClientAddons',
    'GlobalClientAddonsSamlp',
    'GlobalClientAddonsSamlpLogout',
    'GlobalClientJwtConfiguration',
    'GlobalClientMobile',
    'GlobalClientMobileAndroid',
    'GlobalClientMobileIos',
    'ResourceServerScope',
    'RolePermission',
    'TenantChangePassword',
    'TenantErrorPage',
    'TenantFlags',
    'TenantGuardianMfaPage',
    'TenantUniversalLogin',
    'TenantUniversalLoginColors',
]

@pulumi.output_type
class ClientAddons(dict):
    def __init__(__self__, *,
                 aws: Optional[Mapping[str, Any]] = None,
                 azure_blob: Optional[Mapping[str, Any]] = None,
                 azure_sb: Optional[Mapping[str, Any]] = None,
                 box: Optional[Mapping[str, Any]] = None,
                 cloudbees: Optional[Mapping[str, Any]] = None,
                 concur: Optional[Mapping[str, Any]] = None,
                 dropbox: Optional[Mapping[str, Any]] = None,
                 echosign: Optional[Mapping[str, Any]] = None,
                 egnyte: Optional[Mapping[str, Any]] = None,
                 firebase: Optional[Mapping[str, Any]] = None,
                 layer: Optional[Mapping[str, Any]] = None,
                 mscrm: Optional[Mapping[str, Any]] = None,
                 newrelic: Optional[Mapping[str, Any]] = None,
                 office365: Optional[Mapping[str, Any]] = None,
                 rms: Optional[Mapping[str, Any]] = None,
                 salesforce: Optional[Mapping[str, Any]] = None,
                 salesforce_api: Optional[Mapping[str, Any]] = None,
                 salesforce_sandbox_api: Optional[Mapping[str, Any]] = None,
                 samlp: Optional['outputs.ClientAddonsSamlp'] = None,
                 sap_api: Optional[Mapping[str, Any]] = None,
                 sentry: Optional[Mapping[str, Any]] = None,
                 sharepoint: Optional[Mapping[str, Any]] = None,
                 slack: Optional[Mapping[str, Any]] = None,
                 springcm: Optional[Mapping[str, Any]] = None,
                 wams: Optional[Mapping[str, Any]] = None,
                 wsfed: Optional[Mapping[str, Any]] = None,
                 zendesk: Optional[Mapping[str, Any]] = None,
                 zoom: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] aws: String
        :param Mapping[str, Any] azure_blob: String
        :param Mapping[str, Any] azure_sb: String
        :param Mapping[str, Any] box: String
        :param Mapping[str, Any] cloudbees: String
        :param Mapping[str, Any] concur: String
        :param Mapping[str, Any] dropbox: String
        :param Mapping[str, Any] echosign: String
        :param Mapping[str, Any] egnyte: String
        :param Mapping[str, Any] firebase: String
        :param Mapping[str, Any] layer: String
        :param Mapping[str, Any] mscrm: String
        :param Mapping[str, Any] newrelic: String
        :param Mapping[str, Any] office365: String
        :param Mapping[str, Any] rms: String
        :param Mapping[str, Any] salesforce: String
        :param Mapping[str, Any] salesforce_api: String
        :param Mapping[str, Any] salesforce_sandbox_api: String
        :param 'ClientAddonsSamlpArgs' samlp: List(Resource). Configuration settings for a SAML add-on. For details, see SAML.
        :param Mapping[str, Any] sap_api: String
        :param Mapping[str, Any] sentry: String
        :param Mapping[str, Any] sharepoint: String
        :param Mapping[str, Any] slack: String
        :param Mapping[str, Any] springcm: String
        :param Mapping[str, Any] wams: String
        :param Mapping[str, Any] wsfed: String
        :param Mapping[str, Any] zendesk: String
        :param Mapping[str, Any] zoom: String
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_blob is not None:
            pulumi.set(__self__, "azure_blob", azure_blob)
        if azure_sb is not None:
            pulumi.set(__self__, "azure_sb", azure_sb)
        if box is not None:
            pulumi.set(__self__, "box", box)
        if cloudbees is not None:
            pulumi.set(__self__, "cloudbees", cloudbees)
        if concur is not None:
            pulumi.set(__self__, "concur", concur)
        if dropbox is not None:
            pulumi.set(__self__, "dropbox", dropbox)
        if echosign is not None:
            pulumi.set(__self__, "echosign", echosign)
        if egnyte is not None:
            pulumi.set(__self__, "egnyte", egnyte)
        if firebase is not None:
            pulumi.set(__self__, "firebase", firebase)
        if layer is not None:
            pulumi.set(__self__, "layer", layer)
        if mscrm is not None:
            pulumi.set(__self__, "mscrm", mscrm)
        if newrelic is not None:
            pulumi.set(__self__, "newrelic", newrelic)
        if office365 is not None:
            pulumi.set(__self__, "office365", office365)
        if rms is not None:
            pulumi.set(__self__, "rms", rms)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if salesforce_api is not None:
            pulumi.set(__self__, "salesforce_api", salesforce_api)
        if salesforce_sandbox_api is not None:
            pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        if samlp is not None:
            pulumi.set(__self__, "samlp", samlp)
        if sap_api is not None:
            pulumi.set(__self__, "sap_api", sap_api)
        if sentry is not None:
            pulumi.set(__self__, "sentry", sentry)
        if sharepoint is not None:
            pulumi.set(__self__, "sharepoint", sharepoint)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if springcm is not None:
            pulumi.set(__self__, "springcm", springcm)
        if wams is not None:
            pulumi.set(__self__, "wams", wams)
        if wsfed is not None:
            pulumi.set(__self__, "wsfed", wsfed)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)
        if zoom is not None:
            pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlp(self) -> Optional['outputs.ClientAddonsSamlp']:
        """
        List(Resource). Configuration settings for a SAML add-on. For details, see SAML.
        """
        return pulumi.get(self, "samlp")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Optional[Mapping[str, Any]]:
        """
        String
        """
        return pulumi.get(self, "zoom")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientAddonsSamlp(dict):
    def __init__(__self__, *,
                 audience: Optional[str] = None,
                 authn_context_class_ref: Optional[str] = None,
                 binding: Optional[str] = None,
                 create_upn_claim: Optional[bool] = None,
                 destination: Optional[str] = None,
                 digest_algorithm: Optional[str] = None,
                 include_attribute_name_format: Optional[bool] = None,
                 lifetime_in_seconds: Optional[float] = None,
                 logout: Optional['outputs.ClientAddonsSamlpLogout'] = None,
                 map_identities: Optional[bool] = None,
                 map_unknown_claims_as_is: Optional[bool] = None,
                 mappings: Optional[Mapping[str, Any]] = None,
                 name_identifier_format: Optional[str] = None,
                 name_identifier_probes: Optional[List[str]] = None,
                 passthrough_claims_with_no_mapping: Optional[bool] = None,
                 recipient: Optional[str] = None,
                 sign_response: Optional[bool] = None,
                 signature_algorithm: Optional[str] = None,
                 typed_attributes: Optional[bool] = None):
        """
        :param str audience: String. Audience of the SAML Assertion. Default will be the Issuer on SAMLRequest.
        :param str authn_context_class_ref: String. Class reference of the authentication context.
        :param str binding: String. Protocol binding used for SAML logout responses.
        :param bool create_upn_claim: Boolean, (Default=true) Indicates whether or not a UPN claim should be created.
        :param str destination: String. Destination of the SAML Response. If not specified, it will be AssertionConsumerUrlof SAMLRequest or Callback URL if there was no SAMLRequest.
        :param str digest_algorithm: String, (Default=`sha1`). Algorithm used to calculate the digest of the SAML Assertion or response. Options include `defaultsha1` and `sha256`.
        :param bool include_attribute_name_format: Boolean,(Default=true). Indicates whether or not we should infer the NameFormat based on the attribute name. If set to false, the attribute NameFormat is not set in the assertion.
        :param float lifetime_in_seconds: Integer, (Default=3600). Number of seconds during which the token is valid.
        :param 'ClientAddonsSamlpLogoutArgs' logout: Map(Resource). Configuration settings for logout. For details, see Logout.
        :param bool map_identities: Boolean, (Default=true). Indicates whether or not to add additional identity information in the token, such as the provider used and the access_token, if available.
        :param bool map_unknown_claims_as_is: Boolean, (Default=false). Indicates whether or not to add a prefix of `http://schema.auth0.com` to any claims that are not mapped to the common profile when passed through in the output assertion.
        :param Mapping[str, Any] mappings: Map(String). Mappings between the Auth0 user profile property name (`name`) and the output attributes on the SAML attribute in the assertion (`value`).
        :param str name_identifier_format: String, (Default=`urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`). Format of the name identifier.
        :param List[str] name_identifier_probes: List(String). Attributes that can be used for Subject/NameID. Auth0 will try each of the attributes of this array in order and use the first value it finds.
        :param bool passthrough_claims_with_no_mapping: Boolean, (Default=true). Indicates whether or not to passthrough claims that are not mapped to the common profile in the output assertion.
        :param str recipient: String. Recipient of the SAML Assertion (SubjectConfirmationData). Default is AssertionConsumerUrl on SAMLRequest or Callback URL if no SAMLRequest was sent.
        :param bool sign_response: Boolean. Indicates whether or not the SAML Response should be signed instead of the SAML Assertion.
        :param str signature_algorithm: String, (Default=`rsa-sha1`). Algorithm used to sign the SAML Assertion or response. Options include `rsa-sha1` and `rsa-sha256`.
        :param bool typed_attributes: Boolean, (Default=true). Indicates whether or not we should infer the `xs:type` of the element. Types include `xs:string`, `xs:boolean`, `xs:double`, and `xs:anyType`. When set to false, all `xs:type` are `xs:anyType`.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if create_upn_claim is not None:
            pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if include_attribute_name_format is not None:
            pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if logout is not None:
            pulumi.set(__self__, "logout", logout)
        if map_identities is not None:
            pulumi.set(__self__, "map_identities", map_identities)
        if map_unknown_claims_as_is is not None:
            pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if name_identifier_format is not None:
            pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        if name_identifier_probes is not None:
            pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        if passthrough_claims_with_no_mapping is not None:
            pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if sign_response is not None:
            pulumi.set(__self__, "sign_response", sign_response)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if typed_attributes is not None:
            pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        String. Audience of the SAML Assertion. Default will be the Issuer on SAMLRequest.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[str]:
        """
        String. Class reference of the authentication context.
        """
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> Optional[str]:
        """
        String. Protocol binding used for SAML logout responses.
        """
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> Optional[bool]:
        """
        Boolean, (Default=true) Indicates whether or not a UPN claim should be created.
        """
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        String. Destination of the SAML Response. If not specified, it will be AssertionConsumerUrlof SAMLRequest or Callback URL if there was no SAMLRequest.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[str]:
        """
        String, (Default=`sha1`). Algorithm used to calculate the digest of the SAML Assertion or response. Options include `defaultsha1` and `sha256`.
        """
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> Optional[bool]:
        """
        Boolean,(Default=true). Indicates whether or not we should infer the NameFormat based on the attribute name. If set to false, the attribute NameFormat is not set in the assertion.
        """
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[float]:
        """
        Integer, (Default=3600). Number of seconds during which the token is valid.
        """
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Optional['outputs.ClientAddonsSamlpLogout']:
        """
        Map(Resource). Configuration settings for logout. For details, see Logout.
        """
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> Optional[bool]:
        """
        Boolean, (Default=true). Indicates whether or not to add additional identity information in the token, such as the provider used and the access_token, if available.
        """
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> Optional[bool]:
        """
        Boolean, (Default=false). Indicates whether or not to add a prefix of `http://schema.auth0.com` to any claims that are not mapped to the common profile when passed through in the output assertion.
        """
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[Mapping[str, Any]]:
        """
        Map(String). Mappings between the Auth0 user profile property name (`name`) and the output attributes on the SAML attribute in the assertion (`value`).
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> Optional[str]:
        """
        String, (Default=`urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`). Format of the name identifier.
        """
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Optional[List[str]]:
        """
        List(String). Attributes that can be used for Subject/NameID. Auth0 will try each of the attributes of this array in order and use the first value it finds.
        """
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> Optional[bool]:
        """
        Boolean, (Default=true). Indicates whether or not to passthrough claims that are not mapped to the common profile in the output assertion.
        """
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> Optional[str]:
        """
        String. Recipient of the SAML Assertion (SubjectConfirmationData). Default is AssertionConsumerUrl on SAMLRequest or Callback URL if no SAMLRequest was sent.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the SAML Response should be signed instead of the SAML Assertion.
        """
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[str]:
        """
        String, (Default=`rsa-sha1`). Algorithm used to sign the SAML Assertion or response. Options include `rsa-sha1` and `rsa-sha256`.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> Optional[bool]:
        """
        Boolean, (Default=true). Indicates whether or not we should infer the `xs:type` of the element. Types include `xs:string`, `xs:boolean`, `xs:double`, and `xs:anyType`. When set to false, all `xs:type` are `xs:anyType`.
        """
        return pulumi.get(self, "typed_attributes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientAddonsSamlpLogout(dict):
    def __init__(__self__, *,
                 callback: Optional[str] = None,
                 slo_enabled: Optional[bool] = None):
        """
        :param str callback: String. Service provider's Single Logout Service URL, to which Auth0 will send logout requests and responses.
        :param bool slo_enabled: Boolean. Indicates whether or not Auth0 should notify service providers of session termination.
        """
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if slo_enabled is not None:
            pulumi.set(__self__, "slo_enabled", slo_enabled)

    @property
    @pulumi.getter
    def callback(self) -> Optional[str]:
        """
        String. Service provider's Single Logout Service URL, to which Auth0 will send logout requests and responses.
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter(name="sloEnabled")
    def slo_enabled(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not Auth0 should notify service providers of session termination.
        """
        return pulumi.get(self, "slo_enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientJwtConfiguration(dict):
    def __init__(__self__, *,
                 alg: Optional[str] = None,
                 lifetime_in_seconds: Optional[float] = None,
                 scopes: Optional[Mapping[str, str]] = None,
                 secret_encoded: Optional[bool] = None):
        """
        :param str alg: String. Algorithm used to sign JWTs.
        :param float lifetime_in_seconds: Integer. Number of seconds during which the JWT will be valid.
        :param Mapping[str, str] scopes: Map(String). Permissions (scopes) included in JWTs.
        :param bool secret_encoded: Boolean. Indicates whether or not the client secret is base64 encoded.
        """
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_encoded is not None:
            pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> Optional[str]:
        """
        String. Algorithm used to sign JWTs.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[float]:
        """
        Integer. Number of seconds during which the JWT will be valid.
        """
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Mapping[str, str]]:
        """
        Map(String). Permissions (scopes) included in JWTs.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the client secret is base64 encoded.
        """
        return pulumi.get(self, "secret_encoded")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientMobile(dict):
    def __init__(__self__, *,
                 android: Optional['outputs.ClientMobileAndroid'] = None,
                 ios: Optional['outputs.ClientMobileIos'] = None):
        """
        :param 'ClientMobileAndroidArgs' android: List(Resource). Configuration settings for Android native apps. For details, see Android.
        :param 'ClientMobileIosArgs' ios: List(Resource). Configuration settings for i0S native apps. For details, see iOS.
        """
        if android is not None:
            pulumi.set(__self__, "android", android)
        if ios is not None:
            pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def android(self) -> Optional['outputs.ClientMobileAndroid']:
        """
        List(Resource). Configuration settings for Android native apps. For details, see Android.
        """
        return pulumi.get(self, "android")

    @property
    @pulumi.getter
    def ios(self) -> Optional['outputs.ClientMobileIos']:
        """
        List(Resource). Configuration settings for i0S native apps. For details, see iOS.
        """
        return pulumi.get(self, "ios")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientMobileAndroid(dict):
    def __init__(__self__, *,
                 app_package_name: Optional[str] = None,
                 sha256_cert_fingerprints: Optional[List[str]] = None):
        """
        :param str app_package_name: String
        :param List[str] sha256_cert_fingerprints: List(String)
        """
        if app_package_name is not None:
            pulumi.set(__self__, "app_package_name", app_package_name)
        if sha256_cert_fingerprints is not None:
            pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Optional[List[str]]:
        """
        List(String)
        """
        return pulumi.get(self, "sha256_cert_fingerprints")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientMobileIos(dict):
    def __init__(__self__, *,
                 app_bundle_identifier: Optional[str] = None,
                 team_id: Optional[str] = None):
        """
        :param str app_bundle_identifier: String
        :param str team_id: String
        """
        if app_bundle_identifier is not None:
            pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "team_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptions(dict):
    def __init__(__self__, *,
                 adfs_server: Optional[str] = None,
                 allowed_audiences: Optional[List[str]] = None,
                 api_enable_users: Optional[bool] = None,
                 app_domain: Optional[str] = None,
                 app_id: Optional[str] = None,
                 authorization_endpoint: Optional[str] = None,
                 brute_force_protection: Optional[bool] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 community_base_url: Optional[str] = None,
                 configuration: Optional[Mapping[str, str]] = None,
                 custom_scripts: Optional[Mapping[str, str]] = None,
                 disable_cache: Optional[bool] = None,
                 disable_signup: Optional[bool] = None,
                 discovery_url: Optional[str] = None,
                 domain: Optional[str] = None,
                 domain_aliases: Optional[List[str]] = None,
                 enabled_database_customization: Optional[bool] = None,
                 from_: Optional[str] = None,
                 icon_url: Optional[str] = None,
                 identity_api: Optional[str] = None,
                 import_mode: Optional[bool] = None,
                 ips: Optional[List[str]] = None,
                 issuer: Optional[str] = None,
                 jwks_uri: Optional[str] = None,
                 key_id: Optional[str] = None,
                 max_groups_to_retrieve: Optional[str] = None,
                 messaging_service_sid: Optional[str] = None,
                 name: Optional[str] = None,
                 password_complexity_options: Optional['outputs.ConnectionOptionsPasswordComplexityOptions'] = None,
                 password_dictionary: Optional['outputs.ConnectionOptionsPasswordDictionary'] = None,
                 password_histories: Optional[List['outputs.ConnectionOptionsPasswordHistory']] = None,
                 password_no_personal_info: Optional['outputs.ConnectionOptionsPasswordNoPersonalInfo'] = None,
                 password_policy: Optional[str] = None,
                 requires_username: Optional[bool] = None,
                 scopes: Optional[List[str]] = None,
                 strategy_version: Optional[float] = None,
                 subject: Optional[str] = None,
                 syntax: Optional[str] = None,
                 team_id: Optional[str] = None,
                 template: Optional[str] = None,
                 tenant_domain: Optional[str] = None,
                 token_endpoint: Optional[str] = None,
                 totp: Optional['outputs.ConnectionOptionsTotp'] = None,
                 twilio_sid: Optional[str] = None,
                 twilio_token: Optional[str] = None,
                 type: Optional[str] = None,
                 use_cert_auth: Optional[bool] = None,
                 use_kerberos: Optional[bool] = None,
                 use_wsfed: Optional[bool] = None,
                 userinfo_endpoint: Optional[str] = None,
                 validation: Optional[Mapping[str, str]] = None,
                 waad_common_endpoint: Optional[bool] = None,
                 waad_protocol: Optional[str] = None):
        """
        :param str adfs_server: String. ADFS Metadata source.
        :param bool api_enable_users: Boolean.
        :param str app_domain: String. Azure AD domain name.
        :param str app_id: String
        :param str authorization_endpoint: String.
        :param bool brute_force_protection: Boolean. Indicates whether or not to enable brute force protection, which will limit the number of signups and failed logins from a suspicious IP address.
        :param str client_id: String. Client ID given by your OIDC provider.
        :param str client_secret: String, Case-sensitive. Client secret given by your OIDC provider.
        :param str community_base_url: String.
        :param Mapping[str, str] configuration: Map(String), Case-sensitive.
        :param Mapping[str, str] custom_scripts: Map(String).
        :param bool disable_signup: Boolean. Indicates whether or not to allow user sign-ups to your application.
        :param str discovery_url: String. Usually an URL ending with `/.well-known/openid-configuration`
        :param List[str] domain_aliases: List(String). List of the domains that can be authenticated using the Identity Provider. Only needed for Identifier First authentication flows.
        :param bool enabled_database_customization: Boolean.
        :param str from_: String. SMS number for the sender. Used when SMS Source is From.
        :param bool import_mode: Boolean. Indicates whether or not you have a legacy user store and want to gradually migrate those users to the Auth0 user store. [Learn more](https://auth0.com/docs/users/guides/configure-automatic-migration).
        :param str issuer: String. URL of the issuer.
        :param str jwks_uri: String.
        :param str max_groups_to_retrieve: String. Maximum number of groups to retrieve.
        :param str messaging_service_sid: String. SID for Copilot. Used when SMS Source is Copilot.
        :param str name: String.
        :param 'ConnectionOptionsPasswordComplexityOptionsArgs' password_complexity_options: List(Resource). Configuration settings for password complexity. For details, see Password Complexity Options.
        :param 'ConnectionOptionsPasswordDictionaryArgs' password_dictionary: List(Resource). Configuration settings for the password dictionary check, which does not allow passwords that are part of the password dictionary. For details, see Password Dictionary.
        :param List['ConnectionOptionsPasswordHistoryArgs'] password_histories: List(Resource). Configuration settings for the password history that is maintained for each user to prevent the reuse of passwords. For details, see Password History.
        :param 'ConnectionOptionsPasswordNoPersonalInfoArgs' password_no_personal_info: List(Resource). Configuration settings for the password personal info check, which does not allow passwords that contain any part of the user's personal data, including user's name, username, nickname, user_metadata.name, user_metadata.first, user_metadata.last, user's email, or first part of the user's email. For details, see Password No Personal Info.
        :param str password_policy: String. Indicates level of password strength to enforce during authentication. A strong password policy will make it difficult, if not improbable, for someone to guess a password through either manual or automated means. Options include `none`, `low`, `fair`, `good`, `excellent`.
        :param bool requires_username: Boolean. Indicates whether or not the user is required to provide a username in addition to an email address.
        :param List[str] scopes: List(String). Value must be a list of scopes. For example `["openid", "profile", "email"]`
        :param float strategy_version: Int. Version 1 is deprecated, use version 2.
        :param str syntax: String. Syntax of the SMS. Options include `markdown` and `liquid`.
        :param str template: String. Template for the SMS. You can use `@@password@@` as a placeholder for the password value.
        :param str tenant_domain: String
        :param str token_endpoint: String.
        :param 'ConnectionOptionsTotpArgs' totp: Map(Resource). Configuration options for one-time passwords. For details, see TOTP.
        :param str twilio_sid: String. SID for your Twilio account.
        :param str twilio_token: String, Case-sensitive. AuthToken for your Twilio account.
        :param str type: String. Value must be `back_channel` or `front_channel`
        :param bool use_wsfed: Bool
        :param str userinfo_endpoint: String.
        :param Mapping[str, str] validation: String.
        :param bool waad_common_endpoint: Boolean. Indicates whether or not to use the common endpoint rather than the default endpoint. Typically enabled if you're using this for a multi-tenant application in Azure AD.
        :param str waad_protocol: String
        """
        if adfs_server is not None:
            pulumi.set(__self__, "adfs_server", adfs_server)
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if api_enable_users is not None:
            pulumi.set(__self__, "api_enable_users", api_enable_users)
        if app_domain is not None:
            pulumi.set(__self__, "app_domain", app_domain)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if brute_force_protection is not None:
            pulumi.set(__self__, "brute_force_protection", brute_force_protection)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if community_base_url is not None:
            pulumi.set(__self__, "community_base_url", community_base_url)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if custom_scripts is not None:
            pulumi.set(__self__, "custom_scripts", custom_scripts)
        if disable_cache is not None:
            pulumi.set(__self__, "disable_cache", disable_cache)
        if disable_signup is not None:
            pulumi.set(__self__, "disable_signup", disable_signup)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_aliases is not None:
            pulumi.set(__self__, "domain_aliases", domain_aliases)
        if enabled_database_customization is not None:
            pulumi.set(__self__, "enabled_database_customization", enabled_database_customization)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if identity_api is not None:
            pulumi.set(__self__, "identity_api", identity_api)
        if import_mode is not None:
            pulumi.set(__self__, "import_mode", import_mode)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_uri is not None:
            pulumi.set(__self__, "jwks_uri", jwks_uri)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if max_groups_to_retrieve is not None:
            pulumi.set(__self__, "max_groups_to_retrieve", max_groups_to_retrieve)
        if messaging_service_sid is not None:
            pulumi.set(__self__, "messaging_service_sid", messaging_service_sid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_complexity_options is not None:
            pulumi.set(__self__, "password_complexity_options", password_complexity_options)
        if password_dictionary is not None:
            pulumi.set(__self__, "password_dictionary", password_dictionary)
        if password_histories is not None:
            pulumi.set(__self__, "password_histories", password_histories)
        if password_no_personal_info is not None:
            pulumi.set(__self__, "password_no_personal_info", password_no_personal_info)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if requires_username is not None:
            pulumi.set(__self__, "requires_username", requires_username)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if strategy_version is not None:
            pulumi.set(__self__, "strategy_version", strategy_version)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if tenant_domain is not None:
            pulumi.set(__self__, "tenant_domain", tenant_domain)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if totp is not None:
            pulumi.set(__self__, "totp", totp)
        if twilio_sid is not None:
            pulumi.set(__self__, "twilio_sid", twilio_sid)
        if twilio_token is not None:
            pulumi.set(__self__, "twilio_token", twilio_token)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_cert_auth is not None:
            pulumi.set(__self__, "use_cert_auth", use_cert_auth)
        if use_kerberos is not None:
            pulumi.set(__self__, "use_kerberos", use_kerberos)
        if use_wsfed is not None:
            pulumi.set(__self__, "use_wsfed", use_wsfed)
        if userinfo_endpoint is not None:
            pulumi.set(__self__, "userinfo_endpoint", userinfo_endpoint)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)
        if waad_common_endpoint is not None:
            pulumi.set(__self__, "waad_common_endpoint", waad_common_endpoint)
        if waad_protocol is not None:
            pulumi.set(__self__, "waad_protocol", waad_protocol)

    @property
    @pulumi.getter(name="adfsServer")
    def adfs_server(self) -> Optional[str]:
        """
        String. ADFS Metadata source.
        """
        return pulumi.get(self, "adfs_server")

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[List[str]]:
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="apiEnableUsers")
    def api_enable_users(self) -> Optional[bool]:
        """
        Boolean.
        """
        return pulumi.get(self, "api_enable_users")

    @property
    @pulumi.getter(name="appDomain")
    def app_domain(self) -> Optional[str]:
        """
        String. Azure AD domain name.
        """
        return pulumi.get(self, "app_domain")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="bruteForceProtection")
    def brute_force_protection(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not to enable brute force protection, which will limit the number of signups and failed logins from a suspicious IP address.
        """
        return pulumi.get(self, "brute_force_protection")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        String. Client ID given by your OIDC provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        String, Case-sensitive. Client secret given by your OIDC provider.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="communityBaseUrl")
    def community_base_url(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "community_base_url")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, str]]:
        """
        Map(String), Case-sensitive.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="customScripts")
    def custom_scripts(self) -> Optional[Mapping[str, str]]:
        """
        Map(String).
        """
        return pulumi.get(self, "custom_scripts")

    @property
    @pulumi.getter(name="disableCache")
    def disable_cache(self) -> Optional[bool]:
        return pulumi.get(self, "disable_cache")

    @property
    @pulumi.getter(name="disableSignup")
    def disable_signup(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not to allow user sign-ups to your application.
        """
        return pulumi.get(self, "disable_signup")

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[str]:
        """
        String. Usually an URL ending with `/.well-known/openid-configuration`
        """
        return pulumi.get(self, "discovery_url")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainAliases")
    def domain_aliases(self) -> Optional[List[str]]:
        """
        List(String). List of the domains that can be authenticated using the Identity Provider. Only needed for Identifier First authentication flows.
        """
        return pulumi.get(self, "domain_aliases")

    @property
    @pulumi.getter(name="enabledDatabaseCustomization")
    def enabled_database_customization(self) -> Optional[bool]:
        """
        Boolean.
        """
        return pulumi.get(self, "enabled_database_customization")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[str]:
        """
        String. SMS number for the sender. Used when SMS Source is From.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="identityApi")
    def identity_api(self) -> Optional[str]:
        return pulumi.get(self, "identity_api")

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not you have a legacy user store and want to gradually migrate those users to the Auth0 user store. [Learn more](https://auth0.com/docs/users/guides/configure-automatic-migration).
        """
        return pulumi.get(self, "import_mode")

    @property
    @pulumi.getter
    def ips(self) -> Optional[List[str]]:
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        String. URL of the issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksUri")
    def jwks_uri(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "jwks_uri")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="maxGroupsToRetrieve")
    def max_groups_to_retrieve(self) -> Optional[str]:
        """
        String. Maximum number of groups to retrieve.
        """
        return pulumi.get(self, "max_groups_to_retrieve")

    @property
    @pulumi.getter(name="messagingServiceSid")
    def messaging_service_sid(self) -> Optional[str]:
        """
        String. SID for Copilot. Used when SMS Source is Copilot.
        """
        return pulumi.get(self, "messaging_service_sid")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordComplexityOptions")
    def password_complexity_options(self) -> Optional['outputs.ConnectionOptionsPasswordComplexityOptions']:
        """
        List(Resource). Configuration settings for password complexity. For details, see Password Complexity Options.
        """
        return pulumi.get(self, "password_complexity_options")

    @property
    @pulumi.getter(name="passwordDictionary")
    def password_dictionary(self) -> Optional['outputs.ConnectionOptionsPasswordDictionary']:
        """
        List(Resource). Configuration settings for the password dictionary check, which does not allow passwords that are part of the password dictionary. For details, see Password Dictionary.
        """
        return pulumi.get(self, "password_dictionary")

    @property
    @pulumi.getter(name="passwordHistories")
    def password_histories(self) -> Optional[List['outputs.ConnectionOptionsPasswordHistory']]:
        """
        List(Resource). Configuration settings for the password history that is maintained for each user to prevent the reuse of passwords. For details, see Password History.
        """
        return pulumi.get(self, "password_histories")

    @property
    @pulumi.getter(name="passwordNoPersonalInfo")
    def password_no_personal_info(self) -> Optional['outputs.ConnectionOptionsPasswordNoPersonalInfo']:
        """
        List(Resource). Configuration settings for the password personal info check, which does not allow passwords that contain any part of the user's personal data, including user's name, username, nickname, user_metadata.name, user_metadata.first, user_metadata.last, user's email, or first part of the user's email. For details, see Password No Personal Info.
        """
        return pulumi.get(self, "password_no_personal_info")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[str]:
        """
        String. Indicates level of password strength to enforce during authentication. A strong password policy will make it difficult, if not improbable, for someone to guess a password through either manual or automated means. Options include `none`, `low`, `fair`, `good`, `excellent`.
        """
        return pulumi.get(self, "password_policy")

    @property
    @pulumi.getter(name="requiresUsername")
    def requires_username(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the user is required to provide a username in addition to an email address.
        """
        return pulumi.get(self, "requires_username")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[List[str]]:
        """
        List(String). Value must be a list of scopes. For example `["openid", "profile", "email"]`
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="strategyVersion")
    def strategy_version(self) -> Optional[float]:
        """
        Int. Version 1 is deprecated, use version 2.
        """
        return pulumi.get(self, "strategy_version")

    @property
    @pulumi.getter
    def subject(self) -> Optional[str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def syntax(self) -> Optional[str]:
        """
        String. Syntax of the SMS. Options include `markdown` and `liquid`.
        """
        return pulumi.get(self, "syntax")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        String. Template for the SMS. You can use `@@password@@` as a placeholder for the password value.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="tenantDomain")
    def tenant_domain(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "tenant_domain")

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "token_endpoint")

    @property
    @pulumi.getter
    def totp(self) -> Optional['outputs.ConnectionOptionsTotp']:
        """
        Map(Resource). Configuration options for one-time passwords. For details, see TOTP.
        """
        return pulumi.get(self, "totp")

    @property
    @pulumi.getter(name="twilioSid")
    def twilio_sid(self) -> Optional[str]:
        """
        String. SID for your Twilio account.
        """
        return pulumi.get(self, "twilio_sid")

    @property
    @pulumi.getter(name="twilioToken")
    def twilio_token(self) -> Optional[str]:
        """
        String, Case-sensitive. AuthToken for your Twilio account.
        """
        return pulumi.get(self, "twilio_token")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        String. Value must be `back_channel` or `front_channel`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useCertAuth")
    def use_cert_auth(self) -> Optional[bool]:
        return pulumi.get(self, "use_cert_auth")

    @property
    @pulumi.getter(name="useKerberos")
    def use_kerberos(self) -> Optional[bool]:
        return pulumi.get(self, "use_kerberos")

    @property
    @pulumi.getter(name="useWsfed")
    def use_wsfed(self) -> Optional[bool]:
        """
        Bool
        """
        return pulumi.get(self, "use_wsfed")

    @property
    @pulumi.getter(name="userinfoEndpoint")
    def userinfo_endpoint(self) -> Optional[str]:
        """
        String.
        """
        return pulumi.get(self, "userinfo_endpoint")

    @property
    @pulumi.getter
    def validation(self) -> Optional[Mapping[str, str]]:
        """
        String.
        """
        return pulumi.get(self, "validation")

    @property
    @pulumi.getter(name="waadCommonEndpoint")
    def waad_common_endpoint(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not to use the common endpoint rather than the default endpoint. Typically enabled if you're using this for a multi-tenant application in Azure AD.
        """
        return pulumi.get(self, "waad_common_endpoint")

    @property
    @pulumi.getter(name="waadProtocol")
    def waad_protocol(self) -> Optional[str]:
        """
        String
        """
        return pulumi.get(self, "waad_protocol")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptionsPasswordComplexityOptions(dict):
    def __init__(__self__, *,
                 min_length: Optional[float] = None):
        """
        :param float min_length: Integer. Minimum number of characters allowed in passwords.
        """
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[float]:
        """
        Integer. Minimum number of characters allowed in passwords.
        """
        return pulumi.get(self, "min_length")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptionsPasswordDictionary(dict):
    def __init__(__self__, *,
                 dictionaries: Optional[List[str]] = None,
                 enable: Optional[bool] = None):
        """
        :param List[str] dictionaries: Set(String), (Maximum=2000 characters). Customized contents of the password dictionary. By default, the password dictionary contains a list of the [10,000 most common passwords](https://github.com/danielmiessler/SecLists/blob/master/Passwords/Common-Credentials/10k-most-common.txt); your customized content is used in addition to the default password dictionary. Matching is not case-sensitive.
        :param bool enable: Boolean. Indicates whether password history is enabled for the connection. When enabled, any existing users in this connection will be unaffected; the system will maintain their password history going forward.
        """
        if dictionaries is not None:
            pulumi.set(__self__, "dictionaries", dictionaries)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def dictionaries(self) -> Optional[List[str]]:
        """
        Set(String), (Maximum=2000 characters). Customized contents of the password dictionary. By default, the password dictionary contains a list of the [10,000 most common passwords](https://github.com/danielmiessler/SecLists/blob/master/Passwords/Common-Credentials/10k-most-common.txt); your customized content is used in addition to the default password dictionary. Matching is not case-sensitive.
        """
        return pulumi.get(self, "dictionaries")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Boolean. Indicates whether password history is enabled for the connection. When enabled, any existing users in this connection will be unaffected; the system will maintain their password history going forward.
        """
        return pulumi.get(self, "enable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptionsPasswordHistory(dict):
    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 size: Optional[float] = None):
        """
        :param bool enable: Boolean. Indicates whether password history is enabled for the connection. When enabled, any existing users in this connection will be unaffected; the system will maintain their password history going forward.
        :param float size: Integer, (Maximum=24). Indicates the number of passwords to keep in history.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Boolean. Indicates whether password history is enabled for the connection. When enabled, any existing users in this connection will be unaffected; the system will maintain their password history going forward.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def size(self) -> Optional[float]:
        """
        Integer, (Maximum=24). Indicates the number of passwords to keep in history.
        """
        return pulumi.get(self, "size")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptionsPasswordNoPersonalInfo(dict):
    def __init__(__self__, *,
                 enable: Optional[bool] = None):
        """
        :param bool enable: Boolean. Indicates whether the password personal info check is enabled for this connection.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Boolean. Indicates whether the password personal info check is enabled for this connection.
        """
        return pulumi.get(self, "enable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConnectionOptionsTotp(dict):
    def __init__(__self__, *,
                 length: Optional[float] = None,
                 time_step: Optional[float] = None):
        """
        :param float length: Integer. Length of the one-time password.
        :param float time_step: Integer. Seconds between allowed generation of new passwords.
        """
        if length is not None:
            pulumi.set(__self__, "length", length)
        if time_step is not None:
            pulumi.set(__self__, "time_step", time_step)

    @property
    @pulumi.getter
    def length(self) -> Optional[float]:
        """
        Integer. Length of the one-time password.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="timeStep")
    def time_step(self) -> Optional[float]:
        """
        Integer. Seconds between allowed generation of new passwords.
        """
        return pulumi.get(self, "time_step")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CustomDomainVerification(dict):
    def __init__(__self__, *,
                 methods: Optional[List[Any]] = None):
        """
        :param List[Any] methods: List(Map). Verification methods for the domain.
        """
        if methods is not None:
            pulumi.set(__self__, "methods", methods)

    @property
    @pulumi.getter
    def methods(self) -> Optional[List[Any]]:
        """
        List(Map). Verification methods for the domain.
        """
        return pulumi.get(self, "methods")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EmailCredentials(dict):
    def __init__(__self__, *,
                 access_key_id: Optional[str] = None,
                 api_key: Optional[str] = None,
                 api_user: Optional[str] = None,
                 domain: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_access_key: Optional[str] = None,
                 smtp_host: Optional[str] = None,
                 smtp_pass: Optional[str] = None,
                 smtp_port: Optional[float] = None,
                 smtp_user: Optional[str] = None):
        """
        :param str access_key_id: String, Case-sensitive. AWS Access Key ID. Used only for AWS.
        :param str api_key: String, Case-sensitive. API Key for your email service. Will always be encrypted in our database.
        :param str api_user: String. API User for your email service.
        :param str region: String. Default region. Used only for AWS, Mailgun, and SparkPost.
        :param str secret_access_key: String, Case-sensitive. AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
        :param str smtp_host: String. Hostname or IP address of your SMTP server. Used only for SMTP.
        :param str smtp_pass: String, Case-sensitive. SMTP password. Used only for SMTP.
        :param float smtp_port: Integer. Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
        :param str smtp_user: String. SMTP username. Used only for SMTP.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_user is not None:
            pulumi.set(__self__, "api_user", api_user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if smtp_host is not None:
            pulumi.set(__self__, "smtp_host", smtp_host)
        if smtp_pass is not None:
            pulumi.set(__self__, "smtp_pass", smtp_pass)
        if smtp_port is not None:
            pulumi.set(__self__, "smtp_port", smtp_port)
        if smtp_user is not None:
            pulumi.set(__self__, "smtp_user", smtp_user)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[str]:
        """
        String, Case-sensitive. AWS Access Key ID. Used only for AWS.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        String, Case-sensitive. API Key for your email service. Will always be encrypted in our database.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiUser")
    def api_user(self) -> Optional[str]:
        """
        String. API User for your email service.
        """
        return pulumi.get(self, "api_user")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        String. Default region. Used only for AWS, Mailgun, and SparkPost.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[str]:
        """
        String, Case-sensitive. AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="smtpHost")
    def smtp_host(self) -> Optional[str]:
        """
        String. Hostname or IP address of your SMTP server. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_host")

    @property
    @pulumi.getter(name="smtpPass")
    def smtp_pass(self) -> Optional[str]:
        """
        String, Case-sensitive. SMTP password. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_pass")

    @property
    @pulumi.getter(name="smtpPort")
    def smtp_port(self) -> Optional[float]:
        """
        Integer. Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_port")

    @property
    @pulumi.getter(name="smtpUser")
    def smtp_user(self) -> Optional[str]:
        """
        String. SMTP username. Used only for SMTP.
        """
        return pulumi.get(self, "smtp_user")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientAddons(dict):
    def __init__(__self__, *,
                 aws: Optional[Mapping[str, Any]] = None,
                 azure_blob: Optional[Mapping[str, Any]] = None,
                 azure_sb: Optional[Mapping[str, Any]] = None,
                 box: Optional[Mapping[str, Any]] = None,
                 cloudbees: Optional[Mapping[str, Any]] = None,
                 concur: Optional[Mapping[str, Any]] = None,
                 dropbox: Optional[Mapping[str, Any]] = None,
                 echosign: Optional[Mapping[str, Any]] = None,
                 egnyte: Optional[Mapping[str, Any]] = None,
                 firebase: Optional[Mapping[str, Any]] = None,
                 layer: Optional[Mapping[str, Any]] = None,
                 mscrm: Optional[Mapping[str, Any]] = None,
                 newrelic: Optional[Mapping[str, Any]] = None,
                 office365: Optional[Mapping[str, Any]] = None,
                 rms: Optional[Mapping[str, Any]] = None,
                 salesforce: Optional[Mapping[str, Any]] = None,
                 salesforce_api: Optional[Mapping[str, Any]] = None,
                 salesforce_sandbox_api: Optional[Mapping[str, Any]] = None,
                 samlp: Optional['outputs.GlobalClientAddonsSamlp'] = None,
                 sap_api: Optional[Mapping[str, Any]] = None,
                 sentry: Optional[Mapping[str, Any]] = None,
                 sharepoint: Optional[Mapping[str, Any]] = None,
                 slack: Optional[Mapping[str, Any]] = None,
                 springcm: Optional[Mapping[str, Any]] = None,
                 wams: Optional[Mapping[str, Any]] = None,
                 wsfed: Optional[Mapping[str, Any]] = None,
                 zendesk: Optional[Mapping[str, Any]] = None,
                 zoom: Optional[Mapping[str, Any]] = None):
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_blob is not None:
            pulumi.set(__self__, "azure_blob", azure_blob)
        if azure_sb is not None:
            pulumi.set(__self__, "azure_sb", azure_sb)
        if box is not None:
            pulumi.set(__self__, "box", box)
        if cloudbees is not None:
            pulumi.set(__self__, "cloudbees", cloudbees)
        if concur is not None:
            pulumi.set(__self__, "concur", concur)
        if dropbox is not None:
            pulumi.set(__self__, "dropbox", dropbox)
        if echosign is not None:
            pulumi.set(__self__, "echosign", echosign)
        if egnyte is not None:
            pulumi.set(__self__, "egnyte", egnyte)
        if firebase is not None:
            pulumi.set(__self__, "firebase", firebase)
        if layer is not None:
            pulumi.set(__self__, "layer", layer)
        if mscrm is not None:
            pulumi.set(__self__, "mscrm", mscrm)
        if newrelic is not None:
            pulumi.set(__self__, "newrelic", newrelic)
        if office365 is not None:
            pulumi.set(__self__, "office365", office365)
        if rms is not None:
            pulumi.set(__self__, "rms", rms)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if salesforce_api is not None:
            pulumi.set(__self__, "salesforce_api", salesforce_api)
        if salesforce_sandbox_api is not None:
            pulumi.set(__self__, "salesforce_sandbox_api", salesforce_sandbox_api)
        if samlp is not None:
            pulumi.set(__self__, "samlp", samlp)
        if sap_api is not None:
            pulumi.set(__self__, "sap_api", sap_api)
        if sentry is not None:
            pulumi.set(__self__, "sentry", sentry)
        if sharepoint is not None:
            pulumi.set(__self__, "sharepoint", sharepoint)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if springcm is not None:
            pulumi.set(__self__, "springcm", springcm)
        if wams is not None:
            pulumi.set(__self__, "wams", wams)
        if wsfed is not None:
            pulumi.set(__self__, "wsfed", wsfed)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)
        if zoom is not None:
            pulumi.set(__self__, "zoom", zoom)

    @property
    @pulumi.getter
    def aws(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureBlob")
    def azure_blob(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_blob")

    @property
    @pulumi.getter(name="azureSb")
    def azure_sb(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "azure_sb")

    @property
    @pulumi.getter
    def box(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "box")

    @property
    @pulumi.getter
    def cloudbees(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "cloudbees")

    @property
    @pulumi.getter
    def concur(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "concur")

    @property
    @pulumi.getter
    def dropbox(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dropbox")

    @property
    @pulumi.getter
    def echosign(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "echosign")

    @property
    @pulumi.getter
    def egnyte(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "egnyte")

    @property
    @pulumi.getter
    def firebase(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "firebase")

    @property
    @pulumi.getter
    def layer(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "layer")

    @property
    @pulumi.getter
    def mscrm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mscrm")

    @property
    @pulumi.getter
    def newrelic(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "newrelic")

    @property
    @pulumi.getter
    def office365(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "office365")

    @property
    @pulumi.getter
    def rms(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "rms")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="salesforceApi")
    def salesforce_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_api")

    @property
    @pulumi.getter(name="salesforceSandboxApi")
    def salesforce_sandbox_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "salesforce_sandbox_api")

    @property
    @pulumi.getter
    def samlp(self) -> Optional['outputs.GlobalClientAddonsSamlp']:
        return pulumi.get(self, "samlp")

    @property
    @pulumi.getter(name="sapApi")
    def sap_api(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sap_api")

    @property
    @pulumi.getter
    def sentry(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sentry")

    @property
    @pulumi.getter
    def sharepoint(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "sharepoint")

    @property
    @pulumi.getter
    def slack(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def springcm(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "springcm")

    @property
    @pulumi.getter
    def wams(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "wams")

    @property
    @pulumi.getter
    def wsfed(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "wsfed")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zendesk")

    @property
    @pulumi.getter
    def zoom(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "zoom")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientAddonsSamlp(dict):
    def __init__(__self__, *,
                 audience: Optional[str] = None,
                 authn_context_class_ref: Optional[str] = None,
                 binding: Optional[str] = None,
                 create_upn_claim: Optional[bool] = None,
                 destination: Optional[str] = None,
                 digest_algorithm: Optional[str] = None,
                 include_attribute_name_format: Optional[bool] = None,
                 lifetime_in_seconds: Optional[float] = None,
                 logout: Optional['outputs.GlobalClientAddonsSamlpLogout'] = None,
                 map_identities: Optional[bool] = None,
                 map_unknown_claims_as_is: Optional[bool] = None,
                 mappings: Optional[Mapping[str, Any]] = None,
                 name_identifier_format: Optional[str] = None,
                 name_identifier_probes: Optional[List[str]] = None,
                 passthrough_claims_with_no_mapping: Optional[bool] = None,
                 recipient: Optional[str] = None,
                 sign_response: Optional[bool] = None,
                 signature_algorithm: Optional[str] = None,
                 typed_attributes: Optional[bool] = None):
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authn_context_class_ref is not None:
            pulumi.set(__self__, "authn_context_class_ref", authn_context_class_ref)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if create_upn_claim is not None:
            pulumi.set(__self__, "create_upn_claim", create_upn_claim)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if digest_algorithm is not None:
            pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if include_attribute_name_format is not None:
            pulumi.set(__self__, "include_attribute_name_format", include_attribute_name_format)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if logout is not None:
            pulumi.set(__self__, "logout", logout)
        if map_identities is not None:
            pulumi.set(__self__, "map_identities", map_identities)
        if map_unknown_claims_as_is is not None:
            pulumi.set(__self__, "map_unknown_claims_as_is", map_unknown_claims_as_is)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if name_identifier_format is not None:
            pulumi.set(__self__, "name_identifier_format", name_identifier_format)
        if name_identifier_probes is not None:
            pulumi.set(__self__, "name_identifier_probes", name_identifier_probes)
        if passthrough_claims_with_no_mapping is not None:
            pulumi.set(__self__, "passthrough_claims_with_no_mapping", passthrough_claims_with_no_mapping)
        if recipient is not None:
            pulumi.set(__self__, "recipient", recipient)
        if sign_response is not None:
            pulumi.set(__self__, "sign_response", sign_response)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if typed_attributes is not None:
            pulumi.set(__self__, "typed_attributes", typed_attributes)

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authnContextClassRef")
    def authn_context_class_ref(self) -> Optional[str]:
        return pulumi.get(self, "authn_context_class_ref")

    @property
    @pulumi.getter
    def binding(self) -> Optional[str]:
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter(name="createUpnClaim")
    def create_upn_claim(self) -> Optional[bool]:
        return pulumi.get(self, "create_upn_claim")

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "digest_algorithm")

    @property
    @pulumi.getter(name="includeAttributeNameFormat")
    def include_attribute_name_format(self) -> Optional[bool]:
        return pulumi.get(self, "include_attribute_name_format")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[float]:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def logout(self) -> Optional['outputs.GlobalClientAddonsSamlpLogout']:
        return pulumi.get(self, "logout")

    @property
    @pulumi.getter(name="mapIdentities")
    def map_identities(self) -> Optional[bool]:
        return pulumi.get(self, "map_identities")

    @property
    @pulumi.getter(name="mapUnknownClaimsAsIs")
    def map_unknown_claims_as_is(self) -> Optional[bool]:
        return pulumi.get(self, "map_unknown_claims_as_is")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="nameIdentifierFormat")
    def name_identifier_format(self) -> Optional[str]:
        return pulumi.get(self, "name_identifier_format")

    @property
    @pulumi.getter(name="nameIdentifierProbes")
    def name_identifier_probes(self) -> Optional[List[str]]:
        return pulumi.get(self, "name_identifier_probes")

    @property
    @pulumi.getter(name="passthroughClaimsWithNoMapping")
    def passthrough_claims_with_no_mapping(self) -> Optional[bool]:
        return pulumi.get(self, "passthrough_claims_with_no_mapping")

    @property
    @pulumi.getter
    def recipient(self) -> Optional[str]:
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter(name="signResponse")
    def sign_response(self) -> Optional[bool]:
        return pulumi.get(self, "sign_response")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[str]:
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="typedAttributes")
    def typed_attributes(self) -> Optional[bool]:
        return pulumi.get(self, "typed_attributes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientAddonsSamlpLogout(dict):
    def __init__(__self__, *,
                 callback: Optional[str] = None,
                 slo_enabled: Optional[bool] = None):
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if slo_enabled is not None:
            pulumi.set(__self__, "slo_enabled", slo_enabled)

    @property
    @pulumi.getter
    def callback(self) -> Optional[str]:
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter(name="sloEnabled")
    def slo_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "slo_enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientJwtConfiguration(dict):
    def __init__(__self__, *,
                 alg: Optional[str] = None,
                 lifetime_in_seconds: Optional[float] = None,
                 scopes: Optional[Mapping[str, str]] = None,
                 secret_encoded: Optional[bool] = None):
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if lifetime_in_seconds is not None:
            pulumi.set(__self__, "lifetime_in_seconds", lifetime_in_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_encoded is not None:
            pulumi.set(__self__, "secret_encoded", secret_encoded)

    @property
    @pulumi.getter
    def alg(self) -> Optional[str]:
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter(name="lifetimeInSeconds")
    def lifetime_in_seconds(self) -> Optional[float]:
        return pulumi.get(self, "lifetime_in_seconds")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secretEncoded")
    def secret_encoded(self) -> Optional[bool]:
        return pulumi.get(self, "secret_encoded")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientMobile(dict):
    def __init__(__self__, *,
                 android: Optional['outputs.GlobalClientMobileAndroid'] = None,
                 ios: Optional['outputs.GlobalClientMobileIos'] = None):
        if android is not None:
            pulumi.set(__self__, "android", android)
        if ios is not None:
            pulumi.set(__self__, "ios", ios)

    @property
    @pulumi.getter
    def android(self) -> Optional['outputs.GlobalClientMobileAndroid']:
        return pulumi.get(self, "android")

    @property
    @pulumi.getter
    def ios(self) -> Optional['outputs.GlobalClientMobileIos']:
        return pulumi.get(self, "ios")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientMobileAndroid(dict):
    def __init__(__self__, *,
                 app_package_name: Optional[str] = None,
                 sha256_cert_fingerprints: Optional[List[str]] = None):
        if app_package_name is not None:
            pulumi.set(__self__, "app_package_name", app_package_name)
        if sha256_cert_fingerprints is not None:
            pulumi.set(__self__, "sha256_cert_fingerprints", sha256_cert_fingerprints)

    @property
    @pulumi.getter(name="appPackageName")
    def app_package_name(self) -> Optional[str]:
        return pulumi.get(self, "app_package_name")

    @property
    @pulumi.getter(name="sha256CertFingerprints")
    def sha256_cert_fingerprints(self) -> Optional[List[str]]:
        return pulumi.get(self, "sha256_cert_fingerprints")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GlobalClientMobileIos(dict):
    def __init__(__self__, *,
                 app_bundle_identifier: Optional[str] = None,
                 team_id: Optional[str] = None):
        if app_bundle_identifier is not None:
            pulumi.set(__self__, "app_bundle_identifier", app_bundle_identifier)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appBundleIdentifier")
    def app_bundle_identifier(self) -> Optional[str]:
        return pulumi.get(self, "app_bundle_identifier")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        return pulumi.get(self, "team_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ResourceServerScope(dict):
    def __init__(__self__, *,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str value: String. Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        :param str description: String. Description of the permission (scope).
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        String. Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        String. Description of the permission (scope).
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RolePermission(dict):
    def __init__(__self__, *,
                 name: str,
                 resource_server_identifier: str):
        """
        :param str name: String. Name of the permission (scope).
        :param str resource_server_identifier: String. Unique identifier for the resource server.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_server_identifier", resource_server_identifier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        String. Name of the permission (scope).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceServerIdentifier")
    def resource_server_identifier(self) -> str:
        """
        String. Unique identifier for the resource server.
        """
        return pulumi.get(self, "resource_server_identifier")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantChangePassword(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 html: str):
        """
        :param bool enabled: Boolean. Indicates whether or not to use the custom change password page.
        :param str html: String, HTML format with supported Liquid syntax. Customized content of the change password page.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "html", html)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean. Indicates whether or not to use the custom change password page.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        String, HTML format with supported Liquid syntax. Customized content of the change password page.
        """
        return pulumi.get(self, "html")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantErrorPage(dict):
    def __init__(__self__, *,
                 html: str,
                 show_log_link: bool,
                 url: str):
        """
        :param str html: String, HTML format with supported Liquid syntax. Customized content of the error page.
        :param bool show_log_link: Boolean. Indicates whether or not to show the link to logs as part of the default error page.
        :param str url: String. URL to redirect to when an error occurs rather than showing the default error page.
        """
        pulumi.set(__self__, "html", html)
        pulumi.set(__self__, "show_log_link", show_log_link)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        String, HTML format with supported Liquid syntax. Customized content of the error page.
        """
        return pulumi.get(self, "html")

    @property
    @pulumi.getter(name="showLogLink")
    def show_log_link(self) -> bool:
        """
        Boolean. Indicates whether or not to show the link to logs as part of the default error page.
        """
        return pulumi.get(self, "show_log_link")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        String. URL to redirect to when an error occurs rather than showing the default error page.
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantFlags(dict):
    def __init__(__self__, *,
                 change_pwd_flow_v1: Optional[bool] = None,
                 disable_clickjack_protection_headers: Optional[bool] = None,
                 enable_apis_section: Optional[bool] = None,
                 enable_client_connections: Optional[bool] = None,
                 enable_custom_domain_in_emails: Optional[bool] = None,
                 enable_dynamic_client_registration: Optional[bool] = None,
                 enable_legacy_logs_search_v2: Optional[bool] = None,
                 enable_pipeline2: Optional[bool] = None,
                 enable_public_signup_user_exists_error: Optional[bool] = None,
                 universal_login: Optional[bool] = None,
                 use_scope_descriptions_for_consent: Optional[bool] = None):
        """
        :param bool change_pwd_flow_v1: Boolean. Indicates whether or not to use the older v1 change password flow. Not recommended except for backward compatibility.
        :param bool disable_clickjack_protection_headers: Boolean. Indicated whether or not classic Universal Login prompts include additional security headers to prevent clickjacking.
        :param bool enable_apis_section: Boolean. Indicates whether or not the APIs section is enabled for the tenant.
        :param bool enable_client_connections: Boolean. Indicates whether or not all current connections should be enabled when a new client is created.
        :param bool enable_custom_domain_in_emails: Boolean. Indicates whether or not the tenant allows custom domains in emails.
        :param bool enable_dynamic_client_registration: Boolean. Indicates whether or not the tenant allows dynamic client registration.
        :param bool enable_legacy_logs_search_v2: Boolean. Indicates whether or not to use the older v2 legacy logs search.
        :param bool enable_pipeline2: Boolean. Indicates whether or not advanced API Authorization scenarios are enabled.
        :param bool enable_public_signup_user_exists_error: Boolean. Indicates whether or not the public sign up process shows a user_exists error if the user already exists.
        :param bool universal_login: Boolean. Indicates whether or not the tenant uses universal login.
        """
        if change_pwd_flow_v1 is not None:
            pulumi.set(__self__, "change_pwd_flow_v1", change_pwd_flow_v1)
        if disable_clickjack_protection_headers is not None:
            pulumi.set(__self__, "disable_clickjack_protection_headers", disable_clickjack_protection_headers)
        if enable_apis_section is not None:
            pulumi.set(__self__, "enable_apis_section", enable_apis_section)
        if enable_client_connections is not None:
            pulumi.set(__self__, "enable_client_connections", enable_client_connections)
        if enable_custom_domain_in_emails is not None:
            pulumi.set(__self__, "enable_custom_domain_in_emails", enable_custom_domain_in_emails)
        if enable_dynamic_client_registration is not None:
            pulumi.set(__self__, "enable_dynamic_client_registration", enable_dynamic_client_registration)
        if enable_legacy_logs_search_v2 is not None:
            pulumi.set(__self__, "enable_legacy_logs_search_v2", enable_legacy_logs_search_v2)
        if enable_pipeline2 is not None:
            pulumi.set(__self__, "enable_pipeline2", enable_pipeline2)
        if enable_public_signup_user_exists_error is not None:
            pulumi.set(__self__, "enable_public_signup_user_exists_error", enable_public_signup_user_exists_error)
        if universal_login is not None:
            pulumi.set(__self__, "universal_login", universal_login)
        if use_scope_descriptions_for_consent is not None:
            pulumi.set(__self__, "use_scope_descriptions_for_consent", use_scope_descriptions_for_consent)

    @property
    @pulumi.getter(name="changePwdFlowV1")
    def change_pwd_flow_v1(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not to use the older v1 change password flow. Not recommended except for backward compatibility.
        """
        return pulumi.get(self, "change_pwd_flow_v1")

    @property
    @pulumi.getter(name="disableClickjackProtectionHeaders")
    def disable_clickjack_protection_headers(self) -> Optional[bool]:
        """
        Boolean. Indicated whether or not classic Universal Login prompts include additional security headers to prevent clickjacking.
        """
        return pulumi.get(self, "disable_clickjack_protection_headers")

    @property
    @pulumi.getter(name="enableApisSection")
    def enable_apis_section(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the APIs section is enabled for the tenant.
        """
        return pulumi.get(self, "enable_apis_section")

    @property
    @pulumi.getter(name="enableClientConnections")
    def enable_client_connections(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not all current connections should be enabled when a new client is created.
        """
        return pulumi.get(self, "enable_client_connections")

    @property
    @pulumi.getter(name="enableCustomDomainInEmails")
    def enable_custom_domain_in_emails(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the tenant allows custom domains in emails.
        """
        return pulumi.get(self, "enable_custom_domain_in_emails")

    @property
    @pulumi.getter(name="enableDynamicClientRegistration")
    def enable_dynamic_client_registration(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the tenant allows dynamic client registration.
        """
        return pulumi.get(self, "enable_dynamic_client_registration")

    @property
    @pulumi.getter(name="enableLegacyLogsSearchV2")
    def enable_legacy_logs_search_v2(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not to use the older v2 legacy logs search.
        """
        return pulumi.get(self, "enable_legacy_logs_search_v2")

    @property
    @pulumi.getter(name="enablePipeline2")
    def enable_pipeline2(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not advanced API Authorization scenarios are enabled.
        """
        return pulumi.get(self, "enable_pipeline2")

    @property
    @pulumi.getter(name="enablePublicSignupUserExistsError")
    def enable_public_signup_user_exists_error(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the public sign up process shows a user_exists error if the user already exists.
        """
        return pulumi.get(self, "enable_public_signup_user_exists_error")

    @property
    @pulumi.getter(name="universalLogin")
    def universal_login(self) -> Optional[bool]:
        """
        Boolean. Indicates whether or not the tenant uses universal login.
        """
        return pulumi.get(self, "universal_login")

    @property
    @pulumi.getter(name="useScopeDescriptionsForConsent")
    def use_scope_descriptions_for_consent(self) -> Optional[bool]:
        return pulumi.get(self, "use_scope_descriptions_for_consent")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantGuardianMfaPage(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 html: str):
        """
        :param bool enabled: Boolean. Indicates whether or not to use the custom Guardian page.
        :param str html: String, HTML format with supported Liquid syntax. Customized content of the Guardian page.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "html", html)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean. Indicates whether or not to use the custom Guardian page.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def html(self) -> str:
        """
        String, HTML format with supported Liquid syntax. Customized content of the Guardian page.
        """
        return pulumi.get(self, "html")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantUniversalLogin(dict):
    def __init__(__self__, *,
                 colors: Optional['outputs.TenantUniversalLoginColors'] = None):
        """
        :param 'TenantUniversalLoginColorsArgs' colors: List(Resource). Configuration settings for Universal Login colors. See Universal Login - Colors.
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)

    @property
    @pulumi.getter
    def colors(self) -> Optional['outputs.TenantUniversalLoginColors']:
        """
        List(Resource). Configuration settings for Universal Login colors. See Universal Login - Colors.
        """
        return pulumi.get(self, "colors")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TenantUniversalLoginColors(dict):
    def __init__(__self__, *,
                 page_background: Optional[str] = None,
                 primary: Optional[str] = None):
        """
        :param str page_background: String, Hexadecimal. Background color of login pages.
        :param str primary: String, Hexadecimal. Primary button background color.
        """
        if page_background is not None:
            pulumi.set(__self__, "page_background", page_background)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="pageBackground")
    def page_background(self) -> Optional[str]:
        """
        String, Hexadecimal. Background color of login pages.
        """
        return pulumi.get(self, "page_background")

    @property
    @pulumi.getter
    def primary(self) -> Optional[str]:
        """
        String, Hexadecimal. Primary button background color.
        """
        return pulumi.get(self, "primary")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


