# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Role']


class Role(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RolePermissionArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        With this resource, you can created and manage collections of permissions that can be assigned to users, which are otherwise known as roles. Permissions (scopes) are created on auth0_resource_server, then associated with roles and optionally, users using this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_resource_server = auth0.ResourceServer("myResourceServer",
            enforce_policies=True,
            identifier="my-resource-server-identifier",
            scopes=[auth0.ResourceServerScopeArgs(
                description="read something",
                value="read:something",
            )],
            signing_alg="RS256",
            skip_consent_for_verifiable_first_party_clients=True,
            token_lifetime=86400)
        my_role = auth0.Role("myRole",
            description="Role Description...",
            permissions=[auth0.RolePermissionArgs(
                name="read:something",
                resource_server_identifier=my_resource_server.identifier,
            )])
        my_user = auth0.User("myUser",
            connection_name="Username-Password-Authentication",
            email="test@test.com",
            nickname="testnick",
            password="passpass$12$12",
            roles=[my_role.id],
            user_id="auth0|1234567890",
            username="testnick")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: String. Description of the role.
        :param pulumi.Input[str] name: String. Name for this role.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RolePermissionArgs']]]] permissions: Set(Resource). Configuration settings for permissions (scopes) attached to the role. For details, see Permissions.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if description is None:
                description = 'Managed by Pulumi'
            __props__['description'] = description
            __props__['name'] = name
            __props__['permissions'] = permissions
        super(Role, __self__).__init__(
            'auth0:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RolePermissionArgs']]]]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: String. Description of the role.
        :param pulumi.Input[str] name: String. Name for this role.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RolePermissionArgs']]]] permissions: Set(Resource). Configuration settings for permissions (scopes) attached to the role. For details, see Permissions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["name"] = name
        __props__["permissions"] = permissions
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        String. Description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        String. Name for this role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[List['outputs.RolePermission']]]:
        """
        Set(Resource). Configuration settings for permissions (scopes) attached to the role. For details, see Permissions.
        """
        return pulumi.get(self, "permissions")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

