# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['User']


class User(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_metadata: Optional[pulumi.Input[str]] = None,
                 blocked: Optional[pulumi.Input[bool]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 email_verified: Optional[pulumi.Input[bool]] = None,
                 family_name: Optional[pulumi.Input[str]] = None,
                 given_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nickname: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None,
                 phone_verified: Optional[pulumi.Input[bool]] = None,
                 picture: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_metadata: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 verify_email: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        With this resource, you can manage user identities, including resetting passwords, and creating, provisioning, blocking, and deleting users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        admin = auth0.Role("admin", description="Administrator")
        user = auth0.User("user",
            connection_name="Username-Password-Authentication",
            user_id="12345",
            username="unique_username",
            given_name="Firstname",
            family_name="Lastname",
            nickname="some.nickname",
            email="test@test.com",
            email_verified=True,
            password="passpass$12$12",
            roles=[admin.id])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_metadata: String, JSON format. Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[str] connection_name: String. Name of the connection from which the user information was sourced.
        :param pulumi.Input[str] email: String. Email address of the user.
        :param pulumi.Input[bool] email_verified: Boolean. Indicates whether or not the email address has been verified.
        :param pulumi.Input[str] nickname: String. Preferred nickname or alias of the user.
        :param pulumi.Input[str] password: String, Case-sensitive. Initial password for this user. Used for non-SMS connections.
        :param pulumi.Input[str] phone_number: String. Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[bool] phone_verified: Boolean. Indicates whether or not the phone number has been verified.
        :param pulumi.Input[List[pulumi.Input[str]]] roles: Set(String). Set of IDs of roles assigned to the user.
        :param pulumi.Input[str] user_id: String. ID of the user.
        :param pulumi.Input[str] user_metadata: String, JSON format. Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[str] username: String. Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[bool] verify_email: Boolean. Indicates whether or not the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['app_metadata'] = app_metadata
            __props__['blocked'] = blocked
            if connection_name is None:
                raise TypeError("Missing required property 'connection_name'")
            __props__['connection_name'] = connection_name
            __props__['email'] = email
            __props__['email_verified'] = email_verified
            __props__['family_name'] = family_name
            __props__['given_name'] = given_name
            __props__['name'] = name
            __props__['nickname'] = nickname
            __props__['password'] = password
            __props__['phone_number'] = phone_number
            __props__['phone_verified'] = phone_verified
            __props__['picture'] = picture
            __props__['roles'] = roles
            __props__['user_id'] = user_id
            __props__['user_metadata'] = user_metadata
            __props__['username'] = username
            __props__['verify_email'] = verify_email
        super(User, __self__).__init__(
            'auth0:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_metadata: Optional[pulumi.Input[str]] = None,
            blocked: Optional[pulumi.Input[bool]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            email_verified: Optional[pulumi.Input[bool]] = None,
            family_name: Optional[pulumi.Input[str]] = None,
            given_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nickname: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            phone_number: Optional[pulumi.Input[str]] = None,
            phone_verified: Optional[pulumi.Input[bool]] = None,
            picture: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            user_metadata: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            verify_email: Optional[pulumi.Input[bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_metadata: String, JSON format. Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        :param pulumi.Input[str] connection_name: String. Name of the connection from which the user information was sourced.
        :param pulumi.Input[str] email: String. Email address of the user.
        :param pulumi.Input[bool] email_verified: Boolean. Indicates whether or not the email address has been verified.
        :param pulumi.Input[str] nickname: String. Preferred nickname or alias of the user.
        :param pulumi.Input[str] password: String, Case-sensitive. Initial password for this user. Used for non-SMS connections.
        :param pulumi.Input[str] phone_number: String. Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        :param pulumi.Input[bool] phone_verified: Boolean. Indicates whether or not the phone number has been verified.
        :param pulumi.Input[List[pulumi.Input[str]]] roles: Set(String). Set of IDs of roles assigned to the user.
        :param pulumi.Input[str] user_id: String. ID of the user.
        :param pulumi.Input[str] user_metadata: String, JSON format. Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        :param pulumi.Input[str] username: String. Username of the user. Only valid if the connection requires a username.
        :param pulumi.Input[bool] verify_email: Boolean. Indicates whether or not the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["app_metadata"] = app_metadata
        __props__["blocked"] = blocked
        __props__["connection_name"] = connection_name
        __props__["email"] = email
        __props__["email_verified"] = email_verified
        __props__["family_name"] = family_name
        __props__["given_name"] = given_name
        __props__["name"] = name
        __props__["nickname"] = nickname
        __props__["password"] = password
        __props__["phone_number"] = phone_number
        __props__["phone_verified"] = phone_verified
        __props__["picture"] = picture
        __props__["roles"] = roles
        __props__["user_id"] = user_id
        __props__["user_metadata"] = user_metadata
        __props__["username"] = username
        __props__["verify_email"] = verify_email
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> pulumi.Output[Optional[str]]:
        """
        String, JSON format. Custom fields that store info about the user that impact the user's core functionality, such as how an application functions or what the user can access. Examples include support plans and IDs for external accounts.
        """
        return pulumi.get(self, "app_metadata")

    @property
    @pulumi.getter
    def blocked(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "blocked")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        String. Name of the connection from which the user information was sourced.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        String. Email address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not the email address has been verified.
        """
        return pulumi.get(self, "email_verified")

    @property
    @pulumi.getter(name="familyName")
    def family_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "family_name")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[Optional[str]]:
        """
        String. Preferred nickname or alias of the user.
        """
        return pulumi.get(self, "nickname")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        String, Case-sensitive. Initial password for this user. Used for non-SMS connections.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[str]]:
        """
        String. Phone number for the user; follows the E.164 recommendation. Used for SMS connections.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="phoneVerified")
    def phone_verified(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not the phone number has been verified.
        """
        return pulumi.get(self, "phone_verified")

    @property
    @pulumi.getter
    def picture(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "picture")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Set(String). Set of IDs of roles assigned to the user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        String. ID of the user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userMetadata")
    def user_metadata(self) -> pulumi.Output[Optional[str]]:
        """
        String, JSON format. Custom fields that store info about the user that does not impact a user's core functionality. Examples include work address, home address, and user preferences.
        """
        return pulumi.get(self, "user_metadata")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        String. Username of the user. Only valid if the connection requires a username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyEmail")
    def verify_email(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean. Indicates whether or not the user will receive a verification email after creation. Overrides behavior of `email_verified` parameter.
        """
        return pulumi.get(self, "verify_email")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

